/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.oracledesigner.logical;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.oracledesigner.AbstractObjectHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODExtractionHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class ODORelation
extends AbstractObjectHandler {
    public static final String OBJECT_TYPE = "RELATION";
    private Map relations = new TreeMap();
    private Map arcMap = new TreeMap();
    private static final Logger LOGGER = new Logger(ODORelation.class);
    PreparedStatement id_statement;
    PreparedStatement com_statement;

    public ODORelation(ODExtractionHandler oDExtractionHandler, ApplicationView applicationView) {
        super(oDExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        this.relations.clear();
        this.arcMap.clear();
        Statement statement = null;
        this.id_statement = null;
        this.com_statement = null;
        for (ODObject oDObject : list) {
            Object object;
            if (!"ENTITY".equalsIgnoreCase(oDObject.getType())) continue;
            String string = oDObject.ivid;
            if (statement == null) {
                object = "SELECT l.NAME left_name, r.NAME right_name,l.ID left_id, l.FROM_ENTITY_REFERENCE,l.arc_reference, l.TO_ENTITY_REFERENCE,nvl(l.MAXIMUM_CARDINALITY,999) left_max_card,l.MINIMUM_CARDINALITY left_min_card,l.OTHER_RELATIONSHIP_END_REF right_id,nvl(r.MAXIMUM_CARDINALITY,999) right_max_card,r.MINIMUM_CARDINALITY right_min_card,l.IVID,l.arc_number from CI_RELATIONSHIP_ENDS l, CI_RELATIONSHIP_ENDS r  where l.parent_ivid = ?  and l.OTHER_RELATIONSHIP_END_REF = r.id";
                statement = connection.prepareStatement((String)object);
            }
            object = null;
            try {
                statement.setString(1, string);
                object = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("ODORelation.generate():", sQLException);
            }
            if (object == null) continue;
            while (object.next()) {
                List<DummyRelation> list2;
                DummyRelation dummyRelation;
                String string2 = object.getString("left_id");
                String string3 = object.getString("right_id");
                String string4 = object.getString("FROM_ENTITY_REFERENCE");
                String string5 = object.getString("arc_reference");
                String string6 = object.getString("TO_ENTITY_REFERENCE");
                int n = object.getInt("left_max_card");
                int n2 = object.getInt("right_max_card");
                int n3 = object.getInt("left_min_card");
                int n4 = object.getInt("right_min_card");
                String string7 = object.getString("left_name");
                String string8 = object.getString("right_name");
                String string9 = object.getString("arc_number");
                if (!this.relationExists(string2, string3)) {
                    dummyRelation = new DummyRelation(string2, string3, string4, string6);
                    dummyRelation.setLeftCardinality(n2 == 1 ? "1" : "*");
                    dummyRelation.setRightCardinality(n == 1 ? "1" : "*");
                    dummyRelation.setLeftIsOptional(n3 == 0);
                    dummyRelation.setRightIsOptional(n4 == 0);
                    dummyRelation.setLeftName(string7);
                    dummyRelation.setRightName(string8);
                    this.initIdentifying(connection, dummyRelation);
                    this.setRelationNotesAndComments(connection, dummyRelation, string);
                    this.relations.put(dummyRelation.getID(), dummyRelation);
                    if (string5 == null || string9 == null || "".equalsIgnoreCase(string5)) continue;
                    list2 = (List)this.arcMap.get(string5);
                    if (list2 == null) {
                        list2 = new ArrayList();
                    }
                    list2.add(dummyRelation);
                    this.arcMap.put(string5, list2);
                    continue;
                }
                if (string5 == null || string9 == null || "".equalsIgnoreCase(string5)) continue;
                dummyRelation = (DummyRelation)this.relations.get(string2 + "@" + string3);
                if (dummyRelation == null) {
                    dummyRelation = (DummyRelation)this.relations.get(string3 + "@" + string2);
                }
                if (dummyRelation == null) continue;
                list2 = (ArrayList<DummyRelation>)this.arcMap.get(string5);
                if (list2 == null) {
                    list2 = new ArrayList<DummyRelation>();
                }
                list2.add(dummyRelation);
                this.arcMap.put(string5, list2);
            }
            object.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (this.id_statement != null) {
            this.id_statement.close();
        }
        if (this.com_statement != null) {
            this.com_statement.close();
        }
        this.createRelations();
        this.createArcs();
        this.propagateFKAttributes(connection);
    }

    private void initIdentifying(Connection connection, DummyRelation dummyRelation) throws Exception {
        Object object;
        if (this.id_statement == null) {
            object = "SELECT   u.ID, u.relationship_end_reference,i.entity_reference FROM ci_unique_identifier_entries u, ci_unique_identifiers i WHERE u.attribute_or_relation = 'R' AND i.primary_uid_flag = 'Y' AND i.ID = u.unique_identifier_reference AND i.parent_ivid = u.parent_ivid AND u.relationship_end_reference IN ( ? , ? )";
            this.id_statement = connection.prepareStatement((String)object);
        }
        object = null;
        try {
            this.id_statement.setString(1, dummyRelation.getLeftRelationID());
            this.id_statement.setString(2, dummyRelation.getRightRelationID());
            object = this.id_statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("ODORelation.initIdentifying():", sQLException);
        }
        if (object != null) {
            if (object.next()) {
                dummyRelation.setIdentifying(true);
            }
            object.close();
        }
    }

    private void propagateFKAttributes(Connection connection) throws Exception {
        boolean bl = true;
        while (bl) {
            bl = false;
            Object[] objectArray = this.getExtractionHandler().getRelationsToKeys().keySet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                DummyRelation dummyRelation = this.getDummyRelation((String)objectArray[i]);
                if (dummyRelation == null) continue;
                Relation relation = (Relation)this.getExtractionHandler().getImportedObject(dummyRelation.getID());
                CandidateKey candidateKey = (CandidateKey)this.getExtractionHandler().getRelationsToKeys().get(objectArray[i]);
                if (relation == null || candidateKey == null) continue;
                Entity entity = (Entity)candidateKey.getContainerObject();
                ContainedObject[] containedObjectArray = entity.getAllElementsGeneratedBy(relation);
                for (int j = 0; j < containedObjectArray.length; ++j) {
                    if (containedObjectArray[j].getContainer() == null || candidateKey.contains(containedObjectArray[j]) || containedObjectArray[j].getContainer() != candidateKey.getContainerWithKeyObject()) continue;
                    try {
                        candidateKey.add(containedObjectArray[j]);
                        continue;
                    }
                    catch (Exception exception) {
                        LOGGER.error("error adding attribute! \n", exception);
                    }
                }
            }
        }
    }

    private void createRelations() {
        Object[] objectArray = this.relations.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            DummyRelation dummyRelation = (DummyRelation)this.relations.get(objectArray[i]);
            Entity entity = (Entity)this.getExtractionHandler().getImportedObject(dummyRelation.getLeftEntityID());
            Entity entity2 = (Entity)this.getExtractionHandler().getImportedObject(dummyRelation.getRightEntityID());
            if (entity == null || entity2 == null) continue;
            Relation relation = this.getDesign().getLogicalDesign().createRelation();
            relation.setFireCardinalityChange(false);
            relation.setSourceEntity(entity);
            relation.setTargetEntity(entity2);
            relation.setSourceTV((TVEntity)entity.getTopView());
            relation.setTargetTV((TVEntity)entity2.getTopView());
            relation.setCardinality(0, dummyRelation.getLeftCardinality());
            relation.setCardinality(1, dummyRelation.getRightCardinality());
            relation.setOptionalSource(dummyRelation.leftIsOptional());
            relation.setOptionalTarget(dummyRelation.rightIsOptional());
            relation.setNameOnSource(dummyRelation.getLeftName());
            relation.setNameOnTarget(dummyRelation.getRightName());
            relation.setIdentifying(dummyRelation.isIdentifying());
            relation.setFireCardinalityChange(true);
            relation.setTargetCardinality(relation.getTargetCardinality());
            relation.setComment(dummyRelation.getComments());
            relation.setNotes(dummyRelation.getNotes());
            relation.addToAllDPVs();
            ((TVRelation)relation.getTopView()).addConnection();
            ((TVRelation)relation.getTopView()).resetEdgeParams();
            this.getExtractionHandler().addToImportedObjects(dummyRelation.getID(), relation);
            dummyRelation.setRelation(relation);
        }
    }

    private void createArcs() {
        Object[] objectArray = this.arcMap.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object2;
            List list = (List)this.arcMap.get(objectArray[i]);
            if (list == null || list.size() <= 1) continue;
            ArrayList<DesignObject> arrayList = new ArrayList<DesignObject>();
            for (Object object2 : list) {
                if (((DummyRelation)object2).getRelation() == null) continue;
                arrayList.add(((DummyRelation)object2).getRelation());
            }
            if (arrayList.size() <= 1) continue;
            object2 = (Relation)arrayList.get(0);
            int[] nArray = ((Relation)object2).getPKProviderEndPoint();
            Entity entity = null;
            entity = nArray.length > 0 ? ((Relation)object2).getEntity(((Relation)object2).getOtherEndPoint(nArray[0])) : ((Relation)object2).getSourceEntity();
            arrayList.add(0, entity);
            this.getDesign().getLogicalDesign().createArc(arrayList.toArray());
        }
    }

    private DummyRelation getDummyRelation(String string) {
        Object[] objectArray = this.relations.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            DummyRelation dummyRelation = (DummyRelation)this.relations.get(objectArray[i]);
            if (dummyRelation == null || !dummyRelation.getLeftRelationID().equalsIgnoreCase(string) && !dummyRelation.getRightRelationID().equalsIgnoreCase(string)) continue;
            return dummyRelation;
        }
        return null;
    }

    private boolean relationExists(String string, String string2) {
        return this.relations.containsKey(string + "@" + string2) || this.relations.containsKey(string2 + "@" + string);
    }

    protected void setRelationNotesAndComments(Connection connection, DummyRelation dummyRelation, String string) throws Exception {
        Object object;
        if (this.com_statement == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ');
            ((StringBuffer)object).append("txt_type").append(',');
            ((StringBuffer)object).append("txt_text").append(' ');
            ((StringBuffer)object).append("FROM").append(' ');
            ((StringBuffer)object).append("rm_text_lines").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ');
            ((StringBuffer)object).append("TXT_REF").append(' ').append("IN").append(' ').append('(');
            ((StringBuffer)object).append(" ? ").append(',').append(" ? ").append(')').append(' ');
            ((StringBuffer)object).append(" and parent_ivid").append('=').append(" ? ");
            ((StringBuffer)object).append(" and txt_type in ('CDIDSC','CDINOT')");
            ((StringBuffer)object).append(" order by txt_type, txt_seq");
            this.com_statement = connection.prepareStatement(((StringBuffer)object).toString());
        }
        object = null;
        try {
            this.com_statement.setString(1, dummyRelation.getLeftRelationID());
            this.com_statement.setString(2, dummyRelation.getRightRelationID());
            this.com_statement.setString(3, string);
            object = this.com_statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("ODORelation.setRelationNotesAndComments():", sQLException);
        }
        if (object != null) {
            while (object.next()) {
                String string2;
                String string3 = object.getString("txt_type");
                String string4 = object.getString("txt_text");
                if ("CDIDSC".equalsIgnoreCase(string3)) {
                    string2 = dummyRelation.getComments();
                    if (string2 == null || "".equalsIgnoreCase(string2)) {
                        dummyRelation.setComments(string4);
                        continue;
                    }
                    dummyRelation.setComments(string2 + "\n" + string4);
                    continue;
                }
                if (!"CDINOT".equalsIgnoreCase(string3)) continue;
                string2 = dummyRelation.getNotes();
                if (string2 == null || "".equalsIgnoreCase(string2)) {
                    dummyRelation.setNotes(string4);
                    continue;
                }
                dummyRelation.setNotes(string2 + "\n" + string4);
            }
            object.close();
        }
    }

    private class DummyRelation {
        private String leftEntityID;
        private String rightEntityID;
        private String leftRelationID;
        private String rightRelationID;
        private String leftCardinality;
        private String rightCardinality;
        private boolean leftIsOptional;
        private boolean rightIsOptional;
        private String leftName;
        private String rightName;
        private String comments;
        private String notes;
        private boolean identifying = false;
        private Relation relation;

        public DummyRelation(String string, String string2, String string3, String string4) {
            this.leftRelationID = string;
            this.rightRelationID = string2;
            this.leftEntityID = string3;
            this.rightEntityID = string4;
        }

        public String getLeftCardinality() {
            return this.leftCardinality;
        }

        public void setLeftCardinality(String string) {
            this.leftCardinality = string;
        }

        public boolean leftIsOptional() {
            return this.leftIsOptional;
        }

        public void setLeftIsOptional(boolean bl) {
            this.leftIsOptional = bl;
        }

        public String getLeftRelationID() {
            return this.leftRelationID;
        }

        public String getRightRelationID() {
            return this.rightRelationID;
        }

        public String getRightCardinality() {
            return this.rightCardinality;
        }

        public void setRightCardinality(String string) {
            this.rightCardinality = string;
        }

        public boolean rightIsOptional() {
            return this.rightIsOptional;
        }

        public void setRightIsOptional(boolean bl) {
            this.rightIsOptional = bl;
        }

        public String getLeftEntityID() {
            return this.leftEntityID;
        }

        public String getRightEntityID() {
            return this.rightEntityID;
        }

        public String getLeftName() {
            return this.leftName;
        }

        public void setLeftName(String string) {
            this.leftName = string;
        }

        public String getRightName() {
            return this.rightName;
        }

        public void setRightName(String string) {
            this.rightName = string;
        }

        public String getID() {
            return this.leftRelationID + "@" + this.rightRelationID;
        }

        public String getComments() {
            return this.comments;
        }

        public void setComments(String string) {
            this.comments = string;
        }

        public String getNotes() {
            return this.notes;
        }

        public void setNotes(String string) {
            this.notes = string;
        }

        public boolean isIdentifying() {
            return this.identifying;
        }

        public void setIdentifying(boolean bl) {
            this.identifying = bl;
        }

        public Relation getRelation() {
            return this.relation;
        }

        public void setRelation(Relation relation) {
            this.relation = relation;
        }
    }
}

