/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.oracledesigner;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.oracledesigner.AbstractObjectHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODExtractionHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODObject;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class ODOType
extends AbstractObjectHandler {
    public static final String OBJECT_TYPE = "TYPE";
    public static final String OBJECT_TYPE_COLLECTION = "COLLECTION TYPE";
    public static final String OBJECT_TYPE_STRUCTURE = "STRUCTURED TYPE";
    public List collectionTypes = new ArrayList();
    public List structuredTypes = new ArrayList();
    private static final Logger LOGGER = new Logger(ODOType.class);
    PreparedStatement attr_statement;
    PreparedStatement m_statement;
    PreparedStatement ma_statement;
    PreparedStatement mb_statement;

    public ODOType(ODExtractionHandler oDExtractionHandler, ApplicationView applicationView) {
        super(oDExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.extractCollectionTypes(connection, list));
        arrayList.addAll(this.extractStructuredTypes(connection, list));
        return arrayList;
    }

    public List extractCollectionTypes(Connection connection, List list) throws Exception {
        Statement statement = null;
        Statement statement2 = null;
        ArrayList<ODObject> arrayList = new ArrayList<ODObject>();
        for (ODObject oDObject : list) {
            ODObject oDObject2;
            String string;
            String string2;
            CharSequence charSequence;
            ResultSet resultSet;
            if (!oDObject.isSelected()) continue;
            if (oDObject.branches.size() == 0) {
                resultSet = null;
                if (statement2 == null) {
                    charSequence = new StringBuffer();
                    ((StringBuffer)charSequence).append("select  a.NAME,a.ID,a.ivid    ");
                    ((StringBuffer)charSequence).append("from CI_ORACLE_COLLECTION_TYPES a,sdd_folder_members b , i$sdd_wa_context cc ");
                    ((StringBuffer)charSequence).append("where ");
                    ((StringBuffer)charSequence).append(" a.ID = b.member_object and b.folder_reference = ? ");
                    ((StringBuffer)charSequence).append(" and b.PARENT_IVID = ? ");
                    ((StringBuffer)charSequence).append("and cc.workarea_irid = ?  and a.ivid = cc.object_ivid and cc.wastebasket ='N' ");
                    ((StringBuffer)charSequence).append(" order by name ");
                    statement2 = connection.prepareStatement(((StringBuffer)charSequence).toString());
                }
                try {
                    statement2.setString(1, oDObject.getIrid());
                    statement2.setString(2, oDObject.ivid);
                    statement2.setString(3, oDObject.wa_irid);
                    resultSet = statement2.executeQuery();
                }
                catch (SQLException sQLException) {
                    LOGGER.error("ODOCollectionType.extract(): " + sQLException.getMessage());
                }
                if (resultSet == null) continue;
                while (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                    string2 = resultSet.getString(2);
                    string = resultSet.getString(3);
                    oDObject2 = new ODObject(true, (String)charSequence, OBJECT_TYPE_COLLECTION, string2);
                    oDObject2.ivid = string;
                    oDObject2.setParentName(oDObject.getName());
                    oDObject2.setParentID(oDObject.getIrid());
                    arrayList.add(oDObject2);
                }
                resultSet.close();
                continue;
            }
            if (oDObject.branch == null) continue;
            resultSet = null;
            if (statement == null) {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("select  a.NAME,a.ID,a.ivid ");
                ((StringBuffer)charSequence).append("from CI_ORACLE_COLLECTION_TYPES a,sdd_folder_members b ");
                ((StringBuffer)charSequence).append("where ");
                ((StringBuffer)charSequence).append(" a.ID = b.member_object and b.folder_reference = ? ");
                ((StringBuffer)charSequence).append(" and b.PARENT_IVID = ? ");
                ((StringBuffer)charSequence).append("AND EXISTS \n");
                ((StringBuffer)charSequence).append("(SELECT 1 \n");
                ((StringBuffer)charSequence).append("FROM CI_ORACLE_COLLECTION_TYPES F, \n");
                ((StringBuffer)charSequence).append("  I$sdd_Wa_Context C \n");
                ((StringBuffer)charSequence).append("WHERE a.Irid        = F.Irid \n");
                ((StringBuffer)charSequence).append("AND F.Ivid          = C.Object_Ivid \n");
                ((StringBuffer)charSequence).append("AND C.Workarea_Irid = ? \n");
                ((StringBuffer)charSequence).append(")");
                ((StringBuffer)charSequence).append(" and a.ivid = ");
                ((StringBuffer)charSequence).append(" (select ivid from i$sdd_object_versions v ");
                ((StringBuffer)charSequence).append("  where ");
                ((StringBuffer)charSequence).append("  a.id = v.irid and ");
                ((StringBuffer)charSequence).append("  branch_id = ? ");
                ((StringBuffer)charSequence).append("  and sequence_in_branch  is not null");
                ((StringBuffer)charSequence).append("  and wastebasket='N' ");
                ((StringBuffer)charSequence).append("  and sequence_in_branch = ");
                ((StringBuffer)charSequence).append("   ( ");
                ((StringBuffer)charSequence).append("   select max(sequence_in_branch) from i$sdd_object_versions v2 ");
                ((StringBuffer)charSequence).append("     where ");
                ((StringBuffer)charSequence).append("     v2.irid = a.id");
                ((StringBuffer)charSequence).append("     and branch_id = ? ");
                ((StringBuffer)charSequence).append("     and sequence_in_branch  is not null ");
                ((StringBuffer)charSequence).append("     and wastebasket='N' ");
                ((StringBuffer)charSequence).append("   ) ");
                ((StringBuffer)charSequence).append("  )");
                ((StringBuffer)charSequence).append(" order by name ");
                statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
            }
            try {
                statement.setString(1, oDObject.getIrid());
                statement.setString(2, oDObject.ivid);
                statement.setString(3, oDObject.wa_irid);
                statement.setString(4, oDObject.branch.getId());
                statement.setString(5, oDObject.branch.getId());
                resultSet = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("ODOCollectionType.extract(): " + sQLException.getMessage());
            }
            if (resultSet == null) continue;
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                string2 = resultSet.getString(2);
                string = resultSet.getString(3);
                oDObject2 = new ODObject(true, (String)charSequence, OBJECT_TYPE_COLLECTION, string2);
                oDObject2.ivid = string;
                oDObject2.branch = oDObject.branch;
                oDObject2.setParentName(oDObject.getName());
                oDObject2.setParentID(oDObject.getIrid());
                arrayList.add(oDObject2);
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (statement2 != null) {
            statement2.close();
        }
        return arrayList;
    }

    public List extractStructuredTypes(Connection connection, List list) throws Exception {
        Statement statement = null;
        Statement statement2 = null;
        ArrayList<ODObject> arrayList = new ArrayList<ODObject>();
        for (ODObject oDObject : list) {
            ODObject oDObject2;
            String string;
            String string2;
            CharSequence charSequence;
            ResultSet resultSet;
            if (!oDObject.isSelected()) continue;
            if (oDObject.branches.size() == 0) {
                resultSet = null;
                if (statement2 == null) {
                    charSequence = new StringBuffer();
                    ((StringBuffer)charSequence).append("select  a.NAME,a.ID,a.ivid    ");
                    ((StringBuffer)charSequence).append("from ci_oracle_object_types a,sdd_folder_members b , i$sdd_wa_context cc ");
                    ((StringBuffer)charSequence).append("where ");
                    ((StringBuffer)charSequence).append(" a.ID = b.member_object and b.folder_reference = ? ");
                    ((StringBuffer)charSequence).append(" and b.PARENT_IVID = ? ");
                    ((StringBuffer)charSequence).append("and cc.workarea_irid = ?  and a.ivid = cc.object_ivid and cc.wastebasket ='N' ");
                    ((StringBuffer)charSequence).append(" order by name ");
                    statement2 = connection.prepareStatement(((StringBuffer)charSequence).toString());
                }
                try {
                    statement2.setString(1, oDObject.getIrid());
                    statement2.setString(2, oDObject.ivid);
                    statement2.setString(3, oDObject.wa_irid);
                    resultSet = statement2.executeQuery();
                }
                catch (SQLException sQLException) {
                    LOGGER.error("ODOStructuredType.extract(): " + sQLException.getMessage());
                }
                if (resultSet == null) continue;
                while (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                    string2 = resultSet.getString(2);
                    string = resultSet.getString(3);
                    oDObject2 = new ODObject(true, (String)charSequence, OBJECT_TYPE_STRUCTURE, string2);
                    oDObject2.ivid = string;
                    oDObject2.setParentName(oDObject.getName());
                    oDObject2.setParentID(oDObject.getIrid());
                    arrayList.add(oDObject2);
                }
                resultSet.close();
                continue;
            }
            if (oDObject.branch == null) continue;
            resultSet = null;
            if (statement == null) {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("select  a.NAME,a.ID,a.ivid ");
                ((StringBuffer)charSequence).append("from ci_oracle_object_types a,sdd_folder_members b ");
                ((StringBuffer)charSequence).append("where ");
                ((StringBuffer)charSequence).append(" a.ID = b.member_object and b.folder_reference = ? ");
                ((StringBuffer)charSequence).append(" and b.PARENT_IVID = ? ");
                ((StringBuffer)charSequence).append("AND EXISTS \n");
                ((StringBuffer)charSequence).append("(SELECT 1 \n");
                ((StringBuffer)charSequence).append("FROM ci_oracle_object_types F, \n");
                ((StringBuffer)charSequence).append("  I$sdd_Wa_Context C \n");
                ((StringBuffer)charSequence).append("WHERE a.Irid        = F.Irid \n");
                ((StringBuffer)charSequence).append("AND F.Ivid          = C.Object_Ivid \n");
                ((StringBuffer)charSequence).append("AND C.Workarea_Irid = ? \n");
                ((StringBuffer)charSequence).append(")");
                ((StringBuffer)charSequence).append(" and a.ivid = ");
                ((StringBuffer)charSequence).append(" (select ivid from i$sdd_object_versions v ");
                ((StringBuffer)charSequence).append("  where ");
                ((StringBuffer)charSequence).append("  a.id = v.irid and ");
                ((StringBuffer)charSequence).append("  branch_id = ? ");
                ((StringBuffer)charSequence).append("  and sequence_in_branch  is not null");
                ((StringBuffer)charSequence).append("  and wastebasket='N' ");
                ((StringBuffer)charSequence).append("  and sequence_in_branch = ");
                ((StringBuffer)charSequence).append("   ( ");
                ((StringBuffer)charSequence).append("   select max(sequence_in_branch) from i$sdd_object_versions v2 ");
                ((StringBuffer)charSequence).append("     where ");
                ((StringBuffer)charSequence).append("     v2.irid = a.id");
                ((StringBuffer)charSequence).append("     and branch_id = ? ");
                ((StringBuffer)charSequence).append("     and sequence_in_branch  is not null ");
                ((StringBuffer)charSequence).append("     and wastebasket='N' ");
                ((StringBuffer)charSequence).append("   ) ");
                ((StringBuffer)charSequence).append("  )");
                ((StringBuffer)charSequence).append(" order by name ");
                statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
            }
            try {
                statement.setString(1, oDObject.getIrid());
                statement.setString(2, oDObject.ivid);
                statement.setString(3, oDObject.wa_irid);
                statement.setString(4, oDObject.branch.getId());
                statement.setString(5, oDObject.branch.getId());
                resultSet = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("ODOStructuredType.extract(): " + sQLException.getMessage());
            }
            if (resultSet == null) continue;
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                string2 = resultSet.getString(2);
                string = resultSet.getString(3);
                oDObject2 = new ODObject(true, (String)charSequence, OBJECT_TYPE_STRUCTURE, string2);
                oDObject2.ivid = string;
                oDObject2.branch = oDObject.branch;
                oDObject2.setParentName(oDObject.getName());
                oDObject2.setParentID(oDObject.getIrid());
                arrayList.add(oDObject2);
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (statement2 != null) {
            statement2.close();
        }
        return arrayList;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        this.attr_statement = null;
        this.m_statement = null;
        this.ma_statement = null;
        this.mb_statement = null;
        this.generateCollectionTypes(connection, list, importLogger);
        this.generateStructuredTypes(connection, list, importLogger);
        this.createCollectionTypes();
        this.createStructuredTypes();
        this.initCollectionTypesProperties(connection);
        this.initStructuredTypesProperties(connection, importLogger);
        if (this.attr_statement != null) {
            this.attr_statement.close();
        }
        if (this.m_statement != null) {
            this.m_statement.close();
        }
        if (this.ma_statement != null) {
            this.ma_statement.close();
        }
        if (this.mb_statement != null) {
            this.mb_statement.close();
        }
    }

    private void createCollectionTypes() {
        for (DummyObject dummyObject : this.collectionTypes) {
            CollectionType collectionType = this.getDesign().getDataTypesDesign().createCollectionType();
            collectionType.setName((String)dummyObject.getProperty("NAME"));
            this.getExtractionHandler().addToImportedObjects((String)dummyObject.getProperty("ID"), collectionType);
        }
    }

    private void createStructuredTypes() {
        for (DummyObject dummyObject : this.structuredTypes) {
            StructuredType structuredType = this.getDesign().getDataTypesDesign().createStructuredType();
            structuredType.setName((String)dummyObject.getProperty("NAME"));
            this.getExtractionHandler().addToImportedObjects((String)dummyObject.getProperty("ID"), structuredType);
        }
    }

    private void initCollectionTypesProperties(Connection connection) throws Exception {
        for (DummyObject dummyObject : this.collectionTypes) {
            Object object;
            CollectionType collectionType = (CollectionType)this.getExtractionHandler().getImportedObject((String)dummyObject.getProperty("ID"));
            String string = (String)dummyObject.getProperty("COLLECTION_OF");
            String string2 = (String)dummyObject.getProperty("COLLECTION_TYPE");
            String string3 = (String)dummyObject.getProperty("OBJECT_REF_FLAG");
            String string4 = (String)dummyObject.getProperty("ORACLE_OBJECT_TYPE_REFERENCE");
            String string5 = (String)dummyObject.getProperty("SCALAR_DATATYPE");
            int n = (Integer)dummyObject.getProperty("SCALAR_DECIMAL_PLACES");
            int n2 = (Integer)dummyObject.getProperty("SCALAR_MAXIMUM_LENGTH");
            int n3 = (Integer)dummyObject.getProperty("VARRAY_LIMIT");
            if ("NESTED TABLE".equalsIgnoreCase(string2)) {
                collectionType.setCollectionType();
            } else {
                collectionType.setArrayType();
                collectionType.setMaxElement(n3);
            }
            if ("SCALAR".equalsIgnoreCase(string)) {
                object = StandardDatatypeNames.getUsedDatatypeName(string5);
                LogicalDatatype logicalDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), (String)object);
                if (logicalDatatype != null) {
                    collectionType.getElementType().setType(logicalDatatype);
                    if (n > 0) {
                        collectionType.getElementType().setPrecision(n2);
                        collectionType.getElementType().setScale(n);
                    } else {
                        collectionType.getElementType().setSize(Integer.toString(n2));
                    }
                }
            } else if (string4 != null && (object = (StructuredType)this.getExtractionHandler().getImportedObject(string4)) != null) {
                collectionType.getElementType().setType((DesignObject)object);
                if ("Y".equalsIgnoreCase(string3)) {
                    collectionType.getElementType().setReference(true);
                }
            }
            this.setNotesAndComments(connection, collectionType, (String)dummyObject.getProperty("ID"), (String)dummyObject.getProperty("ivid"));
        }
    }

    private void initStructuredTypesProperties(Connection connection, ImportLogger importLogger) throws Exception {
        for (DummyObject dummyObject : this.structuredTypes) {
            String string = (String)dummyObject.getProperty("ID");
            String string2 = (String)dummyObject.getProperty("ivid");
            StructuredType structuredType = (StructuredType)this.getExtractionHandler().getImportedObject(string);
            this.setNotesAndComments(connection, structuredType, string, string2);
            this.initStructuredTypeAttributes(connection, structuredType, string, importLogger, string2);
            this.initStructuredTypeMethods(connection, structuredType, string, string2, (ODExtractionHandler.Branch)dummyObject.getProperty("branch"));
        }
    }

    private void initStructuredTypeAttributes(Connection connection, StructuredType structuredType, String string, ImportLogger importLogger, String string2) throws Exception {
        Object object;
        if (this.attr_statement == null) {
            object = "SELECT c.name,c.id, c.DATATYPE, DECIMAL_PLACES,NULL_INDICATOR,c.MAXIMUM_LENGTH, OBJECT_TYPE_INCLUSION,ORACLE_TYPE_REFERENCE,c.REMARK from ci_columns c where c.parent_ivid = ?  order by  c.SEQUENCE_NUMBER";
            this.attr_statement = connection.prepareStatement((String)object);
        }
        object = null;
        try {
            this.attr_statement.setString(1, string2);
            object = this.attr_statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("ODOType.initStructuredTypeAttributes():", sQLException);
        }
        if (object != null) {
            while (object.next()) {
                Object object2;
                String string3 = object.getString("NAME");
                String string4 = object.getString("ID");
                Object object3 = object.getString("DATATYPE");
                String string5 = object.getString("DECIMAL_PLACES");
                String string6 = object.getString("MAXIMUM_LENGTH");
                String string7 = object.getString("OBJECT_TYPE_INCLUSION");
                String string8 = object.getString("ORACLE_TYPE_REFERENCE");
                String string9 = object.getString("REMARK");
                String string10 = object.getString("NULL_INDICATOR");
                int n = 0;
                try {
                    n = Integer.valueOf(string6);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int n2 = 0;
                try {
                    n2 = Integer.valueOf(string5);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                TypeElement typeElement = new TypeElement(structuredType.getDesignPart(), structuredType);
                typeElement.setName(string3);
                typeElement.setDesign(structuredType.getDesign());
                typeElement.setComment(string9);
                structuredType.add(typeElement);
                if (string8 != null) {
                    object2 = (DesignObject)this.getExtractionHandler().getImportedObject(string8);
                    if (object2 != null) {
                        typeElement.setType((DesignObject)object2);
                        if ("REF".equalsIgnoreCase(string7)) {
                            typeElement.setReference(true);
                        }
                    } else {
                        importLogger.addWarning("Oracle Type: '" + string8 + "' is not imported");
                    }
                } else if (object3 != null) {
                    String string11;
                    Object object4;
                    object2 = StandardDatatypeNames.getUsedDatatypeName((String)object3);
                    if ("UNKNOWN".equalsIgnoreCase((String)object2) && (object4 = MappingDatatypeNameLogicalDataType.getDesignerMappedName((String)object3)) != null) {
                        object2 = object4;
                        object3 = object4;
                    }
                    if ((object4 = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), (String)object2)) == null && (string11 = MappingDatatypeNameLogicalDataType.getDesignerMappedName((String)object2)) != null) {
                        object2 = string11;
                        object3 = string11;
                        object4 = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), ((String)object2).toUpperCase());
                    }
                    if (object4 != null) {
                        typeElement.setType((DesignObject)object4);
                        if (((String)object3).toUpperCase().indexOf("CHAR") <= -1) {
                            if (((String)object3).toUpperCase().indexOf("TIMESTAMP") > -1) {
                                if (string5 != null) {
                                    typeElement.setPrecision(n2);
                                }
                            } else {
                                if (string6 != null) {
                                    typeElement.setPrecision(n);
                                }
                                if (string5 != null) {
                                    typeElement.setScale(n2);
                                }
                            }
                        } else if (string6 != null) {
                            typeElement.setSize(string6);
                        }
                    } else {
                        LOGGER.warn("ODOType.initStructuredTypeAttributes() - Unable to find Logical DataType for: " + (String)object3);
                    }
                }
                typeElement.updateReference();
                if ("NOT NULL".equalsIgnoreCase(string10)) {
                    typeElement.setMandatory(true);
                }
                this.setNotesAndComments(connection, typeElement, string4, string2);
            }
            object.close();
        }
    }

    private void initStructuredTypeMethods(Connection connection, StructuredType structuredType, String string, String string2, ODExtractionHandler.Branch branch) throws Exception {
        CharSequence charSequence;
        String string3;
        ResultSet resultSet = null;
        try {
            if (branch == null) {
                if (this.m_statement == null) {
                    string3 = "SELECT  m.NAME, m.ID, RETURN_TYPE,m.ivid from CI_MODULE_NETWORKS b, ci_modules m where b.CHILD_MODULE_REFERENCE = m.id and b.parent_ivid = ? ";
                    this.m_statement = connection.prepareStatement(string3);
                }
                this.m_statement.setString(1, string2);
            } else {
                if (this.m_statement == null) {
                    string3 = "SELECT  m.NAME, m.ID, RETURN_TYPE,m.ivid from CI_MODULE_NETWORKS b, ci_modules m where b.CHILD_MODULE_REFERENCE = m.id and b.parent_ivid = ? ";
                    charSequence = new StringBuffer(string3);
                    ((StringBuffer)charSequence).append("  and m.ivid = ");
                    ((StringBuffer)charSequence).append("(select ivid from i$sdd_object_versions v ");
                    ((StringBuffer)charSequence).append("  where ");
                    ((StringBuffer)charSequence).append("  v.irid = m.id");
                    ((StringBuffer)charSequence).append("  and branch_id = ? ");
                    ((StringBuffer)charSequence).append("  and sequence_in_branch  is not null ");
                    ((StringBuffer)charSequence).append("  and wastebasket='N' ");
                    ((StringBuffer)charSequence).append("  and sequence_in_branch = ");
                    ((StringBuffer)charSequence).append("   ( ");
                    ((StringBuffer)charSequence).append("   select max(sequence_in_branch) from i$sdd_object_versions v2 ");
                    ((StringBuffer)charSequence).append("     where ");
                    ((StringBuffer)charSequence).append("     v2.irid = m.id");
                    ((StringBuffer)charSequence).append("     and branch_id = ? ");
                    ((StringBuffer)charSequence).append("     and sequence_in_branch  is not null ");
                    ((StringBuffer)charSequence).append("     and wastebasket='N' ");
                    ((StringBuffer)charSequence).append("   ) )");
                    this.m_statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
                }
                this.m_statement.setString(1, string2);
                this.m_statement.setString(2, branch.getId());
                this.m_statement.setString(3, branch.getId());
            }
            resultSet = this.m_statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("ODOType.initStructuredTypeMethods():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                string3 = resultSet.getString("NAME");
                charSequence = resultSet.getString("RETURN_TYPE");
                String string4 = resultSet.getString("ID");
                String string5 = resultSet.getString("ivid");
                Method method = new Method(structuredType.getDesignPart(), structuredType);
                method.setName(string3);
                method.setDesign(structuredType.getDesign());
                structuredType.addMethod(method);
                if (charSequence != null) {
                    String string6 = StandardDatatypeNames.getUsedDatatypeName((String)charSequence);
                    LogicalDatatype logicalDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), string6);
                    if (logicalDatatype != null) {
                        MethodParam methodParam = new MethodParam(structuredType.getDesignPart());
                        methodParam.setType(logicalDatatype);
                        method.setReturnValue(methodParam);
                    } else {
                        LOGGER.warn("ODOType.initStructuredTypeMethods() - Unable to find Logical DataType for: " + (String)charSequence);
                    }
                }
                this.initMethodArguments(connection, method, string4, string5);
                this.setMethodBody(connection, method, string4, string5);
                this.setNotesAndComments(connection, method, string4, string5);
            }
            resultSet.close();
        }
    }

    private void initMethodArguments(Connection connection, Method method, String string, String string2) throws Exception {
        Object object;
        if (this.ma_statement == null) {
            object = "SELECT a.NAME,a.DATATYPE, DOMAIN_REFERENCE, LENGTH, SCALE from ci_module_arguments a where PLSQL_MODULE_REFERENCE = ?  and parent_ivid = ? order by position";
            this.ma_statement = connection.prepareStatement((String)object);
        }
        object = null;
        try {
            this.ma_statement.setString(1, string);
            this.ma_statement.setString(2, string2);
            object = this.ma_statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("ODOType.initMethodArguments():", sQLException);
        }
        if (object != null) {
            while (object.next()) {
                Object object2;
                String string3 = object.getString("NAME");
                Object object3 = object.getString("DATATYPE");
                String string4 = object.getString("domain_reference");
                int n = object.getInt("LENGTH");
                int n2 = object.getInt("SCALE");
                MethodParam methodParam = new MethodParam(method.getDesignPart());
                methodParam.setName(string3);
                methodParam.setDesign(method.getDesign());
                if (string4 != null) {
                    object2 = (Domain)this.getExtractionHandler().getImportedObject(string4);
                    methodParam.setType(((Domain)object2).getLogicalDatatype());
                    methodParam.setSize(((Domain)object2).getSize());
                    try {
                        methodParam.setScale(Integer.parseInt(((Domain)object2).getScale()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    try {
                        methodParam.setPrecision(Integer.parseInt(((Domain)object2).getPrecision()));
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    String string5;
                    Object object4;
                    object2 = StandardDatatypeNames.getUsedDatatypeName((String)object3);
                    if ("UNKNOWN".equalsIgnoreCase((String)object2) && (object4 = MappingDatatypeNameLogicalDataType.getDesignerMappedName((String)object3)) != null) {
                        object2 = object4;
                        object3 = object4;
                    }
                    if ((object4 = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), (String)object2)) == null && (string5 = MappingDatatypeNameLogicalDataType.getDesignerMappedName((String)object2)) != null) {
                        object2 = string5;
                        object3 = string5;
                        object4 = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), (String)object2);
                    }
                    if (object4 != null) {
                        methodParam.setType((DesignObject)object4);
                        if (((String)object3).toUpperCase().indexOf("CHAR") <= -1) {
                            if (n2 >= 0) {
                                methodParam.setPrecision(n);
                            }
                            methodParam.setScale(n2);
                        } else {
                            methodParam.setSize(Integer.toString(n));
                        }
                    } else {
                        LOGGER.warn("ODOType.initMethodArguments() - Unable to find Logical DataType for: " + (String)object3);
                    }
                }
                method.addParameter(methodParam);
            }
            object.close();
        }
    }

    public void generateCollectionTypes(Connection connection, List list, ImportLogger importLogger) throws Exception {
        Statement statement = null;
        for (ODObject oDObject : list) {
            Object object;
            if (!OBJECT_TYPE_COLLECTION.equalsIgnoreCase(oDObject.getType())) continue;
            String string = oDObject.ivid;
            if (statement == null) {
                object = new StringBuffer();
                ((StringBuffer)object).append("SELECT").append(' ');
                ((StringBuffer)object).append("NAME").append(',');
                ((StringBuffer)object).append("COLLECTION_OF").append(',');
                ((StringBuffer)object).append("COLLECTION_TYPE").append(',');
                ((StringBuffer)object).append("a.").append("ID").append(',');
                ((StringBuffer)object).append("OBJECT_REF_FLAG").append(',');
                ((StringBuffer)object).append("ORACLE_OBJECT_TYPE_REFERENCE").append(',');
                ((StringBuffer)object).append("SCALAR_DATATYPE").append(',');
                ((StringBuffer)object).append("SCALAR_DECIMAL_PLACES").append(',');
                ((StringBuffer)object).append("SCALAR_MAXIMUM_LENGTH").append(',');
                ((StringBuffer)object).append("VARRAY_LIMIT").append(' ');
                ((StringBuffer)object).append("FROM").append(' ');
                ((StringBuffer)object).append("CI_ORACLE_COLLECTION_TYPES").append(' ').append("a").append(' ');
                ((StringBuffer)object).append("WHERE").append(' ');
                ((StringBuffer)object).append("a.").append("ivid").append('=').append(" ? ");
                statement = connection.prepareStatement(((StringBuffer)object).toString());
            }
            object = null;
            try {
                statement.setString(1, string);
                object = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("ODOType.generateCollectionTypes():", sQLException);
            }
            if (object != null && object.next()) {
                String string2 = object.getString("COLLECTION_OF");
                String string3 = object.getString("COLLECTION_TYPE");
                String string4 = object.getString("OBJECT_REF_FLAG");
                String string5 = object.getString("ORACLE_OBJECT_TYPE_REFERENCE");
                String string6 = object.getString("SCALAR_DATATYPE");
                int n = object.getInt("SCALAR_DECIMAL_PLACES");
                int n2 = object.getInt("SCALAR_MAXIMUM_LENGTH");
                int n3 = object.getInt("VARRAY_LIMIT");
                DummyObject dummyObject = new DummyObject();
                dummyObject.setProperty("NAME", oDObject.getName());
                dummyObject.setProperty("ID", oDObject.getIrid());
                dummyObject.setProperty("ivid", string);
                dummyObject.setProperty("COLLECTION_OF", string2);
                dummyObject.setProperty("COLLECTION_TYPE", string3);
                dummyObject.setProperty("OBJECT_REF_FLAG", string4);
                dummyObject.setProperty("ORACLE_OBJECT_TYPE_REFERENCE", string5);
                dummyObject.setProperty("SCALAR_DATATYPE", string6);
                dummyObject.setProperty("SCALAR_DECIMAL_PLACES", new Integer(n));
                dummyObject.setProperty("SCALAR_MAXIMUM_LENGTH", new Integer(n2));
                dummyObject.setProperty("VARRAY_LIMIT", new Integer(n3));
                this.collectionTypes.add(dummyObject);
            }
            importLogger.incrementImportedStatements();
        }
        if (statement != null) {
            statement.close();
        }
    }

    public void generateStructuredTypes(Connection connection, List list, ImportLogger importLogger) throws Exception {
        for (ODObject oDObject : list) {
            if (!OBJECT_TYPE_STRUCTURE.equalsIgnoreCase(oDObject.getType())) continue;
            DummyObject dummyObject = new DummyObject();
            dummyObject.setProperty("NAME", oDObject.getName());
            dummyObject.setProperty("ID", oDObject.getIrid());
            dummyObject.setProperty("ivid", oDObject.ivid);
            if (oDObject.branch != null) {
                dummyObject.setProperty("branch", oDObject.branch);
            }
            this.structuredTypes.add(dummyObject);
            importLogger.incrementImportedStatements();
        }
    }

    protected void setMethodBody(Connection connection, Method method, String string, String string2) throws Exception {
        Object object;
        if (this.mb_statement == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ');
            ((StringBuffer)object).append("txt_type").append(',');
            ((StringBuffer)object).append("txt_text").append(' ');
            ((StringBuffer)object).append("FROM").append(' ');
            ((StringBuffer)object).append("rm_text_lines").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ');
            ((StringBuffer)object).append("TXT_REF").append(" = ? ");
            ((StringBuffer)object).append(" and parent_ivid = ? ");
            ((StringBuffer)object).append(" and txt_type = 'CDIPLS'");
            ((StringBuffer)object).append(" order by txt_seq");
            this.mb_statement = connection.prepareStatement(((StringBuffer)object).toString());
        }
        object = null;
        try {
            this.mb_statement.setString(1, string);
            this.mb_statement.setString(2, string2);
            object = this.mb_statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("ODOType.setMethodBody():", sQLException);
        }
        if (object != null) {
            while (object.next()) {
                String string3 = object.getString("txt_type");
                String string4 = object.getString("txt_text");
                if (!"CDIPLS".equalsIgnoreCase(string3)) continue;
                String string5 = method.getBody();
                if (string5 == null || "".equalsIgnoreCase(string5)) {
                    method.setBody(string4);
                    continue;
                }
                method.setBody(string5 + "\n" + string4);
            }
            object.close();
        }
    }

    private class DummyObject {
        private Map map = new TreeMap();

        private DummyObject() {
        }

        public void setProperty(Object object, Object object2) {
            this.map.put(object, object2);
        }

        public Object getProperty(Object object) {
            return this.map.get(object);
        }
    }
}

