/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.oracledesigner;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.oracledesigner.AbstractObjectHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODExtractionHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODObject;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainSet;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class ODODomain
extends AbstractObjectHandler {
    public static final String OBJECT_TYPE = "DOMAIN";
    private static final Logger LOGGER = new Logger(ODODomain.class);
    PreparedStatement val_statement;

    public ODODomain(ODExtractionHandler oDExtractionHandler, ApplicationView applicationView) {
        super(oDExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        Statement statement = null;
        Statement statement2 = null;
        ArrayList<ODObject> arrayList = new ArrayList<ODObject>();
        for (ODObject oDObject : list) {
            ODObject oDObject2;
            String string;
            String string2;
            CharSequence charSequence;
            Object object;
            if (!oDObject.isSelected()) continue;
            if (oDObject.branches.size() == 0) {
                if (statement2 == null) {
                    object = new StringBuffer();
                    ((StringBuffer)object).append("select  a.NAME,a.ID,a.ivid    ");
                    ((StringBuffer)object).append("from ci_domains a,sdd_folder_members b, i$sdd_wa_context cc ");
                    ((StringBuffer)object).append("where ");
                    ((StringBuffer)object).append(" a.ID = b.member_object and b.folder_reference = ? ");
                    ((StringBuffer)object).append(" and b.PARENT_IVID = ? ");
                    ((StringBuffer)object).append("and cc.workarea_irid = ?  and a.ivid = cc.object_ivid and cc.wastebasket ='N' ");
                    ((StringBuffer)object).append(" order by name ");
                    statement2 = connection.prepareStatement(((StringBuffer)object).toString());
                }
                object = null;
                try {
                    statement2.setString(1, oDObject.getIrid());
                    statement2.setString(2, oDObject.ivid);
                    statement2.setString(3, oDObject.wa_irid);
                    object = statement2.executeQuery();
                }
                catch (SQLException sQLException) {
                    LOGGER.error("ODODomain.extract(): " + sQLException.getMessage());
                }
                if (object == null) continue;
                while (object.next()) {
                    charSequence = object.getString(1);
                    string2 = object.getString(2);
                    string = object.getString(3);
                    if (this.getDesign().getDomainSet().getByName((String)charSequence) == null) {
                        oDObject2 = new ODObject(true, (String)charSequence, OBJECT_TYPE, string2);
                    } else {
                        oDObject2 = new ODObject(false, (String)charSequence, OBJECT_TYPE, string2);
                        oDObject2.setStatus("Name exist");
                    }
                    oDObject2.ivid = string;
                    oDObject2.setParentName(oDObject.getName());
                    oDObject2.setParentID(oDObject.getIrid());
                    oDObject2.containerType = oDObject.containerType;
                    arrayList.add(oDObject2);
                }
                object.close();
                continue;
            }
            if (oDObject.branch == null) continue;
            object = null;
            if (statement == null) {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("select  a.NAME,a.ID,a.ivid ");
                ((StringBuffer)charSequence).append("from ci_domains a,sdd_folder_members b ");
                ((StringBuffer)charSequence).append("where ");
                ((StringBuffer)charSequence).append(" a.ID = b.member_object and b.folder_reference = ? ");
                ((StringBuffer)charSequence).append(" and b.PARENT_IVID = ? ");
                ((StringBuffer)charSequence).append("AND EXISTS \n");
                ((StringBuffer)charSequence).append("(SELECT 1 \n");
                ((StringBuffer)charSequence).append("FROM ci_domains F, \n");
                ((StringBuffer)charSequence).append("  I$sdd_Wa_Context C \n");
                ((StringBuffer)charSequence).append("WHERE a.Irid        = F.Irid \n");
                ((StringBuffer)charSequence).append("AND F.Ivid          = C.Object_Ivid \n");
                ((StringBuffer)charSequence).append("AND C.Workarea_Irid = ? \n");
                ((StringBuffer)charSequence).append(")");
                ((StringBuffer)charSequence).append(" and a.ivid = ");
                ((StringBuffer)charSequence).append(" (select ivid from i$sdd_object_versions v ");
                ((StringBuffer)charSequence).append("  where ");
                ((StringBuffer)charSequence).append("  a.id = v.irid and ");
                ((StringBuffer)charSequence).append("  branch_id = ? ");
                ((StringBuffer)charSequence).append("  and sequence_in_branch  is not null");
                ((StringBuffer)charSequence).append("  and wastebasket='N' ");
                ((StringBuffer)charSequence).append("  and sequence_in_branch = ");
                ((StringBuffer)charSequence).append("   ( ");
                ((StringBuffer)charSequence).append("   select max(sequence_in_branch) from i$sdd_object_versions v2 ");
                ((StringBuffer)charSequence).append("     where ");
                ((StringBuffer)charSequence).append("     v2.irid = a.id");
                ((StringBuffer)charSequence).append("     and branch_id = ? ");
                ((StringBuffer)charSequence).append("     and sequence_in_branch  is not null ");
                ((StringBuffer)charSequence).append("     and wastebasket='N' ");
                ((StringBuffer)charSequence).append("   ) ");
                ((StringBuffer)charSequence).append("  )");
                ((StringBuffer)charSequence).append(" order by name ");
                statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
            }
            try {
                statement.setString(1, oDObject.getIrid());
                statement.setString(2, oDObject.ivid);
                statement.setString(3, oDObject.wa_irid);
                statement.setString(4, oDObject.branch.getId());
                statement.setString(5, oDObject.branch.getId());
                object = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("ODODomain.extract(): " + sQLException.getMessage());
            }
            if (object == null) continue;
            while (object.next()) {
                charSequence = object.getString(1);
                string2 = object.getString(2);
                string = object.getString(3);
                if (this.getDesign().getDomainSet().getByName((String)charSequence) == null) {
                    oDObject2 = new ODObject(true, (String)charSequence, OBJECT_TYPE, string2);
                } else {
                    oDObject2 = new ODObject(false, (String)charSequence, OBJECT_TYPE, string2);
                    oDObject2.setStatus("Name exist");
                }
                oDObject2.ivid = string;
                oDObject2.branch = oDObject.branch;
                oDObject2.setParentName(oDObject.getName());
                oDObject2.setParentID(oDObject.getIrid());
                oDObject2.branch = oDObject.branch;
                oDObject2.containerType = oDObject.containerType;
                arrayList.add(oDObject2);
            }
            object.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (statement2 != null) {
            statement2.close();
        }
        return arrayList;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        Statement statement = null;
        this.val_statement = null;
        for (ODObject oDObject : list) {
            CharSequence charSequence;
            if (!OBJECT_TYPE.equalsIgnoreCase(oDObject.getType())) continue;
            if (statement == null) {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT b.ID,b.COLUMN_PRECISION,b.DATATYPE,b.DESCRIPTION,b.MAXIMUM_COLUMN_LENGTH,b.DEFAULT_VALUE,b.UNIT_OF_MEASURE ");
                ((StringBuffer)charSequence).append("FROM ci_domains b ");
                ((StringBuffer)charSequence).append("WHERE b.IVID = ?");
                statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
            }
            charSequence = oDObject.getIrid();
            ResultSet resultSet = null;
            try {
                statement.setString(1, oDObject.ivid);
                resultSet = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("ODODomain.generate():", sQLException);
            }
            if (resultSet != null) {
                if (resultSet.next()) {
                    String string;
                    String string2 = resultSet.getString("COLUMN_PRECISION");
                    String string3 = resultSet.getString("DATATYPE");
                    String string4 = resultSet.getString("MAXIMUM_COLUMN_LENGTH");
                    String string5 = resultSet.getString("DESCRIPTION");
                    String string6 = resultSet.getString("DEFAULT_VALUE");
                    String string7 = resultSet.getString("UNIT_OF_MEASURE");
                    String string8 = oDObject.getName();
                    Domain domain = ODODomain.getDomain(this.getDesign().getDomainSet(), (String)charSequence);
                    if (domain == null && (domain = (Domain)this.getDesign().getDomainSet().getByName(string8)) != null) {
                        domain.setImportedId((String)charSequence);
                    }
                    if (domain != null) {
                        domain.setDefaultValues();
                    } else {
                        domain = this.getDesign().getDomainSet().createDomain();
                        domain.setObjectID((String)charSequence);
                    }
                    domain.setName(string8);
                    domain.setName(oDObject.getName());
                    domain.setFileName(this.getDesign().getName() + "_Domains");
                    domain.setComment(string5);
                    if (string6 != null) {
                        domain.setDefaultValue(string6);
                    }
                    if (string7 != null) {
                        domain.setUnitOfMeasure(string7);
                    }
                    this.getExtractionHandler().addToImportedObjects((String)charSequence, domain);
                    String string9 = StandardDatatypeNames.getUsedDatatypeName(string3);
                    LogicalDatatype logicalDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), string9);
                    if (logicalDatatype == null && (string = MappingDatatypeNameLogicalDataType.getDesignerMappedName(string9)) != null) {
                        string9 = string;
                        logicalDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), string9.toUpperCase());
                    }
                    if (logicalDatatype != null) {
                        domain.setLogicalDatatype(logicalDatatype);
                        if (string3.toUpperCase().indexOf("CHAR") <= -1) {
                            if (string3.toUpperCase().indexOf("TIMESTAMP") > -1) {
                                if (string2 != null) {
                                    domain.setDataTypeParameter("precision", string2);
                                }
                            } else {
                                if (string4 != null) {
                                    domain.setDataTypeParameter("precision", string4);
                                }
                                if (string2 != null) {
                                    domain.setDataTypeParameter("scale", string2);
                                }
                            }
                        } else if (string4 != null) {
                            domain.setDataTypeParameter("size", string4);
                        }
                    } else {
                        LOGGER.warn("ODOType.initStructuredTypeAttributes() - Unable to find Logical DataType for: " + string3);
                    }
                    this.setValues(connection, domain, (String)charSequence, oDObject.ivid);
                }
                resultSet.close();
            }
            importLogger.incrementImportedStatements();
        }
        if (statement != null) {
            statement.close();
        }
        if (this.val_statement != null) {
            this.val_statement.close();
        }
    }

    private void setValues(Connection connection, Domain domain, String string, String string2) throws Exception {
        Object object;
        if (this.val_statement == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ');
            ((StringBuffer)object).append("low_value").append(',');
            ((StringBuffer)object).append("HIGH_VALUE").append(",meaning ");
            ((StringBuffer)object).append("FROM").append(' ');
            ((StringBuffer)object).append("ci_attribute_values").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ');
            ((StringBuffer)object).append("domain_reference").append('=').append(" ? ");
            ((StringBuffer)object).append(" and parent_ivid").append('=').append(" ? ");
            ((StringBuffer)object).append("ORDER BY").append(' ').append("radio_sequence");
            this.val_statement = connection.prepareStatement(((StringBuffer)object).toString());
        }
        object = null;
        try {
            this.val_statement.setString(1, string);
            this.val_statement.setString(2, string2);
            object = this.val_statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("ODODomain.setValues():", sQLException);
        }
        if (object != null) {
            while (object.next()) {
                Object object2;
                String string3 = object.getString("low_value");
                String string4 = object.getString("HIGH_VALUE");
                String string5 = object.getString(3);
                if (string4 != null) {
                    object2 = new AVT(string3, string4, string5);
                    domain.addAVT((AVT)object2);
                    continue;
                }
                if (domain.getValueList() == null) {
                    object2 = new ConstraintEnumeration();
                    domain.setValueList((ConstraintEnumeration)object2);
                } else {
                    object2 = domain.getValueList();
                }
                ((ConstraintEnumeration)object2).add(string3, string5);
            }
            object.close();
        }
    }

    public static Domain getDomain(DomainSet domainSet, String string) {
        Domain domain = (Domain)domainSet.getObjectByID(string);
        if (domain == null) {
            domain = (Domain)domainSet.getObjectByImportedID(string);
        }
        return domain;
    }
}

