/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb.v81;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.MOHTable;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.udb.ColumnProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageObjectConstantsUDB;
import oracle.dbtools.crest.model.design.storage.udb.StructuredTypeProxySetUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TriggerUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.ColumnProxyUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.IndexProxyUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.SchemaUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableCheckConstraintProxyUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableProxyUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableSpaceUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TriggerUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHTableUDBv81
extends MOHTable {
    private static final Logger LOGGER = new Logger(MOHTableUDBv81.class);
    private Map scopedColumns;

    public MOHTableUDBv81(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (DBObject dBObject : list) {
            CharSequence charSequence;
            if (!dBObject.isSelected()) continue;
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT TABNAME from SYSCAT.TABLES t").append(' ');
                ((StringBuffer)charSequence).append("WHERE TYPE = 'T' and TABSCHEMA = '");
                ((StringBuffer)charSequence).append(dBObject.getName()).append("'");
                ((StringBuffer)charSequence).append(" AND NOT EXISTS ");
                ((StringBuffer)charSequence).append("(SELECT 1 FROM SYSCAT.VIEWS v ");
                ((StringBuffer)charSequence).append("WHERE ");
                ((StringBuffer)charSequence).append("v.VIEWNAME = t.TABNAME ");
                ((StringBuffer)charSequence).append("AND v.VIEWSCHEMA = t.TABSCHEMA)");
                resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHTableUDBv81.extract(): ", sQLException);
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                    DBObject dBObject2 = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, "TABLE", dBObject.getName());
                    arrayList.add(dBObject2);
                }
                resultSet.close();
            }
            statement.close();
        }
        return arrayList;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        this.scopedColumns = new TreeMap();
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            DBObject dBObject = (DBObject)list.get(i);
            if (!"TABLE".equalsIgnoreCase(dBObject.getType())) continue;
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                object = new StringBuffer();
                ((StringBuffer)object).append("SELECT").append(' ');
                ((StringBuffer)object).append("TABSCHEMA").append(',');
                ((StringBuffer)object).append("TABNAME").append(',');
                ((StringBuffer)object).append("DEFINER").append(',');
                ((StringBuffer)object).append("TYPE").append(',');
                ((StringBuffer)object).append("ROWTYPESCHEMA").append(',');
                ((StringBuffer)object).append("ROWTYPENAME").append(',');
                ((StringBuffer)object).append("TABLEID").append(',');
                ((StringBuffer)object).append("KEYINDEXID").append(',');
                ((StringBuffer)object).append("TBSPACE").append(',');
                ((StringBuffer)object).append("INDEX_TBSPACE").append(',');
                ((StringBuffer)object).append("LONG_TBSPACE").append(',');
                ((StringBuffer)object).append("PARTITION_MODE").append(',');
                ((StringBuffer)object).append("DATACAPTURE").append(',');
                ((StringBuffer)object).append("LOG_ATTRIBUTE").append(',');
                ((StringBuffer)object).append("REMARKS").append(',');
                ((StringBuffer)object).append("REFRESH").append(',');
                ((StringBuffer)object).append("COMPRESSION").append(',');
                ((StringBuffer)object).append("CLUSTERED").append(' ');
                ((StringBuffer)object).append("FROM").append(' ');
                ((StringBuffer)object).append("SYSCAT").append('.').append("TABLES").append(' ').append("t ");
                ((StringBuffer)object).append("WHERE").append(' ');
                ((StringBuffer)object).append("TABSCHEMA").append('=').append('\'');
                ((StringBuffer)object).append(dBObject.getSchema()).append('\'').append(' ');
                ((StringBuffer)object).append("AND").append(' ');
                ((StringBuffer)object).append("TABNAME").append('=').append('\'');
                ((StringBuffer)object).append(dBObject.getName()).append('\'').append(' ');
                ((StringBuffer)object).append("AND").append(' ');
                ((StringBuffer)object).append("TYPE").append('=').append('\'');
                ((StringBuffer)object).append("T").append('\'').append(' ');
                ((StringBuffer)object).append("AND").append(' ');
                ((StringBuffer)object).append("NOT").append(' ').append("EXISTS");
                ((StringBuffer)object).append('(').append("SELECT").append(' ').append("1").append(' ');
                ((StringBuffer)object).append("FROM").append(' ');
                ((StringBuffer)object).append("SYSCAT").append('.').append("VIEWS").append(' ').append("v ");
                ((StringBuffer)object).append("WHERE").append(' ');
                ((StringBuffer)object).append("v").append('.').append("VIEWNAME").append('=');
                ((StringBuffer)object).append("t").append('.').append("TABNAME").append(' ');
                ((StringBuffer)object).append("AND").append(' ');
                ((StringBuffer)object).append("v").append('.').append("VIEWSCHEMA").append('=');
                ((StringBuffer)object).append("t").append('.').append("TABSCHEMA").append(')');
                resultSet = statement.executeQuery(((StringBuffer)object).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHTableUDBv81.generate():", sQLException);
            }
            object = null;
            TableProxyUDBv81 tableProxyUDBv81 = null;
            StorageDesign storageDesign = null;
            if (resultSet != null) {
                if (resultSet.next()) {
                    object = this.getDesign().getRelationalDesign().createTable();
                    ((ContainerObject)object).setSchema(dBObject.getSchema());
                    ((Table)object).setName(dBObject.getName());
                    this.stampModelObject((ModelObject)object, dBObject);
                    String string = resultSet.getString("TBSPACE");
                    String string2 = resultSet.getString("TABSCHEMA");
                    String string3 = resultSet.getString("INDEX_TBSPACE");
                    String string4 = resultSet.getString("LONG_TBSPACE");
                    TableSpaceUDBv81 tableSpaceUDBv81 = null;
                    TableSpaceUDBv81 tableSpaceUDBv812 = null;
                    TableSpaceUDBv81 tableSpaceUDBv813 = null;
                    SchemaUDBv81 schemaUDBv81 = null;
                    storageDesign = this.getStorageDesign();
                    if (storageDesign != null && storageDesign instanceof StorageDesignUDBv81) {
                        tableProxyUDBv81 = (TableProxyUDBv81)((StorageDesignUDBv81)storageDesign).getTableProxySet().getProxy(((ModelIDObject)object).getObjectID());
                        if (tableProxyUDBv81 != null) {
                            tableProxyUDBv81.setName(dBObject.getName());
                            tableSpaceUDBv81 = this.getTableSpace(storageDesign, string);
                            if (tableSpaceUDBv81 != null) {
                                tableProxyUDBv81.setTableSpace(tableSpaceUDBv81);
                            }
                            if ((tableSpaceUDBv812 = this.getTableSpace(storageDesign, string3)) != null) {
                                tableProxyUDBv81.setIndexInTableSpace(tableSpaceUDBv812);
                            }
                            if ((tableSpaceUDBv813 = this.getTableSpace(storageDesign, string4)) != null) {
                                tableProxyUDBv81.setLongInTableSpace(tableSpaceUDBv813);
                            }
                            if ((schemaUDBv81 = (SchemaUDBv81)((StorageDesignUDBv81)storageDesign).getSchemaSet().getByName(string2.trim())) != null) {
                                tableProxyUDBv81.setSchema(schemaUDBv81);
                                tableProxyUDBv81.setOwner(schemaUDBv81.getOwner());
                            }
                            this.initTriggers(connection, tableProxyUDBv81);
                            this.setProperties(tableProxyUDBv81, (StorageDesignUDBv81)storageDesign, resultSet);
                        } else {
                            LOGGER.error("Unable to find TableProxy for table ID: " + ((ModelIDObject)object).getObjectID());
                        }
                    } else {
                        LOGGER.error("Unable to find Storage Design!");
                    }
                    this.initColumns(connection, tableProxyUDBv81, dBObject);
                    this.initColumnConstraints(connection, (Table)object, string2);
                    this.initTableConstraints(connection, (Table)object, string2);
                    this.initUniqueConstraints(connection, (Table)object, string2);
                    this.initIndexes(connection, (Table)object, string2);
                    this.initDimensions(connection, tableProxyUDBv81, dBObject);
                }
                resultSet.close();
            }
            statement.close();
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObject);
        }
    }

    private void initDimensions(Connection connection, TableProxyUDBv81 tableProxyUDBv81, DBObject dBObject) throws SQLException {
        Serializable serializable;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            serializable = new StringBuffer();
            ((StringBuffer)serializable).append("SELECT tabschema,tabname,colname,dimension,colseq ");
            ((StringBuffer)serializable).append("from sysibm.syscoluse ");
            ((StringBuffer)serializable).append("where tabname = '").append(tableProxyUDBv81.getName()).append("'");
            ((StringBuffer)serializable).append(" and tabschema = '").append(dBObject.getSchema()).append("'");
            ((StringBuffer)serializable).append(" order by dimension,colseq ");
            resultSet = statement.executeQuery(((StringBuffer)serializable).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableUDBv81.initDimensions():", sQLException);
        }
        if (resultSet != null) {
            String string;
            serializable = new ArrayList();
            while (resultSet.next()) {
                string = resultSet.getString(3);
                int n = resultSet.getInt(4);
                DimObject dimObject = new DimObject(string, n);
                serializable.add(dimObject);
            }
            resultSet.close();
            if (!serializable.isEmpty()) {
                string = this.getDimString((List)((Object)serializable));
                tableProxyUDBv81.setDimensions(string);
            }
        }
        statement.close();
    }

    private String getDimString(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        DimObject dimObject = (DimObject)list.get(list.size() - 1);
        stringBuffer.append(dimObject.getColName());
        DimObject dimObject2 = dimObject;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = list.size() - 2; i > -1; --i) {
            DimObject dimObject3 = (DimObject)list.get(i);
            if (dimObject2.getDimensionId() == dimObject3.getDimensionId()) {
                int n;
                if (!bl2) {
                    stringBuffer.append(")");
                    bl2 = true;
                }
                if (!bl) {
                    n = stringBuffer.lastIndexOf(",");
                    stringBuffer.insert(n + 1, "(" + dimObject3.getColName() + ",");
                    bl = true;
                    continue;
                }
                n = stringBuffer.lastIndexOf("(");
                stringBuffer.insert(n + 1, dimObject3.getColName() + ",");
                continue;
            }
            bl = false;
            bl2 = false;
            stringBuffer.append("," + dimObject3.getColName());
            dimObject2 = dimObject3;
        }
        return stringBuffer.toString();
    }

    protected TableSpaceUDBv81 getTableSpace(StorageDesign storageDesign, String string) {
        if (string != null && !string.equalsIgnoreCase("")) {
            TableSpaceUDBv81 tableSpaceUDBv81 = (TableSpaceUDBv81)((StorageDesignUDBv81)storageDesign).getTableSpaceSet().getByName(string);
            return tableSpaceUDBv81;
        }
        return null;
    }

    protected void setProperties(TableProxyUDBv81 tableProxyUDBv81, StorageDesignUDBv81 storageDesignUDBv81, ResultSet resultSet) throws SQLException {
        String string = resultSet.getString("PARTITION_MODE");
        String string2 = resultSet.getString("REMARKS");
        String string3 = resultSet.getString("LOG_ATTRIBUTE");
        String string4 = resultSet.getString("DATACAPTURE");
        String string5 = resultSet.getString("COMPRESSION");
        if ("H".equalsIgnoreCase(string)) {
            tableProxyUDBv81.setPartKeyHashing(true);
        }
        if ("1".equalsIgnoreCase(string3)) {
            tableProxyUDBv81.setInitialLogging(false);
        }
        if (!"N".equalsIgnoreCase(string4)) {
            tableProxyUDBv81.setDataCapture(TableProxyUDB.getAvailableDataCaptureValues()[1]);
        }
        if ("Y".equalsIgnoreCase(string5)) {
            tableProxyUDBv81.setValueCompression(StorageObjectConstantsUDB.YES_NO[0]);
        }
        if (string2 != null && !"".equalsIgnoreCase(string2)) {
            tableProxyUDBv81.setCommentInRDBMS(string2);
            tableProxyUDBv81.setCommentInRDBMSChanged(true);
        }
    }

    protected void initColumns(Connection connection, TableProxyUDBv81 tableProxyUDBv81, DBObject dBObject) throws Exception {
        Object object;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        int n = 0;
        try {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ');
            ((StringBuffer)object).append("TABSCHEMA").append(',');
            ((StringBuffer)object).append("TABNAME").append(',');
            ((StringBuffer)object).append("COLNAME").append(',');
            ((StringBuffer)object).append("COLNO").append(',');
            ((StringBuffer)object).append("TYPESCHEMA").append(',');
            ((StringBuffer)object).append("TYPENAME").append(',');
            ((StringBuffer)object).append("LENGTH").append(',');
            ((StringBuffer)object).append("scale").append(',');
            ((StringBuffer)object).append("DEFAULT").append(',');
            ((StringBuffer)object).append("NULLS").append(',');
            ((StringBuffer)object).append("LOGGED").append(',');
            ((StringBuffer)object).append("COMPACT").append(',');
            ((StringBuffer)object).append("CODEPAGE").append(',');
            ((StringBuffer)object).append("TARGET_TYPESCHEMA").append(',');
            ((StringBuffer)object).append("TARGET_TYPENAME").append(',');
            ((StringBuffer)object).append("SCOPE_TABSCHEMA").append(',');
            ((StringBuffer)object).append("SCOPE_TABNAME").append(',');
            ((StringBuffer)object).append("IDENTITY").append(',');
            ((StringBuffer)object).append("GENERATED").append(',');
            ((StringBuffer)object).append("TEXT").append(',');
            ((StringBuffer)object).append("REMARKS").append(',');
            ((StringBuffer)object).append("SPECIAL_PROPS").append(',');
            ((StringBuffer)object).append("DL_FEATURES").append(',');
            ((StringBuffer)object).append("PARTKEYSEQ").append(',');
            ((StringBuffer)object).append("COMPRESS").append(' ');
            ((StringBuffer)object).append("FROM").append(' ');
            ((StringBuffer)object).append("SYSCAT").append('.').append("COLUMNS").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ');
            ((StringBuffer)object).append("TABSCHEMA").append('=');
            ((StringBuffer)object).append('\'').append(dBObject.getSchema()).append('\'');
            ((StringBuffer)object).append("AND").append(' ');
            ((StringBuffer)object).append("TABNAME").append('=');
            ((StringBuffer)object).append('\'').append(dBObject.getName()).append('\'');
            ((StringBuffer)object).append("ORDER BY").append(' ').append("COLNO");
            resultSet = statement.executeQuery(((StringBuffer)object).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableUDBv81.initColumns():", sQLException);
        }
        object = (Table)tableProxyUDBv81.getObject();
        if (resultSet != null) {
            while (resultSet.next()) {
                Object object2;
                ModelIDObject modelIDObject;
                Object object3;
                String string = resultSet.getString("COLNAME");
                String string2 = resultSet.getString("TYPENAME");
                int n2 = resultSet.getInt("LENGTH");
                int n3 = resultSet.getInt("scale");
                Integer n4 = (Integer)resultSet.getObject("PARTKEYSEQ");
                String string3 = resultSet.getString("NULLS");
                String string4 = resultSet.getString("DEFAULT");
                String string5 = resultSet.getString("LOGGED");
                String string6 = resultSet.getString("COMPACT");
                String string7 = resultSet.getString("IDENTITY");
                String string8 = resultSet.getString("GENERATED");
                String string9 = resultSet.getString("REMARKS");
                String string10 = resultSet.getString("COMPRESS");
                String string11 = resultSet.getString("DL_FEATURES");
                String string12 = resultSet.getString("TARGET_TYPESCHEMA");
                String string13 = resultSet.getString("TARGET_TYPENAME");
                String string14 = resultSet.getString("SCOPE_TABSCHEMA");
                String string15 = resultSet.getString("SCOPE_TABNAME");
                Column column = null;
                if (n == 0 && ((ContainerObject)object).isBST()) {
                    object3 = (Column)((ContainerObject)object).getOidElement();
                    if (object3 != null) {
                        ((DesignObject)object3).setName(string);
                    }
                    ++n;
                    continue;
                }
                column = (Column)((ContainerObject)object).getElementByName(string);
                if (column == null) {
                    column = ((Table)object).createColumn(string);
                    this.stampModelObject((ModelObject)column, ((DesignObject)object).getName(), string);
                    if ("REFERENCE".equalsIgnoreCase(string2)) {
                        column.setReference(true);
                        object3 = ((StructuredTypeProxySetUDB)this.getStorageDesign().getStructuredTypeProxySet()).getBySchemaAndName(string12, string13);
                        if (object3 == null) {
                            object3 = this.getStorageDesign().getStructuredTypeProxySet().getByName(string13);
                        }
                        if ((modelIDObject = object3 != null ? ((StructuredTypeProxy)object3).getStructuredType() : (StructuredType)this.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(string13)) != null) {
                            column.setUse((short)3);
                            column.setStructuredType((StructuredType)modelIDObject);
                        } else {
                            object2 = (DistinctType)this.getDesign().getDataTypesDesign().getCollectionTypeSet().getByName(string2);
                            if (object2 != null) {
                                column.setUse((short)2);
                                column.setDistinctType((DistinctType)object2);
                            }
                        }
                        object2 = new ScoppedNames();
                        ((ScoppedNames)object2).schema = string14;
                        ((ScoppedNames)object2).name = string15;
                        this.scopedColumns.put(column.getObjectID(), object2);
                    } else {
                        object3 = StandardDatatypeNames.getUsedDatatypeName(string2);
                        modelIDObject = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), (String)object3);
                        if (modelIDObject == null) {
                            modelIDObject = this.getDesign().getLogicalDatatypeSet().getLogTypeByNativeType(string2, this.getDbmeHandler().getRDBMSSite().getType().getName());
                        }
                        if (modelIDObject != null && !"UNKNOWN".equalsIgnoreCase((String)object3)) {
                            column.setUse((short)1);
                            column.setLogicalDatatype((LogicalDatatype)modelIDObject);
                            column.setDataTypeParameter("size", String.valueOf(n2));
                            column.setDataTypeParameter("scale", String.valueOf(n3));
                        } else {
                            object2 = (StructuredType)this.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(string2);
                            if (object2 != null) {
                                column.setUse((short)3);
                                column.setStructuredType((StructuredType)object2);
                            } else {
                                DistinctType distinctType = (DistinctType)this.getDesign().getDataTypesDesign().getCollectionTypeSet().getByName(string2);
                                if (distinctType != null) {
                                    column.setUse((short)2);
                                    column.setDistinctType(distinctType);
                                }
                            }
                        }
                        if ("Y".equalsIgnoreCase(string3)) {
                            column.setNullsAllowed(true);
                        } else {
                            column.setNullsAllowed(false);
                        }
                        if (string4 != null) {
                            column.setDefaultValue(string4);
                        }
                        if (n4 != null && n4 > 0) {
                            tableProxyUDBv81.setPartitioningKey(column.getName());
                        }
                    }
                }
                ++n;
                object3 = this.getStorageDesign();
                if (object3 == null || !(object3 instanceof StorageDesignUDBv81) || (object2 = (ColumnProxyUDBv81)(modelIDObject = (StorageDesignUDBv81)object3).getColumnProxySet().getProxy(column.getObjectID())) == null) continue;
                if ("Y".equalsIgnoreCase(string5)) {
                    ((ColumnProxyUDB)object2).setLogging("LOGGED");
                }
                if ("Y".equalsIgnoreCase(string6)) {
                    ((ColumnProxyUDB)object2).setCompact(ColumnProxyUDB.getCompactChoices()[0]);
                }
                if ("Y".equalsIgnoreCase(string7)) {
                    ((ColumnProxyUDB)object2).setUseIdentity(true);
                    this.initIdentityColumn(connection, (Table)object, (ColumnProxyUDBv81)object2);
                    if ("D".equalsIgnoreCase(string8)) {
                        ((ColumnProxyUDB)object2).setGenerate(ColumnProxyUDB.getGenerateValues()[1]);
                    }
                }
                if ("S".equalsIgnoreCase(string10)) {
                    ((ColumnProxyUDBv81)object2).setCompressSystemDefault("YES");
                }
                if (string11 != null && string11.equals("")) {
                    this.initDatalinkOptions((ColumnProxyUDBv81)object2, string11);
                }
                ((ModelIDObject)object2).setCommentInRDBMS(string9);
                ((RelationalObjectProxy)object2).setCommentInRDBMSChanged(true);
            }
            resultSet.close();
        }
        statement.close();
    }

    private void initIdentityColumn(Connection connection, Table table, ColumnProxyUDBv81 columnProxyUDBv81) throws Exception {
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT").append(' ');
            stringBuffer.append("s").append('.').append("INCREMENT").append(',');
            stringBuffer.append("s").append('.').append("START").append(',');
            stringBuffer.append("s").append('.').append("MAXVALUE").append(',');
            stringBuffer.append("s").append('.').append("MINVALUE").append(',');
            stringBuffer.append("s").append('.').append("CYCLE").append(',');
            stringBuffer.append("s").append('.').append("CACHE").append(',');
            stringBuffer.append("s").append('.').append("ORDER").append(' ');
            stringBuffer.append("FROM").append(' ');
            stringBuffer.append("sysibm.SYSSEQUENCES s").append(',');
            stringBuffer.append("sysibm.SYSDEPENDENCIES d").append(' ');
            stringBuffer.append("WHERE").append(' ');
            stringBuffer.append("d").append('.').append("dschema");
            stringBuffer.append('=').append('\'').append(table.getSchema()).append('\'');
            stringBuffer.append(' ').append("AND").append(' ');
            stringBuffer.append("d").append('.').append("dname");
            stringBuffer.append('=').append('\'').append(table.getName()).append('\'');
            stringBuffer.append(' ').append("AND").append(' ');
            stringBuffer.append("s").append('.').append("seqtype ");
            stringBuffer.append('=').append('\'').append("I").append('\'');
            stringBuffer.append(' ').append("AND").append(' ');
            stringBuffer.append("s").append('.').append("seqschema");
            stringBuffer.append('=').append("d.bschema");
            stringBuffer.append(' ').append("AND").append(' ');
            stringBuffer.append("s").append('.').append("seqname");
            stringBuffer.append('=').append("d.bname");
            resultSet = statement.executeQuery(stringBuffer.toString());
        }
        catch (Exception exception) {
            LOGGER.error("MOHTableUDBv81.initIdentityColumn():", exception);
        }
        if (resultSet != null) {
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                String string = resultSet.getString(2);
                Object object = resultSet.getObject(3);
                Object object2 = resultSet.getObject(4);
                String string2 = resultSet.getString(5);
                int n2 = resultSet.getInt(6);
                String string3 = resultSet.getString(7);
                columnProxyUDBv81.setIncrementBy(n);
                columnProxyUDBv81.setStartWith(string);
                columnProxyUDBv81.setMaxValue(String.valueOf(object));
                columnProxyUDBv81.setMinValue(String.valueOf(object2));
                columnProxyUDBv81.setCycle(string2);
                columnProxyUDBv81.setCache(String.valueOf(n2));
                columnProxyUDBv81.setOrder(string3);
            }
            resultSet.close();
        }
        statement.close();
    }

    protected void initColumnConstraints(Connection connection, Table table, String string) throws Exception {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("select a.constname,a.definition, b.enforced, b.enablequeryopt,d.colname ");
            ((StringBuffer)charSequence).append("from (select c.constname,c.text definition,c.tabschema,c.tabname ");
            ((StringBuffer)charSequence).append("from syscat.CHECKS c where c.tabschema = '");
            ((StringBuffer)charSequence).append(string.trim()).append("' and ");
            ((StringBuffer)charSequence).append("c.tabname = '");
            ((StringBuffer)charSequence).append(table.getName()).append("' and c.type = 'C' and 1 = (select count(*) ");
            ((StringBuffer)charSequence).append("from syscat.COLCHECKS ch where c.constname = ch.constname and ");
            ((StringBuffer)charSequence).append("c.tabschema = ch.tabschema and c.tabname = ch.tabname))a, syscat.TABCONST b, syscat.colchecks d ");
            ((StringBuffer)charSequence).append("where a.tabname = b.tabname and a.tabschema = b.tabschema and a.constname = b.constname and ");
            ((StringBuffer)charSequence).append("a.tabname = d.tabname and a.tabschema = d.tabschema and a.constname = d.constname ");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableUDBv81.initColumnConstraints():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(3);
                String string4 = resultSet.getString(4);
                String string5 = resultSet.getString(5);
                CheckConstraint checkConstraint = new CheckConstraint();
                checkConstraint.setDesign(table.getDesign());
                checkConstraint.setName((String)charSequence);
                checkConstraint.add(StorageDesignUDBv81.RDBMS_TYPE, string2);
                Column column = (Column)table.getElementByName(string5);
                if (column == null) continue;
                column.setUseDomainConstraints(false);
                column.setCheck(checkConstraint);
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign == null || !(storageDesign instanceof StorageDesignUDBv81)) continue;
                StorageDesignUDBv81 storageDesignUDBv81 = (StorageDesignUDBv81)storageDesign;
                ColumnProxyUDBv81 columnProxyUDBv81 = (ColumnProxyUDBv81)storageDesignUDBv81.getColumnProxySet().getProxy(column.getObjectID());
                if ("N".equalsIgnoreCase(string3)) {
                    columnProxyUDBv81.setValidation("NOT ENFORCED");
                }
                if (!"N".equalsIgnoreCase(string4)) continue;
                columnProxyUDBv81.setQueryOptimization("DISABLE");
            }
            resultSet.close();
        }
        statement.close();
    }

    protected void initTableConstraints(Connection connection, Table table, String string) throws Exception {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("select a.constname,a.definition, b.enforced, b.enablequeryopt ");
            ((StringBuffer)charSequence).append("from (select c.constname,c.text definition,c.tabschema,c.tabname ");
            ((StringBuffer)charSequence).append("from syscat.CHECKS c where ");
            ((StringBuffer)charSequence).append("c.tabschema =  '");
            ((StringBuffer)charSequence).append(string.trim()).append("' and ");
            ((StringBuffer)charSequence).append("c.tabname = '");
            ((StringBuffer)charSequence).append(table.getName()).append("' and ");
            ((StringBuffer)charSequence).append(" c.type = 'C' and ");
            ((StringBuffer)charSequence).append("1<( ");
            ((StringBuffer)charSequence).append("select count(*) ");
            ((StringBuffer)charSequence).append("from syscat.COLCHECKS ch  ");
            ((StringBuffer)charSequence).append("where ");
            ((StringBuffer)charSequence).append("c.constname = ch.constname and ");
            ((StringBuffer)charSequence).append("c.tabschema = ch.tabschema and ");
            ((StringBuffer)charSequence).append("c.tabname = ch.tabname)) a, syscat.TABCONST b ");
            ((StringBuffer)charSequence).append("where ");
            ((StringBuffer)charSequence).append("a.tabname = b.tabname and ");
            ((StringBuffer)charSequence).append("a.tabschema = b.tabschema and ");
            ((StringBuffer)charSequence).append("a.constname = b.constname ");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableUDBv81.initTableConstraints:", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                StorageDesignUDBv81 storageDesignUDBv81;
                TableCheckConstraintProxyUDBv81 tableCheckConstraintProxyUDBv81;
                charSequence = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(3);
                String string4 = resultSet.getString(4);
                TableLevelConstraint tableLevelConstraint = table.createCheckConstraint((String)charSequence, string2);
                this.stampModelObject((ModelObject)tableLevelConstraint, string.trim(), (String)charSequence);
                table.addCheckConstraint(tableLevelConstraint);
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign == null || !(storageDesign instanceof StorageDesignUDBv81) || (tableCheckConstraintProxyUDBv81 = (TableCheckConstraintProxyUDBv81)(storageDesignUDBv81 = (StorageDesignUDBv81)storageDesign).getTableCheckConstraintSet().getByName((String)charSequence)) == null) continue;
                if ("N".equalsIgnoreCase(string3)) {
                    tableCheckConstraintProxyUDBv81.setValidation("NOT ENFORCED");
                }
                if (!"N".equalsIgnoreCase(string4)) continue;
                tableCheckConstraintProxyUDBv81.setQueryOptimization("DISABLE");
            }
            resultSet.close();
        }
        statement.close();
    }

    protected void initUniqueConstraints(Connection connection, Table table, String string) throws Exception {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT  constname,type, enforced, ");
            ((StringBuffer)charSequence).append("enablequeryopt, remarks comment ");
            ((StringBuffer)charSequence).append("FROM  syscat.TABCONST ");
            ((StringBuffer)charSequence).append("WHERE tabschema  = '");
            ((StringBuffer)charSequence).append(string.trim()).append("'");
            ((StringBuffer)charSequence).append(" AND tabname  = '");
            ((StringBuffer)charSequence).append(table.getName()).append("'");
            ((StringBuffer)charSequence).append(" AND type in ('P','U')");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableUDBv81.initUniqueConstraints():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                Index index = table.createIndex();
                index.setContainerObject(table);
                index.setName((String)charSequence);
                this.stampModelObject((ModelObject)index, string.trim(), (String)charSequence);
                this.initKeyColumns(connection, index, (String)charSequence, table);
                if ("U".equalsIgnoreCase(string2)) {
                    index.setIndexState("Unique Constraint");
                    continue;
                }
                if ("P".equalsIgnoreCase(string2) && !table.isBST()) {
                    index.setIndexState("Primary Constraint");
                    continue;
                }
                if (!"P".equalsIgnoreCase(string2) || !table.isBST()) continue;
                if (index.getElementsCollection().size() > 0) {
                    table.getOidPKColumns().addAll(index.getElementsCollection());
                    table.setOidIsPK(true);
                }
                index.remove();
                index = (Index)table.getPK();
                index.setName((String)charSequence);
            }
            resultSet.close();
        }
        statement.close();
    }

    private void initKeyColumns(Connection connection, Index index, String string, Table table) throws Exception {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT COLNAME, COLSEQ ");
            ((StringBuffer)charSequence).append("from syscat.keycoluse ");
            ((StringBuffer)charSequence).append("WHERE tabschema  = '");
            ((StringBuffer)charSequence).append(table.getSchema()).append("'");
            ((StringBuffer)charSequence).append(" AND tabname = '");
            ((StringBuffer)charSequence).append(table.getName()).append("' and ");
            ((StringBuffer)charSequence).append("constname = '").append(index.getName());
            ((StringBuffer)charSequence).append("' order by colseq");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableUDBv81.initKeyColumns():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                Column column = (Column)table.getElementByName((String)charSequence);
                if (column == null) continue;
                index.add(column);
            }
            resultSet.close();
        }
        statement.close();
    }

    protected void initIndexes(Connection connection, Table table, String string) throws Exception {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT  indname,indschema,colnames, uniquerule, ");
            ((StringBuffer)charSequence).append("colcount,unique_colcount,indextype clust_reg, ");
            ((StringBuffer)charSequence).append("pctfree,minpctused,reverse_scans,remarks comment ");
            ((StringBuffer)charSequence).append("from syscat.indexes  ");
            ((StringBuffer)charSequence).append("WHERE  tabname  =  '");
            ((StringBuffer)charSequence).append(table.getName()).append("'");
            ((StringBuffer)charSequence).append(" AND tabschema  = '");
            ((StringBuffer)charSequence).append(string.trim()).append("'");
            ((StringBuffer)charSequence).append(" AND entrytype <>'H' ");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableUDBv81.initIndexes():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                StorageDesignUDBv81 storageDesignUDBv81;
                charSequence = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(4);
                String string4 = resultSet.getString(7);
                int n = resultSet.getInt(8);
                int n2 = resultSet.getInt(9);
                String string5 = resultSet.getString(10);
                String string6 = resultSet.getString(11);
                Index index = table.createIndex();
                index.setName((String)charSequence);
                index.setCommentInRDBMS(string6);
                this.stampModelObject((ModelObject)index, string.trim(), (String)charSequence);
                if ("U".equalsIgnoreCase(string3)) {
                    index.setIndexState("Unique Plain Index");
                } else if ("P".equalsIgnoreCase(string3) && !table.isBST()) {
                    index.setIndexState("Unique Plain Index");
                } else if ("P".equalsIgnoreCase(string3) && table.isBST()) {
                    if (index.getElementsCollection().size() > 0) {
                        table.getOidPKColumns().addAll(index.getElementsCollection());
                        table.setOidIsPK(true);
                    }
                    index.remove();
                    index = (Index)table.getPK();
                    index.setName((String)charSequence);
                }
                IndexProxyUDBv81 indexProxyUDBv81 = null;
                SchemaUDBv81 schemaUDBv81 = null;
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign == null || !(storageDesign instanceof StorageDesignUDBv81) || (indexProxyUDBv81 = (IndexProxyUDBv81)(storageDesignUDBv81 = (StorageDesignUDBv81)storageDesign).getIndexProxySet().getObjectGeneratedBy(index)) == null) continue;
                schemaUDBv81 = (SchemaUDBv81)storageDesignUDBv81.getSchemaSet().getByName(string2);
                if (schemaUDBv81 != null) {
                    indexProxyUDBv81.setSchema(schemaUDBv81);
                    indexProxyUDBv81.setOwner(schemaUDBv81.getOwner());
                }
                indexProxyUDBv81.setPercentageFree(n);
                indexProxyUDBv81.setMinimumPercentageUsed(n2);
                if ("CLUS".equalsIgnoreCase(string4)) {
                    indexProxyUDBv81.setCluster(true);
                }
                if ("Y".equalsIgnoreCase(string5)) {
                    indexProxyUDBv81.setReverseScanSupport(true);
                }
                this.initIndexPrivileges(connection, indexProxyUDBv81);
                this.initIndexColumns(connection, indexProxyUDBv81, (String)charSequence, table);
            }
            resultSet.close();
        }
        statement.close();
    }

    private void initIndexPrivileges(Connection connection, IndexProxyUDBv81 indexProxyUDBv81) throws Exception {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT grantee,granteetype,controlauth ");
            ((StringBuffer)charSequence).append("from syscat.indexauth ");
            ((StringBuffer)charSequence).append("WHERE INDNAME = '");
            ((StringBuffer)charSequence).append(indexProxyUDBv81.getName()).append("'");
            ((StringBuffer)charSequence).append(" AND INDSCHEMA = '");
            ((StringBuffer)charSequence).append(indexProxyUDBv81.getSchema()).append("'");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableUDBv81.initIndexColumns():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string = resultSet.getString(2);
                String string2 = resultSet.getString(3);
                if (!"Y".equalsIgnoreCase(string2)) continue;
                if ("U".equalsIgnoreCase(string)) {
                    indexProxyUDBv81.setUsers(((String)charSequence).trim());
                    continue;
                }
                indexProxyUDBv81.setGroups(((String)charSequence).trim());
            }
            resultSet.close();
        }
        statement.close();
    }

    private void initIndexColumns(Connection connection, IndexProxyUDBv81 indexProxyUDBv81, String string, Table table) throws Exception {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT colname, colseq, colorder ");
            ((StringBuffer)charSequence).append("from syscat.INDEXCOLUSE ");
            ((StringBuffer)charSequence).append("WHERE INDNAME = '");
            ((StringBuffer)charSequence).append(string).append("'");
            ((StringBuffer)charSequence).append(" AND INDSCHEMA = '");
            ((StringBuffer)charSequence).append(table.getSchema()).append("'");
            ((StringBuffer)charSequence).append(" ORDER BY COLSEQ ");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableUDBv81.initIndexColumns():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                Column column = (Column)table.getElementByName((String)charSequence);
                Index index = indexProxyUDBv81.getIndex();
                if (column == null) continue;
                index.add(column);
                if ("A".equals(string2)) {
                    index.setColumnSortOrder(column, "ASC");
                } else {
                    index.setColumnSortOrder(column, "DESC");
                }
                indexProxyUDBv81.setColumnList(column.getName());
            }
            resultSet.close();
        }
        statement.close();
    }

    protected void initTriggers(Connection connection, TableProxyUDBv81 tableProxyUDBv81) throws Exception {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT TRIGSCHEMA,TRIGNAME,TRIGTIME, ");
            ((StringBuffer)charSequence).append("TRIGEVENT,GRANULARITY,TEXT definition,REMARKS comment ");
            ((StringBuffer)charSequence).append("from syscat.triggers ");
            ((StringBuffer)charSequence).append("WHERE tabname = '");
            ((StringBuffer)charSequence).append(tableProxyUDBv81.getName()).append("'");
            ((StringBuffer)charSequence).append(" AND tabschema = '");
            ((StringBuffer)charSequence).append(tableProxyUDBv81.getSchema()).append("'");
            ((StringBuffer)charSequence).append(" ORDER BY TRIGEVENT,TRIGTIME,create_time ");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableUDBv81.initIndexColumns():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string = resultSet.getString(2);
                String string2 = resultSet.getString(3);
                String string3 = resultSet.getString(4);
                String string4 = resultSet.getString(5);
                String string5 = resultSet.getString(6);
                String string6 = resultSet.getString(7);
                SchemaUDBv81 schemaUDBv81 = null;
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign == null || !(storageDesign instanceof StorageDesignUDBv81)) continue;
                StorageDesignUDBv81 storageDesignUDBv81 = (StorageDesignUDBv81)storageDesign;
                TriggerUDBv81 triggerUDBv81 = (TriggerUDBv81)storageDesignUDBv81.getTriggerSet().createTrigger();
                triggerUDBv81.setName(string);
                triggerUDBv81.setTable(tableProxyUDBv81);
                triggerUDBv81.setSchema(tableProxyUDBv81.getSchema());
                this.stampModelObject((ModelObject)triggerUDBv81, (String)charSequence, string);
                schemaUDBv81 = (SchemaUDBv81)storageDesignUDBv81.getSchemaSet().getByName((String)charSequence);
                if (schemaUDBv81 != null) {
                    triggerUDBv81.setOwner(schemaUDBv81.getOwner());
                }
                if ("U".equalsIgnoreCase(string3)) {
                    triggerUDBv81.setActions(Trigger.ACTION_TYPES[1]);
                } else if ("D".equalsIgnoreCase(string3)) {
                    triggerUDBv81.setActions(Trigger.ACTION_TYPES[2]);
                }
                if ("A".equalsIgnoreCase(string2)) {
                    triggerUDBv81.setTriggerTime(TriggerUDB.TRIGGER_TIMES[1]);
                } else if ("B".equalsIgnoreCase(string2)) {
                    triggerUDBv81.setTriggerTime(TriggerUDB.TRIGGER_TIMES[0]);
                }
                if ("S".equalsIgnoreCase(string4)) {
                    triggerUDBv81.setScope(TriggerUDB.SCOPE_TYPES[1]);
                }
                triggerUDBv81.setBody(string5);
                triggerUDBv81.setCommentInRDBMS(string6);
            }
            resultSet.close();
        }
        statement.close();
    }

    private void initDatalinkOptions(ColumnProxyUDBv81 columnProxyUDBv81, String string) {
        String string2 = String.valueOf(string.charAt(2));
        String string3 = String.valueOf(string.charAt(4));
        String string4 = String.valueOf(string.charAt(5));
        String string5 = String.valueOf(string.charAt(6));
        String string6 = String.valueOf(string.charAt(7));
        if ("F".equalsIgnoreCase(string2)) {
            columnProxyUDBv81.setLinkControl(ColumnProxyUDB.getLinkControlChoices()[1]);
        }
        if ("D".equalsIgnoreCase(string3)) {
            columnProxyUDBv81.setReadPermission(ColumnProxyUDB.getReadPermissionChoices()[1]);
        }
        if ("B".equalsIgnoreCase(string4)) {
            columnProxyUDBv81.setWritePermission(ColumnProxyUDB.getWritePermissionChoices()[1]);
        }
        if ("N".equalsIgnoreCase(string5)) {
            columnProxyUDBv81.setRecovery(ColumnProxyUDB.getRecoveryChoices()[1]);
        }
        if ("D".equalsIgnoreCase(string6)) {
            columnProxyUDBv81.setOnUnlink(ColumnProxyUDB.getOnUnlinkChoices()[1]);
        }
    }

    @Override
    public void postGenerateProcessing(Connection connection) {
        if (this.scopedColumns != null) {
            for (String string : this.scopedColumns.keySet()) {
                TableProxy tableProxy;
                Column column = (Column)this.getDesign().getDesignObject(string);
                ScoppedNames scoppedNames = (ScoppedNames)this.scopedColumns.get(string);
                if (scoppedNames == null || column == null || (tableProxy = this.getStorageDesign().getTableProxySet().getByUserSchemaAndName(scoppedNames.schema, scoppedNames.name)) == null) continue;
                column.setScopeId(tableProxy.getObject().getObjectID());
            }
        }
    }

    class ScoppedNames {
        String schema = "";
        String name = "";

        ScoppedNames() {
        }
    }

    public class DimObject {
        private String colName = "";
        private int dimensionId = 0;

        public DimObject(String string, int n) {
            this.colName = string;
            this.dimensionId = n;
        }

        public String getColName() {
            return this.colName;
        }

        public int getDimensionId() {
            return this.dimensionId;
        }
    }
}

