/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb.v81;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.MOHTable;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.v81.StagingTableUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableProxySetUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableProxyUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHStagingTableUDBv81
extends MOHTable {
    public static final String OBJECT_TYPE = "STAGING TABLE";
    private static final Logger LOGGER = new Logger(MOHStagingTableUDBv81.class);

    public MOHStagingTableUDBv81(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (DBObject dBObject : list) {
            CharSequence charSequence;
            if (!dBObject.isSelected()) continue;
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT TABNAME from SYSCAT.TABLES t,syscat.VIEWS v ").append(' ');
                ((StringBuffer)charSequence).append("WHERE TYPE = 'T' and TABSCHEMA = '");
                ((StringBuffer)charSequence).append(dBObject.getName()).append("'");
                ((StringBuffer)charSequence).append(" AND v.VIEWNAME = t.TABNAME ");
                ((StringBuffer)charSequence).append(" AND v.VIEWSCHEMA = t.TABSCHEMA");
                resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHStagingTableUDBv81.extract(): ", sQLException);
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                    DBObject dBObject2 = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, OBJECT_TYPE, dBObject.getName());
                    arrayList.add(dBObject2);
                }
                resultSet.close();
            }
            statement.close();
        }
        return arrayList;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            DBObject dBObject = (DBObject)list.get(i);
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObject.getType())) continue;
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                object = new StringBuffer();
                ((StringBuffer)object).append("SELECT TABNAME from SYSCAT.TABLES t,syscat.VIEWS v ").append(' ');
                ((StringBuffer)object).append("WHERE TYPE = 'T' and TABSCHEMA = '");
                ((StringBuffer)object).append(dBObject.getSchema()).append("'");
                ((StringBuffer)object).append(" AND TABNAME = '").append(dBObject.getName()).append("'");
                ((StringBuffer)object).append(" AND v.VIEWNAME = t.TABNAME ");
                ((StringBuffer)object).append(" AND v.VIEWSCHEMA = t.TABSCHEMA");
                resultSet = statement.executeQuery(((StringBuffer)object).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHStagingTableUDBv81.generate(): ");
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    object = this.getStorageDesign();
                    if (object == null || !(object instanceof StorageDesignUDBv81)) continue;
                    StorageDesignUDBv81 storageDesignUDBv81 = (StorageDesignUDBv81)object;
                    StagingTableUDBv81 stagingTableUDBv81 = (StagingTableUDBv81)storageDesignUDBv81.getStagingTableSet().createStagingTable();
                    stagingTableUDBv81.setName(dBObject.getName());
                    this.setTable(connection, stagingTableUDBv81, dBObject.getSchema());
                    this.initColumns(connection, stagingTableUDBv81, dBObject);
                    this.stampModelObject(stagingTableUDBv81, dBObject);
                }
                resultSet.close();
            }
            statement.close();
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObject);
        }
    }

    private void setTable(Connection connection, StagingTableUDBv81 stagingTableUDBv81, String string) throws SQLException {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT BSCHEMA, BNAME  from syscat.tabdep ").append(' ');
            ((StringBuffer)charSequence).append("WHERE  TABSCHEMA = '");
            ((StringBuffer)charSequence).append(string).append("'");
            ((StringBuffer)charSequence).append(" AND TABNAME = '").append(stagingTableUDBv81.getName()).append("'");
            ((StringBuffer)charSequence).append(" AND BTYPE = 'S' ");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableDB2v80.extract(): ");
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                StorageDesignUDBv81 storageDesignUDBv81;
                TableProxyUDBv81 tableProxyUDBv81;
                charSequence = resultSet.getString(2);
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign == null || !(storageDesign instanceof StorageDesignUDBv81) || (tableProxyUDBv81 = (TableProxyUDBv81)((TableProxySetUDBv81)(storageDesignUDBv81 = (StorageDesignUDBv81)storageDesign).getTableProxySet()).getByName((String)charSequence)) == null) continue;
                stagingTableUDBv81.setTable(tableProxyUDBv81);
            }
            resultSet.close();
        }
        statement.close();
    }

    private void initColumns(Connection connection, StagingTableUDBv81 stagingTableUDBv81, DBObject dBObject) throws Exception {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append("TABSCHEMA").append(',');
            ((StringBuffer)charSequence).append("TABNAME").append(',');
            ((StringBuffer)charSequence).append("COLNAME").append(',');
            ((StringBuffer)charSequence).append("COLNO").append(',');
            ((StringBuffer)charSequence).append("TYPESCHEMA").append(',');
            ((StringBuffer)charSequence).append("TYPENAME").append(',');
            ((StringBuffer)charSequence).append("LENGTH").append(',');
            ((StringBuffer)charSequence).append("scale").append(',');
            ((StringBuffer)charSequence).append("DEFAULT").append(',');
            ((StringBuffer)charSequence).append("NULLS").append(',');
            ((StringBuffer)charSequence).append("LOGGED").append(',');
            ((StringBuffer)charSequence).append("COMPACT").append(',');
            ((StringBuffer)charSequence).append("CODEPAGE").append(',');
            ((StringBuffer)charSequence).append("TARGET_TYPESCHEMA").append(',');
            ((StringBuffer)charSequence).append("SCOPE_TABSCHEMA").append(',');
            ((StringBuffer)charSequence).append("SCOPE_TABNAME").append(',');
            ((StringBuffer)charSequence).append("IDENTITY").append(',');
            ((StringBuffer)charSequence).append("GENERATED").append(',');
            ((StringBuffer)charSequence).append("TEXT").append(',');
            ((StringBuffer)charSequence).append("REMARKS").append(',');
            ((StringBuffer)charSequence).append("SPECIAL_PROPS").append(',');
            ((StringBuffer)charSequence).append("DL_FEATURES").append(',');
            ((StringBuffer)charSequence).append("PARTKEYSEQ").append(',');
            ((StringBuffer)charSequence).append("COMPRESS").append(' ');
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append("SYSCAT").append('.').append("COLUMNS").append(' ');
            ((StringBuffer)charSequence).append("WHERE").append(' ');
            ((StringBuffer)charSequence).append("TABSCHEMA").append('=');
            ((StringBuffer)charSequence).append('\'').append(dBObject.getSchema()).append('\'');
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("TABNAME").append('=');
            ((StringBuffer)charSequence).append('\'').append(dBObject.getName()).append('\'');
            ((StringBuffer)charSequence).append("ORDER BY").append(' ').append("COLNO");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHStagingTableUDBv81.initColumns():", sQLException);
        }
        if (resultSet != null) {
            stagingTableUDBv81.setDefineColumnNames(true);
            while (resultSet.next()) {
                charSequence = resultSet.getString("COLNAME");
                stagingTableUDBv81.setColumns((String)charSequence);
            }
            resultSet.close();
        }
        statement.close();
    }
}

