/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb.v81;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.v81.SchemaUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.SequenceUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHSequencesUDBv81
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "SEQUENCES";
    private static final Logger LOGGER = new Logger(MOHSequencesUDBv81.class);

    public MOHSequencesUDBv81(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        StorageDesign storageDesign = this.getStorageDesign();
        if (storageDesign != null && storageDesign instanceof StorageDesignUDBv81) {
            StorageDesignUDBv81 storageDesignUDBv81 = (StorageDesignUDBv81)storageDesign;
            Iterator iterator = storageDesignUDBv81.getSchemaSet().iterator();
            while (iterator.hasNext()) {
                SchemaUDBv81 schemaUDBv81 = (SchemaUDBv81)iterator.next();
                this.initSequences(connection, storageDesignUDBv81, schemaUDBv81);
            }
        }
    }

    private void initSequences(Connection connection, StorageDesignUDBv81 storageDesignUDBv81, SchemaUDBv81 schemaUDBv81) throws SQLException {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT seqname,s.increment, s.start, s.maxvalue,  ");
            ((StringBuffer)charSequence).append("s.minvalue, s.cycle, s.cache, s.order ");
            ((StringBuffer)charSequence).append("from  sysibm.SYSSEQUENCES s ");
            ((StringBuffer)charSequence).append("WHERE seqschema = '");
            ((StringBuffer)charSequence).append(schemaUDBv81.getName()).append("'");
            ((StringBuffer)charSequence).append(" and seqtype = 'S'");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHSequencesUDBv81.initSequences():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                int n = resultSet.getInt(2);
                int n2 = resultSet.getInt(3);
                String string = resultSet.getString(4);
                String string2 = resultSet.getString(5);
                String string3 = resultSet.getString(6);
                int n3 = resultSet.getInt(7);
                String string4 = resultSet.getString(8);
                SequenceUDBv81 sequenceUDBv81 = (SequenceUDBv81)storageDesignUDBv81.getSequenceSet().createSequence();
                sequenceUDBv81.setName((String)charSequence);
                this.stampModelObject((ModelObject)sequenceUDBv81, schemaUDBv81.getName(), (String)charSequence);
                sequenceUDBv81.setIncrementBy(n);
                sequenceUDBv81.setStartWith(n2);
                sequenceUDBv81.setMaxValue(string);
                sequenceUDBv81.setMinValue(string2);
                sequenceUDBv81.setCache(n3);
                sequenceUDBv81.setSchema(schemaUDBv81);
                sequenceUDBv81.setOwner(schemaUDBv81.getOwner());
                if ("Y".equalsIgnoreCase(string3)) {
                    sequenceUDBv81.setCycle("YES");
                }
                if (!"Y".equalsIgnoreCase(string4)) continue;
                sequenceUDBv81.setOrder("YES");
            }
            resultSet.close();
        }
        statement.close();
    }
}

