/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.MOHView;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.StructuredTypeProxySetUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxyUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHViewUDB
extends MOHView {
    private static final Logger LOGGER = new Logger(MOHViewUDB.class);

    public MOHViewUDB(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (DBObject dBObject : list) {
            CharSequence charSequence;
            if (!dBObject.isSelected()) continue;
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT a.tabname,a.ROWTYPESCHEMA,a.ROWTYPENAME, ");
                ((StringBuffer)charSequence).append("  b.super_schema, b.super_name ");
                ((StringBuffer)charSequence).append(" from syscat.tables a left join syscat.hierarchies b ");
                ((StringBuffer)charSequence).append("  on a.rowtypename = b.sub_name ");
                ((StringBuffer)charSequence).append("  and a.rowtypeschema = b.sub_schema ");
                ((StringBuffer)charSequence).append("WHERE TYPE in ('V','W') and tabschema  = '");
                ((StringBuffer)charSequence).append(dBObject.getName()).append("'");
                resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHViewUDB.extract(): " + sQLException.getMessage());
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                    String string = resultSet.getString(2);
                    String string2 = resultSet.getString(3);
                    String string3 = resultSet.getString(4);
                    String string4 = resultSet.getString(5);
                    DBObject dBObject2 = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, "VIEW", dBObject.getName());
                    dBObject2.setTypeName(string2);
                    dBObject2.setTypeOwner(string);
                    dBObject2.setSuperTypeOwner(string3);
                    dBObject2.setSuperTypeName(string4);
                    arrayList.add(dBObject2);
                }
                resultSet.close();
            }
            statement.close();
        }
        return arrayList;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        String string = connection.getMetaData().getURL().toLowerCase();
        for (int i = 0; i < list.size(); ++i) {
            CharSequence charSequence;
            DBObject dBObject = (DBObject)list.get(i);
            String string2 = dBObject.getName();
            String string3 = dBObject.getSchema();
            if (!"VIEW".equalsIgnoreCase(dBObject.getType())) continue;
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT  V.VIEWNAME,V.VIEWCHECK,V.READONLY,V.TEXT ,t.REMARKS  ");
                ((StringBuffer)charSequence).append("FROM syscat.VIEWS v,syscat.TABLES t ");
                ((StringBuffer)charSequence).append("WHERE TABSCHEMA = '").append(string3).append("'");
                ((StringBuffer)charSequence).append(" AND  TABNAME = '").append(string2).append("'");
                ((StringBuffer)charSequence).append(" AND  t.TABSCHEMA = v.VIEWSCHEMA");
                ((StringBuffer)charSequence).append(" AND  TABNAME = v.VIEWNAME");
                ((StringBuffer)charSequence).append(" AND t.TYPE IN ('V','W')");
                resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHViewUDB.generate():", sQLException);
                LOGGER.error("MOHViewUDB: name: " + string2);
            }
            if (resultSet != null) {
                if (resultSet.next()) {
                    ModelIDObject modelIDObject;
                    charSequence = resultSet.getString(2);
                    String string4 = "";
                    if (string.startsWith("jdbc:odbc")) {
                        try {
                            string4 = new Scanner(resultSet.getBinaryStream(4), "UTF-8").useDelimiter("\\A").next();
                        }
                        catch (Exception exception) {
                            string4 = resultSet.getString(4);
                        }
                    } else {
                        string4 = resultSet.getString(4);
                    }
                    String string5 = resultSet.getString(5);
                    TableView tableView = this.getDesign().getRelationalDesign().getTableViewSet().createTableView(null);
                    tableView.setName(string2);
                    tableView.setSchema(string3);
                    this.stampModelObject(tableView, dBObject);
                    tableView.setSyntaxProvider("DB2");
                    if (dBObject.getTypeName() != null) {
                        modelIDObject = ((StructuredTypeProxySetUDB)this.getStorageDesign().getStructuredTypeProxySet()).getBySchemaAndName(dBObject.getTypeOwner(), dBObject.getTypeName());
                        if (modelIDObject != null) {
                            tableView.setBasedOnStructuredType(modelIDObject.getStructuredType());
                        }
                    } else {
                        tableView.setUserDefined(true);
                        tableView.getColumns(string4.toString().replaceAll("\n", " ").replaceAll("\r", " ").replaceAll("\t", " ").replaceAll("   ", " ").replaceAll("  ", " "));
                    }
                    tableView.setCommentInRDBMS(string5);
                    tableView.setUserDefinedSQL(string4);
                    modelIDObject = this.getStorageDesign();
                    if (modelIDObject != null && modelIDObject instanceof StorageDesignUDB) {
                        SchemaUDB schemaUDB;
                        StorageDesignUDB storageDesignUDB = (StorageDesignUDB)modelIDObject;
                        TableViewProxyUDB tableViewProxyUDB = (TableViewProxyUDB)storageDesignUDB.getTableViewProxySet().getProxy(tableView.getObjectID());
                        if (!"N".equalsIgnoreCase((String)charSequence)) {
                            tableViewProxyUDB.setCheckOption(true);
                            if ("L".equalsIgnoreCase((String)charSequence)) {
                                tableViewProxyUDB.setCheckOptionScope("LOCAL");
                            }
                        }
                        if ((schemaUDB = (SchemaUDB)storageDesignUDB.getSchemaSet().getByName(string3)) != null) {
                            tableViewProxyUDB.setSchema(schemaUDB);
                            tableViewProxyUDB.setOwner(schemaUDB.getOwner());
                        }
                    }
                }
                resultSet.close();
            }
            statement.close();
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObject);
        }
    }
}

