/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.udb.MOHDatatypeUDB;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.storage.udb.MethodParamProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.StructuredTypeProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.MethodProxyUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHTypeUDB
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "TYPE";
    private static final Logger LOGGER = new Logger(MOHTypeUDB.class);

    public MOHTypeUDB(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        Iterator iterator = this.getDesign().getDataTypesDesign().getStructuredTypeSet().iterator();
        StructuredType structuredType = null;
        StorageDesignUDB storageDesignUDB = (StorageDesignUDB)this.getStorageDesign();
        while (iterator.hasNext()) {
            structuredType = (StructuredType)iterator.next();
            StructuredTypeProxyUDB structuredTypeProxyUDB = (StructuredTypeProxyUDB)storageDesignUDB.getStructuredTypeProxySet().getProxy(structuredType.getObjectID());
            this.initAttributes(connection, structuredType, structuredTypeProxyUDB);
            this.initMethods(connection, structuredType, structuredTypeProxyUDB);
            this.initHierarchyType(connection, structuredType, structuredTypeProxyUDB);
        }
    }

    private void initAttributes(Connection connection, StructuredType structuredType, StructuredTypeProxyUDB structuredTypeProxyUDB) throws Exception {
        if (structuredTypeProxyUDB.getSchema() != null) {
            CharSequence charSequence;
            String string = structuredTypeProxyUDB.getSchema().getName();
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("select ");
                ((StringBuffer)charSequence).append("ATTR_NAME,ATTR_TYPENAME, ");
                ((StringBuffer)charSequence).append("LENGTH, SCALE,TARGET_TYPENAME ");
                ((StringBuffer)charSequence).append("from syscat.attributes ");
                ((StringBuffer)charSequence).append("where ");
                ((StringBuffer)charSequence).append("typeschema = '").append(string).append('\'');
                ((StringBuffer)charSequence).append(" and typename = '").append(structuredTypeProxyUDB.getName()).append('\'');
                ((StringBuffer)charSequence).append(" and typeschema = source_typeschema");
                ((StringBuffer)charSequence).append(" and typename = source_typename");
                ((StringBuffer)charSequence).append(" order by ordinal");
                resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHTypeUDB.initAttributes():", sQLException);
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    Object object;
                    charSequence = resultSet.getString(1);
                    String string2 = resultSet.getString(2);
                    int n = resultSet.getInt(3);
                    int n2 = resultSet.getInt(4);
                    String string3 = resultSet.getString(5);
                    TypeElement typeElement = new TypeElement(structuredType.getDesignPart(), structuredType);
                    typeElement.setName((String)charSequence);
                    typeElement.setDesign(structuredType.getDesign());
                    structuredType.add(typeElement);
                    if (string2 != null && !string2.equalsIgnoreCase("REFERENCE")) {
                        object = StandardDatatypeNames.getUsedDatatypeName(string2);
                        LogicalDatatype logicalDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), (String)object);
                        if (logicalDatatype != null && !((String)object).equalsIgnoreCase("UNKNOWN")) {
                            typeElement.setType(logicalDatatype);
                            if (MOHDatatypeUDB.hasSize(string2)) {
                                typeElement.setSize(Integer.toString(n));
                            } else {
                                if (MOHDatatypeUDB.hasPrecision(string2)) {
                                    typeElement.setPrecision(n);
                                }
                                if (MOHDatatypeUDB.hasScale(string2)) {
                                    typeElement.setScale(n2);
                                }
                            }
                        } else {
                            StructuredType structuredType2 = (StructuredType)typeElement.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(string2);
                            if (structuredType2 != null) {
                                typeElement.setType(structuredType2);
                            } else {
                                DistinctType distinctType = (DistinctType)typeElement.getDesign().getDataTypesDesign().getDistinctTypeSet().getByName(string2);
                                if (distinctType != null) {
                                    typeElement.setType(distinctType);
                                }
                            }
                        }
                        typeElement.updateReference();
                        continue;
                    }
                    object = (StructuredType)typeElement.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(string3);
                    if (object == null) continue;
                    typeElement.setType((DesignObject)object);
                    typeElement.setReference(true);
                    typeElement.updateReference();
                }
                resultSet.close();
            }
            statement.close();
        }
    }

    private void initMethods(Connection connection, StructuredType structuredType, StructuredTypeProxyUDB structuredTypeProxyUDB) throws Exception {
        if (structuredTypeProxyUDB.getSchema() != null) {
            CharSequence charSequence;
            String string = structuredTypeProxyUDB.getSchema().getName();
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("select ");
                ((StringBuffer)charSequence).append("f.funcname,f.specificname,f.language,f.contains_sql, ");
                ((StringBuffer)charSequence).append("f.nullcall,f.parm_style,f.scratchpad,f.fenced,f.final_call, ");
                ((StringBuffer)charSequence).append("f.parallelizable,f.dbinfo,f.body,f.remarks,d.typename ");
                ((StringBuffer)charSequence).append("from syscat.FUNCTIONS f,syscat.datatypes d ");
                ((StringBuffer)charSequence).append("where ");
                ((StringBuffer)charSequence).append("method = 'Y' and ");
                ((StringBuffer)charSequence).append("effect not in ('MU','OB','CN') and ");
                ((StringBuffer)charSequence).append("subject_typeschema  = '").append(string).append('\'');
                ((StringBuffer)charSequence).append(" and subject_typename  = '").append(structuredTypeProxyUDB.getName()).append('\'');
                ((StringBuffer)charSequence).append(" and  f.return_type = d.typeid");
                resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHTypeUDB.initMethods():", sQLException);
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                    String string2 = resultSet.getString(2);
                    String string3 = resultSet.getString(3);
                    String string4 = resultSet.getString(4);
                    String string5 = resultSet.getString(5);
                    String string6 = resultSet.getString(6);
                    String string7 = resultSet.getString(7);
                    String string8 = resultSet.getString(8);
                    String string9 = resultSet.getString(9);
                    String string10 = resultSet.getString(10);
                    String string11 = resultSet.getString(11);
                    String string12 = resultSet.getString(12);
                    String string13 = resultSet.getString(13);
                    String string14 = resultSet.getString(14);
                    Method method = new Method(structuredType.getDesignPart(), structuredType);
                    method.setName((String)charSequence);
                    method.setDesign(structuredType.getDesign());
                    structuredType.addMethod(method);
                    MethodProxyUDBv81 methodProxyUDBv81 = (MethodProxyUDBv81)structuredTypeProxyUDB.getStorageDesign().getMethodProxySet().getByName((String)charSequence);
                    if (methodProxyUDBv81 != null) {
                        methodProxyUDBv81.setSpecificName(string2);
                        methodProxyUDBv81.setLanguage(string3.trim());
                        if (string4.equalsIgnoreCase("CONTAINS SQL")) {
                            methodProxyUDBv81.setSqlStatementType("CONTAINS SQL");
                        }
                        if ("N".equalsIgnoreCase(string5)) {
                            methodProxyUDBv81.setNullParametersTreatment("RETURNS NULL ON NULL INPUT");
                        }
                        if (string6.equalsIgnoreCase("DB2SQL")) {
                            methodProxyUDBv81.setExt_R_ParameterStyle("DB2SQL");
                        }
                        if ("Y".equalsIgnoreCase(string7)) {
                            methodProxyUDBv81.setExt_R_Scratchpad("YES");
                        } else if ("N".equalsIgnoreCase("NO")) {
                            methodProxyUDBv81.setExt_R_Scratchpad("NO");
                        }
                        if ("N".equalsIgnoreCase(string8)) {
                            methodProxyUDBv81.setExt_R_Safeness("NOT FENCED");
                        }
                        if ("Y".equalsIgnoreCase(string9)) {
                            methodProxyUDBv81.setExt_R_FinalCall("YES");
                        }
                        if ("N".equalsIgnoreCase(string10)) {
                            methodProxyUDBv81.setExt_R_ParallelInvocation("DISALLOW");
                        }
                        if ("Y".equalsIgnoreCase(string11)) {
                            methodProxyUDBv81.setExt_R_DBInfo("YES");
                        }
                        methodProxyUDBv81.setSqlMethodBody(string12);
                        methodProxyUDBv81.setComment(string13);
                    }
                    this.initMethodParam(connection, method, methodProxyUDBv81, string);
                    this.initAdditionalMethodParams(connection, methodProxyUDBv81, string);
                    this.initMethodResult(method, string14);
                }
                resultSet.close();
            }
            statement.close();
        }
    }

    private void initMethodParam(Connection connection, Method method, MethodProxyUDBv81 methodProxyUDBv81, String string) throws SQLException {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("select ");
            ((StringBuffer)charSequence).append("funcname,as_locator,typename ");
            ((StringBuffer)charSequence).append("from syscat.funcparms ");
            ((StringBuffer)charSequence).append("where ");
            ((StringBuffer)charSequence).append("funcschema = '").append(string).append('\'');
            ((StringBuffer)charSequence).append(" and funcname = '").append(methodProxyUDBv81.getName()).append('\'');
            ((StringBuffer)charSequence).append(" and parmname<>'SELF' and rowtype ='P' ");
            ((StringBuffer)charSequence).append("order by ordinal");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTypeUDB.initMethodParam():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                MethodParamProxyUDB methodParamProxyUDB;
                charSequence = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(3);
                MethodParam methodParam = this.createParam(method, (String)charSequence);
                this.initDataType(methodParam, string3);
                method.addParameter(methodParam);
                if (!"Y".equalsIgnoreCase(string2) || (methodParamProxyUDB = (MethodParamProxyUDB)methodProxyUDBv81.getStorageDesign().getMethodParamProxySet().getByName((String)charSequence)) == null) continue;
                methodParamProxyUDB.setAsLocator(true);
            }
        }
    }

    private void initAdditionalMethodParams(Connection connection, MethodProxyUDBv81 methodProxyUDBv81, String string) throws SQLException {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("select ");
            ((StringBuffer)charSequence).append("deterministic ");
            ((StringBuffer)charSequence).append("from syscat.procedures ");
            ((StringBuffer)charSequence).append("where ");
            ((StringBuffer)charSequence).append("procschema = '").append(string).append('\'');
            ((StringBuffer)charSequence).append(" and procname = '").append(methodProxyUDBv81.getName()).append('\'');
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTypeUDB.initAdditionalMethodParams():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                if (!"Y".equalsIgnoreCase((String)charSequence)) continue;
                methodProxyUDBv81.setDeterministic("YES");
            }
        }
    }

    private void initMethodResult(Method method, String string) {
        if (string != null && !string.equals("")) {
            MethodParam methodParam = this.createParam(method, string);
            this.initDataType(methodParam, string);
            method.setReturnValue(methodParam);
        }
    }

    private MethodParam createParam(Method method, String string) {
        MethodParam methodParam = new MethodParam(method.getDesignPart());
        methodParam.setName(string);
        methodParam.setDesign(method.getDesign());
        return methodParam;
    }

    private void initDataType(MethodParam methodParam, String string) {
        String string2 = StandardDatatypeNames.getUsedDatatypeName(string);
        LogicalDatatype logicalDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), string2);
        if (logicalDatatype != null && !string2.equalsIgnoreCase("UNKNOWN")) {
            methodParam.setType(logicalDatatype);
        } else {
            StructuredType structuredType = (StructuredType)methodParam.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(string);
            if (structuredType != null) {
                methodParam.setType(structuredType);
            }
        }
    }

    private void initHierarchyType(Connection connection, StructuredType structuredType, StructuredTypeProxyUDB structuredTypeProxyUDB) throws SQLException {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("select ");
            ((StringBuffer)charSequence).append("sub_schema,sub_name,super_schema,super_name, ");
            ((StringBuffer)charSequence).append("root_schema,root_name ");
            ((StringBuffer)charSequence).append("from syscat.HIERARCHIES ");
            ((StringBuffer)charSequence).append("where ");
            ((StringBuffer)charSequence).append(" root_schema =  '").append(structuredTypeProxyUDB.getSchema()).append('\'');
            ((StringBuffer)charSequence).append("  and metatype = 'R'");
            ((StringBuffer)charSequence).append(" and sub_name = '").append(structuredTypeProxyUDB.getName()).append("'");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTypeUDB.initHierarchyType():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(4);
                StructuredType structuredType2 = (StructuredType)this.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName((String)charSequence);
                if (structuredType2 == null) continue;
                structuredType.setParentType(structuredType2, false);
            }
            resultSet.close();
        }
        statement.close();
    }
}

