/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.MOHForeignKey;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.FKProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.FKProxyUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHForeignKeyUDB
extends MOHForeignKey {
    private static final Logger LOGGER = new Logger(MOHForeignKeyUDB.class);

    public MOHForeignKeyUDB(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        StorageDesign storageDesign = this.getDesign().getRelationalDesign().getStorageDesign();
        Iterator iterator = storageDesign.getTableProxySet().iterator();
        TableProxyUDB tableProxyUDB = null;
        SchemaUDB schemaUDB = null;
        while (iterator.hasNext()) {
            CharSequence charSequence;
            tableProxyUDB = (TableProxyUDB)iterator.next();
            schemaUDB = tableProxyUDB.getSchema();
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("select  constname,refkeyname,reftabschema, ");
                ((StringBuffer)charSequence).append("reftabname,colcount,deleterule, ");
                ((StringBuffer)charSequence).append("updaterule,fk_colnames,pk_colnames ");
                ((StringBuffer)charSequence).append("from ");
                ((StringBuffer)charSequence).append("syscat.references ");
                ((StringBuffer)charSequence).append("WHERE tabschema  = '");
                ((StringBuffer)charSequence).append(schemaUDB.getName().trim()).append("'");
                ((StringBuffer)charSequence).append(" AND tabname  = '");
                ((StringBuffer)charSequence).append(tableProxyUDB.getName()).append("'");
                resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHForeignKeyUDB.initForeignKeys():", sQLException);
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    ModelIDObject modelIDObject;
                    charSequence = resultSet.getString(1);
                    String string = resultSet.getString(2);
                    String string2 = resultSet.getString(3);
                    String string3 = resultSet.getString(4);
                    String string4 = resultSet.getString(6);
                    String string5 = resultSet.getString(7);
                    Table table = (Table)tableProxyUDB.getObject();
                    Table table2 = this.getDesign().getRelationalDesign().getTableSet().getBySchemaAndName(string2, string3);
                    if (table2 == null && table != null && (modelIDObject = ((RelationalDesign)table.getDesignPart()).getRelatedSyncModel()) != null) {
                        table2 = modelIDObject.getTableSet().getBySchemaAndName(string2, string3);
                    }
                    if (table == null || table2 == null) continue;
                    modelIDObject = null;
                    FKProxyUDBv81 fKProxyUDBv81 = null;
                    if (storageDesign == null || !(storageDesign instanceof StorageDesignUDB)) continue;
                    StorageDesignUDB storageDesignUDB = (StorageDesignUDB)storageDesign;
                    modelIDObject = (Index)table2.getKeySet().getByName(string);
                    if (modelIDObject == null) continue;
                    FKIndexAssociation fKIndexAssociation = table.addFK((KeyObject)modelIDObject);
                    if (charSequence != null) {
                        fKIndexAssociation.setName((String)charSequence);
                        fKIndexAssociation.getLocalFKIndex().setName((String)charSequence);
                        this.stampModelObject((ModelObject)fKIndexAssociation, table.getSchema(), (String)charSequence);
                        if ("R".equalsIgnoreCase(string4)) {
                            fKIndexAssociation.setDeleteRule("NO ACTION");
                        } else if ("C".equalsIgnoreCase(string4)) {
                            fKIndexAssociation.setDeleteRule("CASCADE");
                        }
                    }
                    this.initFKColumns(connection, fKIndexAssociation, (Index)modelIDObject, string2, tableProxyUDB.getName());
                    fKIndexAssociation.resetMandatoryUsingColumns();
                    fKProxyUDBv81 = (FKProxyUDBv81)storageDesignUDB.getFKProxySet().getObjectGeneratedBy(fKIndexAssociation);
                    if (fKProxyUDBv81 == null) {
                        fKProxyUDBv81 = (FKProxyUDBv81)storageDesignUDB.getFKProxySet().getByName(fKIndexAssociation.getName());
                    }
                    if (fKProxyUDBv81 == null) continue;
                    if ("R".equalsIgnoreCase(string4)) {
                        fKProxyUDBv81.setOnDelete(FKProxyUDB.getOnDeleteChoices()[1]);
                    } else if ("C".equalsIgnoreCase(string4)) {
                        fKProxyUDBv81.setOnDelete(FKProxyUDB.getOnDeleteChoices()[2]);
                    } else if ("N".equalsIgnoreCase(string4)) {
                        fKProxyUDBv81.setOnDelete(FKProxyUDB.getOnDeleteChoices()[3]);
                    }
                    if (!"R".equalsIgnoreCase(string5)) continue;
                    fKProxyUDBv81.setOnUpdate(FKProxyUDB.getOnUpdateChoices()[1]);
                }
                resultSet.close();
            }
            statement.close();
        }
    }

    private void initFKColumns(Connection connection, FKIndexAssociation fKIndexAssociation, Index index, String string, String string2) throws Exception {
        Object object;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT COLNAME, COLSEQ ");
            ((StringBuffer)object).append("from syscat.keycoluse ");
            ((StringBuffer)object).append("WHERE tabschema  = '");
            ((StringBuffer)object).append(string).append("'");
            ((StringBuffer)object).append(" AND tabname = '");
            ((StringBuffer)object).append(string2).append("' and ");
            ((StringBuffer)object).append("constname = '").append(fKIndexAssociation.getName());
            ((StringBuffer)object).append("' order by colseq");
            resultSet = statement.executeQuery(((StringBuffer)object).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHForeignKeyUDB.initFKColumns():", sQLException);
        }
        if (resultSet != null) {
            object = fKIndexAssociation.getTable();
            while (resultSet.next()) {
                String string3 = resultSet.getString(1);
                int n = resultSet.getInt(2);
                Column column = (Column)((ContainerObject)object).getElementByName(string3);
                Column column2 = null;
                try {
                    column2 = (Column)index.getElement(n - 1);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                if (column == null || column2 == null) continue;
                column.addFKAssociation(column2, fKIndexAssociation);
                fKIndexAssociation.getLocalFKIndex().add(column);
            }
            resultSet.close();
        }
        statement.close();
    }
}

