/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHDatatypeUDB
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "DATATYPE";
    private static final Logger LOGGER = new Logger(MOHDatatypeUDB.class);

    public MOHDatatypeUDB(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            CharSequence charSequence;
            DBObject dBObject = (DBObject)list.get(i);
            String string = dBObject.getName();
            String string2 = dBObject.getSchema();
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObject.getType())) continue;
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT  TYPENAME,SOURCESCHEMA,SOURCENAME,METATYPE,LENGTH,SCALE,  ");
                ((StringBuffer)charSequence).append("ATTRCOUNT,INSTANTIABLE,FINAL,INLINE_LENGTH,REMARKS,WITH_FUNC_ACCESS,  ");
                ((StringBuffer)charSequence).append("JARSCHEMA,JAR_ID,CLASS,SQLJ_REPRESENTATION,NATURAL_INLINE_LENGTH ");
                ((StringBuffer)charSequence).append("FROM syscat.DATATYPES ");
                ((StringBuffer)charSequence).append("WHERE TYPESCHEMA = '");
                ((StringBuffer)charSequence).append(string2).append("'");
                ((StringBuffer)charSequence).append(" AND TYPENAME = '").append(string).append("'");
                resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHDatatypeUDB.generate():", sQLException);
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                    String string3 = resultSet.getString(3);
                    String string4 = resultSet.getString(5);
                    String string5 = resultSet.getString(6);
                    DistinctType distinctType = this.getDesign().getDataTypesDesign().createDistinctType();
                    distinctType.setName((String)charSequence);
                    this.stampModelObject(distinctType, dBObject);
                    LogicalDatatype logicalDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getDbmeHandler().getRDBMSSite().getType(), string3);
                    if (logicalDatatype == null) {
                        logicalDatatype = this.getDesign().getLogicalDatatypeSet().getLogTypeByNativeType(string3, this.getDbmeHandler().getRDBMSSite().getType().getName());
                    }
                    if (logicalDatatype == null) continue;
                    distinctType.setLogicalDataType(logicalDatatype);
                    if (MOHDatatypeUDB.hasSize(string3)) {
                        distinctType.setSize(string4);
                        continue;
                    }
                    if (MOHDatatypeUDB.hasPrecision(string3)) {
                        distinctType.setPrecision(Integer.parseInt(string4));
                    }
                    if (!MOHDatatypeUDB.hasScale(string3)) continue;
                    distinctType.setScale(Integer.parseInt(string5));
                }
                resultSet.close();
            }
            statement.close();
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObject);
        }
    }

    public static boolean hasSize(String string) {
        if (string != null) {
            if (string.toUpperCase().indexOf("CHAR") > -1 && string.toUpperCase().indexOf("LONG") == -1) {
                return true;
            }
            if (string.toUpperCase().indexOf("LOB") > -1) {
                return true;
            }
            if (string.toUpperCase().indexOf("GRAPH") > -1 && string.toUpperCase().indexOf("LONG") == -1) {
                return true;
            }
        }
        return false;
    }

    public static boolean hasPrecision(String string) {
        if (string != null) {
            if (string.toUpperCase().indexOf("FLOAT") > -1) {
                return true;
            }
            if (string.toUpperCase().indexOf("NUM") > -1) {
                return true;
            }
            if (string.toUpperCase().indexOf("DEC") > -1) {
                return true;
            }
        }
        return false;
    }

    public static boolean hasScale(String string) {
        if (string != null) {
            if (string.toUpperCase().indexOf("NUM") > -1) {
                return true;
            }
            if (string.toUpperCase().indexOf("DEC") > -1) {
                return true;
            }
        }
        return false;
    }
}

