/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver.v2k5;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBObjectSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBUserSqlServer;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataFileSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHSchemaSqlServer2k5
extends AbstractMOHandler {
    protected static final String OBJECT_TYPE = "SCHEMA";
    private static final Logger LOGGER = new Logger(MOHSchemaSqlServer2k5.class);

    public MOHSchemaSqlServer2k5(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return null;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            DBObjectSqlServer dBObjectSqlServer = (DBObjectSqlServer)list.get(i);
            String string = dBObjectSqlServer.getName();
            String string2 = dBObjectSqlServer.getDb();
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObjectSqlServer.getType())) continue;
            String string3 = ((DBUserSqlServer)dBObjectSqlServer).getUid();
            StorageDesign storageDesign = this.getStorageDesign();
            if (storageDesign != null && storageDesign instanceof StorageDesignSqlServerv2k5) {
                StorageDesignSqlServerv2k5 storageDesignSqlServerv2k5 = (StorageDesignSqlServerv2k5)storageDesign;
                DataBaseSqlServerv2k5 dataBaseSqlServerv2k5 = (DataBaseSqlServerv2k5)storageDesignSqlServerv2k5.getDataBaseSet().getByName(string2);
                if (dataBaseSqlServerv2k5 == null) {
                    dataBaseSqlServerv2k5 = (DataBaseSqlServerv2k5)storageDesignSqlServerv2k5.getDataBaseSet().createDataBase();
                    dataBaseSqlServerv2k5.setName(string2);
                    this.stampModelObject((ModelObject)dataBaseSqlServerv2k5, "", string2);
                    this.initFilegroups(dataBaseSqlServerv2k5, storageDesignSqlServerv2k5, connection);
                }
                SchemaSqlServerv2k5 schemaSqlServerv2k5 = (SchemaSqlServerv2k5)storageDesignSqlServerv2k5.getSchemaSet().createSchema();
                schemaSqlServerv2k5.setName(string);
                schemaSqlServerv2k5.setUid(string3);
                this.stampModelObject((ModelObject)schemaSqlServerv2k5, string2, string);
                String string4 = dBObjectSqlServer.getUserName(connection, string3);
                UserSqlServer userSqlServer = (UserSqlServer)dataBaseSqlServerv2k5.getUsers().getByName(string4);
                schemaSqlServerv2k5.setOwner(userSqlServer);
                schemaSqlServerv2k5.setDatabase(dataBaseSqlServerv2k5);
            } else {
                LOGGER.error("Unable to find Storage Design!");
            }
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObjectSqlServer);
        }
    }

    private void initFilegroups(DataBaseSqlServer dataBaseSqlServer, StorageDesignSqlServer storageDesignSqlServer, Connection connection) {
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT").append(' ');
            stringBuffer.append("groupname").append(' ');
            stringBuffer.append(',').append(' ');
            stringBuffer.append("groupid").append(' ');
            stringBuffer.append("FROM").append(' ');
            stringBuffer.append(dataBaseSqlServer.getName()).append('.').append("dbo.sysfilegroups").append(' ');
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet != null) {
                while (resultSet.next()) {
                    String string = resultSet.getString(1);
                    String string2 = resultSet.getString(2);
                    FileGroupSqlServer fileGroupSqlServer = (FileGroupSqlServer)dataBaseSqlServer.getFilegroups().getByName(string);
                    if (fileGroupSqlServer == null) {
                        fileGroupSqlServer = storageDesignSqlServer.getFileGroupSet().createFileGroup();
                        fileGroupSqlServer.setName(string);
                        fileGroupSqlServer.setDataBase(dataBaseSqlServer);
                        this.stampModelObject((ModelObject)fileGroupSqlServer, dataBaseSqlServer, string);
                    }
                    this.initDatafiles(fileGroupSqlServer, string2, dataBaseSqlServer.getName(), storageDesignSqlServer, connection);
                }
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (Exception exception) {
            LOGGER.error("MOHDatabaseSqlServerv2k5.initFilegroups():", exception);
        }
    }

    private void initDatafiles(FileGroupSqlServer fileGroupSqlServer, String string, String string2, StorageDesignSqlServer storageDesignSqlServer, Connection connection) throws Exception {
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT").append(' ');
            stringBuffer.append("NAME").append(' ');
            stringBuffer.append(',').append(' ');
            stringBuffer.append("size").append(' ');
            stringBuffer.append(',').append(' ');
            stringBuffer.append("maxsize").append(' ');
            stringBuffer.append(',').append(' ');
            stringBuffer.append("growth").append(' ');
            stringBuffer.append(',').append(' ');
            stringBuffer.append("GROWTH_IN_PERCENTAGE = ");
            stringBuffer.append("case status & 0x100000 ");
            stringBuffer.append("when 0x100000 then 'YES' ");
            stringBuffer.append("else 'NO' ");
            stringBuffer.append("end").append(' ');
            stringBuffer.append(',').append(' ');
            stringBuffer.append("filename").append(' ');
            stringBuffer.append("FROM").append(' ');
            stringBuffer.append(string2).append('.').append("dbo.sysfiles").append(' ');
            stringBuffer.append("WHERE").append(' ');
            stringBuffer.append("status & 0x2 = 0x2").append(' ');
            stringBuffer.append("AND").append(' ');
            stringBuffer.append("groupid").append(' ');
            stringBuffer.append('=').append(' ');
            stringBuffer.append(string).append(' ');
            stringBuffer.append("ORDER BY").append(' ');
            stringBuffer.append("fileid").append(' ');
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet != null) {
                while (resultSet.next()) {
                    String string3 = resultSet.getString(1).trim();
                    int n = resultSet.getInt(2);
                    int n2 = resultSet.getInt(3);
                    int n3 = resultSet.getInt(4);
                    String string4 = resultSet.getString(5);
                    String string5 = resultSet.getString(6).trim();
                    DataFileSqlServer dataFileSqlServer = storageDesignSqlServer.getDataFileSet().createDataFile();
                    dataFileSqlServer.setName(string3);
                    dataFileSqlServer.setFileGroup(fileGroupSqlServer);
                    dataFileSqlServer.setFileName(string5);
                    dataFileSqlServer.setInitialSize(n);
                    this.stampModelObject((ModelObject)dataFileSqlServer, fileGroupSqlServer.getDataBase(), string3);
                    if (string4.equalsIgnoreCase("YES")) {
                        dataFileSqlServer.setGrowthMethod("By Percent");
                    } else {
                        dataFileSqlServer.setGrowthMethod("In MegaBytes");
                    }
                    dataFileSqlServer.setGrowthValue(n3);
                    if (n2 == -1) {
                        dataFileSqlServer.setIsUnlimited(true);
                        continue;
                    }
                    dataFileSqlServer.setIsUnlimited(false);
                    dataFileSqlServer.setMaxSize(n2);
                }
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHDatabaseSqlServerv2k5.initDatafiles():", sQLException);
        }
    }
}

