/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver.v2k5;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBObjectSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBUserSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHandlerSqlServer;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHRoleSqlServerv2k5
extends MOHandlerSqlServer {
    protected static final String OBJECT_TYPE = "ROLE";
    private static final Logger LOGGER = new Logger(MOHRoleSqlServerv2k5.class);

    public MOHRoleSqlServerv2k5(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            Object object2;
            Serializable serializable;
            DBObjectSqlServer dBObjectSqlServer = (DBObjectSqlServer)list.get(i);
            String string = dBObjectSqlServer.getName();
            String string2 = dBObjectSqlServer.getDb();
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObjectSqlServer.getType())) continue;
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                serializable = new StringBuffer();
                ((StringBuffer)serializable).append("SELECT").append(' ');
                ((StringBuffer)serializable).append('\'').append("RoleId").append('\'').append(' ');
                ((StringBuffer)serializable).append('=').append(' ');
                ((StringBuffer)serializable).append("UID").append(' ');
                ((StringBuffer)serializable).append(',').append(' ');
                ((StringBuffer)serializable).append('\'').append("IsAppRole").append('\'').append(' ');
                ((StringBuffer)serializable).append('=').append(' ');
                ((StringBuffer)serializable).append("ISAPPROLE").append(' ');
                ((StringBuffer)serializable).append("FROM").append(' ');
                ((StringBuffer)serializable).append(string2).append('.').append("dbo.sysusers").append(' ');
                ((StringBuffer)serializable).append("WHERE").append(' ');
                ((StringBuffer)serializable).append('(').append(' ');
                ((StringBuffer)serializable).append("issqlrole = 1").append(' ');
                ((StringBuffer)serializable).append("OR").append(' ');
                ((StringBuffer)serializable).append("isapprole = 1").append(' ');
                ((StringBuffer)serializable).append(')').append(' ');
                ((StringBuffer)serializable).append("AND").append(' ');
                ((StringBuffer)serializable).append("NAME").append(' ');
                ((StringBuffer)serializable).append("NOT").append(' ');
                ((StringBuffer)serializable).append("IN").append(' ');
                ((StringBuffer)serializable).append('(').append(' ');
                ((StringBuffer)serializable).append('\'').append("db_owner").append('\'').append(',').append(' ');
                ((StringBuffer)serializable).append('\'').append("db_accessadmin").append('\'').append(',').append(' ');
                ((StringBuffer)serializable).append('\'').append("db_securityadmin").append('\'').append(',').append(' ');
                ((StringBuffer)serializable).append('\'').append("db_ddladmin").append('\'').append(',').append(' ');
                ((StringBuffer)serializable).append('\'').append("db_backupoperator").append('\'').append(',').append(' ');
                ((StringBuffer)serializable).append('\'').append("db_datareader").append('\'').append(',').append(' ');
                ((StringBuffer)serializable).append('\'').append("db_datawriter").append('\'').append(',').append(' ');
                ((StringBuffer)serializable).append('\'').append("db_denydatareader").append('\'').append(',').append(' ');
                ((StringBuffer)serializable).append('\'').append("db_denydatawriter").append('\'').append(' ');
                ((StringBuffer)serializable).append(')').append(' ');
                resultSet = statement.executeQuery(((StringBuffer)serializable).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHRoleSqlServerv2k5.generate():", sQLException);
            }
            serializable = new ArrayList();
            if (resultSet != null) {
                while (resultSet.next()) {
                    object2 = resultSet.getString(1);
                    int n = resultSet.getInt(2);
                    object = new Properties();
                    ((Properties)object).setProperty("role_id", (String)object2);
                    ((Properties)object).setProperty("isAppl", String.valueOf(n));
                    serializable.add(object);
                }
            }
            if (statement != null) {
                statement.close();
            }
            object2 = serializable.iterator();
            while (object2.hasNext()) {
                Properties properties = (Properties)object2.next();
                object = properties.getProperty("role_id");
                int n = Integer.parseInt(properties.getProperty("isAppl"));
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign != null && storageDesign instanceof StorageDesignSqlServer) {
                    StorageDesignSqlServer storageDesignSqlServer = (StorageDesignSqlServer)storageDesign;
                    RoleSqlServer roleSqlServer = (RoleSqlServer)storageDesignSqlServer.getRoleSet().getByName(string);
                    if (roleSqlServer == null) {
                        roleSqlServer = storageDesignSqlServer.getRoleSet().createRole();
                        roleSqlServer.setName(string);
                        this.stampModelObject(roleSqlServer, dBObjectSqlServer);
                    }
                    this.setProperties(roleSqlServer, storageDesignSqlServer, string2, n);
                    this.setMembers(roleSqlServer, (String)object, string2, connection);
                    this.initPrivileges(roleSqlServer, (String)object, string2, connection);
                    continue;
                }
                LOGGER.error("Unable to find Storage Design!");
            }
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObjectSqlServer);
        }
    }

    private void initPrivileges(RoleSqlServer roleSqlServer, String string, String string2, Connection connection) {
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT").append(' ');
            stringBuffer.append("DB_PRIV").append(' ');
            stringBuffer.append('=').append(' ');
            stringBuffer.append(" case action ");
            stringBuffer.append(" when 178 then 'CREATE FUNCTION'");
            stringBuffer.append(" when 198 then 'CREATE TABLE'");
            stringBuffer.append(" when 203 then 'CREATE DATABASE'");
            stringBuffer.append(" when 207 then 'CREATE VIEW'");
            stringBuffer.append(" when 222 then 'CREATE PROCEDURE'");
            stringBuffer.append(" when 228 then 'BACKUP DATABASE'");
            stringBuffer.append(" when 233 then 'CREATE DEFAULT'");
            stringBuffer.append(" when 235 then 'BACKUP LOG'");
            stringBuffer.append(" when 236 then 'CREATE RULE'");
            stringBuffer.append(" end").append(' ');
            stringBuffer.append("FROM").append(' ');
            stringBuffer.append(string2).append('.').append("dbo.sysprotects").append(' ');
            stringBuffer.append("WHERE").append(' ');
            stringBuffer.append("protecttype in (204,205)").append(' ');
            stringBuffer.append("AND").append(' ');
            stringBuffer.append("action in (178,198,203,207,222,228,233,235,236)").append(' ');
            stringBuffer.append("AND").append(' ');
            stringBuffer.append("UID").append(' ');
            stringBuffer.append('=').append(' ');
            stringBuffer.append(string).append(' ');
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet != null) {
                while (resultSet.next()) {
                    roleSqlServer.setSystemPrivileges(resultSet.getString(1));
                }
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHRoleSqlServerv2k5.bindColumns():", sQLException);
        }
    }

    private void setMembers(RoleSqlServer roleSqlServer, String string, String string2, Connection connection) {
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT").append(' ');
            stringBuffer.append("u.name").append(' ');
            stringBuffer.append("FROM").append(' ');
            stringBuffer.append(string2).append('.').append("dbo.sysusers u").append(' ');
            stringBuffer.append(',').append(' ');
            stringBuffer.append(string2).append('.').append("dbo.sysusers G").append(' ');
            stringBuffer.append(',').append(' ');
            stringBuffer.append(string2).append('.').append("dbo.sysmembers M").append(' ');
            stringBuffer.append("WHERE").append(' ');
            stringBuffer.append("g").append('.').append("UID").append(' ');
            stringBuffer.append('=').append(' ');
            stringBuffer.append(string).append(' ');
            stringBuffer.append("AND").append(' ');
            stringBuffer.append("g").append('.').append("UID").append(' ');
            stringBuffer.append('=').append(' ');
            stringBuffer.append("m").append('.').append("groupuid").append(' ');
            stringBuffer.append("AND").append(' ');
            stringBuffer.append("g").append('.').append("issqlrole").append(' ');
            stringBuffer.append('=').append(' ');
            stringBuffer.append(1).append(' ');
            stringBuffer.append("AND").append(' ');
            stringBuffer.append("u").append('.').append("UID").append(' ');
            stringBuffer.append('=').append(' ');
            stringBuffer.append("m").append('.').append("memberuid").append(' ');
            stringBuffer.append("AND").append(' ');
            stringBuffer.append("u").append('.').append("issqlrole").append(' ');
            stringBuffer.append('=').append(' ');
            stringBuffer.append(0).append(' ');
            stringBuffer.append("AND").append(' ');
            stringBuffer.append("u").append('.').append("isapprole").append(' ');
            stringBuffer.append('=').append(' ');
            stringBuffer.append(0).append(' ');
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet != null) {
                while (resultSet.next()) {
                    String string3 = resultSet.getString(1);
                    roleSqlServer.setUsers(string3);
                }
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHRoleSqlServerv2k5.bindColumns():", sQLException);
        }
    }

    private void setProperties(RoleSqlServer roleSqlServer, StorageDesignSqlServer storageDesignSqlServer, String string, int n) throws Exception {
        DataBaseSqlServer dataBaseSqlServer = (DataBaseSqlServer)storageDesignSqlServer.getDataBaseSet().getByName(string);
        if (dataBaseSqlServer == null) {
            dataBaseSqlServer = storageDesignSqlServer.getDataBaseSet().createDataBase();
            dataBaseSqlServer.setName(string);
            this.stampModelObject((ModelObject)dataBaseSqlServer, "", string);
        }
        roleSqlServer.setDatabase(dataBaseSqlServer);
        if (n == 0) {
            roleSqlServer.setIsApplicationRole(false);
        } else {
            roleSqlServer.setIsApplicationRole(true);
        }
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        ArrayList<DBObjectSqlServer> arrayList = new ArrayList<DBObjectSqlServer>();
        Iterator iterator = list.iterator();
        String string = null;
        while (iterator.hasNext()) {
            CharSequence charSequence;
            DBUserSqlServer dBUserSqlServer;
            DBObject dBObject = (DBObject)iterator.next();
            if (!dBObject.isSelected() || !(dBObject instanceof DBUserSqlServer) || (string = !this.containsDboForDb(list, dBUserSqlServer = (DBUserSqlServer)dBObject) ? dBUserSqlServer.getDb() : null) == null) continue;
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT").append(' ');
                ((StringBuffer)charSequence).append('\'').append("RoleName").append('\'').append(' ');
                ((StringBuffer)charSequence).append('=').append(' ').append("NAME").append(' ').append(',').append(' ');
                ((StringBuffer)charSequence).append('\'').append("RoleId").append('\'').append(' ');
                ((StringBuffer)charSequence).append('=').append(' ').append("UID").append(' ').append(',').append(' ');
                ((StringBuffer)charSequence).append('\'').append("IsAppRole").append('\'').append(' ');
                ((StringBuffer)charSequence).append('=').append(' ').append("ISAPPROLE").append(' ');
                ((StringBuffer)charSequence).append("FROM").append(' ');
                ((StringBuffer)charSequence).append(string).append(".dbo.sysusers").append(' ');
                ((StringBuffer)charSequence).append("WHERE").append(' ');
                ((StringBuffer)charSequence).append('(').append(' ');
                ((StringBuffer)charSequence).append("ISSQLROLE").append(' ');
                ((StringBuffer)charSequence).append('=').append(' ');
                ((StringBuffer)charSequence).append(1).append(' ');
                ((StringBuffer)charSequence).append("OR").append(' ');
                ((StringBuffer)charSequence).append("ISAPPROLE").append(' ');
                ((StringBuffer)charSequence).append('=').append(' ');
                ((StringBuffer)charSequence).append(1).append(' ');
                ((StringBuffer)charSequence).append(')').append(' ');
                ((StringBuffer)charSequence).append("AND").append(' ');
                ((StringBuffer)charSequence).append("NAME").append(' ').append("NOT").append(' ').append("IN").append(' ');
                ((StringBuffer)charSequence).append('(').append(' ');
                ((StringBuffer)charSequence).append('\'').append("db_owner").append('\'').append(',').append(' ');
                ((StringBuffer)charSequence).append('\'').append("db_accessadmin").append('\'').append(',').append(' ');
                ((StringBuffer)charSequence).append('\'').append("db_securityadmin").append('\'').append(',').append(' ');
                ((StringBuffer)charSequence).append('\'').append("db_ddladmin").append('\'').append(',').append(' ');
                ((StringBuffer)charSequence).append('\'').append("db_backupoperator").append('\'').append(',').append(' ');
                ((StringBuffer)charSequence).append('\'').append("db_datareader").append('\'').append(',').append(' ');
                ((StringBuffer)charSequence).append('\'').append("db_datawriter").append('\'').append(',').append(' ');
                ((StringBuffer)charSequence).append('\'').append("db_denydatareader").append('\'').append(',').append(' ');
                ((StringBuffer)charSequence).append('\'').append("db_denydatawriter").append('\'').append(' ');
                ((StringBuffer)charSequence).append(')').append(' ');
                resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("getRoles(): " + sQLException.getMessage());
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                    DBObjectSqlServer dBObjectSqlServer = new DBObjectSqlServer(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, OBJECT_TYPE, "");
                    dBObjectSqlServer.setDb(string);
                    arrayList.add(dBObjectSqlServer);
                }
            }
            if (statement == null) continue;
            statement.close();
        }
        return arrayList;
    }
}

