/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver.v2k5;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHandlerSqlServer;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.FileGroupSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PartitionFunctionSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PartitionSchemeSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHPartitionFunctionSqlServerv2k5
extends MOHandlerSqlServer {
    private StorageDesignSqlServerv2k5 storage;
    private DataBaseSqlServerv2k5 database;
    private List boundaryValues = new ArrayList();
    private static final Logger LOGGER = new Logger(MOHPartitionFunctionSqlServerv2k5.class);

    public MOHPartitionFunctionSqlServerv2k5(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return null;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        if (this.getStorageDesign() instanceof StorageDesignSqlServerv2k5) {
            this.storage = (StorageDesignSqlServerv2k5)this.getStorageDesign();
            Iterator iterator = this.storage.getDataBaseSet().iterator();
            while (iterator.hasNext()) {
                this.database = (DataBaseSqlServerv2k5)iterator.next();
                if (this.database.isNullInstance()) continue;
                this.initPartitionFunctions(connection, importLogger);
            }
        }
    }

    private void initPartitionFunctions(Connection connection, ImportLogger importLogger) throws Exception {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        String string = this.database.getName();
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("USE").append(' ').append(string).append(' ');
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append("name, function_id, fanout part_number, ");
            ((StringBuffer)charSequence).append("boundary_value_on_right ");
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append("sys.partition_functions");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHPartitionFunctionSqlServerv2k5.initPartitionFunctions():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(4);
                PartitionFunctionSqlServerv2k5 partitionFunctionSqlServerv2k5 = (PartitionFunctionSqlServerv2k5)this.storage.getPartitionFunctionSet().createPartitionFunction();
                partitionFunctionSqlServerv2k5.setName((String)charSequence);
                partitionFunctionSqlServerv2k5.setDatabase(this.database);
                this.stampModelObject((ModelObject)partitionFunctionSqlServerv2k5, this.database, (String)charSequence);
                if (string3.equals("1")) {
                    partitionFunctionSqlServerv2k5.setRangeType("RIGHT");
                }
                this.initDataType(connection, partitionFunctionSqlServerv2k5, string2);
                this.initBoundaryValues(connection, partitionFunctionSqlServerv2k5, string2);
                this.initPartitionSchemes(connection, partitionFunctionSqlServerv2k5, string2);
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initPartitionSchemes(Connection connection, PartitionFunctionSqlServerv2k5 partitionFunctionSqlServerv2k5, String string) throws Exception {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        String string2 = this.database.getName();
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("USE").append(' ').append(string2).append(' ');
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append("name, data_space_id as partition_scheme_id ");
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append("sys.partition_schemes ");
            ((StringBuffer)charSequence).append("WHERE").append(" type = 'PS' ");
            ((StringBuffer)charSequence).append("AND").append(" function_id = ").append(string);
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHPartitionFunctionSqlServerv2k5.initPartitionSchemes():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                PartitionSchemeSqlServerv2k5 partitionSchemeSqlServerv2k5 = (PartitionSchemeSqlServerv2k5)this.storage.getPartitionSchemeSet().createPartitionScheme();
                partitionSchemeSqlServerv2k5.setName((String)charSequence);
                partitionSchemeSqlServerv2k5.setPartitionFunction(partitionFunctionSqlServerv2k5);
                this.stampModelObject((ModelObject)partitionSchemeSqlServerv2k5, this.database, (String)charSequence);
                this.initMapping(connection, partitionSchemeSqlServerv2k5, string3);
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initMapping(Connection connection, PartitionSchemeSqlServerv2k5 partitionSchemeSqlServerv2k5, String string) throws Exception {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        String string2 = this.database.getName();
        ArrayList<StringBuffer> arrayList = new ArrayList<StringBuffer>();
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("USE").append(' ').append(string2).append(' ');
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append(" fg.name as fg_name, partition_scheme_id,destination_id,ds.data_space_id  ");
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append("sys.destination_data_spaces ds,sys.filegroups fg ");
            ((StringBuffer)charSequence).append("WHERE").append(" partition_scheme_id =  ").append(string);
            ((StringBuffer)charSequence).append("AND").append(" ds.data_space_id = fg.data_space_id  ");
            ((StringBuffer)charSequence).append("order by partition_scheme_id, destination_id");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHPartitionFunctionSqlServerv2k5.initMappingType():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                arrayList.add((StringBuffer)charSequence);
            }
        }
        if (statement != null) {
            statement.close();
        }
        if (arrayList.size() > 0) {
            charSequence = this.getMappingType(arrayList);
            partitionSchemeSqlServerv2k5.setMappingType((String)charSequence);
            if (partitionSchemeSqlServerv2k5.isSingleFileGroupSelected()) {
                String string3 = (String)arrayList.get(0);
                FileGroupSqlServerv2k5 fileGroupSqlServerv2k5 = (FileGroupSqlServerv2k5)this.database.getFilegroups().getByName(string3);
                if (fileGroupSqlServerv2k5 != null) {
                    partitionSchemeSqlServerv2k5.setSingleFileGroup(fileGroupSqlServerv2k5);
                }
            } else {
                ListIterator listIterator = this.getBoundaryValues().listIterator();
                while (listIterator.hasNext()) {
                    String string4 = (String)listIterator.next();
                    partitionSchemeSqlServerv2k5.setMappingTable(string4);
                    String string5 = "";
                    int n = listIterator.nextIndex() - 1;
                    if (n < arrayList.size()) {
                        string5 = (String)arrayList.get(n);
                    }
                    partitionSchemeSqlServerv2k5.setMappingTable(string5);
                }
                partitionSchemeSqlServerv2k5.setMappingTable("MAXVALUE");
                partitionSchemeSqlServerv2k5.setMappingTable((String)arrayList.get(arrayList.size() - 1));
            }
        }
    }

    private String getMappingType(List list) {
        Iterator iterator = list.iterator();
        String string = (String)list.get(0);
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string.equals(string2)) continue;
            return "MULTIPLE FILE GROUPS";
        }
        return "SINGLE FILE GROUP";
    }

    private void initBoundaryValues(Connection connection, PartitionFunctionSqlServerv2k5 partitionFunctionSqlServerv2k5, String string) throws Exception {
        Object object;
        this.getBoundaryValues().clear();
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        String string2 = this.database.getName();
        try {
            object = new StringBuffer();
            ((StringBuffer)object).append("USE").append(' ').append(string2).append(' ');
            ((StringBuffer)object).append("SELECT").append(' ');
            ((StringBuffer)object).append("function_id, boundary_id, parameter_id, cast(value as varchar) as b_value ");
            ((StringBuffer)object).append("FROM").append(' ');
            ((StringBuffer)object).append("sys.partition_range_values ");
            ((StringBuffer)object).append("WHERE").append(' ');
            ((StringBuffer)object).append("function_id = ").append(string);
            ((StringBuffer)object).append(" order by ").append("boundary_id");
            resultSet = statement.executeQuery(((StringBuffer)object).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHPartitionFunctionSqlServerv2k5.initBoundaryValues():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                object = resultSet.getObject(4);
                this.addBoundaryValues(object);
                partitionFunctionSqlServerv2k5.setBoundaryValues(object.toString());
                partitionFunctionSqlServerv2k5.setBoundaryValues("");
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initDataType(Connection connection, PartitionFunctionSqlServerv2k5 partitionFunctionSqlServerv2k5, String string) throws Exception {
        CharSequence charSequence;
        this.getBoundaryValues().clear();
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        String string2 = this.database.getName();
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("USE").append(' ').append(string2).append(' ');
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append("t.name datatype,par.max_length, par.precision,par.scale ");
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append("sys.partition_parameters par, sys.types t ");
            ((StringBuffer)charSequence).append("WHERE").append(' ');
            ((StringBuffer)charSequence).append("function_id = ").append(string);
            ((StringBuffer)charSequence).append(" and par.system_type_id = t.system_type_id ");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHPartitionFunctionSqlServerv2k5.initBoundaryValues():", sQLException);
        }
        if (resultSet != null && resultSet.next()) {
            charSequence = resultSet.getString(1);
            int n = resultSet.getInt(2);
            int n2 = resultSet.getInt(3);
            int n3 = resultSet.getInt(4);
            if (n != 0) {
                charSequence = (String)charSequence + "(" + n + ")";
            } else if (n2 != 0) {
                charSequence = (String)charSequence + "(" + n2;
                if (n3 != 0) {
                    charSequence = (String)charSequence + "," + n3;
                }
                charSequence = (String)charSequence + ")";
            }
            partitionFunctionSqlServerv2k5.setInputType((String)charSequence);
        }
        if (statement != null) {
            statement.close();
        }
    }

    public List getBoundaryValues() {
        return this.boundaryValues;
    }

    public void addBoundaryValues(Object object) {
        this.boundaryValues.add(object);
    }
}

