/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver.v2k5;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBMExtractionHandlerSQLServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBObjectSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBUserSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHandlerSqlServer;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DefaultSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UsedUserDefinedDatav2k5;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHDefaultSqlServerv2k5
extends MOHandlerSqlServer {
    protected static final String OBJECT_TYPE = "DEFAULT";
    private static final Logger LOGGER = new Logger(MOHDefaultSqlServerv2k5.class);

    public MOHDefaultSqlServerv2k5(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            Serializable serializable;
            DBObjectSqlServer dBObjectSqlServer = (DBObjectSqlServer)list.get(i);
            String string = dBObjectSqlServer.getName();
            String string2 = dBObjectSqlServer.getDb();
            String string3 = dBObjectSqlServer.getId();
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObjectSqlServer.getType())) continue;
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                serializable = new StringBuffer();
                ((StringBuffer)serializable).append("USE").append(' ');
                ((StringBuffer)serializable).append(string2).append(' ').append("\n");
                ((StringBuffer)serializable).append(';').append("\n").append("\n");
                ((StringBuffer)serializable).append("SELECT").append(' ');
                ((StringBuffer)serializable).append("text,encrypted ");
                ((StringBuffer)serializable).append("FROM").append(' ');
                ((StringBuffer)serializable).append("dbo.syscomments ").append(' ');
                ((StringBuffer)serializable).append("WHERE").append(' ');
                ((StringBuffer)serializable).append("ID").append(' ');
                ((StringBuffer)serializable).append('=').append(' ');
                ((StringBuffer)serializable).append(string3);
                resultSet = statement.executeQuery(((StringBuffer)serializable).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHDefaultSqlServerv2k5.generate():", sQLException);
            }
            serializable = new ArrayList();
            if (resultSet != null && resultSet.next()) {
                object = resultSet.getString(1);
                serializable.add(object);
            }
            if (statement != null) {
                statement.close();
            }
            object = serializable.iterator();
            while (object.hasNext()) {
                String string4 = (String)object.next();
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign != null && storageDesign instanceof StorageDesignSqlServer) {
                    StorageDesignSqlServer storageDesignSqlServer = (StorageDesignSqlServer)storageDesign;
                    DataBaseSqlServer dataBaseSqlServer = (DataBaseSqlServer)storageDesignSqlServer.getDataBaseSet().getByName(string2);
                    if (dataBaseSqlServer == null) {
                        dataBaseSqlServer = storageDesignSqlServer.getDataBaseSet().createDataBase();
                        dataBaseSqlServer.setName(string2);
                        this.stampModelObject((ModelObject)dataBaseSqlServer, "", string2);
                    }
                    DefaultSqlServer defaultSqlServer = storageDesignSqlServer.getDefaultSet().createDefault();
                    defaultSqlServer.setName(string);
                    defaultSqlServer.setDataBase(dataBaseSqlServer);
                    this.setSchema(defaultSqlServer, dBObjectSqlServer.getSchema());
                    this.setText(defaultSqlServer, string4);
                    this.stampModelObject((ModelObject)defaultSqlServer, dBObjectSqlServer.getSchema(), string);
                    this.bindColumns(defaultSqlServer, storageDesignSqlServer, string3, string2, connection);
                    this.bindToUserDefinedTypes(defaultSqlServer, storageDesignSqlServer);
                    continue;
                }
                LOGGER.error("Unable to find Storage Design!");
            }
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObjectSqlServer);
        }
    }

    private void bindToUserDefinedTypes(DefaultSqlServer defaultSqlServer, StorageDesignSqlServer storageDesignSqlServer) {
        String string = defaultSqlServer.getLongName();
        if (((DBMExtractionHandlerSQLServer)this.getDbmeHandler()).getDefaultMap().containsKey(string)) {
            List list = (List)((DBMExtractionHandlerSQLServer)this.getDbmeHandler()).getDefaultMap().get(string);
            for (String string2 : list) {
                UsedUserDefinedDatav2k5 usedUserDefinedDatav2k5 = (UsedUserDefinedDatav2k5)storageDesignSqlServer.getUsedUserDefinedDataSet().getById(string2);
                if (usedUserDefinedDatav2k5 == null) continue;
                usedUserDefinedDatav2k5.setDefaultObject(defaultSqlServer);
            }
        }
    }

    private void setSchema(DefaultSqlServer defaultSqlServer, String string) {
        SchemaSqlServerv2k5 schemaSqlServerv2k5 = (SchemaSqlServerv2k5)defaultSqlServer.getDataBase().getSchemas().getByName(string);
        defaultSqlServer.setSchema(schemaSqlServerv2k5);
    }

    private void bindColumns(DefaultSqlServer defaultSqlServer, StorageDesignSqlServer storageDesignSqlServer, String string, String string2, Connection connection) {
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT").append(' ');
            stringBuffer.append("col.name columnname").append(' ');
            stringBuffer.append(',').append(' ');
            stringBuffer.append("obj.name tablename").append(' ');
            stringBuffer.append("FROM").append(' ');
            stringBuffer.append(string2).append('.').append("dbo.syscolumns col").append(' ');
            stringBuffer.append(',').append(' ');
            stringBuffer.append(string2).append('.').append("dbo.sysobjects obj").append(' ');
            stringBuffer.append("WHERE").append(' ');
            stringBuffer.append("col.cdefault").append(' ');
            stringBuffer.append('=').append(' ');
            stringBuffer.append(string).append(' ');
            stringBuffer.append("AND").append(' ');
            stringBuffer.append("col").append('.').append("ID").append(' ');
            stringBuffer.append('=').append(' ');
            stringBuffer.append("obj").append('.').append("ID").append(' ');
            resultSet = statement.executeQuery(stringBuffer.toString());
            TableProxySetSqlServer tableProxySetSqlServer = (TableProxySetSqlServer)storageDesignSqlServer.getTableProxySet();
            if (resultSet != null) {
                while (resultSet.next()) {
                    ColumnProxySqlServer columnProxySqlServer;
                    String string3 = resultSet.getString(1);
                    String string4 = resultSet.getString(2);
                    TableProxySqlServer tableProxySqlServer = tableProxySetSqlServer.getByName(string4);
                    if (tableProxySqlServer == null || (columnProxySqlServer = (ColumnProxySqlServer)tableProxySqlServer.getColumnProxyByName(string3)) == null) continue;
                    columnProxySqlServer.setDefineDefault(true);
                    columnProxySqlServer.setDefaultObject(defaultSqlServer);
                }
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHRuleSqlServer.bindColumns():", sQLException);
        }
    }

    private void setText(DefaultSqlServer defaultSqlServer, String string) throws Exception {
        String string2 = Token.getStringAfterToken(string, "AS");
        string2 = Token.getValBetweenQuotes(string2);
        defaultSqlServer.setConstant(string2.trim());
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        ArrayList arrayList = new ArrayList();
        for (DBObject dBObject : list) {
            if (!dBObject.isSelected() || !(dBObject instanceof DBUserSqlServer)) continue;
            DBUserSqlServer dBUserSqlServer = (DBUserSqlServer)dBObject;
            arrayList.addAll(this.extractByUser(connection, dBUserSqlServer));
        }
        return arrayList;
    }

    private List extractByUser(Connection connection, DBUserSqlServer dBUserSqlServer) throws Exception {
        CharSequence charSequence;
        ArrayList<DBObjectSqlServer> arrayList = new ArrayList<DBObjectSqlServer>();
        String string = dBUserSqlServer.getDb();
        String string2 = dBUserSqlServer.getId();
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("USE").append(' ');
            ((StringBuffer)charSequence).append(string).append(' ').append("\n");
            ((StringBuffer)charSequence).append(';').append("\n").append("\n");
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append("NAME").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("ID").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("UID").append(' ');
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append(string).append('.').append("dbo.sysobjects s").append(' ');
            ((StringBuffer)charSequence).append("WHERE").append(' ');
            ((StringBuffer)charSequence).append("XTYPE").append(' ');
            ((StringBuffer)charSequence).append('=').append(' ');
            ((StringBuffer)charSequence).append('\'').append("D").append('\'').append(' ');
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append(1).append(' ');
            ((StringBuffer)charSequence).append('=').append(' ');
            ((StringBuffer)charSequence).append('(').append(' ');
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append("OBJECTPROPERTY ( s.id ,'IsDefault')").append(' ');
            ((StringBuffer)charSequence).append(')').append(' ');
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("UID").append(' ');
            ((StringBuffer)charSequence).append('=').append(' ');
            ((StringBuffer)charSequence).append(string2);
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHDefaultSqlServerv2k5.extract():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                DBObjectSqlServer dBObjectSqlServer = new DBObjectSqlServer(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, OBJECT_TYPE, dBUserSqlServer.getName());
                dBObjectSqlServer.setDb(string);
                dBObjectSqlServer.setId(string3);
                arrayList.add(dBObjectSqlServer);
            }
        }
        if (statement != null) {
            statement.close();
        }
        return arrayList;
    }
}

