/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver.v2k5;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBObjectSqlServer;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataFileSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHDatabaseSqlServerv2k5
extends AbstractMOHandler {
    protected static final String OBJECT_TYPE = "DATABASE";
    private static final Logger LOGGER = new Logger(MOHDatabaseSqlServerv2k5.class);
    protected static final String UserAccess = "UserAccess";
    protected static final String Collation = "Collation";
    protected static final String IsCloseCursorsOnCommitEnabled = "IsCloseCursorsOnCommitEnabled";
    protected static final String IsLocalCursorsDefault = "IsLocalCursorsDefault";
    protected static final String IsAnsiNullsEnabled = "IsAnsiNullsEnabled";
    protected static final String IsAnsiPaddingEnabled = "IsAnsiPaddingEnabled";
    protected static final String IsAnsiWarningsEnabled = "IsAnsiWarningsEnabled";
    protected static final String IsArithmeticAbortEnabled = "IsArithmeticAbortEnabled";
    protected static final String IsAutoClose = "IsAutoClose";
    protected static final String IsAutoCreateStatistics = "IsAutoCreateStatistics";
    protected static final String IsAutoShrink = "IsAutoShrink";
    protected static final String IsAutoUpdateStatistics = "IsAutoUpdateStatistics";
    protected static final String IsNullConcat = "IsNullConcat";
    protected static final String IsNumericRoundAbortEnabled = "IsNumericRoundAbortEnabled";
    protected static final String IsQuotedIdentifiersEnabled = "IsQuotedIdentifiersEnabled";
    protected static final String IsRecursiveTriggersEnabled = "IsRecursiveTriggersEnabled";
    protected static final String IsTornPageDetectionEnabled = "IsTornPageDetectionEnabled";
    protected static final String Recovery = "Recovery";
    protected static final String PRIMARY = "PRIMARY";

    public MOHDatabaseSqlServerv2k5(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            DBObjectSqlServer dBObjectSqlServer = (DBObjectSqlServer)list.get(i);
            String string = dBObjectSqlServer.getId();
            String string2 = dBObjectSqlServer.getName();
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObjectSqlServer.getType())) continue;
            this.initDataBase(connection, string2, string);
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObjectSqlServer);
        }
    }

    protected void initDataBase(Connection connection, String string, String string2) throws SQLException, Exception {
        Object object;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ');
            ((StringBuffer)object).append("DATABASEPROPERTY").append(' ');
            ((StringBuffer)object).append('(').append(' ');
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(string);
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(',').append(' ');
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(UserAccess);
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(')').append(' ');
            ((StringBuffer)object).append(UserAccess);
            ((StringBuffer)object).append(',').append(' ');
            ((StringBuffer)object).append("DATABASEPROPERTY").append(' ');
            ((StringBuffer)object).append('(').append(' ');
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(string);
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(',').append(' ');
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(Collation);
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(')').append(' ');
            ((StringBuffer)object).append(Collation);
            ((StringBuffer)object).append(',').append(' ');
            ((StringBuffer)object).append("DATABASEPROPERTY").append(' ');
            ((StringBuffer)object).append('(').append(' ');
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(string);
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(',').append(' ');
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(IsCloseCursorsOnCommitEnabled);
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(')').append(' ');
            ((StringBuffer)object).append(IsCloseCursorsOnCommitEnabled);
            ((StringBuffer)object).append(',').append(' ');
            ((StringBuffer)object).append("DATABASEPROPERTY").append(' ');
            ((StringBuffer)object).append('(').append(' ');
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(string);
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(',').append(' ');
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(IsLocalCursorsDefault);
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(')').append(' ');
            ((StringBuffer)object).append(IsLocalCursorsDefault);
            ((StringBuffer)object).append(',').append(' ');
            ((StringBuffer)object).append("DATABASEPROPERTY").append(' ');
            ((StringBuffer)object).append('(').append(' ');
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(string);
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(',').append(' ');
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(IsAnsiNullsEnabled);
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(')').append(' ');
            ((StringBuffer)object).append(IsAnsiNullsEnabled);
            ((StringBuffer)object).append(',').append(' ');
            ((StringBuffer)object).append("DATABASEPROPERTY").append(' ');
            ((StringBuffer)object).append('(').append(' ');
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(string);
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(',').append(' ');
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(IsAnsiPaddingEnabled);
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(')').append(' ');
            ((StringBuffer)object).append(IsAnsiPaddingEnabled);
            ((StringBuffer)object).append(',').append(' ');
            ((StringBuffer)object).append("DATABASEPROPERTY").append(' ');
            ((StringBuffer)object).append('(').append(' ');
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(string);
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(',').append(' ');
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(IsAnsiWarningsEnabled);
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(')').append(' ');
            ((StringBuffer)object).append(IsAnsiWarningsEnabled);
            ((StringBuffer)object).append(',').append(' ');
            ((StringBuffer)object).append("DATABASEPROPERTY").append(' ');
            ((StringBuffer)object).append('(').append(' ');
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(string);
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(',').append(' ');
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(IsArithmeticAbortEnabled);
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(')').append(' ');
            ((StringBuffer)object).append(IsArithmeticAbortEnabled);
            ((StringBuffer)object).append(',').append(' ');
            ((StringBuffer)object).append("DATABASEPROPERTY").append(' ');
            ((StringBuffer)object).append('(').append(' ');
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(string);
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(',').append(' ');
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(IsAutoClose);
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(')').append(' ');
            ((StringBuffer)object).append(IsAutoClose);
            ((StringBuffer)object).append(',').append(' ');
            ((StringBuffer)object).append("DATABASEPROPERTY").append(' ');
            ((StringBuffer)object).append('(').append(' ');
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(string);
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(',').append(' ');
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(IsAutoCreateStatistics);
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(')').append(' ');
            ((StringBuffer)object).append(IsAutoCreateStatistics);
            ((StringBuffer)object).append(',').append(' ');
            ((StringBuffer)object).append("DATABASEPROPERTY").append(' ');
            ((StringBuffer)object).append('(').append(' ');
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(string);
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(',').append(' ');
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(IsAutoShrink);
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(')').append(' ');
            ((StringBuffer)object).append(IsAutoShrink);
            ((StringBuffer)object).append(',').append(' ');
            ((StringBuffer)object).append("DATABASEPROPERTY").append(' ');
            ((StringBuffer)object).append('(').append(' ');
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(string);
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(',').append(' ');
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(IsAutoUpdateStatistics);
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(')').append(' ');
            ((StringBuffer)object).append(IsAutoUpdateStatistics);
            ((StringBuffer)object).append(',').append(' ');
            ((StringBuffer)object).append("DATABASEPROPERTY").append(' ');
            ((StringBuffer)object).append('(').append(' ');
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(string);
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(',').append(' ');
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(IsNullConcat);
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(')').append(' ');
            ((StringBuffer)object).append(IsNullConcat);
            ((StringBuffer)object).append(',').append(' ');
            ((StringBuffer)object).append("DATABASEPROPERTY").append(' ');
            ((StringBuffer)object).append('(').append(' ');
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(string);
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(',').append(' ');
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(IsNumericRoundAbortEnabled);
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(')').append(' ');
            ((StringBuffer)object).append(IsNumericRoundAbortEnabled);
            ((StringBuffer)object).append(',').append(' ');
            ((StringBuffer)object).append("DATABASEPROPERTY").append(' ');
            ((StringBuffer)object).append('(').append(' ');
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(string);
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(',').append(' ');
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(IsQuotedIdentifiersEnabled);
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(')').append(' ');
            ((StringBuffer)object).append(IsQuotedIdentifiersEnabled);
            ((StringBuffer)object).append(',').append(' ');
            ((StringBuffer)object).append("DATABASEPROPERTY").append(' ');
            ((StringBuffer)object).append('(').append(' ');
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(string);
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(',').append(' ');
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(IsRecursiveTriggersEnabled);
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(')').append(' ');
            ((StringBuffer)object).append(IsRecursiveTriggersEnabled);
            ((StringBuffer)object).append(',').append(' ');
            ((StringBuffer)object).append("DATABASEPROPERTY").append(' ');
            ((StringBuffer)object).append('(').append(' ');
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(string);
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(',').append(' ');
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(IsTornPageDetectionEnabled);
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(')').append(' ');
            ((StringBuffer)object).append(IsTornPageDetectionEnabled);
            ((StringBuffer)object).append(',').append(' ');
            ((StringBuffer)object).append("DATABASEPROPERTY").append(' ');
            ((StringBuffer)object).append('(').append(' ');
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(string);
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(',').append(' ');
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(Recovery);
            ((StringBuffer)object).append('\'');
            ((StringBuffer)object).append(')').append(' ');
            ((StringBuffer)object).append(Recovery);
            resultSet = statement.executeQuery(((StringBuffer)object).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHDatabaseSqlServerv2k5.generate():", sQLException);
        }
        if (resultSet != null && resultSet.next()) {
            object = this.getStorageDesign();
            if (object != null && object instanceof StorageDesignSqlServer) {
                StorageDesignSqlServer storageDesignSqlServer = (StorageDesignSqlServer)object;
                DataBaseSqlServerv2k5 dataBaseSqlServerv2k5 = (DataBaseSqlServerv2k5)((StorageDesignSqlServerv2k5)object).getDataBaseSet().getByName(string);
                if (dataBaseSqlServerv2k5 == null) {
                    dataBaseSqlServerv2k5 = (DataBaseSqlServerv2k5)storageDesignSqlServer.getDataBaseSet().createDataBase();
                    dataBaseSqlServerv2k5.setName(string);
                    dataBaseSqlServerv2k5.setObjectID(string2);
                    this.stampModelObject((ModelObject)dataBaseSqlServerv2k5, "", string);
                }
                this.setProperties(dataBaseSqlServerv2k5, resultSet);
                this.initFilegroups(dataBaseSqlServerv2k5, storageDesignSqlServer, connection);
                this.initLogfiles(dataBaseSqlServerv2k5, storageDesignSqlServer, connection);
            } else {
                LOGGER.error("Unable to find Storage Design!");
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initLogfiles(DataBaseSqlServer dataBaseSqlServer, StorageDesignSqlServer storageDesignSqlServer, Connection connection) {
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT").append(' ');
            stringBuffer.append("NAME").append(' ');
            stringBuffer.append(',').append(' ');
            stringBuffer.append("size").append(' ');
            stringBuffer.append(',').append(' ');
            stringBuffer.append("maxsize").append(' ');
            stringBuffer.append(',').append(' ');
            stringBuffer.append("growth").append(' ');
            stringBuffer.append(',').append(' ');
            stringBuffer.append("GROWTH_IN_PERCENTAGE = ");
            stringBuffer.append("case status & 0x100000 ");
            stringBuffer.append("when 0x100000 then 'YES' ");
            stringBuffer.append("else 'NO' ");
            stringBuffer.append("end").append(' ');
            stringBuffer.append(',').append(' ');
            stringBuffer.append("filename").append(' ');
            stringBuffer.append("FROM").append(' ');
            stringBuffer.append(dataBaseSqlServer.getName()).append('.').append("dbo.sysfiles").append(' ');
            stringBuffer.append("WHERE").append(' ');
            stringBuffer.append("status & 0x40 = 0x40").append(' ');
            stringBuffer.append("ORDER BY").append(' ');
            stringBuffer.append("fileid").append(' ');
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet != null) {
                while (resultSet.next()) {
                    String string = resultSet.getString(1).trim();
                    int n = resultSet.getInt(2);
                    int n2 = resultSet.getInt(3);
                    int n3 = resultSet.getInt(4);
                    String string2 = resultSet.getString(5);
                    String string3 = resultSet.getString(6).trim();
                    DataFileSqlServer dataFileSqlServer = storageDesignSqlServer.getDataFileSet().createDataFile();
                    dataFileSqlServer.setName(string);
                    dataFileSqlServer.setDataBase(dataBaseSqlServer);
                    dataFileSqlServer.setFileName(string3);
                    dataFileSqlServer.setInitialSize(n);
                    this.stampModelObject((ModelObject)dataFileSqlServer, dataBaseSqlServer, string);
                    if (string2.equalsIgnoreCase("YES")) {
                        dataFileSqlServer.setGrowthMethod("By Percent");
                    } else {
                        dataFileSqlServer.setGrowthMethod("In MegaBytes");
                    }
                    dataFileSqlServer.setGrowthValue(n3);
                    if (n2 == -1) {
                        dataFileSqlServer.setIsUnlimited(true);
                        continue;
                    }
                    dataFileSqlServer.setIsUnlimited(false);
                    dataFileSqlServer.setMaxSize(n2);
                }
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHDatabaseSqlServerv2k5.initLogfiles():", sQLException);
        }
    }

    private void initFilegroups(DataBaseSqlServer dataBaseSqlServer, StorageDesignSqlServer storageDesignSqlServer, Connection connection) {
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT").append(' ');
            stringBuffer.append("groupname").append(' ');
            stringBuffer.append(',').append(' ');
            stringBuffer.append("groupid").append(' ');
            stringBuffer.append("FROM").append(' ');
            stringBuffer.append(dataBaseSqlServer.getName()).append('.').append("dbo.sysfilegroups").append(' ');
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet != null) {
                while (resultSet.next()) {
                    String string = resultSet.getString(1);
                    String string2 = resultSet.getString(2);
                    FileGroupSqlServer fileGroupSqlServer = (FileGroupSqlServer)dataBaseSqlServer.getFilegroups().getByName(string);
                    if (fileGroupSqlServer == null) {
                        fileGroupSqlServer = storageDesignSqlServer.getFileGroupSet().createFileGroup();
                        fileGroupSqlServer.setName(string);
                        fileGroupSqlServer.setDataBase(dataBaseSqlServer);
                        this.stampModelObject((ModelObject)fileGroupSqlServer, dataBaseSqlServer, string);
                    }
                    this.initDatafiles(fileGroupSqlServer, string2, dataBaseSqlServer.getName(), storageDesignSqlServer, connection);
                }
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (Exception exception) {
            LOGGER.error("MOHDatabaseSqlServerv2k5.initFilegroups():", exception);
        }
    }

    private void initDatafiles(FileGroupSqlServer fileGroupSqlServer, String string, String string2, StorageDesignSqlServer storageDesignSqlServer, Connection connection) throws Exception {
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT").append(' ');
            stringBuffer.append("NAME").append(' ');
            stringBuffer.append(',').append(' ');
            stringBuffer.append("size").append(' ');
            stringBuffer.append(',').append(' ');
            stringBuffer.append("maxsize").append(' ');
            stringBuffer.append(',').append(' ');
            stringBuffer.append("growth").append(' ');
            stringBuffer.append(',').append(' ');
            stringBuffer.append("GROWTH_IN_PERCENTAGE = ");
            stringBuffer.append("case status & 0x100000 ");
            stringBuffer.append("when 0x100000 then 'YES' ");
            stringBuffer.append("else 'NO' ");
            stringBuffer.append("end").append(' ');
            stringBuffer.append(',').append(' ');
            stringBuffer.append("filename").append(' ');
            stringBuffer.append("FROM").append(' ');
            stringBuffer.append(string2).append('.').append("dbo.sysfiles").append(' ');
            stringBuffer.append("WHERE").append(' ');
            stringBuffer.append("status & 0x2 = 0x2").append(' ');
            stringBuffer.append("AND").append(' ');
            stringBuffer.append("groupid").append(' ');
            stringBuffer.append('=').append(' ');
            stringBuffer.append(string).append(' ');
            stringBuffer.append("ORDER BY").append(' ');
            stringBuffer.append("fileid").append(' ');
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet != null) {
                while (resultSet.next()) {
                    String string3 = resultSet.getString(1).trim();
                    int n = resultSet.getInt(2);
                    int n2 = resultSet.getInt(3);
                    int n3 = resultSet.getInt(4);
                    String string4 = resultSet.getString(5);
                    String string5 = resultSet.getString(6).trim();
                    DataFileSqlServer dataFileSqlServer = storageDesignSqlServer.getDataFileSet().createDataFile();
                    dataFileSqlServer.setName(string3);
                    dataFileSqlServer.setFileGroup(fileGroupSqlServer);
                    dataFileSqlServer.setFileName(string5);
                    dataFileSqlServer.setInitialSize(n);
                    this.stampModelObject((ModelObject)dataFileSqlServer, fileGroupSqlServer.getDataBase(), string3);
                    if (string4.equalsIgnoreCase("YES")) {
                        dataFileSqlServer.setGrowthMethod("By Percent");
                    } else {
                        dataFileSqlServer.setGrowthMethod("In MegaBytes");
                    }
                    dataFileSqlServer.setGrowthValue(n3);
                    if (n2 == -1) {
                        dataFileSqlServer.setIsUnlimited(true);
                        continue;
                    }
                    dataFileSqlServer.setIsUnlimited(false);
                    dataFileSqlServer.setMaxSize(n2);
                }
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHDatabaseSqlServerv2k5.initDatafiles():", sQLException);
        }
    }

    private void setProperties(DataBaseSqlServer dataBaseSqlServer, ResultSet resultSet) throws Exception {
        String string = resultSet.getString(UserAccess);
        String string2 = resultSet.getString(Collation);
        int n = resultSet.getInt(IsCloseCursorsOnCommitEnabled);
        int n2 = resultSet.getInt(IsLocalCursorsDefault);
        int n3 = resultSet.getInt(IsAnsiNullsEnabled);
        int n4 = resultSet.getInt(IsAnsiPaddingEnabled);
        int n5 = resultSet.getInt(IsAnsiWarningsEnabled);
        int n6 = resultSet.getInt(IsArithmeticAbortEnabled);
        int n7 = resultSet.getInt(IsAutoClose);
        int n8 = resultSet.getInt(IsAutoCreateStatistics);
        int n9 = resultSet.getInt(IsAutoShrink);
        int n10 = resultSet.getInt(IsAutoUpdateStatistics);
        int n11 = resultSet.getInt(IsNullConcat);
        int n12 = resultSet.getInt(IsNumericRoundAbortEnabled);
        int n13 = resultSet.getInt(IsQuotedIdentifiersEnabled);
        int n14 = resultSet.getInt(IsRecursiveTriggersEnabled);
        int n15 = resultSet.getInt(IsTornPageDetectionEnabled);
        String string3 = resultSet.getString(Recovery);
        dataBaseSqlServer.setUserState(string);
        dataBaseSqlServer.setCollationName(string2);
        if (n == 0) {
            dataBaseSqlServer.setCursorCloseOnCommit("OFF");
        } else {
            dataBaseSqlServer.setCursorCloseOnCommit("ON");
        }
        if (n2 == 0) {
            dataBaseSqlServer.setCursorDefault("GLOBAL");
        } else {
            dataBaseSqlServer.setCursorDefault("LOCAL");
        }
        if (n3 == 0) {
            dataBaseSqlServer.setAnsiNulls("OFF");
        } else {
            dataBaseSqlServer.setAnsiNulls("ON");
        }
        if (n4 == 0) {
            dataBaseSqlServer.setAnsiPadding("OFF");
        } else {
            dataBaseSqlServer.setAnsiPadding("ON");
        }
        if (n5 == 0) {
            dataBaseSqlServer.setAnsiWarnings("OFF");
        } else {
            dataBaseSqlServer.setAnsiWarnings("ON");
        }
        if (n6 == 0) {
            dataBaseSqlServer.setArithabort("OFF");
        } else {
            dataBaseSqlServer.setArithabort("ON");
        }
        if (n7 == 0) {
            dataBaseSqlServer.setAutoClose("OFF");
        } else {
            dataBaseSqlServer.setAutoClose("ON");
        }
        if (n8 == 0) {
            dataBaseSqlServer.setAutoCreateStatistics("OFF");
        } else {
            dataBaseSqlServer.setAutoCreateStatistics("ON");
        }
        if (n9 == 0) {
            dataBaseSqlServer.setAutoShrink("OFF");
        } else {
            dataBaseSqlServer.setAutoShrink("ON");
        }
        if (n10 == 0) {
            dataBaseSqlServer.setAutoUpdateStatistics("OFF");
        } else {
            dataBaseSqlServer.setAutoUpdateStatistics("ON");
        }
        if (n11 == 0) {
            dataBaseSqlServer.setConcatNullYieldsNull("OFF");
        } else {
            dataBaseSqlServer.setConcatNullYieldsNull("ON");
        }
        if (n12 == 0) {
            dataBaseSqlServer.setNumericRoundabort("OFF");
        } else {
            dataBaseSqlServer.setNumericRoundabort("ON");
        }
        if (n13 == 0) {
            dataBaseSqlServer.setQuotedIdentifier("OFF");
        } else {
            dataBaseSqlServer.setQuotedIdentifier("ON");
        }
        if (n14 == 0) {
            dataBaseSqlServer.setRecursiveTriggers("OFF");
        } else {
            dataBaseSqlServer.setRecursiveTriggers("ON");
        }
        if (n15 == 0) {
            dataBaseSqlServer.setTornPageDetection("OFF");
        } else {
            dataBaseSqlServer.setTornPageDetection("ON");
        }
        dataBaseSqlServer.setRecovery(string3);
    }
}

