/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBObjectSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBUserSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHandlerSqlServer;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.LoginSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHUserSqlServer
extends MOHandlerSqlServer {
    public static final String OBJECT_TYPE = "USER";
    private static final Logger LOGGER = new Logger(MOHUserSqlServer.class);

    public MOHUserSqlServer(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            DBObjectSqlServer dBObjectSqlServer = (DBObjectSqlServer)list.get(i);
            String string = dBObjectSqlServer.getName();
            String string2 = dBObjectSqlServer.getDb();
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObjectSqlServer.getType())) continue;
            StorageDesign storageDesign = this.getStorageDesign();
            if (storageDesign != null && storageDesign instanceof StorageDesignSqlServer) {
                UserSqlServer userSqlServer;
                StorageDesignSqlServer storageDesignSqlServer = (StorageDesignSqlServer)storageDesign;
                DataBaseSqlServer dataBaseSqlServer = null;
                if (!"".equalsIgnoreCase(string2)) {
                    dataBaseSqlServer = (DataBaseSqlServer)storageDesignSqlServer.getDataBaseSet().getByName(string2);
                    if (dataBaseSqlServer == null) {
                        dataBaseSqlServer = storageDesignSqlServer.getDataBaseSet().createDataBase();
                        dataBaseSqlServer.setName(string2);
                        this.stampModelObject((ModelObject)dataBaseSqlServer, "", string2);
                    }
                } else {
                    dataBaseSqlServer = (DataBaseSqlServer)storageDesignSqlServer.getDataBaseSet().getNullInstance();
                }
                if ((userSqlServer = (UserSqlServer)storageDesignSqlServer.getUserSet().getByName(string)) == null) {
                    userSqlServer = storageDesignSqlServer.getUserSet().createUser();
                    userSqlServer.setName(string);
                    this.stampModelObject((ModelObject)userSqlServer, string2, string);
                }
                String string3 = this.getUserId(string, string2, connection);
                String string4 = this.getLogin(string, string2, connection);
                if (string4 != null) {
                    LoginSqlServer loginSqlServer = (LoginSqlServer)storageDesignSqlServer.getLoginSet().getByName(string4);
                    if (loginSqlServer == null) {
                        loginSqlServer = storageDesignSqlServer.getLoginSet().createLogin();
                        loginSqlServer.setName(string4);
                        this.stampModelObject((ModelObject)loginSqlServer, dBObjectSqlServer.getSchema(), string4);
                    }
                    userSqlServer.setLogin(loginSqlServer);
                    loginSqlServer.setUsers(string);
                }
                userSqlServer.setDatabase(dataBaseSqlServer);
                if (string3 != null) {
                    this.initPrivileges(userSqlServer, string3, string2, connection);
                }
            } else {
                LOGGER.error("Unable to find Storage Design!");
            }
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObjectSqlServer);
        }
    }

    private void initPrivileges(UserSqlServer userSqlServer, String string, String string2, Connection connection) {
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT").append(' ');
            stringBuffer.append("DB_PRIV").append(' ');
            stringBuffer.append('=').append(' ');
            stringBuffer.append(" case action ");
            stringBuffer.append(" when 178 then 'CREATE FUNCTION'");
            stringBuffer.append(" when 198 then 'CREATE TABLE'");
            stringBuffer.append(" when 203 then 'CREATE DATABASE'");
            stringBuffer.append(" when 207 then 'CREATE VIEW'");
            stringBuffer.append(" when 222 then 'CREATE PROCEDURE'");
            stringBuffer.append(" when 228 then 'BACKUP DATABASE'");
            stringBuffer.append(" when 233 then 'CREATE DEFAULT'");
            stringBuffer.append(" when 235 then 'BACKUP LOG'");
            stringBuffer.append(" when 236 then 'CREATE RULE'");
            stringBuffer.append(" end").append(' ');
            stringBuffer.append("FROM").append(' ');
            stringBuffer.append(string2).append('.').append("dbo.sysprotects").append(' ');
            stringBuffer.append("WHERE").append(' ');
            stringBuffer.append("protecttype in (204,205)").append(' ');
            stringBuffer.append("AND").append(' ');
            stringBuffer.append("action in (178,198,203,207,222,228,233,235,236)").append(' ');
            stringBuffer.append("AND").append(' ');
            stringBuffer.append("UID").append(' ');
            stringBuffer.append('=').append(' ');
            stringBuffer.append(string).append(' ');
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet != null) {
                while (resultSet.next()) {
                    userSqlServer.setSystemPrivileges(resultSet.getString(1));
                }
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHUserSqlServer.bindColumns():", sQLException);
        }
    }

    private String getUserId(String string, String string2, Connection connection) {
        String string3 = null;
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT").append(' ');
            stringBuffer.append("u").append('.').append("UID").append(' ');
            stringBuffer.append("FROM").append(' ');
            stringBuffer.append("master.dbo.syslogins l").append(' ');
            stringBuffer.append(',').append(' ');
            stringBuffer.append(string2).append('.').append("dbo.sysusers u").append(' ');
            stringBuffer.append("WHERE").append(' ');
            stringBuffer.append("l").append('.').append("sid").append(' ');
            stringBuffer.append('=').append(' ');
            stringBuffer.append("u").append('.').append("sid").append(' ');
            stringBuffer.append("AND").append(' ');
            stringBuffer.append("u").append('.').append("NAME").append(' ');
            stringBuffer.append('=').append(' ').append('\'');
            stringBuffer.append(string).append('\'').append(' ');
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet != null && resultSet.next()) {
                string3 = resultSet.getString(1);
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHUserSqlServer.getUserId():", sQLException);
        }
        return string3;
    }

    private String getLogin(String string, String string2, Connection connection) {
        String string3 = null;
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT").append(' ');
            stringBuffer.append("l.loginname").append(' ');
            stringBuffer.append("FROM").append(' ');
            stringBuffer.append("master.dbo.syslogins l").append(' ');
            stringBuffer.append(',').append(' ');
            stringBuffer.append(string2).append('.').append("dbo.sysusers u").append(' ');
            stringBuffer.append("WHERE").append(' ');
            stringBuffer.append("l").append('.').append("sid").append(' ');
            stringBuffer.append('=').append(' ');
            stringBuffer.append("u").append('.').append("sid").append(' ');
            stringBuffer.append("AND").append(' ');
            stringBuffer.append("u").append('.').append("NAME").append(' ');
            stringBuffer.append('=').append(' ').append('\'');
            stringBuffer.append(string).append('\'').append(' ');
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet != null && resultSet.next()) {
                string3 = resultSet.getString(1);
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHRuleSqlServer.getLogin():", sQLException);
        }
        return string3;
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        ArrayList<DBUserSqlServer> arrayList = new ArrayList<DBUserSqlServer>();
        Iterator iterator = list.iterator();
        String string = null;
        while (iterator.hasNext()) {
            CharSequence charSequence;
            DBUserSqlServer dBUserSqlServer;
            DBObject dBObject = (DBObject)iterator.next();
            if (!dBObject.isSelected() || !(dBObject instanceof DBUserSqlServer) || (string = !this.containsDboForDb(list, dBUserSqlServer = (DBUserSqlServer)dBObject) ? dBUserSqlServer.getDb() : null) == null) continue;
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT").append(' ');
                ((StringBuffer)charSequence).append("NAME").append(' ').append(',');
                ((StringBuffer)charSequence).append("UID").append(' ').append(',');
                ((StringBuffer)charSequence).append("sid").append(' ');
                ((StringBuffer)charSequence).append("FROM").append(' ');
                ((StringBuffer)charSequence).append(string).append(".dbo.sysusers").append(' ');
                ((StringBuffer)charSequence).append("WHERE").append(' ');
                ((StringBuffer)charSequence).append("sid").append(' ').append("IS").append(' ').append("NOT").append(' ').append("NULL");
                resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("getUsers(): " + sQLException.getMessage());
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                    String string2 = resultSet.getString(2);
                    DBUserSqlServer dBUserSqlServer2 = new DBUserSqlServer(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, OBJECT_TYPE, (String)charSequence);
                    dBUserSqlServer2.setUid(string2);
                    dBUserSqlServer2.setDb(string);
                    arrayList.add(dBUserSqlServer2);
                }
            }
            if (statement == null) continue;
            statement.close();
        }
        return arrayList;
    }
}

