/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBObjectSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBUserSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHandlerSqlServer;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.IndexProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PKProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TriggerSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UniqueProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHTableSQLServer
extends MOHandlerSqlServer {
    public static final String OBJECT_TYPE = "TABLE";
    protected static final String COL_OBJECT_TYPE = "COLUMN";
    protected static final String SIZE = "size";
    protected static final String PRECISION = "precision";
    private static final Logger LOGGER = new Logger(MOHTableSQLServer.class);

    public MOHTableSQLServer(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        ArrayList arrayList = new ArrayList();
        for (DBObject dBObject : list) {
            if (!dBObject.isSelected() || !(dBObject instanceof DBUserSqlServer)) continue;
            DBUserSqlServer dBUserSqlServer = (DBUserSqlServer)dBObject;
            arrayList.addAll(MOHTableSQLServer.extractByUser(connection, dBUserSqlServer));
        }
        return arrayList;
    }

    private static List extractByUser(Connection connection, DBUserSqlServer dBUserSqlServer) throws Exception {
        CharSequence charSequence;
        ArrayList<DBObjectSqlServer> arrayList = new ArrayList<DBObjectSqlServer>();
        String string = dBUserSqlServer.getUid();
        String string2 = dBUserSqlServer.getDb();
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append("NAME").append(' ');
            ((StringBuffer)charSequence).append("TABLENAME").append(',').append(' ');
            ((StringBuffer)charSequence).append("ID").append(',').append(' ');
            ((StringBuffer)charSequence).append("UID").append(' ');
            ((StringBuffer)charSequence).append("USERID").append(' ');
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append(string2).append('.').append("dbo.sysobjects").append(' ');
            ((StringBuffer)charSequence).append("WHERE").append(' ');
            ((StringBuffer)charSequence).append("XTYPE").append(' ');
            ((StringBuffer)charSequence).append('=').append(' ');
            ((StringBuffer)charSequence).append('\'').append("U").append('\'').append(' ');
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("UID").append(' ');
            ((StringBuffer)charSequence).append('=').append(' ');
            ((StringBuffer)charSequence).append(string).append(' ');
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableSQLServer.extractByUser():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                DBObjectSqlServer dBObjectSqlServer = new DBObjectSqlServer(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, OBJECT_TYPE, "");
                dBObjectSqlServer.setDb(string2);
                dBObjectSqlServer.setSchema(dBUserSqlServer.getName());
                arrayList.add(dBObjectSqlServer);
            }
        }
        if (statement != null) {
            statement.close();
        }
        return arrayList;
    }

    protected ResultSet getTables(DatabaseMetaData databaseMetaData, DBObject dBObject, boolean bl) throws Exception {
        DBObjectSqlServer dBObjectSqlServer = (DBObjectSqlServer)dBObject;
        if (bl) {
            return databaseMetaData.getTables(dBObject.getName(), null, "%", new String[]{OBJECT_TYPE});
        }
        return databaseMetaData.getTables(dBObjectSqlServer.getDb(), null, dBObject.getName(), new String[]{OBJECT_TYPE});
    }

    protected ResultSet getColumns(DatabaseMetaData databaseMetaData, DBObject dBObject) throws Exception {
        DBObjectSqlServer dBObjectSqlServer = (DBObjectSqlServer)dBObject;
        return databaseMetaData.getColumns(dBObjectSqlServer.getDb(), null, dBObject.getName(), "%");
    }

    protected ResultSet getPrimaryKeys(DatabaseMetaData databaseMetaData, DBObject dBObject) throws Exception {
        DBObjectSqlServer dBObjectSqlServer = (DBObjectSqlServer)dBObject;
        return databaseMetaData.getPrimaryKeys(dBObjectSqlServer.getDb(), null, dBObject.getName());
    }

    protected ResultSet getIndexInfo(DatabaseMetaData databaseMetaData, DBObject dBObject) throws Exception {
        DBObjectSqlServer dBObjectSqlServer = (DBObjectSqlServer)dBObject;
        return databaseMetaData.getIndexInfo(dBObjectSqlServer.getDb(), null, dBObject.getName(), false, false);
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            CharSequence charSequence;
            DBObjectSqlServer dBObjectSqlServer = (DBObjectSqlServer)list.get(i);
            String string = dBObjectSqlServer.getName();
            String string2 = dBObjectSqlServer.getDb();
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObjectSqlServer.getType())) continue;
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT").append(' ');
                ((StringBuffer)charSequence).append("o").append('.').append("NAME").append(' ');
                ((StringBuffer)charSequence).append("TABLENAME").append(' ');
                ((StringBuffer)charSequence).append(',').append(' ');
                ((StringBuffer)charSequence).append("u").append('.').append("NAME").append(' ');
                ((StringBuffer)charSequence).append("USERNAME").append(' ');
                ((StringBuffer)charSequence).append(',').append(' ');
                ((StringBuffer)charSequence).append("o").append('.').append("ID").append(' ');
                ((StringBuffer)charSequence).append("TABLEID").append(' ');
                ((StringBuffer)charSequence).append("FROM").append(' ');
                ((StringBuffer)charSequence).append(string2).append('.').append("dbo.sysobjects o").append(' ');
                ((StringBuffer)charSequence).append(',').append(' ');
                ((StringBuffer)charSequence).append(string2).append('.').append("dbo.sysusers u").append(' ');
                ((StringBuffer)charSequence).append("WHERE").append(' ');
                ((StringBuffer)charSequence).append("XTYPE").append(' ');
                ((StringBuffer)charSequence).append('=').append(' ');
                ((StringBuffer)charSequence).append('\'').append("U").append('\'').append(' ');
                ((StringBuffer)charSequence).append("AND").append(' ');
                ((StringBuffer)charSequence).append("o").append('.').append("UID").append(' ');
                ((StringBuffer)charSequence).append('=').append(' ');
                ((StringBuffer)charSequence).append("u").append('.').append("UID").append(' ');
                ((StringBuffer)charSequence).append("AND").append(' ');
                ((StringBuffer)charSequence).append("o").append('.').append("NAME").append(' ');
                ((StringBuffer)charSequence).append('=').append(' ');
                ((StringBuffer)charSequence).append('\'').append(string).append('\'').append(' ');
                resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHTableSqlServer.extract():", sQLException);
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                    String string3 = resultSet.getString(2);
                    String string4 = resultSet.getString(3);
                    if (!((String)charSequence).equals(string)) continue;
                    Table table = this.getDesign().getRelationalDesign().createTable();
                    table.setSchemaObject(this.getSchemaSqlServer(dBObjectSqlServer.getSchema(), string2));
                    table.setName((String)charSequence);
                    this.stampModelObject(table, dBObjectSqlServer);
                    this.initColumns(connection, table, string4, string2);
                    this.initIndexes(connection, table, string4, string2);
                    this.initConstraints(connection, table, string4, string2);
                    this.initUniqueKeys(connection, table, string4, string2);
                    StorageDesign storageDesign = this.getStorageDesign();
                    if (storageDesign != null && storageDesign instanceof StorageDesignSqlServer) {
                        StorageDesignSqlServer storageDesignSqlServer = (StorageDesignSqlServer)storageDesign;
                        TableProxySqlServer tableProxySqlServer = (TableProxySqlServer)storageDesignSqlServer.getTableProxySet().getProxy(table.getObjectID());
                        if (tableProxySqlServer != null) {
                            DataBaseSqlServer dataBaseSqlServer = (DataBaseSqlServer)storageDesignSqlServer.getDataBaseSet().getByName(string2);
                            if (dataBaseSqlServer == null) {
                                dataBaseSqlServer = storageDesignSqlServer.getDataBaseSet().createDataBase();
                                dataBaseSqlServer.setName(string2);
                                this.stampModelObject((ModelObject)dataBaseSqlServer, "", string2);
                            }
                            tableProxySqlServer.setDatabase(dataBaseSqlServer);
                            this.setUser(tableProxySqlServer, string3, dataBaseSqlServer);
                            this.setFilegroups(tableProxySqlServer, string4, storageDesignSqlServer, dataBaseSqlServer, connection);
                            this.initTriggers(connection, tableProxySqlServer, string4, string2);
                            continue;
                        }
                        LOGGER.error("Unable to find TableProxy for table ID: " + table.getObjectID());
                        continue;
                    }
                    LOGGER.error("Unable to find Storage Design!");
                }
            }
            if (statement != null) {
                statement.close();
            }
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObjectSqlServer);
        }
    }

    private void setUser(TableProxySqlServer tableProxySqlServer, String string, DataBaseSqlServer dataBaseSqlServer) {
        UserSqlServer userSqlServer = (UserSqlServer)dataBaseSqlServer.getUsers().getByName(string);
        if (userSqlServer != null) {
            tableProxySqlServer.setUser(userSqlServer);
        }
    }

    private void setFilegroups(TableProxySqlServer tableProxySqlServer, String string, StorageDesignSqlServer storageDesignSqlServer, DataBaseSqlServer dataBaseSqlServer, Connection connection) {
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT").append(' ');
            stringBuffer.append("s").append('.').append("GROUPNAME").append(' ');
            stringBuffer.append("filegroup").append(' ');
            stringBuffer.append(',').append(' ');
            stringBuffer.append("i").append('.').append("indid").append(' ');
            stringBuffer.append("FROM").append(' ');
            stringBuffer.append(dataBaseSqlServer.getName()).append('.').append("dbo.sysfilegroups s").append(' ');
            stringBuffer.append(',').append(' ');
            stringBuffer.append(dataBaseSqlServer.getName()).append('.').append("dbo.sysindexes i").append(' ');
            stringBuffer.append("WHERE").append(' ');
            stringBuffer.append("i").append('.').append("ID").append(' ');
            stringBuffer.append('=').append(' ');
            stringBuffer.append(string).append(' ');
            stringBuffer.append("AND").append(' ');
            stringBuffer.append("(i.indid =0 or i.indid = 255)").append(' ');
            stringBuffer.append("AND").append(' ');
            stringBuffer.append("i").append('.').append("GROUPID").append(' ');
            stringBuffer.append('=').append(' ');
            stringBuffer.append("s").append('.').append("GROUPID").append(' ');
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet != null) {
                while (resultSet.next()) {
                    FileGroupSqlServer fileGroupSqlServer;
                    String string2 = resultSet.getString(1);
                    int n = resultSet.getInt(2);
                    if (n == 0) {
                        fileGroupSqlServer = (FileGroupSqlServer)dataBaseSqlServer.getFilegroups().getByName(string2);
                        if (fileGroupSqlServer == null) {
                            fileGroupSqlServer = storageDesignSqlServer.getFileGroupSet().createFileGroup();
                            fileGroupSqlServer.setName(string2);
                            fileGroupSqlServer.setDataBase(dataBaseSqlServer);
                            this.stampModelObject((ModelObject)fileGroupSqlServer, tableProxySqlServer, string2);
                        }
                        tableProxySqlServer.setFilegroup(fileGroupSqlServer);
                        continue;
                    }
                    if (n != 255) continue;
                    fileGroupSqlServer = (FileGroupSqlServer)dataBaseSqlServer.getFilegroups().getByName(string2);
                    if (fileGroupSqlServer == null) {
                        fileGroupSqlServer = storageDesignSqlServer.getFileGroupSet().createFileGroup();
                        fileGroupSqlServer.setName(string2);
                        fileGroupSqlServer.setDataBase(dataBaseSqlServer);
                        this.stampModelObject((ModelObject)fileGroupSqlServer, tableProxySqlServer, string2);
                    }
                    tableProxySqlServer.setTextImageFG(fileGroupSqlServer);
                }
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableSqlServer.initFilegroups():", sQLException);
        }
    }

    private void initColumns(Connection connection, Table table, String string, String string2) throws Exception {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append("c").append('.');
            ((StringBuffer)charSequence).append("NAME").append(' ');
            ((StringBuffer)charSequence).append("colname").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("t").append('.');
            ((StringBuffer)charSequence).append("NAME").append(' ');
            ((StringBuffer)charSequence).append("typename").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("c").append('.');
            ((StringBuffer)charSequence).append("colid").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("c").append('.');
            ((StringBuffer)charSequence).append("length").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("c").append('.');
            ((StringBuffer)charSequence).append("prec").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("c").append('.');
            ((StringBuffer)charSequence).append("scale").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("c").append('.');
            ((StringBuffer)charSequence).append("isnullable").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("c").append('.');
            ((StringBuffer)charSequence).append("iscomputed").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("computed_expr = com.text").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("c").append('.');
            ((StringBuffer)charSequence).append("collation").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("identitycolumn = ");
            ((StringBuffer)charSequence).append("case c.colstat & 1 ");
            ((StringBuffer)charSequence).append("when 1 then 'YES' ");
            ((StringBuffer)charSequence).append("else 'NO' ");
            ((StringBuffer)charSequence).append("end").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("ROWGUIDCOLL = ColumnProperty(c.id, c.name, 'IsRowGuidCol')").append(' ');
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append(string2).append('.').append("dbo.systypes t").append(',');
            ((StringBuffer)charSequence).append('(').append(' ').append(string2).append('.');
            ((StringBuffer)charSequence).append("dbo.syscolumns c Left Outer Join ");
            ((StringBuffer)charSequence).append(string2).append('.');
            ((StringBuffer)charSequence).append("dbo.syscomments com ");
            ((StringBuffer)charSequence).append("On com.id = c.id and com.number = c.colid)").append(' ');
            ((StringBuffer)charSequence).append("WHERE").append(' ');
            ((StringBuffer)charSequence).append("c.id ").append('=').append(string);
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("c.xusertype ").append('=').append("t.xusertype").append(' ');
            ((StringBuffer)charSequence).append("ORDER BY").append(' ');
            ((StringBuffer)charSequence).append("c.colid");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableSqlServer.initColumns():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                ModelIDObject modelIDObject;
                charSequence = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                int n = resultSet.getInt(4);
                int n2 = resultSet.getInt(5);
                int n3 = resultSet.getInt(6);
                int n4 = resultSet.getInt(7);
                int n5 = resultSet.getInt(8);
                String string4 = resultSet.getString(9);
                String string5 = resultSet.getString(10);
                String string6 = resultSet.getString(11);
                int n6 = resultSet.getInt(12);
                Column column = table.createColumn((String)charSequence);
                this.stampModelObject((ModelObject)column, table.getName(), (String)charSequence);
                String string7 = StandardDatatypeNames.getUsedDatatypeName(string3);
                LogicalDatatype logicalDatatype = this.getDesign().getLogicalDatatypeSet().getLogTypeByNativeType(string7, this.getDbmeHandler().getRDBMSSite().getType().getName());
                if (logicalDatatype != null && !"UNKNOWN".equalsIgnoreCase(string7)) {
                    column.setUse((short)1);
                    column.setLogicalDatatype(logicalDatatype);
                    column.setDataTypeParameter(SIZE, String.valueOf(n));
                    column.setDataTypeParameter(PRECISION, String.valueOf(n2));
                    column.setDataTypeParameter("SCALE", String.valueOf(n3));
                } else {
                    modelIDObject = (DistinctType)this.getDesign().getDataTypesDesign().getDistinctTypeSet().getByName(string3);
                    if (modelIDObject != null) {
                        column.setUse((short)2);
                        column.setDistinctType((DistinctType)modelIDObject);
                    } else {
                        column.setUse((short)1);
                        column.setLogicalDatatype(logicalDatatype);
                        column.setDataTypeParameter(SIZE, String.valueOf(n));
                        column.setDataTypeParameter(PRECISION, String.valueOf(n2));
                        column.setDataTypeParameter("SCALE", String.valueOf(n3));
                        System.out.println("Unable to find logical datatype for: " + string3);
                    }
                }
                column.setNullsAllowed(n4 == 1);
                if (n5 != 0) {
                    column.setComputed(true);
                    column.setFormulaDesc(string4);
                }
                if ((modelIDObject = this.getStorageDesign()) != null && modelIDObject instanceof StorageDesignSqlServer) {
                    StorageDesignSqlServer storageDesignSqlServer = (StorageDesignSqlServer)modelIDObject;
                    ColumnProxySqlServer columnProxySqlServer = (ColumnProxySqlServer)storageDesignSqlServer.getColumnProxySet().getProxy(column.getObjectID());
                    if (columnProxySqlServer != null) {
                        if (n6 == 0) {
                            columnProxySqlServer.setRowGuidCol("NO");
                        } else {
                            columnProxySqlServer.setRowGuidCol("YES");
                        }
                        columnProxySqlServer.setAsIdentity("YES".equalsIgnoreCase(string6));
                        columnProxySqlServer.setCollation(string5);
                        continue;
                    }
                    LOGGER.error("Unable to find ColumnProxy for table ID: " + table.getObjectID());
                    continue;
                }
                LOGGER.error("Unable to find Storage Design!");
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initIndexes(Connection connection, Table table, String string, String string2) throws Exception {
        Object object;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        Object object2;
        Object object3;
        Serializable serializable;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            serializable = new StringBuffer();
            ((StringBuffer)serializable).append("SELECT").append(' ');
            ((StringBuffer)serializable).append("i.name").append(' ');
            ((StringBuffer)serializable).append(',').append(' ');
            ((StringBuffer)serializable).append("clustered_ind = ");
            ((StringBuffer)serializable).append("case when (i.status & 16)=16 ");
            ((StringBuffer)serializable).append("then 'YES' ");
            ((StringBuffer)serializable).append("else 'NO' ");
            ((StringBuffer)serializable).append("end").append(' ');
            ((StringBuffer)serializable).append(',').append(' ');
            ((StringBuffer)serializable).append("f.groupname filegroup").append(' ');
            ((StringBuffer)serializable).append(',').append(' ');
            ((StringBuffer)serializable).append("i.origfillfactor fill_factor").append(' ');
            ((StringBuffer)serializable).append(',').append(' ');
            ((StringBuffer)serializable).append("i.indid").append(' ');
            ((StringBuffer)serializable).append(',').append(' ');
            ((StringBuffer)serializable).append("unique_ind = case when (i.status & 2)<>0 then 'YES' else 'NO' end").append(' ');
            ((StringBuffer)serializable).append(',').append(' ');
            ((StringBuffer)serializable).append("stats_no_recompute = case when (i.status & 16777216)<>0 then 'YES'  else 'NO' end").append(' ');
            ((StringBuffer)serializable).append(',').append(' ');
            ((StringBuffer)serializable).append("ignore_dup_keys = case when (i.status & 1)<>0 then 'YES'  else 'NO' end").append(' ');
            ((StringBuffer)serializable).append(',').append(' ');
            ((StringBuffer)serializable).append("is_pad_index = (select INDEXPROPERTY(i.id, i.name,'IsPadIndex'))").append(' ');
            ((StringBuffer)serializable).append("FROM").append(' ');
            ((StringBuffer)serializable).append(string2).append('.').append("dbo.sysindexes i").append(' ');
            ((StringBuffer)serializable).append(',').append(' ');
            ((StringBuffer)serializable).append(string2).append('.').append("dbo.sysfilegroups f").append(' ');
            ((StringBuffer)serializable).append("WHERE").append(' ');
            ((StringBuffer)serializable).append("i.id ").append('=').append(string).append(' ');
            ((StringBuffer)serializable).append("AND").append(' ');
            ((StringBuffer)serializable).append("f.groupid ").append('=').append("i.groupid").append(' ');
            ((StringBuffer)serializable).append("AND").append(' ');
            ((StringBuffer)serializable).append("NOT").append(' ').append("EXISTS").append(' ');
            ((StringBuffer)serializable).append('(').append(' ');
            ((StringBuffer)serializable).append("select 1 from ");
            ((StringBuffer)serializable).append(string2).append('.').append("dbo.sysobjects o ");
            ((StringBuffer)serializable).append(" where ");
            ((StringBuffer)serializable).append(" o.parent_obj = i.id and o.name = i.name and ");
            ((StringBuffer)serializable).append(" o.xtype in ('PK','UQ')").append(' ');
            ((StringBuffer)serializable).append(')').append(' ');
            resultSet = statement.executeQuery(((StringBuffer)serializable).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableSqlServer.initIndexes():", sQLException);
        }
        serializable = new ArrayList();
        if (resultSet != null) {
            while (resultSet.next()) {
                object3 = resultSet.getString(1);
                object2 = resultSet.getString(2);
                string7 = resultSet.getString(3);
                int n = resultSet.getInt(4);
                string6 = resultSet.getString(5);
                String string8 = resultSet.getString(6);
                string5 = resultSet.getString(7);
                string4 = resultSet.getString(8);
                string3 = resultSet.getString(9);
                if (object3 == null) continue;
                object = new Properties();
                ((Properties)object).setProperty("name", (String)object3);
                ((Properties)object).setProperty("clustered", (String)object2);
                ((Properties)object).setProperty("filegroup", string7);
                ((Properties)object).setProperty("fillFactor", String.valueOf(n));
                ((Properties)object).setProperty("indId", string6);
                ((Properties)object).setProperty("unique", string8);
                ((Properties)object).setProperty("statsNoRecompute", string5);
                ((Properties)object).setProperty("ignoreDupKeys", string4);
                ((Properties)object).setProperty("isPadIndex", string3 != null ? string3 : "0");
                serializable.add(object);
            }
        }
        if (statement != null) {
            statement.close();
        }
        object3 = serializable.iterator();
        while (object3.hasNext()) {
            object2 = (Properties)object3.next();
            string7 = ((Properties)object2).getProperty("name");
            String string9 = ((Properties)object2).getProperty("clustered");
            string6 = ((Properties)object2).getProperty("filegroup");
            int n = Integer.parseInt(((Properties)object2).getProperty("fillFactor"));
            string5 = ((Properties)object2).getProperty("indId");
            string4 = ((Properties)object2).getProperty("unique");
            string3 = ((Properties)object2).getProperty("statsNoRecompute");
            object = ((Properties)object2).getProperty("ignoreDupKeys");
            String string10 = ((Properties)object2).getProperty("isPadIndex");
            Index index = table.createIndex();
            index.setName(string7);
            this.stampModelObject((ModelObject)index, table.getSchema(), string7);
            if ("YES".equalsIgnoreCase(string4)) {
                index.setIndexState("Unique Plain Index");
            }
            this.initKeyColumns(index, table, string, string5, string2, connection);
            StorageDesign storageDesign = this.getStorageDesign();
            StorageDesign storageDesign2 = null;
            if (storageDesign != null && storageDesign instanceof StorageDesignSqlServer) {
                storageDesign2 = (StorageDesignSqlServer)storageDesign;
            }
            if (storageDesign2 != null) {
                IndexProxySqlServer indexProxySqlServer = (IndexProxySqlServer)storageDesign2.getIndexProxySet().getProxy(index.getObjectID());
                if (indexProxySqlServer != null) {
                    FileGroupSqlServer fileGroupSqlServer;
                    if ("YES".equalsIgnoreCase(string9)) {
                        indexProxySqlServer.setClustered(true);
                    } else {
                        indexProxySqlServer.setClustered(false);
                    }
                    indexProxySqlServer.setFillFactor(n);
                    if ("YES".equalsIgnoreCase(string3)) {
                        indexProxySqlServer.setRecomputeStatistics("NO");
                    } else {
                        indexProxySqlServer.setRecomputeStatistics("AUTO");
                    }
                    indexProxySqlServer.setIgnoreDupKey((String)object);
                    if ("1".equalsIgnoreCase(string10)) {
                        indexProxySqlServer.setPadIndex("YES");
                    } else {
                        indexProxySqlServer.setPadIndex("NO");
                    }
                    DataBaseSqlServer dataBaseSqlServer = (DataBaseSqlServer)((StorageDesignSqlServer)storageDesign2).getDataBaseSet().getByName(string2);
                    if (dataBaseSqlServer == null) {
                        dataBaseSqlServer = ((StorageDesignSqlServer)storageDesign2).getDataBaseSet().createDataBase();
                        dataBaseSqlServer.setName(string2);
                        this.stampModelObject((ModelObject)dataBaseSqlServer, "", string2);
                    }
                    if ((fileGroupSqlServer = (FileGroupSqlServer)dataBaseSqlServer.getFilegroups().getByName(string6)) == null) {
                        fileGroupSqlServer = ((StorageDesignSqlServer)storageDesign2).getFileGroupSet().createFileGroup();
                        fileGroupSqlServer.setName(string6);
                        fileGroupSqlServer.setDataBase(dataBaseSqlServer);
                        this.stampModelObject((ModelObject)fileGroupSqlServer, indexProxySqlServer, string6);
                    }
                    indexProxySqlServer.setFilegroup(fileGroupSqlServer);
                    continue;
                }
                LOGGER.error("Unable to find IndexProxy for table ID: " + table.getObjectID());
                continue;
            }
            LOGGER.error("Unable to find Storage Design!");
        }
    }

    private void initConstraints(Connection connection, Table table, String string, String string2) throws Exception {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append("o").append('.');
            ((StringBuffer)charSequence).append("ID").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("o").append('.');
            ((StringBuffer)charSequence).append("NAME").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("o").append('.');
            ((StringBuffer)charSequence).append("XTYPE").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("table_constraint = ");
            ((StringBuffer)charSequence).append(" case ");
            ((StringBuffer)charSequence).append("  when o.info = 0 then 'YES' ");
            ((StringBuffer)charSequence).append(" else 'NO' ");
            ((StringBuffer)charSequence).append(" end").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("column_name ").append('=').append(' ');
            ((StringBuffer)charSequence).append("col_name").append(' ');
            ((StringBuffer)charSequence).append('(').append(' ');
            ((StringBuffer)charSequence).append(string).append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("o.info").append(' ');
            ((StringBuffer)charSequence).append(')').append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("c.text constr_text").append(' ');
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append(string2).append('.').append("dbo.sysobjects o").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append(string2).append('.').append("dbo.syscomments c").append(' ');
            ((StringBuffer)charSequence).append("WHERE").append(' ');
            ((StringBuffer)charSequence).append("o.parent_obj").append(' ').append('=').append(' ').append(string).append(' ');
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("o.xtype in ('C ','D')").append(' ');
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("o.id = c.id").append(' ');
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableSqlServer.initConstraints():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                ModelObject modelObject;
                charSequence = resultSet.getString(2);
                String string3 = resultSet.getString(3);
                String string4 = resultSet.getString(4);
                String string5 = resultSet.getString(5);
                String string6 = resultSet.getString(6);
                if ("NO".equalsIgnoreCase(string4)) {
                    if ("C".equalsIgnoreCase(string3.trim())) {
                        modelObject = new CheckConstraint();
                        modelObject.setName((String)charSequence);
                        ((CheckConstraint)modelObject).add(StorageDesignSqlServerv2k.RDBMS_TYPE, string6);
                        Column column = (Column)table.getElementByName(string5);
                        if (column == null) continue;
                        column.setUseDomainConstraints(false);
                        column.setCheck((CheckConstraint)modelObject);
                        continue;
                    }
                    modelObject = (Column)table.getElementByName(string5);
                    if (modelObject == null) continue;
                    ((ContainedObjectWithDomain)modelObject).setUsesDefaultValue(true);
                    ((ContainedObjectWithDomain)modelObject).setDefaultValue(string6);
                    continue;
                }
                modelObject = table.createCheckConstraint((String)charSequence, string6);
                table.addCheckConstraint((TableLevelConstraint)modelObject);
                this.stampModelObject(modelObject, table.getSchema(), (String)charSequence);
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initUniqueKeys(Connection connection, Table table, String string, String string2) throws Exception {
        String string3;
        String string4;
        String string5;
        Object object;
        Object object2;
        Serializable serializable;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            serializable = new StringBuffer();
            ((StringBuffer)serializable).append("SELECT").append(' ');
            ((StringBuffer)serializable).append("o").append('.');
            ((StringBuffer)serializable).append("ID").append(' ');
            ((StringBuffer)serializable).append(',').append(' ');
            ((StringBuffer)serializable).append("o").append('.');
            ((StringBuffer)serializable).append("NAME").append(' ');
            ((StringBuffer)serializable).append(',').append(' ');
            ((StringBuffer)serializable).append("o").append('.');
            ((StringBuffer)serializable).append("XTYPE").append(' ');
            ((StringBuffer)serializable).append(',').append(' ');
            ((StringBuffer)serializable).append("clustered_ind = ");
            ((StringBuffer)serializable).append("case when (i.status & 16)=16 ");
            ((StringBuffer)serializable).append("then 'YES' ");
            ((StringBuffer)serializable).append("else 'NO' ");
            ((StringBuffer)serializable).append("end").append(' ');
            ((StringBuffer)serializable).append(',').append(' ');
            ((StringBuffer)serializable).append("f.groupname filegroup").append(' ');
            ((StringBuffer)serializable).append(',').append(' ');
            ((StringBuffer)serializable).append("i.origfillfactor fill_factor").append(' ');
            ((StringBuffer)serializable).append(',').append(' ');
            ((StringBuffer)serializable).append("i.indid").append(' ');
            ((StringBuffer)serializable).append("FROM").append(' ');
            ((StringBuffer)serializable).append(string2).append('.').append("dbo.sysobjects o").append(' ');
            ((StringBuffer)serializable).append(',').append(' ');
            ((StringBuffer)serializable).append(string2).append('.').append("dbo.sysindexes i").append(' ');
            ((StringBuffer)serializable).append(',').append(' ');
            ((StringBuffer)serializable).append(string2).append('.').append("dbo.sysfilegroups f").append(' ');
            ((StringBuffer)serializable).append("WHERE").append(' ');
            ((StringBuffer)serializable).append("o.parent_obj").append(' ').append('=').append(' ').append(string).append(' ');
            ((StringBuffer)serializable).append("AND").append(' ');
            ((StringBuffer)serializable).append("o.xtype in ('PK','UQ')").append(' ');
            ((StringBuffer)serializable).append("AND").append(' ');
            ((StringBuffer)serializable).append("i.id").append(' ').append('=').append(' ').append(string).append(' ');
            ((StringBuffer)serializable).append("AND").append(' ');
            ((StringBuffer)serializable).append("o.name").append(' ').append('=').append(' ').append("i.name").append(' ');
            ((StringBuffer)serializable).append("AND").append(' ');
            ((StringBuffer)serializable).append("f.groupid").append(' ').append('=').append(' ').append("i.groupid").append(' ');
            resultSet = statement.executeQuery(((StringBuffer)serializable).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableSqlServer.initUniqueKeys():", sQLException);
        }
        serializable = new ArrayList();
        if (resultSet != null) {
            while (resultSet.next()) {
                object2 = resultSet.getString(2);
                object = resultSet.getString(3);
                string5 = resultSet.getString(4);
                string4 = resultSet.getString(5);
                int n = resultSet.getInt(6);
                string3 = resultSet.getString(7);
                Properties properties = new Properties();
                properties.setProperty("name", (String)object2);
                properties.setProperty("xtype", (String)object);
                properties.setProperty("clustered", string5);
                properties.setProperty("filegroup", string4);
                properties.setProperty("fillFactor", String.valueOf(n));
                properties.setProperty("indId", string3);
                serializable.add(properties);
            }
        }
        if (statement != null) {
            statement.close();
        }
        object2 = serializable.iterator();
        while (object2.hasNext()) {
            FileGroupSqlServer fileGroupSqlServer;
            DataBaseSqlServer dataBaseSqlServer;
            IndexProxy indexProxy;
            object = (Properties)object2.next();
            string5 = ((Properties)object).getProperty("name");
            string4 = ((Properties)object).getProperty("xtype");
            String string6 = ((Properties)object).getProperty("clustered");
            string3 = ((Properties)object).getProperty("filegroup");
            int n = Integer.parseInt(((Properties)object).getProperty("fillFactor"));
            String string7 = ((Properties)object).getProperty("indId");
            Index index = table.createIndex();
            index.setName(string5);
            this.stampModelObject((ModelObject)index, table.getSchema(), string5);
            this.initKeyColumns(index, table, string, string7, string2, connection);
            StorageDesign storageDesign = this.getStorageDesign();
            StorageDesignSqlServer storageDesignSqlServer = null;
            if (storageDesign != null && storageDesign instanceof StorageDesignSqlServer) {
                storageDesignSqlServer = (StorageDesignSqlServer)storageDesign;
            }
            if ("PK".equalsIgnoreCase(string4)) {
                index.setIndexState("Primary Constraint");
                if (storageDesignSqlServer != null) {
                    indexProxy = (PKProxySqlServer)storageDesignSqlServer.getPKProxySet().getProxy(index.getObjectID());
                    if (indexProxy != null) {
                        if ("YES".equalsIgnoreCase(string6)) {
                            indexProxy.setClustered(true);
                        } else {
                            indexProxy.setClustered(false);
                        }
                        ((PKProxySqlServer)indexProxy).setFillFactor(n);
                        dataBaseSqlServer = (DataBaseSqlServer)storageDesignSqlServer.getDataBaseSet().getByName(string2);
                        if (dataBaseSqlServer == null) {
                            dataBaseSqlServer = storageDesignSqlServer.getDataBaseSet().createDataBase();
                            dataBaseSqlServer.setName(string2);
                            this.stampModelObject((ModelObject)dataBaseSqlServer, "", string2);
                        }
                        if ((fileGroupSqlServer = (FileGroupSqlServer)dataBaseSqlServer.getFilegroups().getByName(string3)) == null) {
                            fileGroupSqlServer = storageDesignSqlServer.getFileGroupSet().createFileGroup();
                            fileGroupSqlServer.setName(string3);
                            fileGroupSqlServer.setDataBase(dataBaseSqlServer);
                            this.stampModelObject((ModelObject)fileGroupSqlServer, indexProxy, string3);
                        }
                        ((PKProxySqlServer)indexProxy).setFilegroup(fileGroupSqlServer);
                        continue;
                    }
                    LOGGER.error("Unable to find IndexProxy for table ID: " + table.getObjectID());
                    continue;
                }
                LOGGER.error("Unable to find Storage Design!");
                continue;
            }
            index.setIndexState("Unique Constraint");
            if (storageDesignSqlServer != null) {
                indexProxy = (UniqueProxySqlServer)storageDesignSqlServer.getUniqueProxySet().getProxy(index.getObjectID());
                if (indexProxy != null) {
                    if ("YES".equalsIgnoreCase(string6)) {
                        indexProxy.setClustered(true);
                    } else {
                        indexProxy.setClustered(false);
                    }
                    ((UniqueProxySqlServer)indexProxy).setFillFactor(n);
                    dataBaseSqlServer = (DataBaseSqlServer)storageDesignSqlServer.getDataBaseSet().getByName(string2);
                    if (dataBaseSqlServer == null) {
                        dataBaseSqlServer = storageDesignSqlServer.getDataBaseSet().createDataBase();
                        dataBaseSqlServer.setName(string2);
                        this.stampModelObject((ModelObject)dataBaseSqlServer, "", string2);
                    }
                    if ((fileGroupSqlServer = (FileGroupSqlServer)dataBaseSqlServer.getFilegroups().getByName(string3)) == null) {
                        fileGroupSqlServer = storageDesignSqlServer.getFileGroupSet().createFileGroup();
                        fileGroupSqlServer.setName(string3);
                        fileGroupSqlServer.setDataBase(dataBaseSqlServer);
                        this.stampModelObject((ModelObject)fileGroupSqlServer, indexProxy, string3);
                    }
                    ((UniqueProxySqlServer)indexProxy).setFilegroup(fileGroupSqlServer);
                    continue;
                }
                LOGGER.error("Unable to find IndexProxy for table ID: " + table.getObjectID());
                continue;
            }
            LOGGER.error("Unable to find Storage Design!");
        }
    }

    private void initKeyColumns(Index index, Table table, String string, String string2, String string3, Connection connection) throws Exception {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("USE").append(' ');
            ((StringBuffer)charSequence).append(string3).append(' ');
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append("col_name(id,colid) columnname").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("sort_desc = indexkey_property(id, indid, keyno, 'isdescending')").append(' ');
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append(string3).append('.').append("dbo.sysindexkeys").append(' ');
            ((StringBuffer)charSequence).append("WHERE").append(' ');
            ((StringBuffer)charSequence).append("ID").append(' ').append('=').append(' ').append(string).append(' ');
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("indid").append(' ').append('=').append(' ').append(string2).append(' ');
            ((StringBuffer)charSequence).append("ORDER BY").append(' ');
            ((StringBuffer)charSequence).append("keyno").append(' ');
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableSqlServer.initKeyColumns():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                int n = resultSet.getInt(2);
                Column column = (Column)table.getElementByName((String)charSequence);
                if (column == null) continue;
                index.add(column);
                if (n == 0) {
                    index.setColumnSortOrder(column, "ASC");
                    continue;
                }
                index.setColumnSortOrder(column, "DESC");
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initTriggers(Connection connection, TableProxySqlServer tableProxySqlServer, String string, String string2) throws Exception {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("USE").append(' ');
            ((StringBuffer)charSequence).append(string2).append(' ');
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append("trigger_name").append(' ');
            ((StringBuffer)charSequence).append('=').append(' ');
            ((StringBuffer)charSequence).append("NAME").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("o").append('.');
            ((StringBuffer)charSequence).append("ID").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("trigger_owner").append(' ');
            ((StringBuffer)charSequence).append('=').append(' ');
            ((StringBuffer)charSequence).append("user_name(uid)").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("isupdate = ObjectProperty( o.id, 'ExecIsUpdateTrigger')").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("isdelete = ObjectProperty( o.id, 'ExecIsDeleteTrigger')").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("isinsert = ObjectProperty( o.id, 'ExecIsInsertTrigger')").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("isafter = ObjectProperty( o.id, 'ExecIsAfterTrigger')").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("isinsteadof = ObjectProperty( o.id, 'ExecIsInsteadOfTrigger')").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("isfirstupdate = ObjectProperty( o.id, 'ExecIsFirstUpdateTrigger')").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("isfirstdelete = ObjectProperty( o.id, 'ExecIsFirstDeleteTrigger')").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("isfirstinsert = ObjectProperty( o.id, 'ExecIsFirstInsertTrigger')").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("isLastupdate = ObjectProperty( o.id, 'ExecIsLastUpdateTrigger')").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("isLastdelete = ObjectProperty( o.id, 'ExecIsLastDeleteTrigger')").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("isLastinsert = ObjectProperty( o.id, 'ExecIsLastInsertTrigger')").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("s.encrypted").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("s.text trigger_definition").append(' ');
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append(string2).append('.').append("dbo.sysobjects o").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append(string2).append('.').append("dbo.syscomments s").append(' ');
            ((StringBuffer)charSequence).append("WHERE").append(' ');
            ((StringBuffer)charSequence).append("parent_obj").append(' ').append('=').append(' ').append(string).append(' ');
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("type = 'TR'").append(' ');
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("o.id = s.id").append(' ');
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableSqlServer.initTriggers():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string3 = resultSet.getString(3);
                int n = resultSet.getInt(4);
                int n2 = resultSet.getInt(5);
                int n3 = resultSet.getInt(6);
                int n4 = resultSet.getInt(7);
                int n5 = resultSet.getInt(8);
                int n6 = resultSet.getInt(9);
                int n7 = resultSet.getInt(10);
                int n8 = resultSet.getInt(11);
                int n9 = resultSet.getInt(12);
                int n10 = resultSet.getInt(13);
                int n11 = resultSet.getInt(14);
                int n12 = resultSet.getInt(15);
                String string4 = resultSet.getString(16);
                StorageDesignSqlServer storageDesignSqlServer = (StorageDesignSqlServer)tableProxySqlServer.getStorageDesign();
                TriggerSqlServer triggerSqlServer = storageDesignSqlServer.getTriggerSet().createTrigger();
                triggerSqlServer.setName((String)charSequence);
                triggerSqlServer.setTable(tableProxySqlServer);
                this.stampModelObject((ModelObject)triggerSqlServer, tableProxySqlServer.getSchema(), (String)charSequence);
                UserSqlServer userSqlServer = (UserSqlServer)storageDesignSqlServer.getUserSet().getByName(string3);
                if (userSqlServer != null) {
                    triggerSqlServer.setOwner(userSqlServer);
                }
                if (n == 1) {
                    triggerSqlServer.setActions("UPDATE");
                }
                if (n2 == 1) {
                    triggerSqlServer.setActions("DELETE");
                }
                if (n3 == 1) {
                    triggerSqlServer.setActions("INSERT");
                }
                if (n4 == 1) {
                    triggerSqlServer.setTriggerTime("AFTER");
                } else if (n5 == 1) {
                    triggerSqlServer.setTriggerTime("INSTEAD OF");
                }
                if (n7 == 1 || n8 == 1 || n6 == 1) {
                    triggerSqlServer.setExecutionOrder("FIRST");
                } else if (n10 == 1 || n11 == 1 || n9 == 1) {
                    triggerSqlServer.setExecutionOrder("LAST");
                }
                if (n12 == 1) {
                    triggerSqlServer.setEncription("YES");
                } else {
                    triggerSqlServer.setEncription("NO");
                }
                triggerSqlServer.setBody(string4);
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }
}

