/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHandlerSqlServer;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectPlaceHolder;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PermissionsSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHPermissionsSqlServer
extends MOHandlerSqlServer {
    protected static final String OBJECT_TYPE = "PERMISSIONS";
    private static final Logger LOGGER = new Logger(MOHPermissionsSqlServer.class);

    public MOHPermissionsSqlServer(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        StorageDesignSqlServer storageDesignSqlServer = (StorageDesignSqlServer)this.getDesign().getRelationalDesign().getStorageDesign();
        Iterator iterator = storageDesignSqlServer.getDataBaseSet().iterator();
        while (iterator.hasNext()) {
            CharSequence charSequence;
            DataBaseSqlServer dataBaseSqlServer = (DataBaseSqlServer)iterator.next();
            if (dataBaseSqlServer.getName().equalsIgnoreCase("[None]")) continue;
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("USE").append(' ');
                ((StringBuffer)charSequence).append(dataBaseSqlServer.getName()).append(' ');
                ((StringBuffer)charSequence).append("SELECT").append(' ');
                ((StringBuffer)charSequence).append("p.id objectid").append(' ');
                ((StringBuffer)charSequence).append(',').append(' ');
                ((StringBuffer)charSequence).append("o.name objectname").append(' ');
                ((StringBuffer)charSequence).append(',').append(' ');
                ((StringBuffer)charSequence).append("u.name ownername").append(' ');
                ((StringBuffer)charSequence).append(',').append(' ');
                ((StringBuffer)charSequence).append("o.xtype").append(' ');
                ((StringBuffer)charSequence).append(',').append(' ');
                ((StringBuffer)charSequence).append("PERMISSION = ");
                ((StringBuffer)charSequence).append("case p.action ");
                ((StringBuffer)charSequence).append("when 26 then 'REFERENCES' ");
                ((StringBuffer)charSequence).append("when 193 then 'SELECT' ");
                ((StringBuffer)charSequence).append("when 195 then 'INSERT' ");
                ((StringBuffer)charSequence).append("when 196 then 'DELETE' ");
                ((StringBuffer)charSequence).append("when 197 then 'UPDATE' ");
                ((StringBuffer)charSequence).append("when 224 then 'EXECUTE' ");
                ((StringBuffer)charSequence).append("end").append(' ');
                ((StringBuffer)charSequence).append(',').append(' ');
                ((StringBuffer)charSequence).append("WITH_GRAND_OPTION = ");
                ((StringBuffer)charSequence).append("case p.protecttype ");
                ((StringBuffer)charSequence).append("when 204 then 'YES' ");
                ((StringBuffer)charSequence).append("when 205 then 'NO' ");
                ((StringBuffer)charSequence).append("end ").append(' ');
                ((StringBuffer)charSequence).append(',').append(' ');
                ((StringBuffer)charSequence).append("p.columns").append(' ');
                ((StringBuffer)charSequence).append("FROM").append(' ');
                ((StringBuffer)charSequence).append(dataBaseSqlServer).append('.').append("dbo.sysprotects p").append(' ');
                ((StringBuffer)charSequence).append(',').append(' ');
                ((StringBuffer)charSequence).append(dataBaseSqlServer).append('.').append("dbo.sysobjects o").append(' ');
                ((StringBuffer)charSequence).append(',').append(' ');
                ((StringBuffer)charSequence).append(dataBaseSqlServer).append('.').append("dbo.sysusers u").append(' ');
                ((StringBuffer)charSequence).append("WHERE").append(' ');
                ((StringBuffer)charSequence).append("p.protecttype in (204,205)").append(' ');
                ((StringBuffer)charSequence).append("AND").append(' ');
                ((StringBuffer)charSequence).append("p.action in (26,193,195,196,197,224)").append(' ');
                ((StringBuffer)charSequence).append("AND").append(' ');
                ((StringBuffer)charSequence).append("p.uid = 16400").append(' ');
                ((StringBuffer)charSequence).append("AND").append(' ');
                ((StringBuffer)charSequence).append("p.id = o.id").append(' ');
                ((StringBuffer)charSequence).append("AND").append(' ');
                ((StringBuffer)charSequence).append("o.uid = u.uid").append(' ');
                resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHTableSqlServer.initForeignKeys():", sQLException);
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    PermissionsSqlServer permissionsSqlServer;
                    charSequence = resultSet.getString(1);
                    String string = resultSet.getString(2).trim();
                    String string2 = resultSet.getString(3).trim();
                    String string3 = resultSet.getString(4).trim();
                    String string4 = resultSet.getString(5);
                    String string5 = resultSet.getString(6);
                    String string6 = resultSet.getString(7);
                    UserSqlServer userSqlServer = (UserSqlServer)storageDesignSqlServer.getUserSet().getByName(string2);
                    RoleSqlServer roleSqlServer = null;
                    userSqlServer = (UserSqlServer)dataBaseSqlServer.getUsers().getByName(string2);
                    if (userSqlServer == null) {
                        roleSqlServer = (RoleSqlServer)dataBaseSqlServer.getRoles().getByName(string2);
                    }
                    TableProxySqlServer tableProxySqlServer = null;
                    TableViewProxySqlServer tableViewProxySqlServer = null;
                    if (string3.equalsIgnoreCase("U")) {
                        StorageObjectPlaceHolder storageObjectPlaceHolder = (StorageObjectPlaceHolder)dataBaseSqlServer.getTables().getByName(string);
                        if (storageObjectPlaceHolder != null) {
                            tableProxySqlServer = (TableProxySqlServer)storageObjectPlaceHolder.getObject();
                        } else {
                            storageObjectPlaceHolder = (StorageObjectPlaceHolder)dataBaseSqlServer.getViews().getByName(string2);
                            if (storageObjectPlaceHolder != null) {
                                tableViewProxySqlServer = (TableViewProxySqlServer)storageObjectPlaceHolder.getObject();
                            }
                        }
                    }
                    int n = 0;
                    try {
                        n = new Integer(string6);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (userSqlServer != null && tableProxySqlServer != null) {
                        permissionsSqlServer = this.getPermission(storageDesignSqlServer, userSqlServer, tableProxySqlServer);
                        if (permissionsSqlServer == null) {
                            permissionsSqlServer = storageDesignSqlServer.getPermissionsSet().createPermissions();
                            permissionsSqlServer.setUser(userSqlServer);
                            permissionsSqlServer.setTable(tableProxySqlServer);
                        }
                        if ("NO".equalsIgnoreCase(string5)) {
                            permissionsSqlServer.setPrivileges(string4);
                        } else {
                            permissionsSqlServer.setPrivilegesWithGrantOption(string4);
                        }
                        if (n <= 0) continue;
                        this.setColumnPermissions(dataBaseSqlServer.getName(), permissionsSqlServer, (String)charSequence, connection);
                        continue;
                    }
                    if (userSqlServer != null && tableViewProxySqlServer != null) {
                        permissionsSqlServer = this.getPermission(storageDesignSqlServer, userSqlServer, tableViewProxySqlServer);
                        if (permissionsSqlServer == null) {
                            permissionsSqlServer = storageDesignSqlServer.getPermissionsSet().createPermissions();
                            permissionsSqlServer.setUser(userSqlServer);
                            permissionsSqlServer.setView(tableViewProxySqlServer);
                        }
                        if ("NO".equalsIgnoreCase(string5)) {
                            permissionsSqlServer.setPrivileges(string4);
                            continue;
                        }
                        permissionsSqlServer.setPrivilegesWithGrantOption(string4);
                        continue;
                    }
                    if (roleSqlServer != null && tableProxySqlServer != null) {
                        permissionsSqlServer = this.getPermission(storageDesignSqlServer, roleSqlServer, tableProxySqlServer);
                        if (permissionsSqlServer == null) {
                            permissionsSqlServer = storageDesignSqlServer.getPermissionsSet().createPermissions();
                            permissionsSqlServer.setRole(roleSqlServer);
                            permissionsSqlServer.setTable(tableProxySqlServer);
                        }
                        if ("NO".equalsIgnoreCase(string5)) {
                            permissionsSqlServer.setPrivileges(string4);
                            continue;
                        }
                        permissionsSqlServer.setPrivilegesWithGrantOption(string4);
                        continue;
                    }
                    if (roleSqlServer == null || tableViewProxySqlServer == null) continue;
                    permissionsSqlServer = this.getPermission(storageDesignSqlServer, roleSqlServer, tableViewProxySqlServer);
                    if (permissionsSqlServer == null) {
                        permissionsSqlServer = storageDesignSqlServer.getPermissionsSet().createPermissions();
                        permissionsSqlServer.setRole(roleSqlServer);
                        permissionsSqlServer.setView(tableViewProxySqlServer);
                    }
                    if ("NO".equalsIgnoreCase(string5)) {
                        permissionsSqlServer.setPrivileges(string4);
                        continue;
                    }
                    permissionsSqlServer.setPrivilegesWithGrantOption(string4);
                }
            }
            if (statement == null) continue;
            statement.close();
        }
    }

    private void setColumnPermissions(String string, PermissionsSqlServer permissionsSqlServer, String string2, Connection connection) {
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT").append(' ');
            stringBuffer.append("NAME").append(' ');
            stringBuffer.append("FROM").append(' ');
            stringBuffer.append(string).append('.').append("dbo.syscolumns").append(' ');
            stringBuffer.append("WHERE").append(' ');
            stringBuffer.append("ID").append(' ');
            stringBuffer.append('=').append(' ');
            stringBuffer.append(string2).append(' ');
            stringBuffer.append("ORDER BY").append(' ');
            stringBuffer.append("colid").append(' ');
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet != null) {
                while (resultSet.next()) {
                    String string3 = resultSet.getString(1).trim();
                    string3 = string3 + ", ALL PRIVILEGES";
                    permissionsSqlServer.setColumnList(string3);
                }
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHProcedureSqlServer.generate():", sQLException);
        }
    }

    private PermissionsSqlServer getPermission(StorageDesignSqlServer storageDesignSqlServer, StorageObject storageObject, StorageObject storageObject2) {
        Iterator iterator = storageDesignSqlServer.getPermissionsSet().iterator();
        while (iterator.hasNext()) {
            PermissionsSqlServer permissionsSqlServer = (PermissionsSqlServer)iterator.next();
            if (permissionsSqlServer.getUser() != storageObject && permissionsSqlServer.getRole() != storageObject || permissionsSqlServer.getTable() != storageObject2 && permissionsSqlServer.getView() != storageObject2) continue;
            return permissionsSqlServer;
        }
        return null;
    }
}

