/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBObjectSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBUserSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHandlerSqlServer;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.LoginSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHLoginSqlServer
extends MOHandlerSqlServer {
    protected static final String OBJECT_TYPE = "LOGIN";
    private static final Logger LOGGER = new Logger(MOHLoginSqlServer.class);

    public MOHLoginSqlServer(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    protected boolean imported(List list, DBUserSqlServer dBUserSqlServer) {
        int n = list.lastIndexOf(dBUserSqlServer);
        for (int i = 0; i < n; ++i) {
            DBObject dBObject = (DBObject)list.get(i);
            if (!(dBObject instanceof DBUserSqlServer) || !dBObject.isSelected()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        ArrayList<DBObjectSqlServer> arrayList = new ArrayList<DBObjectSqlServer>();
        for (DBObject dBObject : list) {
            CharSequence charSequence;
            if (!dBObject.isSelected() || !(dBObject instanceof DBUserSqlServer) || this.imported(list, (DBUserSqlServer)dBObject)) continue;
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT").append(' ');
                ((StringBuffer)charSequence).append("NAME").append(' ');
                ((StringBuffer)charSequence).append("FROM").append(' ');
                ((StringBuffer)charSequence).append("master.dbo.syslogins").append(' ');
                ((StringBuffer)charSequence).append("WHERE").append(' ');
                ((StringBuffer)charSequence).append("sid").append(' ').append("IS").append(' ').append("NOT").append(' ').append("NULL");
                resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("getLogins(): " + sQLException.getMessage());
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                    DBObjectSqlServer dBObjectSqlServer = new DBObjectSqlServer(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, OBJECT_TYPE, "");
                    arrayList.add(dBObjectSqlServer);
                }
            }
            if (statement == null) continue;
            statement.close();
        }
        return arrayList;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            DBObjectSqlServer dBObjectSqlServer = (DBObjectSqlServer)list.get(i);
            String string = dBObjectSqlServer.getName();
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObjectSqlServer.getType())) continue;
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                object = new StringBuffer();
                ((StringBuffer)object).append("SELECT").append(' ');
                ((StringBuffer)object).append("dbname").append(' ');
                ((StringBuffer)object).append(',').append(' ');
                ((StringBuffer)object).append("LANGUAGE").append(' ');
                ((StringBuffer)object).append(',').append(' ');
                ((StringBuffer)object).append("isntname").append(' ');
                ((StringBuffer)object).append("FROM").append(' ');
                ((StringBuffer)object).append("master.dbo.syslogins").append(' ');
                ((StringBuffer)object).append("WHERE").append(' ');
                ((StringBuffer)object).append("LOGINNAME").append(' ');
                ((StringBuffer)object).append('=').append(' ');
                ((StringBuffer)object).append('\'').append(string).append('\'').append(' ');
                resultSet = statement.executeQuery(((StringBuffer)object).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHLoginSqlServer.generate():", sQLException);
            }
            if (resultSet != null && resultSet.next()) {
                object = this.getStorageDesign();
                if (object != null && object instanceof StorageDesignSqlServer) {
                    StorageDesignSqlServer storageDesignSqlServer = (StorageDesignSqlServer)object;
                    LoginSqlServer loginSqlServer = (LoginSqlServer)storageDesignSqlServer.getLoginSet().getByName(string);
                    if (loginSqlServer == null) {
                        loginSqlServer = storageDesignSqlServer.getLoginSet().createLogin();
                        loginSqlServer.setName(string);
                        this.stampModelObject(loginSqlServer, dBObjectSqlServer);
                    }
                    this.setProperties(loginSqlServer, storageDesignSqlServer, resultSet);
                } else {
                    LOGGER.error("Unable to find Storage Design!");
                }
            }
            if (statement != null) {
                statement.close();
            }
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObjectSqlServer);
        }
    }

    private void setProperties(LoginSqlServer loginSqlServer, StorageDesignSqlServer storageDesignSqlServer, ResultSet resultSet) throws Exception {
        String string = resultSet.getString(1);
        String string2 = resultSet.getString(2);
        int n = resultSet.getInt(3);
        DataBaseSqlServer dataBaseSqlServer = (DataBaseSqlServer)storageDesignSqlServer.getDataBaseSet().getByName(string);
        if (dataBaseSqlServer == null) {
            dataBaseSqlServer = storageDesignSqlServer.getDataBaseSet().createDataBase();
            dataBaseSqlServer.setName(string);
            this.stampModelObject((ModelObject)dataBaseSqlServer, "", string);
        }
        loginSqlServer.setDefaultDatabase(dataBaseSqlServer);
        loginSqlServer.setLanguage(string2);
        if (n == 0) {
            loginSqlServer.setAuthentication(LoginSqlServer.AUTH_CHOICES[1]);
        } else {
            loginSqlServer.setAuthentication(LoginSqlServer.AUTH_CHOICES[0]);
        }
    }
}

