/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.MOHForeignKey;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageObjectPlaceHolder;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FKProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHForeignKeySQLServer
extends MOHForeignKey {
    private static final Logger LOGGER = new Logger(MOHForeignKeySQLServer.class);

    public MOHForeignKeySQLServer(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        StorageDesignSqlServer storageDesignSqlServer = (StorageDesignSqlServer)this.getDesign().getRelationalDesign().getStorageDesign();
        Iterator iterator = storageDesignSqlServer.getDataBaseSet().iterator();
        while (iterator.hasNext()) {
            int n;
            String string;
            Object object;
            Object object2;
            Serializable serializable;
            DataBaseSqlServer dataBaseSqlServer = (DataBaseSqlServer)iterator.next();
            if (dataBaseSqlServer.getName().equalsIgnoreCase("[None]")) continue;
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                serializable = new StringBuffer();
                ((StringBuffer)serializable).append("USE").append(' ');
                ((StringBuffer)serializable).append(dataBaseSqlServer.getName()).append(' ');
                ((StringBuffer)serializable).append("SELECT").append(' ');
                ((StringBuffer)serializable).append("o").append('.');
                ((StringBuffer)serializable).append("ID").append(' ');
                ((StringBuffer)serializable).append(',').append(' ');
                ((StringBuffer)serializable).append("o").append('.');
                ((StringBuffer)serializable).append("NAME").append(' ');
                ((StringBuffer)serializable).append(',').append(' ');
                ((StringBuffer)serializable).append("t").append('.');
                ((StringBuffer)serializable).append("NAME").append(' ');
                ((StringBuffer)serializable).append("tablename").append(' ');
                ((StringBuffer)serializable).append(',').append(' ');
                ((StringBuffer)serializable).append("t").append('.');
                ((StringBuffer)serializable).append("ID").append(' ');
                ((StringBuffer)serializable).append("tableid").append(' ');
                ((StringBuffer)serializable).append(',').append(' ');
                ((StringBuffer)serializable).append("not_for_replication = ObjectProperty(o.id, 'CnstIsNotRepl')").append(' ');
                ((StringBuffer)serializable).append(',').append(' ');
                ((StringBuffer)serializable).append("is_delete_cascade = ObjectProperty(o.id, 'CnstIsDeleteCascade')").append(' ');
                ((StringBuffer)serializable).append(',').append(' ');
                ((StringBuffer)serializable).append("is_upd_cascade = ObjectProperty(o.id, 'CnstIsUpdateCascade')").append(' ');
                ((StringBuffer)serializable).append("FROM").append(' ');
                ((StringBuffer)serializable).append(dataBaseSqlServer).append('.').append("dbo.sysobjects o").append(' ');
                ((StringBuffer)serializable).append(',').append(' ');
                ((StringBuffer)serializable).append(dataBaseSqlServer).append('.').append("dbo.sysobjects t").append(' ');
                ((StringBuffer)serializable).append("WHERE").append(' ');
                ((StringBuffer)serializable).append("o.xtype = 'F'").append(' ');
                ((StringBuffer)serializable).append("AND").append(' ');
                ((StringBuffer)serializable).append("o.parent_obj").append(' ').append('=').append(' ').append("t.id").append(' ');
                resultSet = statement.executeQuery(((StringBuffer)serializable).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHForeignKeySqlServer.initForeignKeys():", sQLException);
            }
            serializable = new ArrayList();
            if (resultSet != null) {
                while (resultSet.next()) {
                    object2 = resultSet.getString(1);
                    object = resultSet.getString(2);
                    string = resultSet.getString(3);
                    int n2 = resultSet.getInt(5);
                    int n3 = resultSet.getInt(6);
                    n = resultSet.getInt(7);
                    Properties properties = new Properties();
                    properties.setProperty("constrId", (String)object2);
                    properties.setProperty("fkName", (String)object);
                    properties.setProperty("tableName", string);
                    properties.setProperty("notForReplication", String.valueOf(n2));
                    properties.setProperty("isDeleteCascade", String.valueOf(n3));
                    properties.setProperty("isUpdateCascade", String.valueOf(n));
                    serializable.add(properties);
                }
            }
            if (statement != null) {
                statement.close();
            }
            object2 = serializable.iterator();
            while (object2.hasNext()) {
                FKIndexAssociation fKIndexAssociation;
                object = (Properties)object2.next();
                string = ((Properties)object).getProperty("constrId");
                String string2 = ((Properties)object).getProperty("fkName");
                String string3 = ((Properties)object).getProperty("tableName");
                n = Integer.parseInt(((Properties)object).getProperty("notForReplication"));
                int n4 = Integer.parseInt(((Properties)object).getProperty("isDeleteCascade"));
                int n5 = Integer.parseInt(((Properties)object).getProperty("isUpdateCascade"));
                Table table = this.getTable(dataBaseSqlServer, string3);
                if (table == null || (fKIndexAssociation = this.initFK(table, string, string2, dataBaseSqlServer, connection)) == null) continue;
                this.initFKColumns(fKIndexAssociation, dataBaseSqlServer.getName(), string, connection);
                if (n4 == 1) {
                    fKIndexAssociation.setDeleteRule("CASCADE");
                }
                fKIndexAssociation.resetMandatoryUsingColumns();
                FKProxySqlServer fKProxySqlServer = (FKProxySqlServer)storageDesignSqlServer.getFKProxySet().getProxy(fKIndexAssociation.getObjectID());
                if (fKProxySqlServer == null) continue;
                if (n5 == 1) {
                    fKProxySqlServer.setOnUpdate("CASCADE");
                }
                if (n != 1) continue;
                fKProxySqlServer.setForReplication("NO");
            }
        }
    }

    private void initFKColumns(FKIndexAssociation fKIndexAssociation, String string, String string2, Connection connection) throws Exception {
        Object object;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            object = new StringBuffer();
            ((StringBuffer)object).append("USE").append(' ');
            ((StringBuffer)object).append(string).append(' ');
            ((StringBuffer)object).append("SELECT").append(' ');
            ((StringBuffer)object).append("column_name").append(' ');
            ((StringBuffer)object).append('=').append(' ');
            ((StringBuffer)object).append("col_name(fkeyid,fkey)").append(' ');
            ((StringBuffer)object).append(',').append(' ');
            ((StringBuffer)object).append("refcol_name").append(' ');
            ((StringBuffer)object).append('=').append(' ');
            ((StringBuffer)object).append("col_name(rkeyid,rkey)").append(' ');
            ((StringBuffer)object).append(',').append(' ');
            ((StringBuffer)object).append("keyno").append(' ');
            ((StringBuffer)object).append("FROM").append(' ');
            ((StringBuffer)object).append(string).append('.').append("dbo.sysforeignkeys").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ');
            ((StringBuffer)object).append("constid").append(' ').append('=').append(' ').append(string2).append(' ');
            ((StringBuffer)object).append("ORDER BY").append(' ');
            ((StringBuffer)object).append("keyno").append(' ');
            resultSet = statement.executeQuery(((StringBuffer)object).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHForeignKeySQLServer.initForeignKeys():", sQLException);
        }
        if (resultSet != null) {
            object = fKIndexAssociation.getTable();
            Table table = fKIndexAssociation.getRemoteTable();
            while (resultSet.next()) {
                String string3 = resultSet.getString(1);
                String string4 = resultSet.getString(2);
                Column column = (Column)((ContainerObject)object).getElementByName(string3);
                Column column2 = (Column)table.getElementByName(string4);
                if (column == null || column2 == null) continue;
                column.addFKAssociation(column2, fKIndexAssociation);
                fKIndexAssociation.getLocalFKIndex().add(column);
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    private FKIndexAssociation initFK(Table table, String string, String string2, DataBaseSqlServer dataBaseSqlServer, Connection connection) throws Exception {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("USE").append(' ');
            ((StringBuffer)charSequence).append(dataBaseSqlServer.getName()).append(' ');
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append("rtrim(user_name(ObjectProperty(rkeyid,'ownerid'))) reftab_owner_name").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("object_name(rkeyid) reftab_name").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("key_name = (select name from ");
            ((StringBuffer)charSequence).append(dataBaseSqlServer).append('.').append("dbo.sysindexes").append(' ');
            ((StringBuffer)charSequence).append("where id = rkeyid and indid = rkeyindid)").append(' ');
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append(dataBaseSqlServer).append('.').append("dbo.sysreferences").append(' ');
            ((StringBuffer)charSequence).append("WHERE").append(' ');
            ((StringBuffer)charSequence).append("constid").append(' ').append('=').append(' ').append(string).append(' ');
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHForeignKeySQLServer.initForeignKeys():", sQLException);
        }
        if (resultSet != null && resultSet.next()) {
            charSequence = resultSet.getString(2);
            String string3 = resultSet.getString(3);
            Table table2 = (Table)this.getDesign().getRelationalDesign().getTableSet().getByName((String)charSequence);
            if (table2 != null) {
                DesignObject designObject;
                FKIndexAssociation[] fKIndexAssociationArray = table.getFKIndexAssociationsWith(table2);
                for (int i = 0; i < fKIndexAssociationArray.length; ++i) {
                    designObject = fKIndexAssociationArray[i];
                    if (!designObject.getName().equalsIgnoreCase(string2)) continue;
                    if (statement != null) {
                        statement.close();
                    }
                    return null;
                }
                ContainerObjectPlaceHolder containerObjectPlaceHolder = (ContainerObjectPlaceHolder)table2.getPKeys().getByName(string3);
                designObject = null;
                if (containerObjectPlaceHolder != null && (designObject = (Index)containerObjectPlaceHolder.getObject()) == null) {
                    containerObjectPlaceHolder = (ContainerObjectPlaceHolder)table2.getUKeys().getByName(string3);
                    designObject = (Index)containerObjectPlaceHolder.getObject();
                }
                if (designObject != null) {
                    FKIndexAssociation fKIndexAssociation = table.addFK((KeyObject)designObject);
                    if (string2 != null) {
                        fKIndexAssociation.setName(string2);
                        fKIndexAssociation.getLocalFKIndex().setName(string2);
                        this.stampModelObject((ModelObject)fKIndexAssociation, table.getSchema(), string2);
                        if (statement != null) {
                            statement.close();
                        }
                        return fKIndexAssociation;
                    }
                }
            }
        }
        if (statement != null) {
            statement.close();
        }
        return null;
    }

    private Table getTable(DataBaseSqlServer dataBaseSqlServer, String string) {
        Iterator iterator = dataBaseSqlServer.getTables().iterator();
        while (iterator.hasNext()) {
            StorageObjectPlaceHolder storageObjectPlaceHolder = (StorageObjectPlaceHolder)iterator.next();
            TableProxySqlServer tableProxySqlServer = (TableProxySqlServer)storageObjectPlaceHolder.getObject();
            if (!tableProxySqlServer.getName().equals(string)) continue;
            return (Table)tableProxySqlServer.getObject();
        }
        return null;
    }
}

