/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBObjectSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBUserSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHandlerSqlServer;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DefaultSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.LoginSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHDefaultSqlServer
extends MOHandlerSqlServer {
    protected static final String OBJECT_TYPE = "DEFAULT";
    private static final Logger LOGGER = new Logger(MOHDefaultSqlServer.class);

    public MOHDefaultSqlServer(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            DBObjectSqlServer dBObjectSqlServer = (DBObjectSqlServer)list.get(i);
            String string = dBObjectSqlServer.getName();
            String string2 = dBObjectSqlServer.getDb();
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObjectSqlServer.getType())) continue;
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                object = new StringBuffer();
                ((StringBuffer)object).append("USE").append(' ');
                ((StringBuffer)object).append(string2).append(' ').append("\n");
                ((StringBuffer)object).append(';').append("\n").append("\n");
                ((StringBuffer)object).append("SELECT").append(' ');
                ((StringBuffer)object).append("u").append('.');
                ((StringBuffer)object).append("NAME").append(' ');
                ((StringBuffer)object).append(',').append(' ');
                ((StringBuffer)object).append("c").append('.');
                ((StringBuffer)object).append("TEXT").append(' ');
                ((StringBuffer)object).append(',').append(' ');
                ((StringBuffer)object).append("s").append('.');
                ((StringBuffer)object).append("ID").append(' ');
                ((StringBuffer)object).append("FROM").append(' ');
                ((StringBuffer)object).append(string2).append('.').append("dbo.sysobjects s").append(' ');
                ((StringBuffer)object).append(',').append(' ');
                ((StringBuffer)object).append(string2).append('.').append("dbo.sysusers u").append(' ');
                ((StringBuffer)object).append(',').append(' ');
                ((StringBuffer)object).append(string2).append('.').append("dbo.syscomments c").append(' ');
                ((StringBuffer)object).append("WHERE").append(' ');
                ((StringBuffer)object).append("XTYPE").append(' ');
                ((StringBuffer)object).append('=').append(' ');
                ((StringBuffer)object).append('\'').append("D").append('\'').append(' ');
                ((StringBuffer)object).append("AND").append(' ');
                ((StringBuffer)object).append(1).append(' ').append('=').append(' ');
                ((StringBuffer)object).append('(').append(' ');
                ((StringBuffer)object).append("SELECT").append(' ');
                ((StringBuffer)object).append("OBJECTPROPERTY").append(' ');
                ((StringBuffer)object).append('(').append(' ');
                ((StringBuffer)object).append("s.id ,'IsDefault'").append(' ');
                ((StringBuffer)object).append(')').append(' ');
                ((StringBuffer)object).append(')').append(' ');
                ((StringBuffer)object).append("AND").append(' ');
                ((StringBuffer)object).append("s").append('.').append("NAME").append(' ');
                ((StringBuffer)object).append('=').append(' ');
                ((StringBuffer)object).append('\'').append(string).append('\'').append(' ');
                ((StringBuffer)object).append("AND").append(' ');
                ((StringBuffer)object).append("s").append('.').append("UID").append(' ');
                ((StringBuffer)object).append('=').append(' ');
                ((StringBuffer)object).append("u").append('.').append("UID").append(' ');
                ((StringBuffer)object).append("AND").append(' ');
                ((StringBuffer)object).append("c").append('.').append("ID").append(' ');
                ((StringBuffer)object).append('=').append(' ');
                ((StringBuffer)object).append("s").append('.').append("ID").append(' ');
                resultSet = statement.executeQuery(((StringBuffer)object).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHDefaultSqlServer.generate():", sQLException);
            }
            if (resultSet != null && resultSet.next()) {
                object = this.getStorageDesign();
                if (object != null && object instanceof StorageDesignSqlServer) {
                    StorageDesignSqlServer storageDesignSqlServer = (StorageDesignSqlServer)object;
                    DataBaseSqlServer dataBaseSqlServer = (DataBaseSqlServer)storageDesignSqlServer.getDataBaseSet().getByName(string2);
                    if (dataBaseSqlServer == null) {
                        dataBaseSqlServer = storageDesignSqlServer.getDataBaseSet().createDataBase();
                        dataBaseSqlServer.setName(string2);
                        this.stampModelObject((ModelObject)dataBaseSqlServer, "", string2);
                    }
                    DefaultSqlServer defaultSqlServer = storageDesignSqlServer.getDefaultSet().createDefault();
                    defaultSqlServer.setName(string);
                    this.stampModelObject(defaultSqlServer, dBObjectSqlServer);
                    String string3 = resultSet.getString(1);
                    String string4 = resultSet.getString(2);
                    String string5 = resultSet.getString(3);
                    defaultSqlServer.setDataBase(dataBaseSqlServer);
                    this.setUser(defaultSqlServer, storageDesignSqlServer, string3, string2, connection);
                    this.setText(defaultSqlServer, string4);
                    this.bindColumns(defaultSqlServer, storageDesignSqlServer, string5, string2, connection);
                } else {
                    LOGGER.error("Unable to find Storage Design!");
                }
            }
            if (statement != null) {
                statement.close();
            }
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObjectSqlServer);
        }
    }

    private void setUser(DefaultSqlServer defaultSqlServer, StorageDesignSqlServer storageDesignSqlServer, String string, String string2, Connection connection) {
        String string3;
        UserSqlServer userSqlServer = (UserSqlServer)storageDesignSqlServer.getUserSet().getByName(string);
        if (userSqlServer == null) {
            userSqlServer = storageDesignSqlServer.getUserSet().createUser();
            userSqlServer.setName(string);
            userSqlServer.setDatabase(defaultSqlServer.getDataBase());
            this.stampModelObject((ModelObject)userSqlServer, string2, string);
        }
        if ((string3 = this.getLogin(string, string2, connection)) != null) {
            LoginSqlServer loginSqlServer = (LoginSqlServer)storageDesignSqlServer.getLoginSet().getByName(string3);
            if (loginSqlServer == null) {
                loginSqlServer = storageDesignSqlServer.getLoginSet().createLogin();
                loginSqlServer.setName(string3);
                this.stampModelObject((ModelObject)loginSqlServer, defaultSqlServer, string3);
            }
            userSqlServer.setLogin(loginSqlServer);
            loginSqlServer.setUsers(string);
        }
        defaultSqlServer.setOwner(userSqlServer);
    }

    private String getLogin(String string, String string2, Connection connection) {
        String string3 = null;
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT").append(' ');
            stringBuffer.append("l.loginname").append(' ');
            stringBuffer.append("FROM").append(' ');
            stringBuffer.append("master.dbo.syslogins l").append(' ');
            stringBuffer.append(',').append(' ');
            stringBuffer.append(string2).append('.').append("dbo.sysusers u").append(' ');
            stringBuffer.append("WHERE").append(' ');
            stringBuffer.append("l").append('.').append("sid").append(' ');
            stringBuffer.append('=').append(' ');
            stringBuffer.append("u").append('.').append("sid").append(' ');
            stringBuffer.append("AND").append(' ');
            stringBuffer.append("u").append('.').append("NAME").append(' ');
            stringBuffer.append('=').append(' ').append('\'');
            stringBuffer.append(string).append('\'').append(' ');
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet != null && resultSet.next()) {
                string3 = resultSet.getString(1);
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHDefaultSqlServer.getLogin():", sQLException);
        }
        return string3;
    }

    private void bindColumns(DefaultSqlServer defaultSqlServer, StorageDesignSqlServer storageDesignSqlServer, String string, String string2, Connection connection) {
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT").append(' ');
            stringBuffer.append("col.name columnname").append(' ');
            stringBuffer.append(',').append(' ');
            stringBuffer.append("obj.name tablename").append(' ');
            stringBuffer.append("FROM").append(' ');
            stringBuffer.append(string2).append('.').append("dbo.syscolumns col").append(' ');
            stringBuffer.append(',').append(' ');
            stringBuffer.append(string2).append('.').append("dbo.sysobjects obj").append(' ');
            stringBuffer.append("WHERE").append(' ');
            stringBuffer.append("col.cdefault").append(' ');
            stringBuffer.append('=').append(' ');
            stringBuffer.append(string).append(' ');
            stringBuffer.append("AND").append(' ');
            stringBuffer.append("col").append('.').append("ID").append(' ');
            stringBuffer.append('=').append(' ');
            stringBuffer.append("obj").append('.').append("ID").append(' ');
            resultSet = statement.executeQuery(stringBuffer.toString());
            TableProxySetSqlServer tableProxySetSqlServer = (TableProxySetSqlServer)storageDesignSqlServer.getTableProxySet();
            if (resultSet != null) {
                while (resultSet.next()) {
                    ColumnProxySqlServer columnProxySqlServer;
                    String string3 = resultSet.getString(1);
                    String string4 = resultSet.getString(2);
                    TableProxySqlServer tableProxySqlServer = tableProxySetSqlServer.getByName(string4);
                    if (tableProxySqlServer == null || (columnProxySqlServer = (ColumnProxySqlServer)tableProxySqlServer.getColumnProxyByName(string3)) == null) continue;
                    columnProxySqlServer.setDefineDefault(true);
                    columnProxySqlServer.setDefaultObject(defaultSqlServer);
                }
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHRuleSqlServer.bindColumns():", sQLException);
        }
    }

    private void setText(DefaultSqlServer defaultSqlServer, String string) throws Exception {
        String string2 = Token.getStringAfterToken(string, "AS");
        string2 = Token.getValBetweenQuotes(string2);
        defaultSqlServer.setConstant(string2.trim());
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        ArrayList arrayList = new ArrayList();
        for (DBObject dBObject : list) {
            if (!dBObject.isSelected() || !(dBObject instanceof DBUserSqlServer)) continue;
            DBUserSqlServer dBUserSqlServer = (DBUserSqlServer)dBObject;
            arrayList.addAll(this.extractByUser(connection, dBUserSqlServer));
        }
        return arrayList;
    }

    private List extractByUser(Connection connection, DBUserSqlServer dBUserSqlServer) throws Exception {
        CharSequence charSequence;
        ArrayList<DBObjectSqlServer> arrayList = new ArrayList<DBObjectSqlServer>();
        String string = dBUserSqlServer.getDb();
        String string2 = dBUserSqlServer.getUid();
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("USE").append(' ');
            ((StringBuffer)charSequence).append(string).append(' ').append("\n");
            ((StringBuffer)charSequence).append(';').append("\n").append("\n");
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append("NAME").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("ID").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("UID").append(' ');
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append(string).append('.').append("dbo.sysobjects s").append(' ');
            ((StringBuffer)charSequence).append("WHERE").append(' ');
            ((StringBuffer)charSequence).append("XTYPE").append(' ');
            ((StringBuffer)charSequence).append('=').append(' ');
            ((StringBuffer)charSequence).append('\'').append("D").append('\'').append(' ');
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append(1).append(' ');
            ((StringBuffer)charSequence).append('=').append(' ');
            ((StringBuffer)charSequence).append('(').append(' ');
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append("OBJECTPROPERTY ( s.id ,'IsDefault')").append(' ');
            ((StringBuffer)charSequence).append(')').append(' ');
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("UID").append(' ');
            ((StringBuffer)charSequence).append('=').append(' ');
            ((StringBuffer)charSequence).append(string2);
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHDefaultSqlServer.extract():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                DBObjectSqlServer dBObjectSqlServer = new DBObjectSqlServer(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, OBJECT_TYPE, dBUserSqlServer.getSchema());
                dBObjectSqlServer.setDb(string);
                arrayList.add(dBObjectSqlServer);
            }
        }
        if (statement != null) {
            statement.close();
        }
        return arrayList;
    }
}

