/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle.v9i;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.datatypes.AbstractDTObject;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.CollectionTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHTypeIncompleteOraclev9i
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "OBJECT";
    private Map selectedTypes = new TreeMap();
    private Map allTypes;
    private static List types;
    private static final Logger LOGGER;
    protected boolean dbaUser;
    PreparedStatement supert_statement = null;
    PreparedStatement attr_statement = null;
    PreparedStatement par_statement = null;
    PreparedStatement result_statement = null;
    PreparedStatement elem_statement = null;

    public MOHTypeIncompleteOraclev9i(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
        this.dbaUser = false;
    }

    public MOHTypeIncompleteOraclev9i(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView, boolean bl) {
        super(abstractDBMExtractionHandler, applicationView);
        this.dbaUser = bl;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        Statement statement = null;
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        if (types == null) {
            types = new ArrayList();
        } else {
            types.clear();
        }
        if (this.allTypes == null) {
            this.allTypes = new TreeMap();
        } else {
            this.allTypes.clear();
        }
        for (DBObject dBObject : list) {
            String string;
            Object object;
            if (!dBObject.isSelected()) continue;
            String string2 = dBObject.getName();
            if (statement == null) {
                object = new StringBuffer();
                ((StringBuffer)object).append("SELECT").append(' ').append("TYPE_NAME").append(',').append(' ');
                ((StringBuffer)object).append("TYPECODE").append(',').append(' ');
                ((StringBuffer)object).append("SUPERTYPE_OWNER").append(',').append(' ');
                ((StringBuffer)object).append("SUPERTYPE_NAME").append(',').append(' ');
                ((StringBuffer)object).append("FINAL").append(',').append(' ');
                ((StringBuffer)object).append("INSTANTIABLE").append(',').append(" LOCAL_ATTRIBUTES, LOCAL_METHODS ");
                ((StringBuffer)object).append("FROM").append(' ').append(this.dbaUser ? "dba_types" : "all_types").append(' ');
                ((StringBuffer)object).append("WHERE").append(' ').append("PREDEFINED").append(' ').append('=').append(' ');
                ((StringBuffer)object).append('\'').append("NO").append('\'').append(' ');
                ((StringBuffer)object).append("AND").append(' ').append("OWNER").append(' ').append('=').append(' ').append('?').append(' ');
                string = ((StringBuffer)object).toString();
                statement = connection.prepareStatement(string);
            }
            object = null;
            try {
                statement.setString(1, dBObject.getName());
                object = statement.executeQuery();
            }
            catch (Exception exception) {
                LOGGER.error("MOHTypeIncompleteOraclev9i.extract():", exception);
            }
            if (object == null) continue;
            while (object.next()) {
                AbstractDTObject abstractDTObject;
                DBObject dBObject2;
                string = object.getString(1);
                String string3 = object.getString("TYPECODE");
                String string4 = object.getString(3);
                String string5 = object.getString(4);
                String string6 = object.getString(5);
                String string7 = object.getString(6);
                int n = object.getInt(7);
                int n2 = object.getInt(8);
                if (string3.equalsIgnoreCase("COLLECTION")) {
                    dBObject2 = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), string, "COLLECTION", string2);
                    arrayList.add(dBObject2);
                    abstractDTObject = (CollectionType)this.getDesign().getDataTypesDesign().getCollectionTypeSet().getByName(string);
                    if (abstractDTObject == null) continue;
                    dBObject2.setStatus("Type name exist");
                    dBObject2.setSelected(false);
                    continue;
                }
                dBObject2 = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), string, OBJECT_TYPE, string2);
                dBObject2.setSuperTypeOwner(string4);
                dBObject2.setSuperTypeName(string5);
                if (string6.equalsIgnoreCase("YES")) {
                    dBObject2.setFinal(true);
                }
                if (string7.equalsIgnoreCase("NO")) {
                    dBObject2.setInstantiable(false);
                }
                dBObject2.setLocalAttributes(n);
                dBObject2.setLocalMethods(n2);
                abstractDTObject = (StructuredType)this.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(string);
                if (abstractDTObject != null) {
                    dBObject2.setStatus("Type name exist");
                    dBObject2.setSelected(false);
                }
                arrayList.add(dBObject2);
                this.allTypes.put(dBObject2.toString(), dBObject2);
            }
            object.close();
        }
        if (statement != null) {
            statement.close();
        }
        types.clear();
        return arrayList;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        Object object;
        Object object2;
        int n;
        TimeLog.log("Type Incomplete begin");
        this.supert_statement = null;
        this.attr_statement = null;
        this.par_statement = null;
        this.result_statement = null;
        this.elem_statement = null;
        StorageDesign storageDesign = this.getStorageDesign();
        StorageDesignOracle storageDesignOracle = null;
        TreeMap treeMap = new TreeMap();
        this.selectedTypes = new TreeMap();
        if (types == null) {
            types = new ArrayList();
        } else {
            types.clear();
        }
        if (this.allTypes == null) {
            this.allTypes = new TreeMap();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n = 0; n < list.size(); ++n) {
            object2 = (DBObject)list.get(n);
            if (OBJECT_TYPE.equalsIgnoreCase(((DBObject)object2).getType()) || "COLLECTION".equalsIgnoreCase(((DBObject)object2).getType())) {
                types.add(object2);
                this.selectedTypes.put(((DBObject)object2).toString(), object2);
            }
            if (!"TABLE".equalsIgnoreCase(((DBObject)object2).getType()) && !"VIEW".equalsIgnoreCase(((DBObject)object2).getType())) continue;
            if ("XMLTYPE".equalsIgnoreCase(((DBObject)object2).getTypeCode())) {
                ((DBObject)object2).setTypeCode(OBJECT_TYPE);
            }
            if ("TABLE".equalsIgnoreCase(((DBObject)object2).getType()) || "VIEW".equalsIgnoreCase(((DBObject)object2).getType())) {
                this.addAdditionalType(treeMap, (DBObject)object2);
            }
            if (((DBObject)object2).getTypeCode() == null || !OBJECT_TYPE.equalsIgnoreCase(((DBObject)object2).getTypeCode()) && !"XMLTYPE".equalsIgnoreCase(((DBObject)object2).getTypeCode()) && !"COLLECTION".equalsIgnoreCase(((DBObject)object2).getTypeCode())) continue;
            arrayList.add(object2);
        }
        TimeLog.log("Step 1 end");
        this.generateAdditionalColumnTypes(connection, treeMap);
        TimeLog.log("Step 2 end");
        for (n = 0; n < arrayList.size(); ++n) {
            object2 = (DBObject)arrayList.get(n);
            DBObject dBObject = new DBObject(true, ((DBObject)object2).getTypeName(), ((DBObject)object2).getTypeCode(), ((DBObject)object2).getTypeOwner());
            dBObject.setSuperTypeOwner(((DBObject)object2).getSuperTypeOwner());
            dBObject.setSuperTypeName(((DBObject)object2).getSuperTypeName());
            object = dBObject.toString();
            if (this.selectedTypes.containsKey(object)) continue;
            Object v = this.allTypes.get(object);
            if (v != null) {
                dBObject = (DBObject)v;
            }
            types.add(dBObject);
            this.selectedTypes.put(dBObject.toString(), dBObject);
        }
        List list2 = this.getNotProcessed1000(types, OBJECT_TYPE);
        if (list2.size() == 0) {
            list2 = this.getNotProcessed1000(types, "COLLECTION");
        }
        object2 = new TreeMap();
        while (list2.size() > 0) {
            object2.clear();
            this.addAdditionalTypes((Map)object2, list2, OBJECT_TYPE);
            if (!object2.isEmpty()) {
                TimeLog.log("Struct_types begin " + list2.size());
                this.addSuperTypesMulti((Map)object2, connection, list2);
                TimeLog.log(" Super types END ");
                object2.clear();
                this.addAdditionalTypesWithAttributes((Map)object2, list2, OBJECT_TYPE);
                this.getAttributeTypeMulti((Map)object2, connection);
                object2.clear();
                this.addAdditionalTypesWithMethods((Map)object2, list2, OBJECT_TYPE);
                this.getParameterTypesMulti((Map)object2, connection);
                this.getMethodResultTypesMulti((Map)object2, connection);
                this.markProcessed(list2);
                TimeLog.log("Struct_types end ");
            }
            object2.clear();
            list2 = this.getNotProcessed1000(types, "COLLECTION");
            this.addAdditionalTypes((Map)object2, list2, "COLLECTION");
            if (!object2.isEmpty()) {
                TimeLog.log("Collections begin " + list2.size());
                this.getCollectionElementTypesMulti((Map)object2, connection);
                this.markProcessed(list2);
                TimeLog.log("Collections end ");
            }
            if ((list2 = this.getNotProcessed1000(types, OBJECT_TYPE)).size() != 0) continue;
            list2 = this.getNotProcessed1000(types, "COLLECTION");
        }
        TimeLog.log("Step 3 end");
        if (storageDesign != null && storageDesign instanceof StorageDesignOracle) {
            storageDesignOracle = (StorageDesignOracle)storageDesign;
        }
        for (int i = 0; i < types.size(); ++i) {
            object = (DBObject)types.get(i);
            if (OBJECT_TYPE.equalsIgnoreCase(((DBObject)object).getType()) && this.createStructuredType(storageDesignOracle, (DBObject)object) && list.contains(object)) {
                importLogger.incrementImportedStatements();
                this.addToHandledObjects((DBObject)object);
            }
            if (!"COLLECTION".equalsIgnoreCase(((DBObject)object).getType()) || !this.createCollectionType(storageDesignOracle, (DBObject)object) || !list.contains(object)) continue;
            importLogger.incrementImportedStatements();
            this.addToHandledObjects((DBObject)object);
        }
        if (this.supert_statement != null) {
            this.supert_statement.close();
        }
        if (this.attr_statement != null) {
            this.attr_statement.close();
        }
        if (this.par_statement != null) {
            this.par_statement.close();
        }
        if (this.result_statement != null) {
            this.result_statement.close();
        }
        if (this.elem_statement != null) {
            this.elem_statement.close();
        }
        this.allTypes.clear();
        this.selectedTypes.clear();
        TimeLog.log("Type Incomplete end");
    }

    private void generateAdditionalColumnTypes(Connection connection, Map map) throws SQLException {
        for (String string : map.keySet()) {
            CharSequence charSequence;
            List list = (List)map.get(string);
            Statement statement = null;
            int n = list.size();
            if (n > 1000) {
                n = 1000;
            }
            ResultSet resultSet = null;
            try {
                int n2;
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("with cols as (select /*+ materialize */ distinct owner,DATA_TYPE_OWNER,DATA_TYPE ");
                if (this.dbaUser) {
                    ((StringBuffer)charSequence).append("from dba_tab_columns ");
                } else {
                    ((StringBuffer)charSequence).append("from all_tab_columns ");
                }
                ((StringBuffer)charSequence).append("where DATA_TYPE_OWNER is not null and owner = ").append('?').append(' ').append("AND");
                ((StringBuffer)charSequence).append(" table_name in ").append('(').append('?');
                for (n2 = 1; n2 < n; ++n2) {
                    ((StringBuffer)charSequence).append(',').append('?');
                }
                ((StringBuffer)charSequence).append(')').append(')');
                ((StringBuffer)charSequence).append(" select distinct b.TYPE_NAME, b.OWNER, b.typecode, b.SUPERTYPE_OWNER, b.SUPERTYPE_NAME, b.LOCAL_ATTRIBUTES, b.LOCAL_METHODS  ");
                if (this.dbaUser) {
                    ((StringBuffer)charSequence).append("from dba_types b ");
                } else {
                    ((StringBuffer)charSequence).append("from all_types b ");
                }
                ((StringBuffer)charSequence).append("where exists( select 1 from cols where b.owner = cols.DATA_TYPE_OWNER and b.TYPE_NAME = cols.DATA_TYPE ) ");
                ((StringBuffer)charSequence).append("and b.predefined = 'NO'");
                statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
                statement.setString(1, string);
                for (n2 = 0; n2 < n; ++n2) {
                    statement.setString(n2 + 2, (String)list.get(n2));
                }
                resultSet = statement.executeQuery();
            }
            catch (Exception exception) {
                LOGGER.error("MOHTypeIncompleteOraclev9i.generateAdditionalColumnTypes():", exception);
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                    String string2 = resultSet.getString(2);
                    String string3 = resultSet.getString(3);
                    String string4 = resultSet.getString(4);
                    String string5 = resultSet.getString(5);
                    int n3 = resultSet.getInt(6);
                    int n4 = resultSet.getInt(7);
                    DBObject dBObject = new DBObject(true, (String)charSequence, string3, string2);
                    dBObject.setSuperTypeOwner(string4);
                    dBObject.setSuperTypeName(string5);
                    dBObject.setLocalAttributes(n3);
                    dBObject.setLocalMethods(n4);
                    String string6 = dBObject.toString();
                    if (this.selectedTypes.containsKey(string6)) continue;
                    Object v = this.allTypes.get(string6);
                    if (v != null) {
                        dBObject = (DBObject)v;
                    }
                    types.add(dBObject);
                    this.selectedTypes.put(dBObject.toString(), dBObject);
                }
                resultSet.close();
            }
            if (statement == null) continue;
            statement.close();
        }
    }

    private void getAttributeType(Connection connection, DBObject dBObject) throws SQLException {
        String string;
        Object object;
        if (this.attr_statement == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ').append("DISTINCT").append(' ');
            ((StringBuffer)object).append("b.").append("TYPE_NAME").append(',').append(' ');
            ((StringBuffer)object).append("b.").append("OWNER").append(',').append(' ');
            ((StringBuffer)object).append("b.").append("TYPECODE").append(',').append(' ');
            ((StringBuffer)object).append("b.").append("SUPERTYPE_OWNER").append(',').append(' ');
            ((StringBuffer)object).append("b.").append("SUPERTYPE_NAME").append(',').append(" b.LOCAL_ATTRIBUTES, b.LOCAL_METHODS ");
            ((StringBuffer)object).append("FROM").append(' ').append(this.dbaUser ? "dba_type_attrs" : "all_type_attrs").append(' ').append("a").append(',').append(' ');
            ((StringBuffer)object).append(this.dbaUser ? "dba_types" : "all_types").append(' ').append("b").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ').append("a.").append("OWNER").append(' ').append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object).append("AND").append(' ').append("a.").append("TYPE_NAME").append(' ').append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object).append("AND").append(' ').append("a.").append("ATTR_TYPE_NAME").append(' ').append('=').append(' ').append("b.").append("TYPE_NAME").append(' ');
            ((StringBuffer)object).append("AND").append(' ').append("a.").append("ATTR_TYPE_OWNER").append(' ').append('=').append(' ').append("b.").append("OWNER");
            string = ((StringBuffer)object).toString();
            this.attr_statement = connection.prepareStatement(string);
        }
        object = null;
        try {
            this.attr_statement.setString(1, dBObject.getSchema());
            this.attr_statement.setString(2, dBObject.getName());
            object = this.attr_statement.executeQuery();
        }
        catch (Exception exception) {
            LOGGER.error("MOHTypeIncompleteOraclev9i.getAttributeType():", exception);
        }
        if (object != null) {
            while (object.next()) {
                Object object2;
                string = object.getString(1);
                String string2 = object.getString(2);
                String string3 = object.getString(3);
                String string4 = object.getString(4);
                String string5 = object.getString(5);
                int n = object.getInt(6);
                int n2 = object.getInt(7);
                DBObject dBObject2 = new DBObject(true, string, string3, string2);
                dBObject2.setSuperTypeOwner(string4);
                dBObject2.setSuperTypeName(string5);
                dBObject2.setLocalAttributes(n);
                dBObject2.setLocalMethods(n2);
                String string6 = dBObject2.toString();
                if (!this.selectedTypes.containsKey(string6)) {
                    object2 = this.allTypes.get(string6);
                    if (object2 != null) {
                        dBObject2 = (DBObject)object2;
                    }
                    types.add(dBObject2);
                    this.selectedTypes.put(dBObject2.toString(), dBObject2);
                }
                if (string5 == null || string5.equals("") || this.selectedTypes.containsKey(string6 = ((DBObject)(object2 = new DBObject(true, string5, string3, string4))).toString())) continue;
                Object v = this.allTypes.get(string6);
                if (v != null) {
                    object2 = (DBObject)v;
                }
                types.add(object2);
                this.selectedTypes.put(((DBObject)object2).toString(), object2);
            }
            object.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getParameterTypesMulti(Map map, Connection connection) throws SQLException {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            for (String string : map.keySet()) {
                String string2 = (String)map.get(string);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("SELECT").append(' ').append("DISTINCT").append(' ');
                stringBuffer.append("b.").append("TYPE_NAME").append(',').append(' ');
                stringBuffer.append("b.").append("OWNER").append(',').append(' ');
                stringBuffer.append("b.").append("TYPECODE").append(',').append(' ');
                stringBuffer.append("b.").append("SUPERTYPE_OWNER").append(',').append(' ');
                stringBuffer.append("b.").append("SUPERTYPE_NAME").append(", b.LOCAL_ATTRIBUTES, b.LOCAL_METHODS ");
                stringBuffer.append("FROM").append(' ').append(this.dbaUser ? "dba_method_params" : "all_method_params").append(' ').append("a").append(',').append(' ');
                stringBuffer.append(this.dbaUser ? "dba_types" : "all_types").append(' ').append("b").append(' ');
                stringBuffer.append("WHERE").append(' ').append("a.").append("OWNER").append(' ').append('=').append(' ').append("'" + string + "'").append(' ');
                stringBuffer.append("AND").append(' ').append("a.").append("TYPE_NAME").append(' ').append(" in (" + string2 + ")").append(' ');
                stringBuffer.append("AND").append(" a.PARAM_TYPE_OWNER is not null AND ").append("a.").append("PARAM_TYPE_NAME").append(' ').append('=').append(' ').append("b.").append("TYPE_NAME").append(' ');
                stringBuffer.append("AND").append(' ').append("a.").append("PARAM_TYPE_OWNER").append(' ').append('=').append(' ').append("b.").append("OWNER").append(' ');
                stringBuffer.append("AND").append(' ').append("b.").append("PREDEFINED").append(' ').append('=').append(' ');
                stringBuffer.append('\'').append("NO").append('\'').append(' ');
                stringBuffer.append("AND").append(' ').append("a.").append("PARAM_TYPE_OWNER").append(' ').append("IS").append(' ').append("NOT").append(' ').append("NULL");
                String string3 = stringBuffer.toString();
                ResultSet resultSet = null;
                try {
                    resultSet = statement.executeQuery(string3);
                }
                catch (Exception exception) {
                    LOGGER.error("MOHTypeIncompleteOraclev9i.getParameterType():", exception);
                }
                if (resultSet == null) continue;
                while (resultSet.next()) {
                    Object object;
                    String string4 = resultSet.getString(1);
                    String string5 = resultSet.getString(2);
                    String string6 = resultSet.getString(3);
                    String string7 = resultSet.getString(4);
                    String string8 = resultSet.getString(5);
                    int n = resultSet.getInt(6);
                    int n2 = resultSet.getInt(7);
                    DBObject dBObject = new DBObject(true, string4, string6, string5);
                    dBObject.setSuperTypeOwner(string7);
                    dBObject.setSuperTypeName(string8);
                    dBObject.setLocalAttributes(n);
                    dBObject.setLocalMethods(n2);
                    String string9 = dBObject.toString();
                    if (!this.selectedTypes.containsKey(string9)) {
                        object = this.allTypes.get(string9);
                        if (object != null) {
                            dBObject = (DBObject)object;
                        }
                        types.add(dBObject);
                        this.selectedTypes.put(dBObject.toString(), dBObject);
                    }
                    if (string8 == null || string8.equals("") || this.selectedTypes.containsKey(((DBObject)(object = new DBObject(true, string8, string6, string7))).toString())) continue;
                    types.add(object);
                    this.selectedTypes.put(((DBObject)object).toString(), object);
                }
                resultSet.close();
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getMethodResultTypesMulti(Map map, Connection connection) throws SQLException {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            for (String string : map.keySet()) {
                String string2 = (String)map.get(string);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("SELECT").append(' ').append("DISTINCT").append(' ');
                stringBuffer.append("b.").append("TYPE_NAME").append(',').append(' ');
                stringBuffer.append("b.").append("OWNER").append(',').append(' ');
                stringBuffer.append("b.").append("TYPECODE").append(',').append(' ');
                stringBuffer.append("b.").append("SUPERTYPE_OWNER").append(',').append(' ');
                stringBuffer.append("b.").append("SUPERTYPE_NAME").append(", b.LOCAL_ATTRIBUTES, b.LOCAL_METHODS ");
                stringBuffer.append("FROM").append(' ').append(this.dbaUser ? "dba_method_results" : "all_method_results").append(' ').append("a").append(',').append(' ');
                stringBuffer.append(this.dbaUser ? "dba_types" : "all_types").append(' ').append("b").append(' ');
                stringBuffer.append("WHERE").append(' ').append("a.").append("OWNER").append(' ').append('=').append(" '" + string + "'").append(' ');
                stringBuffer.append("AND").append(' ').append("a.").append("TYPE_NAME").append(' ').append(" in (" + string2 + ")").append(' ');
                stringBuffer.append("AND").append(" a.RESULT_TYPE_OWNER is not null AND ").append("a.").append("RESULT_TYPE_NAME").append(' ').append('=').append(' ').append("b.").append("TYPE_NAME").append(' ');
                stringBuffer.append("AND").append(' ').append("a.").append("RESULT_TYPE_OWNER").append(' ').append('=').append(' ').append("b.").append("OWNER").append(' ');
                stringBuffer.append("AND").append(' ').append("b.").append("PREDEFINED").append(' ').append('=').append(' ');
                stringBuffer.append('\'').append("NO").append('\'').append(' ');
                stringBuffer.append("AND").append(' ').append("a.").append("RESULT_TYPE_OWNER").append(' ').append("IS").append(' ').append("NOT").append(' ').append("NULL");
                String string3 = stringBuffer.toString();
                this.result_statement = connection.prepareStatement(string3);
                ResultSet resultSet = null;
                try {
                    resultSet = statement.executeQuery(string3);
                }
                catch (Exception exception) {
                    LOGGER.error("MOHTypeIncompleteOraclev9i.getMethodResultType():", exception);
                }
                if (resultSet == null) continue;
                while (resultSet.next()) {
                    Object object;
                    String string4 = resultSet.getString(1);
                    String string5 = resultSet.getString(2);
                    String string6 = resultSet.getString(3);
                    String string7 = resultSet.getString(4);
                    String string8 = resultSet.getString(5);
                    int n = resultSet.getInt(6);
                    int n2 = resultSet.getInt(7);
                    DBObject dBObject = new DBObject(true, string4, string6, string5);
                    dBObject.setSuperTypeOwner(string7);
                    dBObject.setSuperTypeName(string8);
                    dBObject.setLocalAttributes(n);
                    dBObject.setLocalMethods(n2);
                    String string9 = dBObject.toString();
                    if (!this.selectedTypes.containsKey(string9)) {
                        object = this.allTypes.get(string9);
                        if (object != null) {
                            dBObject = (DBObject)object;
                        }
                        types.add(dBObject);
                        this.selectedTypes.put(dBObject.toString(), dBObject);
                    }
                    if (string8 == null || string8.equals("") || this.selectedTypes.containsKey(((DBObject)(object = new DBObject(true, string8, string6, string7))).toString())) continue;
                    types.add(object);
                    this.selectedTypes.put(((DBObject)object).toString(), object);
                }
                resultSet.close();
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    private void addSuperTypesMulti(Map map, Connection connection, List list) throws SQLException {
        for (DBObject dBObject : list) {
            String string;
            CharSequence charSequence;
            DBObject dBObject2;
            String string2;
            String string3 = dBObject.getSuperTypeOwner();
            String string4 = dBObject.getSuperTypeName();
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObject.getType()) || string4 == null || string4.equals("") || this.selectedTypes.containsKey(string2 = (dBObject2 = new DBObject(true, string4, OBJECT_TYPE, string3)).toString())) continue;
            Object v = this.allTypes.get(string2);
            if (v != null) {
                dBObject2 = (DBObject)v;
            }
            types.add(dBObject2);
            this.selectedTypes.put(dBObject2.toString(), dBObject2);
            if (v != null) continue;
            ResultSet resultSet = null;
            if (this.supert_statement == null) {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT").append(' ').append("SUPERTYPE_OWNER").append(',').append(' ');
                ((StringBuffer)charSequence).append("SUPERTYPE_NAME").append(", LOCAL_ATTRIBUTES, LOCAL_METHODS ");
                ((StringBuffer)charSequence).append("FROM").append(' ').append(this.dbaUser ? "dba_types" : "all_types").append(' ');
                ((StringBuffer)charSequence).append("WHERE").append(' ').append("OWNER").append(' ').append('=').append(' ').append('?').append(' ');
                ((StringBuffer)charSequence).append("AND").append(' ').append("TYPE_NAME").append(' ').append('=').append(' ').append('?').append(' ');
                string = ((StringBuffer)charSequence).toString();
                this.supert_statement = connection.prepareStatement(string);
            }
            try {
                this.supert_statement.setString(1, string3);
                this.supert_statement.setString(2, string4);
                resultSet = this.supert_statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHTypeIncompleteUDB.extract(): " + sQLException.getMessage());
            }
            if (resultSet == null) continue;
            if (resultSet.next()) {
                charSequence = resultSet.getString(1);
                string = resultSet.getString(2);
                int n = resultSet.getInt(3);
                int n2 = resultSet.getInt(4);
                dBObject2.setLocalAttributes(n);
                dBObject2.setLocalMethods(n2);
                dBObject2.setSuperTypeOwner((String)charSequence);
                dBObject2.setSuperTypeName(string);
            }
            resultSet.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCollectionElementTypesMulti(Map map, Connection connection) throws SQLException {
        Statement statement = null;
        try {
            String string;
            CharSequence charSequence2;
            statement = connection.createStatement();
            String string2 = null;
            String string3 = null;
            boolean bl = true;
            for (CharSequence charSequence2 : map.keySet()) {
                string = (String)map.get(charSequence2);
                if (bl) {
                    string2 = "'" + (String)charSequence2 + "'";
                    string3 = string;
                    continue;
                }
                string2 = string2 + "," + "'" + (String)charSequence2 + "'";
                string3 = string3 + "," + string;
            }
            charSequence2 = new StringBuffer();
            ((StringBuffer)charSequence2).append("SELECT").append(' ').append("DISTINCT").append(' ');
            ((StringBuffer)charSequence2).append("b.").append("TYPE_NAME").append(',').append(' ');
            ((StringBuffer)charSequence2).append("b.").append("OWNER").append(',').append(' ');
            ((StringBuffer)charSequence2).append("b.").append("TYPECODE").append(',').append(' ');
            ((StringBuffer)charSequence2).append("b.").append("SUPERTYPE_OWNER").append(',').append(' ');
            ((StringBuffer)charSequence2).append("b.").append("SUPERTYPE_NAME").append(", b.LOCAL_ATTRIBUTES, b.LOCAL_METHODS ");
            ((StringBuffer)charSequence2).append("FROM").append(' ').append(this.dbaUser ? "dba_coll_types" : "all_coll_types").append(' ').append("a").append(',').append(' ');
            ((StringBuffer)charSequence2).append(this.dbaUser ? "dba_types" : "all_types").append(' ').append("b").append(' ');
            ((StringBuffer)charSequence2).append("WHERE").append(' ').append("a.").append("OWNER").append(' ').append(" in (" + string2 + ")").append(' ');
            ((StringBuffer)charSequence2).append("AND").append(' ').append("a.").append("TYPE_NAME").append(' ').append(" in (" + string3 + ")").append(' ');
            ((StringBuffer)charSequence2).append("AND").append(" a.ELEM_TYPE_OWNER is not null AND ").append("a.").append("ELEM_TYPE_NAME").append(' ').append('=').append(' ').append("b.").append("TYPE_NAME").append(' ');
            ((StringBuffer)charSequence2).append("AND").append(' ').append("a.").append("ELEM_TYPE_OWNER").append(' ').append('=').append(' ').append("b.").append("OWNER").append(' ');
            ((StringBuffer)charSequence2).append("AND").append(' ').append("b.").append("PREDEFINED").append(' ').append('=').append(' ');
            ((StringBuffer)charSequence2).append('\'').append("NO").append('\'').append(' ');
            ((StringBuffer)charSequence2).append("AND").append(' ').append("a.").append("ELEM_TYPE_OWNER").append(' ').append("IS").append(' ').append("NOT").append(' ').append("NULL");
            string = ((StringBuffer)charSequence2).toString();
            ResultSet resultSet = null;
            try {
                resultSet = statement.executeQuery(string);
            }
            catch (Exception exception) {
                LOGGER.error("MOHTypeIncompleteOraclev9i.getCollectionElementType():", exception);
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    Object object;
                    String string4 = resultSet.getString(1);
                    String string5 = resultSet.getString(2);
                    String string6 = (String)map.get(string5);
                    String string7 = resultSet.getString(3);
                    String string8 = resultSet.getString(4);
                    String string9 = resultSet.getString(5);
                    int n = resultSet.getInt(6);
                    int n2 = resultSet.getInt(7);
                    DBObject dBObject = new DBObject(true, string4, string7, string5);
                    dBObject.setSuperTypeOwner(string8);
                    dBObject.setSuperTypeName(string9);
                    dBObject.setLocalAttributes(n);
                    dBObject.setLocalMethods(n2);
                    String string10 = dBObject.toString();
                    if (!this.selectedTypes.containsKey(string10)) {
                        object = this.allTypes.get(string10);
                        if (object != null) {
                            dBObject = (DBObject)object;
                        }
                        types.add(dBObject);
                        this.selectedTypes.put(dBObject.toString(), dBObject);
                    }
                    if (string9 == null || string9.equals("") || this.selectedTypes.containsKey(string10 = ((DBObject)(object = new DBObject(true, string9, string7, string8))).toString())) continue;
                    Object v = this.allTypes.get(string10);
                    if (v != null) {
                        object = (DBObject)v;
                    }
                    types.add(object);
                    this.selectedTypes.put(string10, object);
                }
                resultSet.close();
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAttributeTypeMulti(Map map, Connection connection) throws SQLException {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            for (String string : map.keySet()) {
                String string2 = (String)map.get(string);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("SELECT").append(' ').append("DISTINCT").append(' ');
                stringBuffer.append("b.").append("TYPE_NAME").append(',').append(' ');
                stringBuffer.append("b.").append("OWNER").append(',').append(' ');
                stringBuffer.append("b.").append("TYPECODE").append(',').append(' ');
                stringBuffer.append("b.").append("SUPERTYPE_OWNER").append(',').append(' ');
                stringBuffer.append("b.").append("SUPERTYPE_NAME").append(',').append(" b.LOCAL_ATTRIBUTES, b.LOCAL_METHODS ");
                stringBuffer.append("FROM").append(' ').append(this.dbaUser ? "dba_type_attrs" : "all_type_attrs").append(' ').append("a").append(',').append(' ');
                stringBuffer.append(this.dbaUser ? "dba_types" : "all_types").append(' ').append("b").append(' ');
                stringBuffer.append("WHERE").append(' ').append("a.").append("OWNER").append(' ').append('=').append(' ').append("'" + string + "'").append(' ');
                stringBuffer.append("AND").append(' ').append("a.").append("TYPE_NAME").append(' ').append(" in (" + string2 + ")").append(' ');
                stringBuffer.append("AND").append(" a.ATTR_TYPE_OWNER is not null AND ").append("a.").append("ATTR_TYPE_NAME").append(' ').append('=').append(' ').append("b.").append("TYPE_NAME").append(' ');
                stringBuffer.append("AND").append(' ').append("a.").append("ATTR_TYPE_OWNER").append(' ').append('=').append(' ').append("b.").append("OWNER");
                String string3 = stringBuffer.toString();
                ResultSet resultSet = null;
                try {
                    resultSet = statement.executeQuery(string3);
                }
                catch (Exception exception) {
                    LOGGER.error("MOHTypeIncompleteOraclev9i.getAttributeType():", exception);
                }
                if (resultSet == null) continue;
                while (resultSet.next()) {
                    Object object;
                    String string4 = resultSet.getString(1);
                    String string5 = resultSet.getString(2);
                    String string6 = resultSet.getString(3);
                    String string7 = resultSet.getString(4);
                    String string8 = resultSet.getString(5);
                    int n = resultSet.getInt(6);
                    int n2 = resultSet.getInt(7);
                    DBObject dBObject = new DBObject(true, string4, string6, string5);
                    dBObject.setSuperTypeOwner(string7);
                    dBObject.setSuperTypeName(string8);
                    dBObject.setLocalAttributes(n);
                    dBObject.setLocalMethods(n2);
                    String string9 = dBObject.toString();
                    if (!this.selectedTypes.containsKey(string9)) {
                        object = this.allTypes.get(string9);
                        if (object != null) {
                            dBObject = (DBObject)object;
                        }
                        types.add(dBObject);
                        this.selectedTypes.put(dBObject.toString(), dBObject);
                    }
                    if (string8 == null || string8.equals("") || this.selectedTypes.containsKey(string9 = ((DBObject)(object = new DBObject(true, string8, string6, string7))).toString())) continue;
                    Object v = this.allTypes.get(string9);
                    if (v != null) {
                        object = (DBObject)v;
                    }
                    types.add(object);
                    this.selectedTypes.put(((DBObject)object).toString(), object);
                }
                resultSet.close();
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    private void markProcessed(List list) {
        for (DBObject dBObject : list) {
            dBObject.setProcessed(true);
        }
    }

    private void getParameterType(Connection connection, DBObject dBObject) throws SQLException {
        String string;
        Object object;
        if (this.par_statement == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ').append("DISTINCT").append(' ');
            ((StringBuffer)object).append("b.").append("TYPE_NAME").append(',').append(' ');
            ((StringBuffer)object).append("b.").append("OWNER").append(',').append(' ');
            ((StringBuffer)object).append("b.").append("TYPECODE").append(',').append(' ');
            ((StringBuffer)object).append("b.").append("SUPERTYPE_OWNER").append(',').append(' ');
            ((StringBuffer)object).append("b.").append("SUPERTYPE_NAME").append(", b.LOCAL_ATTRIBUTES, b.LOCAL_METHODS ");
            ((StringBuffer)object).append("FROM").append(' ').append(this.dbaUser ? "dba_method_params" : "all_method_params").append(' ').append("a").append(',').append(' ');
            ((StringBuffer)object).append(this.dbaUser ? "dba_types" : "all_types").append(' ').append("b").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ').append("a.").append("OWNER").append(' ').append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object).append("AND").append(' ').append("a.").append("TYPE_NAME").append(' ').append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object).append("AND").append(' ').append("a.").append("PARAM_TYPE_NAME").append(' ').append('=').append(' ').append("b.").append("TYPE_NAME").append(' ');
            ((StringBuffer)object).append("AND").append(' ').append("a.").append("PARAM_TYPE_OWNER").append(' ').append('=').append(' ').append("b.").append("OWNER").append(' ');
            ((StringBuffer)object).append("AND").append(' ').append("b.").append("PREDEFINED").append(' ').append('=').append(' ');
            ((StringBuffer)object).append('\'').append("NO").append('\'').append(' ');
            ((StringBuffer)object).append("AND").append(' ').append("a.").append("PARAM_TYPE_OWNER").append(' ').append("IS").append(' ').append("NOT").append(' ').append("NULL");
            string = ((StringBuffer)object).toString();
            this.par_statement = connection.prepareStatement(string);
        }
        object = null;
        try {
            this.par_statement.setString(1, dBObject.getSchema());
            this.par_statement.setString(2, dBObject.getName());
            object = this.par_statement.executeQuery();
        }
        catch (Exception exception) {
            LOGGER.error("MOHTypeIncompleteOraclev9i.getParameterType():", exception);
        }
        if (object != null) {
            while (object.next()) {
                Object object2;
                string = object.getString(1);
                String string2 = object.getString(2);
                String string3 = object.getString(3);
                String string4 = object.getString(4);
                String string5 = object.getString(5);
                int n = object.getInt(6);
                int n2 = object.getInt(7);
                DBObject dBObject2 = new DBObject(true, string, string3, string2);
                dBObject2.setSuperTypeOwner(string4);
                dBObject2.setSuperTypeName(string5);
                dBObject2.setLocalAttributes(n);
                dBObject2.setLocalMethods(n2);
                String string6 = dBObject2.toString();
                if (!this.selectedTypes.containsKey(string6)) {
                    object2 = this.allTypes.get(string6);
                    if (object2 != null) {
                        dBObject2 = (DBObject)object2;
                    }
                    types.add(dBObject2);
                    this.selectedTypes.put(dBObject2.toString(), dBObject2);
                }
                if (string5 == null || string5.equals("") || this.selectedTypes.containsKey(((DBObject)(object2 = new DBObject(true, string5, string3, string4))).toString())) continue;
                types.add(object2);
                this.selectedTypes.put(((DBObject)object2).toString(), object2);
            }
            object.close();
        }
    }

    private void getMethodResultType(Connection connection, DBObject dBObject) throws SQLException {
        String string;
        Object object;
        if (this.result_statement == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ').append("DISTINCT").append(' ');
            ((StringBuffer)object).append("b.").append("TYPE_NAME").append(',').append(' ');
            ((StringBuffer)object).append("b.").append("OWNER").append(',').append(' ');
            ((StringBuffer)object).append("b.").append("TYPECODE").append(',').append(' ');
            ((StringBuffer)object).append("b.").append("SUPERTYPE_OWNER").append(',').append(' ');
            ((StringBuffer)object).append("b.").append("SUPERTYPE_NAME").append(", b.LOCAL_ATTRIBUTES, b.LOCAL_METHODS ");
            ((StringBuffer)object).append("FROM").append(' ').append(this.dbaUser ? "dba_method_results" : "all_method_results").append(' ').append("a").append(',').append(' ');
            ((StringBuffer)object).append(this.dbaUser ? "dba_types" : "all_types").append(' ').append("b").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ').append("a.").append("OWNER").append(' ').append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object).append("AND").append(' ').append("a.").append("TYPE_NAME").append(' ').append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object).append("AND").append(' ').append("a.").append("RESULT_TYPE_NAME").append(' ').append('=').append(' ').append("b.").append("TYPE_NAME").append(' ');
            ((StringBuffer)object).append("AND").append(' ').append("a.").append("RESULT_TYPE_OWNER").append(' ').append('=').append(' ').append("b.").append("OWNER").append(' ');
            ((StringBuffer)object).append("AND").append(' ').append("b.").append("PREDEFINED").append(' ').append('=').append(' ');
            ((StringBuffer)object).append('\'').append("NO").append('\'').append(' ');
            ((StringBuffer)object).append("AND").append(' ').append("a.").append("RESULT_TYPE_OWNER").append(' ').append("IS").append(' ').append("NOT").append(' ').append("NULL");
            string = ((StringBuffer)object).toString();
            this.result_statement = connection.prepareStatement(string);
        }
        object = null;
        try {
            this.result_statement.setString(1, dBObject.getSchema());
            this.result_statement.setString(2, dBObject.getName());
            object = this.result_statement.executeQuery();
        }
        catch (Exception exception) {
            LOGGER.error("MOHTypeIncompleteOraclev9i.getMethodResultType():", exception);
        }
        if (object != null) {
            while (object.next()) {
                Object object2;
                string = object.getString(1);
                String string2 = object.getString(2);
                String string3 = object.getString(3);
                String string4 = object.getString(4);
                String string5 = object.getString(5);
                int n = object.getInt(6);
                int n2 = object.getInt(7);
                DBObject dBObject2 = new DBObject(true, string, string3, string2);
                dBObject2.setSuperTypeOwner(string4);
                dBObject2.setSuperTypeName(string5);
                dBObject2.setLocalAttributes(n);
                dBObject2.setLocalMethods(n2);
                String string6 = dBObject2.toString();
                if (!this.selectedTypes.containsKey(string6)) {
                    object2 = this.allTypes.get(string6);
                    if (object2 != null) {
                        dBObject2 = (DBObject)object2;
                    }
                    types.add(dBObject2);
                    this.selectedTypes.put(dBObject2.toString(), dBObject2);
                }
                if (string5 == null || string5.equals("") || this.selectedTypes.containsKey(((DBObject)(object2 = new DBObject(true, string5, string3, string4))).toString())) continue;
                types.add(object2);
                this.selectedTypes.put(((DBObject)object2).toString(), object2);
            }
            object.close();
        }
    }

    private void getCollectionElementType(Connection connection, DBObject dBObject) throws SQLException {
        String string;
        Object object;
        if (this.elem_statement == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ').append("DISTINCT").append(' ');
            ((StringBuffer)object).append("b.").append("TYPE_NAME").append(',').append(' ');
            ((StringBuffer)object).append("b.").append("OWNER").append(',').append(' ');
            ((StringBuffer)object).append("b.").append("TYPECODE").append(',').append(' ');
            ((StringBuffer)object).append("b.").append("SUPERTYPE_OWNER").append(',').append(' ');
            ((StringBuffer)object).append("b.").append("SUPERTYPE_NAME").append(", b.LOCAL_ATTRIBUTES, b.LOCAL_METHODS ");
            ((StringBuffer)object).append("FROM").append(' ').append(this.dbaUser ? "dba_coll_types" : "all_coll_types").append(' ').append("a").append(',').append(' ');
            ((StringBuffer)object).append(this.dbaUser ? "dba_types" : "all_types").append(' ').append("b").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ').append("a.").append("OWNER").append(' ').append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object).append("AND").append(' ').append("a.").append("ELEM_TYPE_NAME").append(' ').append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object).append("AND").append(' ').append("a.").append("ELEM_TYPE_NAME").append(' ').append('=').append(' ').append("b.").append("TYPE_NAME").append(' ');
            ((StringBuffer)object).append("AND").append(' ').append("a.").append("ELEM_TYPE_OWNER").append(' ').append('=').append(' ').append("b.").append("OWNER").append(' ');
            ((StringBuffer)object).append("AND").append(' ').append("b.").append("PREDEFINED").append(' ').append('=').append(' ');
            ((StringBuffer)object).append('\'').append("NO").append('\'').append(' ');
            ((StringBuffer)object).append("AND").append(' ').append("a.").append("ELEM_TYPE_OWNER").append(' ').append("IS").append(' ').append("NOT").append(' ').append("NULL");
            string = ((StringBuffer)object).toString();
            this.elem_statement = connection.prepareStatement(string);
        }
        object = null;
        try {
            this.elem_statement.setString(1, dBObject.getSchema());
            this.elem_statement.setString(2, dBObject.getName());
            object = this.elem_statement.executeQuery();
        }
        catch (Exception exception) {
            LOGGER.error("MOHTypeIncompleteOraclev9i.getCollectionElementType():", exception);
        }
        if (object != null) {
            while (object.next()) {
                Object object2;
                string = object.getString(1);
                String string2 = object.getString(2);
                String string3 = object.getString(3);
                String string4 = object.getString(4);
                String string5 = object.getString(5);
                int n = object.getInt(6);
                int n2 = object.getInt(7);
                DBObject dBObject2 = new DBObject(true, string, string3, string2);
                dBObject2.setSuperTypeOwner(string4);
                dBObject2.setSuperTypeName(string5);
                dBObject2.setLocalAttributes(n);
                dBObject2.setLocalMethods(n2);
                String string6 = dBObject2.toString();
                if (!this.selectedTypes.containsKey(string6)) {
                    object2 = this.allTypes.get(string6);
                    if (object2 != null) {
                        dBObject2 = (DBObject)object2;
                    }
                    types.add(dBObject2);
                    this.selectedTypes.put(dBObject2.toString(), dBObject2);
                }
                if (string5 == null || string5.equals("") || this.selectedTypes.containsKey(((DBObject)(object2 = new DBObject(true, string5, string3, string4))).toString())) continue;
                types.add(object2);
                this.selectedTypes.put(((DBObject)object2).toString(), object2);
            }
            object.close();
        }
    }

    private boolean createCollectionType(StorageDesignOracle storageDesignOracle, DBObject dBObject) {
        String string = dBObject.getName();
        String string2 = dBObject.getSchema();
        CollectionType collectionType = (CollectionType)this.getDesign().getDataTypesDesign().getCollectionTypeSet().getByName(string);
        if (collectionType == null) {
            collectionType = this.getDesign().getDataTypesDesign().createCollectionType();
            collectionType.setName(string);
            this.stampModelObject(collectionType, dBObject);
        }
        if (storageDesignOracle != null) {
            CollectionTypeProxyOracle collectionTypeProxyOracle = (CollectionTypeProxyOracle)storageDesignOracle.getCollectionTypeProxySet().getProxy(collectionType.getObjectID());
            if (collectionTypeProxyOracle != null) {
                UserOracle userOracle = (UserOracle)storageDesignOracle.getUserSet().getByName(string2);
                if (userOracle == null) {
                    userOracle = storageDesignOracle.getUserSet().createUser();
                    userOracle.setName(string2);
                    this.stampModelObject((ModelObject)userOracle, "", string2);
                }
                collectionTypeProxyOracle.setOwner(userOracle);
                this.stampModelObject(collectionTypeProxyOracle, dBObject);
            }
            return true;
        }
        return false;
    }

    private boolean createStructuredType(StorageDesignOracle storageDesignOracle, DBObject dBObject) {
        String string = dBObject.getName();
        String string2 = dBObject.getSchema();
        StructuredType structuredType = (StructuredType)this.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(string);
        if (structuredType != null) {
            structuredType.removeAll();
            structuredType.removeAllMethods();
        } else {
            structuredType = this.getDesign().getDataTypesDesign().createStructuredType();
            structuredType.setName(string);
            this.stampModelObject(structuredType, dBObject);
        }
        if (storageDesignOracle != null) {
            StructuredTypeProxyOracle structuredTypeProxyOracle = (StructuredTypeProxyOracle)storageDesignOracle.getStructuredTypeProxySet().getProxy(structuredType.getObjectID());
            if (structuredTypeProxyOracle != null) {
                structuredTypeProxyOracle.setName(string);
                UserOracle userOracle = (UserOracle)storageDesignOracle.getUserSet().getByName(string2);
                if (userOracle == null) {
                    userOracle = storageDesignOracle.getUserSet().createUser();
                    userOracle.setName(string2);
                    this.stampModelObject((ModelObject)userOracle, "", string2);
                }
                structuredTypeProxyOracle.setOwner(userOracle);
                this.stampModelObject(structuredTypeProxyOracle, dBObject);
            }
            return true;
        }
        return false;
    }

    private void addAdditionalType(Map map, DBObject dBObject) {
        if (!map.containsKey(dBObject.getSchema())) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(dBObject.getName());
            map.put(dBObject.getSchema(), arrayList);
        } else {
            List list = (List)map.get(dBObject.getSchema());
            list.add(dBObject.getName());
        }
    }

    private void addAdditionalTypes(Map map, List list, String string) {
        for (DBObject dBObject : list) {
            if (!string.equals(dBObject.getType())) continue;
            String string2 = dBObject.getSchema();
            if (!map.containsKey(string2)) {
                map.put(dBObject.getSchema(), '\'' + dBObject.getName() + '\'');
                continue;
            }
            String string3 = (String)map.get(string2);
            string3 = string3 + ',' + '\'' + dBObject.getName() + '\'';
            map.put(string2, string3);
        }
    }

    private void addAdditionalTypesWithAttributes(Map map, List list, String string) {
        for (DBObject dBObject : list) {
            if (!string.equals(dBObject.getType()) || dBObject.getLocalAttributes() == 0) continue;
            String string2 = dBObject.getSchema();
            if (!map.containsKey(string2)) {
                map.put(dBObject.getSchema(), '\'' + dBObject.getName() + '\'');
                continue;
            }
            String string3 = (String)map.get(string2);
            string3 = string3 + ',' + '\'' + dBObject.getName() + '\'';
            map.put(string2, string3);
        }
    }

    private void addAdditionalTypesWithMethods(Map map, List list, String string) {
        for (DBObject dBObject : list) {
            if (!string.equals(dBObject.getType()) || dBObject.getLocalMethods() == 0) continue;
            String string2 = dBObject.getSchema();
            if (!map.containsKey(string2)) {
                map.put(dBObject.getSchema(), '\'' + dBObject.getName() + '\'');
                continue;
            }
            String string3 = (String)map.get(string2);
            string3 = string3 + ',' + '\'' + dBObject.getName() + '\'';
            map.put(string2, string3);
        }
    }

    private List getNotProcessed1000(List list, String string) {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (arrayList.size() < 1000) {
                DBObject dBObject = (DBObject)iterator.next();
                if (dBObject.isProcessed() || !string.equals(dBObject.getType())) continue;
                arrayList.add(dBObject);
                continue;
            }
            return arrayList;
        }
        return arrayList;
    }

    public static List getAllTypes() {
        return types;
    }

    private void addSuperTypes(Connection connection, DBObject dBObject) throws SQLException {
        DBObject dBObject2;
        String string;
        String string2 = dBObject.getSuperTypeOwner();
        String string3 = dBObject.getSuperTypeName();
        if (OBJECT_TYPE.equalsIgnoreCase(dBObject.getType()) && string3 != null && !string3.equals("") && !this.selectedTypes.containsKey(string = (dBObject2 = new DBObject(true, string3, OBJECT_TYPE, string2)).toString())) {
            String string4;
            CharSequence charSequence;
            Object v = this.allTypes.get(string);
            if (v != null) {
                dBObject2 = (DBObject)v;
            }
            types.add(dBObject2);
            this.selectedTypes.put(dBObject2.toString(), dBObject2);
            if (v != null) {
                return;
            }
            ResultSet resultSet = null;
            if (this.supert_statement == null) {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT").append(' ').append("SUPERTYPE_OWNER").append(',').append(' ');
                ((StringBuffer)charSequence).append("SUPERTYPE_NAME").append(' ');
                ((StringBuffer)charSequence).append("FROM").append(' ').append(this.dbaUser ? "dba_types" : "all_types").append(' ');
                ((StringBuffer)charSequence).append("WHERE").append(' ').append("OWNER").append(' ').append('=').append(' ').append('?').append(' ');
                ((StringBuffer)charSequence).append("AND").append(' ').append("TYPE_NAME").append(' ').append('=').append(' ').append('?').append(' ');
                string4 = ((StringBuffer)charSequence).toString();
                this.supert_statement = connection.prepareStatement(string4);
            }
            try {
                this.supert_statement.setString(1, string2);
                this.supert_statement.setString(2, string3);
                resultSet = this.supert_statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHTypeIncompleteUDB.extract(): " + sQLException.getMessage());
            }
            if (resultSet != null) {
                if (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                    string4 = resultSet.getString(2);
                    dBObject2.setSuperTypeOwner((String)charSequence);
                    dBObject2.setSuperTypeName(string4);
                }
                resultSet.close();
            }
        }
    }

    static {
        LOGGER = new Logger(MOHTypeIncompleteOraclev9i.class);
    }
}

