/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle.v9i;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ContextOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHContextOraclev9i
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "CONTEXT";
    private static final Logger LOGGER = new Logger(MOHContextOraclev9i.class);
    protected boolean dbaUser;

    public MOHContextOraclev9i(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView, boolean bl) {
        super(abstractDBMExtractionHandler, applicationView);
        this.dbaUser = bl;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        CharSequence charSequence;
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append("NAMESPACE").append(' ');
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append(this.dbaUser ? "dba_context" : "all_context").append(' ');
            ((StringBuffer)charSequence).append("ORDER BY").append(' ');
            ((StringBuffer)charSequence).append("NAMESPACE");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            if (sQLException.getMessage().startsWith("ORA-00942")) {
                System.out.println("MOHContextOraclev9i.extract(): " + sQLException.getMessage());
                LOGGER.error("MOHContextOraclev9i.extract(): current connection user has no SELECT privilege on " + (this.dbaUser ? "dba_context" : "all_context"));
            } else {
                System.out.println("MOHContextOraclev9i.extract(): " + sQLException.getMessage());
                LOGGER.error("MOHContextOraclev9i.extract():", sQLException);
            }
        }
        catch (Exception exception) {
            System.out.println("MOHContextOraclev9i.extract(): " + exception.getMessage());
            LOGGER.error("MOHContextOraclev9i.extract():", exception);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString("NAMESPACE");
                DBObject dBObject = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, OBJECT_TYPE);
                arrayList.add(dBObject);
            }
            resultSet.close();
        }
        statement.close();
        return arrayList;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        Statement statement = null;
        for (int i = 0; i < list.size(); ++i) {
            DBObject dBObject = (DBObject)list.get(i);
            if (OBJECT_TYPE.equalsIgnoreCase(dBObject.getType())) {
                Object object;
                ResultSet resultSet = null;
                try {
                    if (statement == null) {
                        object = new StringBuffer();
                        ((StringBuffer)object).append("SELECT").append(' ');
                        ((StringBuffer)object).append("NAMESPACE").append(',');
                        ((StringBuffer)object).append("SCHEMA").append(',');
                        ((StringBuffer)object).append("PACKAGE").append(',');
                        ((StringBuffer)object).append(this.dbaUser ? "TYPE" : "NULL").append(' ').append("AS").append(' ').append("TYPE").append(' ');
                        ((StringBuffer)object).append("FROM").append(' ');
                        ((StringBuffer)object).append(this.dbaUser ? "dba_context" : "all_context").append(' ');
                        ((StringBuffer)object).append("WHERE").append(' ');
                        ((StringBuffer)object).append("NAMESPACE").append('=').append('?');
                        statement = connection.prepareStatement(((StringBuffer)object).toString());
                    }
                    statement.setString(1, dBObject.getName());
                    resultSet = statement.executeQuery();
                }
                catch (SQLException sQLException) {
                    if (sQLException.getMessage().startsWith("ORA-00942")) {
                        System.out.println("MOHContextOraclev9i.generate(): " + sQLException.getMessage());
                        LOGGER.error("MOHContextOraclev9i.generate(): current connection user has no SELECT privilege on " + (this.dbaUser ? "dba_context" : "all_context"));
                    } else {
                        System.out.println("MOHContextOraclev9i.generate(): " + sQLException.getMessage());
                        LOGGER.error("MOHContextOraclev9i.generate():", sQLException);
                    }
                }
                catch (Exception exception) {
                    System.out.println("MOHContextOraclev9i.generate(): " + exception.getMessage());
                    LOGGER.error("MOHContextOraclev9i.generate():", exception);
                }
                if (resultSet != null) {
                    object = (StorageDesignOracle)this.getStorageDesign();
                    while (resultSet.next()) {
                        String string = resultSet.getString("NAMESPACE");
                        String string2 = resultSet.getString("SCHEMA");
                        String string3 = resultSet.getString("PACKAGE");
                        String string4 = resultSet.getString("TYPE");
                        ContextOraclev9i contextOraclev9i = (ContextOraclev9i)((StorageDesignOracle)object).getContextSet().createContext();
                        contextOraclev9i.setName(string);
                        contextOraclev9i.setNamespace(string);
                        contextOraclev9i.setPackage(string2 + "." + string3);
                        if (string4 != null) {
                            if ("ACCESSED GLOBALLY".equalsIgnoreCase(string4.trim())) {
                                contextOraclev9i.setAccessedGlobally("YES");
                            } else if ("INITIALIZED GLOBALLY".equalsIgnoreCase(string4.trim())) {
                                contextOraclev9i.setInitialized("GLOBALLY");
                            } else if ("INITIALIZED EXTERNALLY".equalsIgnoreCase(string4.trim())) {
                                contextOraclev9i.setInitialized("EXTERNALLY");
                            }
                        }
                        this.stampModelObject(contextOraclev9i, dBObject);
                    }
                    resultSet.close();
                }
            }
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObject.getType())) continue;
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObject);
        }
        if (statement != null) {
            statement.close();
        }
    }
}

