/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle.v10g;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.oracle.BitmapJoinIndexOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.BitmapJoinIndexOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UserOraclev10g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHBitmapIndexesv10g
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "BITMAP JOIN";
    private static final Logger LOGGER = new Logger(MOHBitmapIndexesv10g.class);
    protected boolean dbaUser;
    PreparedStatement col_statement = null;
    PreparedStatement jcol_statement = null;

    public MOHBitmapIndexesv10g(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
        this.dbaUser = false;
    }

    public MOHBitmapIndexesv10g(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView, boolean bl) {
        super(abstractDBMExtractionHandler, applicationView);
        this.dbaUser = bl;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        this.col_statement = null;
        this.jcol_statement = null;
        ResultSet resultSet = null;
        Iterator iterator = this.getStorageDesign().getTableProxySet().iterator();
        TableProxyOraclev10g tableProxyOraclev10g = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT").append(' ');
        stringBuffer.append("OWNER").append(',');
        stringBuffer.append("INDEX_NAME").append(',');
        stringBuffer.append("INDEX_TYPE").append(',');
        stringBuffer.append("TABLE_OWNER").append(',');
        stringBuffer.append("TABLE_NAME").append(',');
        stringBuffer.append("TABLE_TYPE").append(',');
        stringBuffer.append("UNIQUENESS").append(',');
        stringBuffer.append("COMPRESSION").append(',');
        stringBuffer.append("TABLESPACE_NAME").append(',');
        stringBuffer.append("INI_TRANS").append(',');
        stringBuffer.append("MAX_TRANS").append(',');
        stringBuffer.append("INITIAL_EXTENT").append(',');
        stringBuffer.append("NEXT_EXTENT").append(',');
        stringBuffer.append("MIN_EXTENTS").append(',');
        stringBuffer.append("MAX_EXTENTS").append(',');
        stringBuffer.append("PCT_INCREASE").append(',');
        stringBuffer.append("INCLUDE_COLUMN").append(',');
        stringBuffer.append("FREELISTS").append(',');
        stringBuffer.append("FREELIST_GROUPS").append(',');
        stringBuffer.append("PCT_FREE").append(',');
        stringBuffer.append("LOGGING").append(',');
        stringBuffer.append("DEGREE").append(',');
        stringBuffer.append("PARTITIONED").append(',');
        stringBuffer.append("TEMPORARY").append(',');
        stringBuffer.append("GENERATED").append(',');
        stringBuffer.append("SECONDARY").append(',');
        stringBuffer.append("BUFFER_POOL").append(' ');
        stringBuffer.append("FROM").append(' ');
        stringBuffer.append(this.dbaUser ? "dba_indexes" : "all_indexes").append(' ');
        stringBuffer.append("WHERE").append(' ');
        stringBuffer.append("TABLE_OWNER").append(' ').append('=').append(' ').append('?').append(' ');
        stringBuffer.append("AND").append(' ');
        stringBuffer.append("TABLE_NAME").append(' ').append('=').append(' ').append('?').append(' ');
        stringBuffer.append("AND").append(' ');
        stringBuffer.append("JOIN_INDEX").append('=').append('\'');
        stringBuffer.append("YES").append('\'');
        String string = stringBuffer.toString();
        Statement statement = null;
        while (iterator.hasNext()) {
            if (statement == null) {
                statement = connection.prepareStatement(string);
            }
            tableProxyOraclev10g = (TableProxyOraclev10g)iterator.next();
            try {
                statement.setString(1, ((Table)tableProxyOraclev10g.getObject()).getSchema());
                statement.setString(2, tableProxyOraclev10g.getName());
                resultSet = statement.executeQuery();
            }
            catch (Exception exception) {
                System.out.println("MOHBitmapIndexesv10g.generate(): " + exception.getMessage());
                LOGGER.error("MOHBitmapIndexesv10g.generate(): ", exception);
            }
            if (resultSet == null) continue;
            while (resultSet.next()) {
                String string2 = resultSet.getString("INDEX_NAME");
                String string3 = resultSet.getString("TABLE_OWNER");
                String string4 = resultSet.getString("PARTITIONED");
                String string5 = resultSet.getString("TABLESPACE_NAME");
                String string6 = resultSet.getString("LOGGING");
                BitmapJoinIndexOraclev10g bitmapJoinIndexOraclev10g = (BitmapJoinIndexOraclev10g)((StorageDesignOraclev10g)this.getStorageDesign()).getBitmapJoinIndexSet().createBitmapJoinIndex();
                UserOraclev10g userOraclev10g = (UserOraclev10g)((StorageDesignOraclev10g)this.getStorageDesign()).getUserSet().getByName(string3);
                bitmapJoinIndexOraclev10g.setName(string2);
                bitmapJoinIndexOraclev10g.setUser(userOraclev10g);
                bitmapJoinIndexOraclev10g.setTable(tableProxyOraclev10g);
                bitmapJoinIndexOraclev10g.setLocalPartitioning(string4);
                bitmapJoinIndexOraclev10g.setTablespace(string5);
                bitmapJoinIndexOraclev10g.setLogging(string6);
                this.stampModelObject((ModelObject)bitmapJoinIndexOraclev10g, string3, string2);
                this.initIndexColumns(connection, bitmapJoinIndexOraclev10g, string3, importLogger);
                this.initJoinColumns(connection, bitmapJoinIndexOraclev10g, string3, importLogger);
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (this.col_statement != null) {
            this.col_statement.close();
        }
        if (this.jcol_statement != null) {
            this.jcol_statement.close();
        }
    }

    private void initJoinColumns(Connection connection, BitmapJoinIndexOracle bitmapJoinIndexOracle, String string, ImportLogger importLogger) throws SQLException {
        String string2;
        Object object;
        if (this.jcol_statement == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ');
            ((StringBuffer)object).append("INNER_TABLE_OWNER").append(',');
            ((StringBuffer)object).append("INNER_TABLE_NAME").append(',');
            ((StringBuffer)object).append("INNER_TABLE_COLUMN").append(',');
            ((StringBuffer)object).append("OUTER_TABLE_OWNER").append(',');
            ((StringBuffer)object).append("OUTER_TABLE_NAME").append(',');
            ((StringBuffer)object).append("OUTER_TABLE_COLUMN").append(' ');
            ((StringBuffer)object).append("FROM").append(' ');
            ((StringBuffer)object).append(this.dbaUser ? "dba_join_ind_columns" : "all_join_ind_columns").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ');
            ((StringBuffer)object).append("INDEX_OWNER").append(' ').append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object).append("AND").append(' ');
            ((StringBuffer)object).append("INDEX_NAME").append(' ').append('=').append(' ').append('?').append(' ');
            string2 = ((StringBuffer)object).toString();
            this.jcol_statement = connection.prepareStatement(string2);
        }
        object = null;
        try {
            this.jcol_statement.setString(1, string);
            this.jcol_statement.setString(2, bitmapJoinIndexOracle.getName());
            object = this.jcol_statement.executeQuery();
            if (object != null) {
                while (object.next()) {
                    string2 = object.getString("INNER_TABLE_NAME");
                    String string3 = object.getString("INNER_TABLE_COLUMN");
                    String string4 = object.getString("OUTER_TABLE_NAME");
                    String string5 = object.getString("OUTER_TABLE_COLUMN");
                    Table table = (Table)this.getDesign().getRelationalDesign().getTableSet().getByName(string2);
                    Table table2 = (Table)this.getDesign().getRelationalDesign().getTableSet().getByName(string4);
                    if (table == null || table2 == null) continue;
                    Column column = (Column)table.getElementByName(string3);
                    Column column2 = (Column)table2.getElementByName(string5);
                    if (column == null || column2 == null) continue;
                    bitmapJoinIndexOracle.setJoinColumns(column2.getObjectID());
                    bitmapJoinIndexOracle.setJoinColumns(column.getObjectID());
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(column2.getName());
                    Index index = this.getUniqueIndexForColumnNames(table2, arrayList);
                    bitmapJoinIndexOracle.setDimensionKeys(table2.getObjectID());
                    bitmapJoinIndexOracle.setDimensionKeys(index.getObjectID());
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("MOHBitmapIndexesv10g.initJoinColumns():", exception);
        }
    }

    private void initIndexColumns(Connection connection, BitmapJoinIndexOracle bitmapJoinIndexOracle, String string, ImportLogger importLogger) throws SQLException {
        String string2;
        Object object;
        if (this.col_statement == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ');
            ((StringBuffer)object).append("TABLE_OWNER").append(',');
            ((StringBuffer)object).append("TABLE_NAME").append(',');
            ((StringBuffer)object).append("COLUMN_NAME").append(',');
            ((StringBuffer)object).append("COLUMN_POSITION").append(',');
            ((StringBuffer)object).append("DESCEND").append(' ');
            ((StringBuffer)object).append("FROM").append(' ');
            ((StringBuffer)object).append(this.dbaUser ? "dba_ind_columns" : "all_ind_columns").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ');
            ((StringBuffer)object).append("INDEX_OWNER").append(' ').append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object).append("AND").append(' ');
            ((StringBuffer)object).append("INDEX_NAME").append(' ').append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object).append("ORDER BY").append(' ');
            ((StringBuffer)object).append("COLUMN_POSITION");
            string2 = ((StringBuffer)object).toString();
            this.col_statement = connection.prepareStatement(string2);
        }
        object = null;
        try {
            this.col_statement.setString(1, string);
            this.col_statement.setString(2, bitmapJoinIndexOracle.getName());
            object = this.col_statement.executeQuery();
            if (object != null) {
                while (object.next()) {
                    string2 = object.getString("COLUMN_NAME");
                    String string3 = object.getString("TABLE_NAME");
                    Table table = (Table)this.getDesign().getRelationalDesign().getTableSet().getByName(string3);
                    if (table != null) {
                        Column column = (Column)table.getElementByName(string2);
                        String string4 = object.getString("DESCEND");
                        if (column != null) {
                            bitmapJoinIndexOracle.setIndexColumns(column.getObjectID());
                            bitmapJoinIndexOracle.setIndexColumns(string4);
                            continue;
                        }
                        importLogger.addWarning("Column " + string2 + " is not imported");
                        continue;
                    }
                    importLogger.addWarning("Table " + string3 + " is not imported");
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("MOHBitmapIndexesv10g.initIndexColumns():", exception);
        }
    }

    private boolean isIndexForColumnNames(Index index, List list) {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(list);
        Column[] columnArray = (Column[])index.getElements();
        if (columnArray.length != list.size()) {
            return false;
        }
        for (int i = 0; i < columnArray.length; ++i) {
            for (int j = 0; j < list.size(); ++j) {
                if (!columnArray[i].getName().equalsIgnoreCase((String)list.get(j))) continue;
                arrayList.remove(list.get(j));
            }
        }
        return arrayList.size() == 0;
    }

    private Index getUniqueIndexForColumnNames(Table table, List list) {
        Index index = (Index)table.getPK();
        if (index != null && this.isIndexForColumnNames(index, list)) {
            return index;
        }
        Index[] indexArray = (Index[])table.getKeys();
        for (int i = 0; i < indexArray.length; ++i) {
            if (!indexArray[i].getIndexState().equalsIgnoreCase("Unique Constraint") || !this.isIndexForColumnNames(indexArray[i], list)) continue;
            return indexArray[i];
        }
        return null;
    }
}

