/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.MOHView;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.TableViewSet;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHViewOracle
extends MOHView {
    private static final Logger LOGGER = new Logger(MOHViewOracle.class);
    private List postProc;
    protected boolean dbaUser;

    public MOHViewOracle(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
        this.dbaUser = false;
    }

    public MOHViewOracle(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView, boolean bl) {
        super(abstractDBMExtractionHandler, applicationView);
        this.dbaUser = bl;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        TimeLog.log("Views begin");
        this.postProc = new ArrayList();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT").append(' ');
        stringBuffer.append("a.").append("COLUMN_NAME").append(',');
        stringBuffer.append("DATA_TYPE").append(',');
        stringBuffer.append("DATA_LENGTH").append(',');
        stringBuffer.append("DATA_PRECISION").append(',');
        stringBuffer.append("DATA_SCALE").append(',');
        stringBuffer.append("COMMENTS").append(' ');
        stringBuffer.append("FROM").append(' ');
        stringBuffer.append(this.dbaUser ? "dba_tab_columns" : "all_tab_columns").append(' ').append("a").append(',');
        stringBuffer.append(this.dbaUser ? "dba_col_comments" : "all_col_comments").append(' ').append("b").append(' ');
        stringBuffer.append("WHERE").append(' ');
        stringBuffer.append("a.").append("TABLE_NAME").append('=').append(' ').append('?').append(' ');
        stringBuffer.append("AND").append(' ');
        stringBuffer.append("a.").append("OWNER").append('=').append(' ').append('?').append(' ');
        stringBuffer.append("AND").append(' ');
        stringBuffer.append("a.").append("OWNER").append('=');
        stringBuffer.append("b.").append("OWNER").append(' ');
        stringBuffer.append("AND").append(' ');
        stringBuffer.append("a.").append("TABLE_NAME").append('=');
        stringBuffer.append("b.").append("TABLE_NAME").append(' ');
        stringBuffer.append("AND").append(' ');
        stringBuffer.append("a.").append("COLUMN_NAME").append('=');
        stringBuffer.append("b.").append("COLUMN_NAME").append(' ');
        stringBuffer.append("ORDER BY").append(' ').append("COLUMN_ID");
        String string = stringBuffer.toString();
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT").append(' ');
        stringBuffer.append("OWNER").append(',');
        stringBuffer.append("TRIGGER_NAME").append(',');
        stringBuffer.append("TRIGGER_TYPE").append(',');
        stringBuffer.append("TRIGGERING_EVENT").append(',');
        stringBuffer.append("REFERENCING_NAMES").append(',');
        stringBuffer.append("WHEN_CLAUSE").append(',');
        stringBuffer.append("STATUS").append(',');
        stringBuffer.append("DESCRIPTION").append(',');
        stringBuffer.append("TRIGGER_BODY").append(' ');
        stringBuffer.append("FROM").append(' ').append(this.dbaUser ? "dba_triggers" : "all_triggers").append(' ');
        stringBuffer.append("WHERE").append(' ').append("TABLE_OWNER").append(' ').append('=').append(' ').append('?').append(' ');
        stringBuffer.append("AND").append(' ').append("TABLE_NAME").append(' ').append('=').append(' ').append('?').append(' ');
        String string2 = stringBuffer.toString();
        PreparedStatement preparedStatement2 = connection.prepareStatement(string2);
        stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT").append(' ');
        stringBuffer.append("TEXT").append(',');
        stringBuffer.append("OID_TEXT").append(',');
        stringBuffer.append("SUPERVIEW_NAME").append(' ');
        stringBuffer.append("FROM").append(' ');
        stringBuffer.append(this.dbaUser ? "dba_views" : "all_views").append(' ');
        stringBuffer.append("WHERE").append(' ');
        stringBuffer.append("VIEW_NAME").append(' ').append('=').append(' ').append('?').append(' ');
        stringBuffer.append("AND").append(' ');
        stringBuffer.append("OWNER").append(' ').append('=').append(' ').append('?').append(' ');
        String string3 = stringBuffer.toString();
        PreparedStatement preparedStatement3 = connection.prepareStatement(string3);
        for (int i = 0; i < list.size(); ++i) {
            DBObject dBObject = (DBObject)list.get(i);
            if (!"VIEW".equalsIgnoreCase(dBObject.getType())) continue;
            ResultSet resultSet = null;
            try {
                preparedStatement3.setString(1, dBObject.getName());
                preparedStatement3.setString(2, dBObject.getSchema());
                resultSet = preparedStatement3.executeQuery();
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                LOGGER.error("MOHViewOracle.generate():", exception);
            }
            if (resultSet != null) {
                if (resultSet.next()) {
                    Object object;
                    String string4;
                    String string5;
                    String string6;
                    Object object2;
                    SchemaObjectSet schemaObjectSet;
                    SchemaObject schemaObject;
                    TableView tableView = this.getDesign().getRelationalDesign().getTableViewSet().createTableView(null);
                    tableView.setCommentInRDBMS(dBObject.getComments());
                    tableView.setSchema(dBObject.getSchema());
                    String string7 = dBObject.getSchema();
                    UserOracle userOracle = (UserOracle)((StorageDesignOracle)this.getStorageDesign()).getUserSet().getByName(string7);
                    TableViewProxyOracle tableViewProxyOracle = (TableViewProxyOracle)this.getStorageDesign().getTableViewProxySet().getProxy(tableView.getObjectID());
                    if (userOracle == null) {
                        userOracle = (UserOracle)((StorageDesignOracle)this.getStorageDesign()).getUserSet().createElement(null);
                        userOracle.setName(string7);
                        this.stampModelObject((ModelObject)userOracle, "", string7);
                    }
                    if ((schemaObject = (SchemaObject)(schemaObjectSet = ((RelationalDesign)tableView.getDesignPart()).getSchemaObjectSet()).getByName(string7)) == null) {
                        schemaObject = schemaObjectSet.createSchemaObject(null);
                        schemaObject.setName(string7);
                        this.stampModelObject((ModelObject)schemaObject, "", string7);
                    }
                    if (userOracle != null) {
                        if (userOracle.getSchemaObject() == null) {
                            userOracle.setSchemaObject(schemaObject);
                        }
                        if (userOracle.getSchemaObject() != schemaObject) {
                            tableViewProxyOracle.setUser(userOracle);
                        }
                    }
                    tableView.setSchemaObject(schemaObject);
                    tableView.setName(dBObject.getName());
                    if (dBObject.getTypeName() != null) {
                        object2 = ((StructuredTypeProxySetOracle)this.getStorageDesign().getStructuredTypeProxySet()).getByLongName(dBObject.getTypeName(), dBObject.getTypeOwner());
                        if (object2 != null && ((StructuredTypeProxy)object2).getStructuredType() != null) {
                            tableView.setBasedOnStructuredType(((StructuredTypeProxy)object2).getStructuredType());
                            string6 = resultSet.getString("TEXT");
                            String string8 = "CREATE OR REPLACE VIEW " + dBObject.getName();
                            string5 = resultSet.getString("SUPERVIEW_NAME");
                            string4 = resultSet.getString("OID_TEXT");
                            if (string5 != null) {
                                object = new Temp();
                                ((Temp)object).superViewName = string5;
                                ((Temp)object).tview = tableView;
                                this.postProc.add(object);
                            }
                            if (string4 != null) {
                                tableView.setOidText(string4);
                                if (tableViewProxyOracle != null) {
                                    tableViewProxyOracle.setOidAttributes(string4);
                                }
                            }
                            tableView.setUserDefinedSQL(string8 + "\nAS \n" + string6);
                        }
                    } else {
                        tableView.setUserDefined(true);
                        object2 = resultSet.getString("TEXT").trim();
                        string6 = ((String)object2).toUpperCase();
                        int n = string6.indexOf("WITH READ ONLY");
                        string5 = "";
                        if (n > -1) {
                            string5 = ((String)object2).substring(n);
                            object2 = ((String)object2).substring(0, n);
                            tableViewProxyOracle.setViewReadOnly("YES");
                        } else {
                            n = string6.indexOf("WITH CHECK OPTION");
                            if (n > -1) {
                                string5 = ((String)object2).substring(n);
                                object2 = ((String)object2).substring(0, n);
                                tableViewProxyOracle.setCheckOption(true);
                            }
                        }
                        if (!"".equals(string5)) {
                            // empty if block
                        }
                        string4 = "CREATE OR REPLACE VIEW " + dBObject.getName() + "\nAS \n" + (String)object2;
                        tableView.setUserDefinedSQL(string4);
                        object = null;
                        try {
                            preparedStatement.setString(1, dBObject.getName());
                            preparedStatement.setString(2, dBObject.getSchema());
                            object = preparedStatement.executeQuery();
                            if (object != null) {
                                while (object.next()) {
                                    String string9 = object.getString(1);
                                    String string10 = object.getString(2);
                                    String string11 = object.getString(3);
                                    String string12 = object.getString(4);
                                    String string13 = object.getString(5);
                                    String string14 = object.getString(6);
                                    AbstractViewElement abstractViewElement = tableView.createViewElement(tableView.getDesignPart());
                                    abstractViewElement.setName(string9);
                                    abstractViewElement.setDataType(this.createDataTypeString(string10, string11, string12, string13));
                                    abstractViewElement.setDesign(tableView.getDesign());
                                    abstractViewElement.setAlias(string9);
                                    abstractViewElement.setContainer(tableView);
                                    if (string14 != null) {
                                        abstractViewElement.setCommentInRDBMS(string14);
                                    }
                                    tableView.add(abstractViewElement);
                                    this.stampModelObject((ModelObject)abstractViewElement, tableView.getName(), string9);
                                }
                            }
                        }
                        catch (Exception exception) {
                            System.out.println(exception.getMessage());
                            LOGGER.error("MOHViewOracle.generate() column names:", exception);
                        }
                        if (object != null) {
                            object.close();
                        }
                    }
                    this.initViewTriggers(preparedStatement2, tableView, dBObject.getSchema());
                    this.stampModelObject(tableView, dBObject);
                }
                resultSet.close();
            }
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObject);
        }
        preparedStatement2.close();
        preparedStatement.close();
        preparedStatement3.close();
        TimeLog.log("End Views");
    }

    private boolean isNotEmpty(String string) {
        return string != null && !"".equalsIgnoreCase(string) && !"0".equalsIgnoreCase(string);
    }

    private String createDataTypeString(String string, String string2, String string3, String string4) {
        if (!(string.startsWith("TIMESTAMP") || string.startsWith("INTERVAL") || string2 == null && string3 == null && string4 == null)) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            if (!"NUMBER".equalsIgnoreCase(string) && this.isNotEmpty(string2)) {
                stringBuffer.append(string2);
                bl = true;
            }
            if (this.isNotEmpty(string3)) {
                if (bl) {
                    stringBuffer.append(',').append(' ');
                }
                stringBuffer.append(string3);
                bl = true;
            }
            if (this.isNotEmpty(string4)) {
                if (bl) {
                    stringBuffer.append(',').append(' ');
                }
                stringBuffer.append(string4);
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.append(')');
                return string + " (" + stringBuffer.toString();
            }
        }
        return string;
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        Statement statement = null;
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (DBObject dBObject : list) {
            String string;
            Object object;
            if (!dBObject.isSelected()) continue;
            String string2 = dBObject.getName();
            if (statement == null) {
                object = new StringBuffer();
                ((StringBuffer)object).append("SELECT").append(' ').append("VIEW_NAME").append(',').append(' ');
                ((StringBuffer)object).append("VIEW_TYPE").append(',').append(' ');
                ((StringBuffer)object).append("a.").append("VIEW_TYPE_OWNER").append(',').append(' ');
                ((StringBuffer)object).append("TYPECODE").append(',').append(' ');
                ((StringBuffer)object).append("SUPERTYPE_OWNER").append(',').append(' ');
                ((StringBuffer)object).append("SUPERTYPE_NAME").append(',').append(' ');
                ((StringBuffer)object).append("c.").append("COMMENTS").append(' ');
                ((StringBuffer)object).append("FROM").append(' ').append(this.dbaUser ? "dba_views" : "all_views").append(' ').append("a").append(',').append(' ');
                ((StringBuffer)object).append(this.dbaUser ? "dba_types" : "all_types").append(' ').append("b").append(',').append(' ');
                ((StringBuffer)object).append(this.dbaUser ? "dba_tab_comments" : "all_tab_comments").append(' ').append("c").append(' ');
                ((StringBuffer)object).append("WHERE").append(' ').append("a.").append("OWNER").append(' ').append('=').append(' ').append('?').append(' ');
                ((StringBuffer)object).append("AND").append(' ').append("a.").append("OWNER").append(' ').append('=').append(' ').append("c.").append("OWNER").append(' ');
                ((StringBuffer)object).append("AND").append(' ').append("a.").append("VIEW_NAME").append(' ').append('=').append(' ').append("c.").append("TABLE_NAME").append(' ');
                ((StringBuffer)object).append("AND").append(' ').append("a.").append("VIEW_TYPE_OWNER").append(' ').append('=').append(' ').append("b.").append("OWNER").append("(+)").append(' ');
                ((StringBuffer)object).append("AND").append(' ').append("a.").append("VIEW_TYPE").append(' ').append('=').append(' ').append("b.").append("TYPE_NAME").append("(+)").append(' ');
                ((StringBuffer)object).append("ORDER BY").append(' ').append("VIEW_NAME");
                string = ((StringBuffer)object).toString();
                statement = connection.prepareStatement(string);
            }
            object = null;
            try {
                statement.setString(1, dBObject.getName());
                object = statement.executeQuery();
            }
            catch (Exception exception) {
                LOGGER.error("MOHViewOracle.extract():", exception);
            }
            if (object == null) continue;
            while (object.next()) {
                string = object.getString(1);
                String string3 = object.getString(3);
                String string4 = object.getString(2);
                String string5 = object.getString("TYPECODE");
                String string6 = object.getString("SUPERTYPE_OWNER");
                String string7 = object.getString("SUPERTYPE_NAME");
                String string8 = object.getString("COMMENTS");
                DBObject dBObject2 = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), string, "VIEW", string2);
                dBObject2.setTypeName(string4);
                dBObject2.setTypeOwner(string3);
                dBObject2.setTypeCode(string5);
                dBObject2.setSuperTypeOwner(string6);
                dBObject2.setSuperTypeName(string7);
                dBObject2.setComments(string8);
                arrayList.add(dBObject2);
            }
            object.close();
        }
        if (statement != null) {
            statement.close();
        }
        return arrayList;
    }

    private void initViewTriggers(PreparedStatement preparedStatement, TableView tableView, String string) throws Exception {
        ResultSet resultSet = null;
        try {
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, tableView.getName());
            resultSet = preparedStatement.executeQuery();
        }
        catch (Exception exception) {
            LOGGER.error("MOHTableOracle.initTableConstraints():", exception);
        }
        if (resultSet != null) {
            StorageDesignOracle storageDesignOracle = (StorageDesignOracle)this.getStorageDesign();
            TableViewProxyOracle tableViewProxyOracle = (TableViewProxyOracle)storageDesignOracle.getTableViewProxySet().getProxy(tableView.getObjectID());
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                String string4 = resultSet.getString(4);
                String string5 = resultSet.getString(5);
                String string6 = resultSet.getString(6);
                String string7 = resultSet.getString(9);
                TriggerOracle triggerOracle = storageDesignOracle.getTriggerSet().createTrigger();
                UserOracle userOracle = (UserOracle)storageDesignOracle.getUserSet().getByName(string2);
                triggerOracle.setOwner(userOracle);
                triggerOracle.setName(string3);
                triggerOracle.setView(tableViewProxyOracle);
                this.stampModelObject((ModelObject)triggerOracle, tableViewProxyOracle, string3);
                triggerOracle.setTriggerTime("INSTEAD OF");
                if (string4.indexOf("INSERT") > -1) {
                    triggerOracle.setActions(Trigger.ACTION_TYPES[0]);
                }
                if (string4.indexOf("UPDATE") > -1) {
                    triggerOracle.setActions(Trigger.ACTION_TYPES[1]);
                }
                if (string4.indexOf("DELETE") > -1) {
                    triggerOracle.setActions(Trigger.ACTION_TYPES[2]);
                }
                String string8 = "NEW";
                String string9 = "OLD";
                String string10 = "PARENT";
                if (string5.indexOf("NEW AS") > -1 && !"NEW".equalsIgnoreCase(string8 = Token.getFirstToken(Token.getStringAfter(string5, "NEW AS")))) {
                    triggerOracle.setRef_NEW_AS(string8);
                }
                if (string5.indexOf("OLD AS") > -1 && !"OLD".equalsIgnoreCase(string9 = Token.getFirstToken(Token.getStringAfter(string5, "OLD AS")))) {
                    triggerOracle.setRef_OLD_AS(string9);
                }
                if (string5.indexOf("PARENT AS") > -1 && !"PARENT".equalsIgnoreCase(string10 = Token.getFirstToken(Token.getStringAfter(string5, "PARENT AS")))) {
                    triggerOracle.setRef_PARENT_AS(string10);
                }
                if (string6 != null) {
                    triggerOracle.setCondition(string6);
                }
                triggerOracle.setBody(string7);
            }
            resultSet.close();
        }
    }

    @Override
    public void postGenerateProcessing(Connection connection) {
        if (this.postProc != null) {
            TableViewSet tableViewSet = this.getDesign().getRelationalDesign().getTableViewSet();
            for (Temp temp : this.postProc) {
                TableView tableView = (TableView)tableViewSet.getByName(temp.superViewName);
                if (tableView == null || tableView == temp.tview) continue;
                TypeSubstitution typeSubstitution = this.getDesign().getRelationalDesign().createTypeSubstitution();
                ContainerView containerView = (ContainerView)temp.tview.getFirstViewForDPV(this.getDesign().getRelationalDesign().getMainView());
                ContainerView containerView2 = (ContainerView)tableView.getFirstViewForDPV(this.getDesign().getRelationalDesign().getMainView());
                typeSubstitution.setChildCV(containerView);
                typeSubstitution.setParentCV(containerView2);
                typeSubstitution.addToAllDPVs();
            }
            this.postProc.clear();
        }
    }

    class Temp {
        TableView tview;
        String superViewName;

        Temp() {
        }
    }
}

