/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.CollectionTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DirectoryOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TemporaryTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserSetOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHUserOracle
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "USER";
    private static final Logger LOGGER = new Logger(MOHUserOracle.class);
    protected boolean dbaUser;
    PreparedStatement objectPrivilegesStmt = null;
    PreparedStatement columnPrivilegesStmt = null;
    PreparedStatement directoryPrivilegesStmt = null;
    PreparedStatement systemPrivilegesStmt = null;
    PreparedStatement rolesStmt = null;

    public MOHUserOracle(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
        this.dbaUser = false;
    }

    public MOHUserOracle(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView, boolean bl) {
        super(abstractDBMExtractionHandler, applicationView);
        this.dbaUser = bl;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        boolean bl = true;
        Statement statement = null;
        this.systemPrivilegesStmt = null;
        this.rolesStmt = null;
        TreeMap<String, UserOracle> treeMap = new TreeMap<String, UserOracle>();
        for (int i = 0; i < list.size(); ++i) {
            UserOracle userOracle;
            DBObject dBObject = (DBObject)list.get(i);
            String string = dBObject.getSchema();
            StorageDesign storageDesign = this.getStorageDesign();
            if (string != null && !"".equals(string) && (userOracle = (UserOracle)treeMap.get(string)) == null) {
                if (storageDesign != null && storageDesign instanceof StorageDesignOracle && (userOracle = (UserOracle)((StorageDesignOracle)storageDesign).getUserSet().getByName(string)) == null) {
                    userOracle = ((StorageDesignOracle)storageDesign).getUserSet().createUser();
                    userOracle.setName(string);
                    this.stampModelObject((ModelObject)userOracle, "", string);
                }
                if (userOracle != null) {
                    treeMap.put(string, userOracle);
                }
            }
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObject.getType())) continue;
            if (OBJECT_TYPE.equalsIgnoreCase(dBObject.getType())) {
                string = dBObject.getName();
            }
            if (storageDesign != null && storageDesign instanceof StorageDesignOracle) {
                userOracle = (UserOracle)((StorageDesignOracle)storageDesign).getUserSet().getByName(string);
                if (bl) {
                    if (userOracle == null) {
                        userOracle = ((StorageDesignOracle)storageDesign).getUserSet().createUser();
                        userOracle.setName(string);
                        this.stampModelObject((ModelObject)userOracle, "", string);
                    }
                    ResultSet resultSet = null;
                    try {
                        if (statement == null) {
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("SELECT").append(' ');
                            stringBuffer.append(this.dbaUser ? "PASSWORD" : "NULL").append(' ').append("AS").append(' ').append("PASSWORD").append(',');
                            stringBuffer.append("DEFAULT_TABLESPACE").append(',');
                            stringBuffer.append("TEMPORARY_TABLESPACE").append(',');
                            stringBuffer.append(this.dbaUser ? "PROFILE" : "NULL").append(' ').append("AS").append(' ').append("PROFILE").append(',');
                            stringBuffer.append("EXTERNAL_NAME").append(' ');
                            stringBuffer.append("FROM").append(' ');
                            stringBuffer.append(this.dbaUser ? "dba_users" : "user_users").append(' ');
                            stringBuffer.append("WHERE").append(' ');
                            stringBuffer.append("USERNAME").append('=').append('?');
                            statement = connection.prepareStatement(stringBuffer.toString());
                        }
                        statement.setString(1, string);
                        resultSet = statement.executeQuery();
                    }
                    catch (SQLException sQLException) {
                        if (sQLException.getMessage().startsWith("ORA-00942")) {
                            bl = false;
                            System.out.println("MOHUserOracle.generate(): " + sQLException.getMessage());
                            LOGGER.error("MOHUserOracle.generate(): current connection user has no SELECT privilege on " + (this.dbaUser ? "dba_users" : "user_users"));
                        } else {
                            System.out.println("MOHUserOracle.generate(): " + sQLException.getMessage());
                            LOGGER.error("MOHUserOracle.generate():", sQLException);
                        }
                    }
                    catch (Exception exception) {
                        System.out.println("MOHUserOracle.generate(): " + exception.getMessage());
                        LOGGER.error("MOHUserOracle.generate():", exception);
                    }
                    if (resultSet != null) {
                        if (resultSet.next()) {
                            this.setProperties(userOracle, (StorageDesignOracle)storageDesign, resultSet);
                            this.setSystemPrivileges(userOracle, connection);
                            this.setRoles(userOracle, connection);
                        }
                        resultSet.close();
                    }
                }
                if (OBJECT_TYPE.equalsIgnoreCase(dBObject.getType())) {
                    this.stampModelObject(userOracle, dBObject);
                } else {
                    this.stampModelObject((ModelObject)userOracle, "", string);
                }
            } else {
                LOGGER.error("Unable to find Storage Design");
            }
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObject);
        }
        if (this.rolesStmt != null) {
            this.rolesStmt.close();
            this.rolesStmt = null;
        }
        if (this.systemPrivilegesStmt != null) {
            this.systemPrivilegesStmt.close();
            this.systemPrivilegesStmt = null;
        }
        if (statement != null) {
            statement.close();
        }
        treeMap.clear();
    }

    private void setProperties(UserOracle userOracle, StorageDesignOracle storageDesignOracle, ResultSet resultSet) throws Exception {
        AbstractStorageObjectOracle abstractStorageObjectOracle;
        String string = resultSet.getString("PASSWORD");
        String string2 = resultSet.getString("DEFAULT_TABLESPACE");
        String string3 = resultSet.getString("TEMPORARY_TABLESPACE");
        String string4 = resultSet.getString("PROFILE");
        String string5 = resultSet.getString("EXTERNAL_NAME");
        if (string != null) {
            if ("EXTERNAL".equalsIgnoreCase(string.trim())) {
                userOracle.setAuthType("EXTERNALLY");
            } else if ("GLOBAL".equalsIgnoreCase(string.trim())) {
                userOracle.setAuthType("GLOBALLY");
            }
        }
        if (string2 != null && !"".equalsIgnoreCase(string2) && (abstractStorageObjectOracle = (TableSpaceOracle)storageDesignOracle.getTableSpaceSet().getByName(string2)) != null) {
            userOracle.setDefTableSpace((TableSpaceOracle)abstractStorageObjectOracle);
        }
        if (string3 != null && !"".equalsIgnoreCase(string3) && (abstractStorageObjectOracle = (TemporaryTablespaceOracle)storageDesignOracle.getTemporaryTablespaceSet().getByName(string3)) != null) {
            userOracle.setTempTableSpace((TemporaryTablespaceOracle)abstractStorageObjectOracle);
        }
        if (string4 != null) {
            userOracle.setProfile(string4);
        }
        if (string5 != null) {
            userOracle.setExternalName(string5);
        }
    }

    private void setRoles(UserOracle userOracle, Connection connection) throws Exception {
        StorageDesign storageDesign = this.getStorageDesign();
        if (storageDesign != null && storageDesign instanceof StorageDesignOracle) {
            CharSequence charSequence;
            ResultSet resultSet = null;
            try {
                if (this.rolesStmt == null) {
                    charSequence = new StringBuffer();
                    ((StringBuffer)charSequence).append("SELECT");
                    ((StringBuffer)charSequence).append(' ').append("GRANTED_ROLE");
                    ((StringBuffer)charSequence).append(',').append("ADMIN_OPTION");
                    ((StringBuffer)charSequence).append(',').append("DEFAULT_ROLE");
                    ((StringBuffer)charSequence).append(' ').append("FROM").append(' ');
                    ((StringBuffer)charSequence).append(this.dbaUser ? "dba_role_privs" : "user_role_privs").append(' ');
                    ((StringBuffer)charSequence).append("WHERE").append(' ');
                    ((StringBuffer)charSequence).append(this.dbaUser ? "GRANTEE" : "USERNAME").append('=').append('?');
                    this.rolesStmt = connection.prepareStatement(((StringBuffer)charSequence).toString());
                }
                this.rolesStmt.setString(1, userOracle.getName());
                resultSet = this.rolesStmt.executeQuery();
            }
            catch (SQLException sQLException) {
                if (sQLException.getMessage().startsWith("ORA-00942")) {
                    System.out.println("MOHUserOracle.setRoles(): " + sQLException.getMessage());
                    LOGGER.error("MOHUserOracle.setRoles(): current connection user has no SELECT privilege on " + (this.dbaUser ? "dba_role_privs" : "user_role_privs"));
                } else {
                    System.out.println("MOHUserOracle.setRoles(): " + sQLException.getMessage());
                    LOGGER.error("MOHUserOracle.setRoles():", sQLException);
                }
            }
            catch (Exception exception) {
                LOGGER.error("MOHUserOracle.setRoles():", exception);
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    RoleOracle roleOracle;
                    charSequence = resultSet.getString("GRANTED_ROLE");
                    String string = resultSet.getString("ADMIN_OPTION");
                    if (charSequence == null || "".equalsIgnoreCase((String)charSequence) || (roleOracle = (RoleOracle)((StorageDesignOracle)storageDesign).getRoleSet().getByName((String)charSequence)) == null) continue;
                    if ("YES".equalsIgnoreCase(string)) {
                        userOracle.setRolesWithAdminOption(roleOracle.getObjectID());
                        continue;
                    }
                    userOracle.setRoles(roleOracle.getObjectID());
                }
                resultSet.close();
            }
        }
    }

    private void setSystemPrivileges(UserOracle userOracle, Connection connection) throws Exception {
        CharSequence charSequence;
        ResultSet resultSet = null;
        try {
            if (this.systemPrivilegesStmt == null) {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT").append(' ');
                ((StringBuffer)charSequence).append("PRIVILEGE").append(',');
                ((StringBuffer)charSequence).append("ADMIN_OPTION").append(' ');
                ((StringBuffer)charSequence).append("FROM").append(' ');
                ((StringBuffer)charSequence).append(this.dbaUser ? "dba_sys_privs" : "user_sys_privs").append(' ');
                ((StringBuffer)charSequence).append("WHERE").append(' ');
                ((StringBuffer)charSequence).append(this.dbaUser ? "GRANTEE" : "USERNAME").append('=').append('?');
                this.systemPrivilegesStmt = connection.prepareStatement(((StringBuffer)charSequence).toString());
            }
            this.systemPrivilegesStmt.setString(1, userOracle.getName());
            resultSet = this.systemPrivilegesStmt.executeQuery();
        }
        catch (SQLException sQLException) {
            if (sQLException.getMessage().startsWith("ORA-00942")) {
                System.out.println("MOHUserOracle.setSystemPrivileges(): " + sQLException.getMessage());
                LOGGER.error("MOHUserOracle.setSystemPrivileges(): current connection user has no SELECT privilege on " + (this.dbaUser ? "dba_sys_privs" : "user_sys_privs"));
            } else {
                System.out.println("MOHUserOracle.setSystemPrivileges(): " + sQLException.getMessage());
                LOGGER.error("MOHUserOracle.setSystemPrivileges():", sQLException);
            }
        }
        catch (Exception exception) {
            System.out.println("MOHUserOracle.setSystemPrivileges(): " + exception.getMessage());
            LOGGER.error("MOHUserOracle.setSystemPrivileges():", exception);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString("PRIVILEGE");
                String string = resultSet.getString("ADMIN_OPTION");
                if ("YES".equalsIgnoreCase(string)) {
                    userOracle.setPrivilegesWithAdminOption((String)charSequence);
                    continue;
                }
                userOracle.setPrivileges((String)charSequence);
            }
            resultSet.close();
        }
    }

    private void setObjectPrivileges(UserOracle userOracle, Connection connection) throws Exception {
        CharSequence charSequence;
        ResultSet resultSet = null;
        String string = userOracle.getName();
        try {
            if (this.objectPrivilegesStmt == null) {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT").append(' ');
                ((StringBuffer)charSequence).append(' ').append(this.dbaUser ? "OWNER" : "TABLE_SCHEMA").append(',');
                ((StringBuffer)charSequence).append("TABLE_NAME").append(',');
                ((StringBuffer)charSequence).append("PRIVILEGE").append(',');
                ((StringBuffer)charSequence).append("GRANTABLE").append(',');
                ((StringBuffer)charSequence).append("HIERARCHY").append(' ');
                ((StringBuffer)charSequence).append("FROM").append(' ');
                ((StringBuffer)charSequence).append(this.dbaUser ? "dba_tab_privs" : "all_tab_privs").append(' ');
                ((StringBuffer)charSequence).append("WHERE").append(' ');
                ((StringBuffer)charSequence).append("GRANTEE").append('=').append('?').append(' ');
                this.objectPrivilegesStmt = connection.prepareStatement(((StringBuffer)charSequence).toString());
            }
            this.objectPrivilegesStmt.setString(1, string);
            resultSet = this.objectPrivilegesStmt.executeQuery();
        }
        catch (SQLException sQLException) {
            if (sQLException.getMessage().startsWith("ORA-00942")) {
                System.out.println("MOHUserOracle.setObjectPrivileges(): " + sQLException.getMessage());
                LOGGER.error("MOHUserOracle.setObjectPrivileges(): current connection user has no SELECT privilege on " + (this.dbaUser ? "dba_tab_privs" : "all_tab_privs"));
            } else {
                System.out.println("MOHUserOracle.setObjectPrivileges(): " + sQLException.getMessage());
                LOGGER.error("MOHUserOracle.setObjectPrivileges():", sQLException);
            }
        }
        catch (Exception exception) {
            System.out.println("MOHUserOracle.setObjectPrivileges(): " + exception.getMessage());
            LOGGER.error("MOHUserOracle.setObjectPrivileges():", exception);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                ExternalTableSetOracle externalTableSetOracle;
                ExternalTableOracle externalTableOracle;
                ModelIDObject modelIDObject;
                charSequence = resultSet.getString(1);
                String string2 = resultSet.getString("TABLE_NAME");
                String string3 = resultSet.getString("PRIVILEGE");
                String string4 = resultSet.getString("GRANTABLE");
                String string5 = resultSet.getString("HIERARCHY");
                boolean bl = false;
                PermissionsOracle permissionsOracle = this.getPermissionPerObject(userOracle, string2, (String)charSequence);
                if (permissionsOracle == null) {
                    permissionsOracle = ((StorageDesignOracle)this.getStorageDesign()).getPermissionsSet().createPermissions();
                }
                permissionsOracle.setUser(userOracle);
                boolean bl2 = false;
                if (MOHUserOracle.isTableGrant(string3) && (modelIDObject = (TableProxyOracle)((TableProxySetOracle)this.getStorageDesign().getTableProxySet()).getByUserSchemaAndName((String)charSequence, string2)) != null) {
                    bl2 = true;
                    permissionsOracle.setTable((TableProxyOracle)modelIDObject);
                    bl = true;
                }
                if (!bl2 && MOHUserOracle.isViewGrant(string3) && (modelIDObject = (TableViewProxyOracle)((TableViewProxySetOracle)this.getStorageDesign().getTableViewProxySet()).getBySchemaAndName((String)charSequence, string2)) != null) {
                    bl2 = true;
                    permissionsOracle.setView((TableViewProxyOracle)modelIDObject);
                    bl = true;
                }
                if (!bl2 && MOHUserOracle.isSequenceGrant(string3) && (modelIDObject = (SequenceOracle)((StorageDesignOracle)this.getStorageDesign()).getSequenceSet().getByUserSchemaAndName((String)charSequence, string2)) != null) {
                    bl2 = true;
                    permissionsOracle.setSequence((SequenceOracle)modelIDObject);
                    bl = true;
                }
                if (!bl2 && MOHUserOracle.isStoredProcedureGrant(string3) && (modelIDObject = ((StorageDesignOracle)this.getStorageDesign()).getFunctionSet().getByOwnerAndName((String)charSequence, string2)) != null) {
                    bl2 = true;
                    permissionsOracle.setFunctionOracle((FunctionOracle)modelIDObject);
                    bl = true;
                }
                if (!bl2 && MOHUserOracle.isStoredProcedureGrant(string3) && (modelIDObject = ((StorageDesignOracle)this.getStorageDesign()).getPackageSet().getByOwnerAndName((String)charSequence, string2)) != null) {
                    bl2 = true;
                    permissionsOracle.setPackage((PackageOracle)modelIDObject);
                    bl = true;
                }
                if (!bl2 && MOHUserOracle.isStoredProcedureGrant(string3) && (modelIDObject = ((StorageDesignOracle)this.getStorageDesign()).getStoredProcedureSet().getByOwnerAndName((String)charSequence, string2)) != null) {
                    bl2 = true;
                    permissionsOracle.setProc((StoredProcedureOracle)modelIDObject);
                    bl = true;
                }
                if (!bl2 && MOHUserOracle.isCollectionTypeGrant(string3) && (modelIDObject = (CollectionTypeProxyOracle)((StorageDesignOracle)this.getStorageDesign()).getCollectionTypeProxySet().getByOwnerAndName((String)charSequence, string2)) != null) {
                    bl2 = true;
                    permissionsOracle.setCollectionTypeOracle((CollectionTypeProxyOracle)modelIDObject);
                    bl = true;
                }
                if (!bl2 && MOHUserOracle.isStructuredTypeGrant(string3) && (modelIDObject = (StructuredTypeProxyOracle)((StorageDesignOracle)this.getStorageDesign()).getStructuredTypeProxySet().getBySchemaAndName((String)charSequence, string2)) != null) {
                    bl2 = true;
                    permissionsOracle.setStructuredTypeOracle((StructuredTypeProxyOracle)modelIDObject);
                    bl = true;
                }
                if (!bl2 && MOHUserOracle.isExternalTableGrant(string3) && (externalTableOracle = (externalTableSetOracle = ((StorageDesignOracle)(modelIDObject = (StorageDesignOracle)this.getStorageDesign())).getExternalTableSet()).getByOwnerAndName((String)charSequence, string2)) != null) {
                    bl2 = true;
                    permissionsOracle.setExternalTableOracle(externalTableOracle);
                    bl = true;
                }
                if (!bl2 && MOHUserOracle.isDirectoryGrant(string3) && (modelIDObject = (DirectoryOracle)((StorageDesignOracle)this.getStorageDesign()).getDirectorySet().getByName(string2)) != null) {
                    permissionsOracle.setDirectoryOracle((DirectoryOracle)modelIDObject);
                    bl = true;
                }
                if (bl) {
                    if (string4.equals("YES")) {
                        permissionsOracle.setPrivilegesWithGrantOption(string3);
                    } else {
                        permissionsOracle.setPrivileges(string3);
                    }
                    if (string5.equals("YES")) {
                        permissionsOracle.setPrivilegesWithHierarchyOption(string3);
                    }
                    permissionsOracle.setUser(userOracle);
                    continue;
                }
                permissionsOracle.remove(true);
            }
            resultSet.close();
        }
    }

    private void setColumnPrivileges(UserOracle userOracle, Connection connection) throws Exception {
        ResultSet resultSet = null;
        String string = userOracle.getName();
        try {
            if (this.columnPrivilegesStmt == null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("SELECT").append(' ');
                stringBuffer.append(' ').append(this.dbaUser ? "OWNER" : "TABLE_SCHEMA").append(',');
                stringBuffer.append("TABLE_NAME").append(',');
                stringBuffer.append("COLUMN_NAME").append(',');
                stringBuffer.append("PRIVILEGE").append(',');
                stringBuffer.append("GRANTABLE").append(' ');
                stringBuffer.append("FROM").append(' ');
                stringBuffer.append(this.dbaUser ? "dba_col_privs" : "all_col_privs").append(' ').append("a").append(' ');
                stringBuffer.append("WHERE").append(' ');
                stringBuffer.append("GRANTEE").append('=').append('?').append(' ');
                this.columnPrivilegesStmt = connection.prepareStatement(stringBuffer.toString());
            }
            this.columnPrivilegesStmt.setString(1, string);
            resultSet = this.columnPrivilegesStmt.executeQuery();
        }
        catch (SQLException sQLException) {
            if (sQLException.getMessage().startsWith("ORA-00942")) {
                System.out.println("MOHUserOracle.setColumnPrivileges(): " + sQLException.getMessage());
                LOGGER.error("MOHUserOracle.setColumnPrivileges(): current connection user has no SELECT privilege on " + (this.dbaUser ? "dba_tab_privs" : "all_tab_privs"));
            } else {
                System.out.println("MOHUserOracle.setColumnPrivileges(): " + sQLException.getMessage());
                LOGGER.error("MOHUserOracle.setColumnPrivileges():", sQLException);
            }
        }
        catch (Exception exception) {
            System.out.println("MOHUserOracle.setColumnPrivileges(): " + exception.getMessage());
            LOGGER.error("MOHUserOracle.setColumnPrivileges():", exception);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                boolean bl = false;
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString("TABLE_NAME");
                String string4 = resultSet.getString("COLUMN_NAME");
                String string5 = resultSet.getString("PRIVILEGE");
                String string6 = resultSet.getString("GRANTABLE");
                String string7 = "";
                String string8 = "";
                string7 = string7.concat(string4);
                string8 = string8.concat(string4);
                PermissionsOracle permissionsOracle = this.getPermissionPerObject(userOracle, string3, string2);
                if (permissionsOracle == null) {
                    permissionsOracle = ((StorageDesignOracle)this.getStorageDesign()).getPermissionsSet().createPermissions();
                }
                permissionsOracle.setUser(userOracle);
                TableProxyOracle tableProxyOracle = (TableProxyOracle)((TableProxySetOracle)this.getStorageDesign().getTableProxySet()).getByUserSchemaAndName(string2, string3);
                if (tableProxyOracle != null) {
                    permissionsOracle.setColumnsTable(tableProxyOracle);
                }
                if (string6.equals("YES")) {
                    string8 = string8.concat(", ").concat(string5);
                } else {
                    string7 = string7.concat(", ").concat(string5);
                }
                if (string7.indexOf(",") > -1) {
                    permissionsOracle.setColumnList(string7);
                }
                if (string8.indexOf(",") > -1) {
                    permissionsOracle.setColumnListWithGrantOption(string8);
                }
                if (!bl) continue;
                permissionsOracle.setPrivileges(string5);
                permissionsOracle.setPrivilegesWithGrantOption(string6.equals("YES") ? string5 : "");
            }
        }
    }

    public static boolean isTableGrant(String string) {
        String[] stringArray = PermissionsOracle.getTablePrivilegesValues();
        Iterator<String> iterator = Arrays.asList(stringArray).iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().trim();
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isViewGrant(String string) {
        String[] stringArray = PermissionsOracle.getViewPrivilegesValues();
        Iterator<String> iterator = Arrays.asList(stringArray).iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().trim();
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSequenceGrant(String string) {
        String[] stringArray = PermissionsOracle.getSeqPrivilegesValues();
        Iterator<String> iterator = Arrays.asList(stringArray).iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().trim();
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDirectoryGrant(String string) {
        String[] stringArray = PermissionsOracle.getDirectoryPrivilegesValues();
        Iterator<String> iterator = Arrays.asList(stringArray).iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().trim();
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isStoredProcedureGrant(String string) {
        String[] stringArray = PermissionsOracle.getProcedurePrivilegesValues();
        Iterator<String> iterator = Arrays.asList(stringArray).iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().trim();
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCollectionTypeGrant(String string) {
        String[] stringArray = PermissionsOracle.getCollectionTypePrivilegesValues();
        Iterator<String> iterator = Arrays.asList(stringArray).iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().trim();
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isStructuredTypeGrant(String string) {
        String[] stringArray = PermissionsOracle.getStructuredTypePrivilegesValues();
        Iterator<String> iterator = Arrays.asList(stringArray).iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().trim();
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isExternalTableGrant(String string) {
        String[] stringArray = PermissionsOracle.getExtTablesPrivilegesValues();
        Iterator<String> iterator = Arrays.asList(stringArray).iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().trim();
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        CharSequence charSequence;
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append("USERNAME").append(' ');
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append(this.dbaUser ? "dba_users" : "all_users").append(' ');
            ((StringBuffer)charSequence).append("ORDER BY").append(' ').append("USERNAME");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (Exception exception) {
            LOGGER.error("MOHUserOracle.extract():", exception);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                DBObject dBObject = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, OBJECT_TYPE);
                arrayList.add(dBObject);
            }
            resultSet.close();
        }
        statement.close();
        return arrayList;
    }

    @Override
    public void postGenerateProcessing(Connection connection) {
        try {
            StorageDesign storageDesign = this.getStorageDesign();
            if (storageDesign != null && storageDesign instanceof StorageDesignOracle) {
                UserOracle userOracle;
                UserSetOracle userSetOracle = ((StorageDesignOracle)storageDesign).getUserSet();
                this.objectPrivilegesStmt = null;
                this.columnPrivilegesStmt = null;
                this.directoryPrivilegesStmt = null;
                for (Object object : this.handledObjects) {
                    if (object == null || (userOracle = (UserOracle)userSetOracle.getByName(((DBObject)object).getName())) == null) continue;
                    this.setObjectPrivileges(userOracle, connection);
                    this.setColumnPrivileges(userOracle, connection);
                    RelationalDesign relationalDesign = this.getDesign().getRelationalDesign();
                    SchemaObject schemaObject = (SchemaObject)relationalDesign.getSchemaObjectSet().getByName(userOracle.getName());
                    if (schemaObject == null) {
                        schemaObject = relationalDesign.getSchemaObjectSet().createSchemaObject(null);
                        schemaObject.setName(userOracle.getName());
                        this.stampModelObject((ModelObject)schemaObject, "", userOracle.getName());
                    }
                    userOracle.setSchemaObject(schemaObject);
                }
                if (this.objectPrivilegesStmt != null) {
                    this.objectPrivilegesStmt.close();
                    this.objectPrivilegesStmt = null;
                }
                if (this.columnPrivilegesStmt != null) {
                    this.columnPrivilegesStmt.close();
                    this.columnPrivilegesStmt = null;
                }
                if (this.directoryPrivilegesStmt != null) {
                    this.directoryPrivilegesStmt.close();
                    this.directoryPrivilegesStmt = null;
                }
                Iterator iterator = this.getDesign().getRelationalDesign().getSchemaObjectSet().iterator();
                while (iterator.hasNext()) {
                    Object object;
                    object = (SchemaObject)iterator.next();
                    userOracle = (UserOracle)userSetOracle.getByName(((DesignObject)object).getName());
                    if (userOracle == null) continue;
                    userOracle.setSchemaObject((SchemaObject)object);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private PermissionsOracle getPermissionPerObject(StorageObject storageObject, String string, String string2) {
        String string3 = string2 + ".";
        Iterator iterator = ((StorageDesignOracle)this.getStorageDesign()).getPermissionsSet().iterator();
        while (iterator.hasNext()) {
            PermissionsOracle permissionsOracle = (PermissionsOracle)iterator.next();
            if (permissionsOracle.getUser() != storageObject) continue;
            if (permissionsOracle.getTable() != null && permissionsOracle.getTable().getName().equals(string) && permissionsOracle.getTable().getLongName().startsWith(string3)) {
                return permissionsOracle;
            }
            if (permissionsOracle.getView() != null && permissionsOracle.getView().getName().equals(string) && permissionsOracle.getView().getLongName().startsWith(string3)) {
                return permissionsOracle;
            }
            if (permissionsOracle.getProc() != null && permissionsOracle.getProc().getName().equals(string)) {
                return permissionsOracle;
            }
            if (permissionsOracle.getFunctionOracle() != null && permissionsOracle.getFunctionOracle().getName().equals(string) && permissionsOracle.getFunctionOracle().getLongName().startsWith(string3)) {
                return permissionsOracle;
            }
            if (permissionsOracle.getPackage() != null && permissionsOracle.getPackage().getName().equals(string) && permissionsOracle.getPackage().getLongName().startsWith(string3)) {
                return permissionsOracle;
            }
            if (permissionsOracle.getSequence() != null && permissionsOracle.getSequence().getName().equals(string) && permissionsOracle.getSequence().getLongName().startsWith(string3)) {
                return permissionsOracle;
            }
            if (permissionsOracle.getSnapshot() != null && permissionsOracle.getSnapshot().getName().equals(string) && permissionsOracle.getSnapshot().getLongName().startsWith(string3)) {
                return permissionsOracle;
            }
            if (permissionsOracle.getDirectoryOracle() != null && permissionsOracle.getDirectoryOracle().getName().equals(string)) {
                return permissionsOracle;
            }
            if (permissionsOracle.getStructuredTypeOracle() != null && permissionsOracle.getStructuredTypeOracle().getName().equals(string) && permissionsOracle.getStructuredTypeOracle().getLongName().startsWith(string3)) {
                return permissionsOracle;
            }
            if (permissionsOracle.getCollectionTypeOracle() != null && permissionsOracle.getCollectionTypeOracle().getName().equals(string) && permissionsOracle.getCollectionTypeOracle().getLongName().startsWith(string3)) {
                return permissionsOracle;
            }
            if (permissionsOracle.getExternalTableOracle() != null && permissionsOracle.getExternalTableOracle().getName().equals(string) && permissionsOracle.getExternalTableOracle().getLongName().startsWith(string3)) {
                return permissionsOracle;
            }
            if (permissionsOracle.getColumnsTable() == null) continue;
            String string4 = string;
            String string5 = string;
            if (string.indexOf(".") > -1) {
                string4 = string.substring(0, string.indexOf("."));
                string5 = string.substring(string.indexOf(".") + 1, string.length());
            }
            if (!permissionsOracle.getColumnsTable().getName().equals(string4) || !permissionsOracle.getColumns().contains(string5) && !permissionsOracle.getColumnsWithGrantOption().contains(string5)) continue;
            return permissionsOracle;
        }
        return null;
    }
}

