/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TemporaryTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TemporaryTablespaceOraclev10g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHTempTableSpaceOracle
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "TEMP TABLESPACE";
    private static final Logger LOGGER = new Logger(MOHTempTableSpaceOracle.class);
    protected boolean dbaUser;

    public MOHTempTableSpaceOracle(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
        this.dbaUser = false;
    }

    public MOHTempTableSpaceOracle(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView, boolean bl) {
        super(abstractDBMExtractionHandler, applicationView);
        this.dbaUser = bl;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        CharSequence charSequence;
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append("TABLESPACE_NAME").append(' ');
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append(this.dbaUser ? "dba_tablespaces" : "user_tablespaces").append(' ');
            ((StringBuffer)charSequence).append("WHERE").append(' ');
            ((StringBuffer)charSequence).append("TABLESPACE_NAME").append(' ');
            ((StringBuffer)charSequence).append("NOT").append(' ').append("IN").append(' ');
            ((StringBuffer)charSequence).append('(').append('\'');
            ((StringBuffer)charSequence).append("SYSTEM").append('\'').append(')').append(' ');
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("CONTENTS").append('=').append('\'');
            ((StringBuffer)charSequence).append("TEMPORARY").append('\'').append(' ');
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("EXTENT_MANAGEMENT").append('=').append('\'');
            ((StringBuffer)charSequence).append("LOCAL").append('\'').append(' ');
            ((StringBuffer)charSequence).append("ORDER BY").append(' ');
            ((StringBuffer)charSequence).append("TABLESPACE_NAME");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (Exception exception) {
            System.out.println("MOHTempTableSpaceOracle.extract(): " + exception.getMessage());
            LOGGER.error("MOHTempTableSpaceOracle.extract():", exception);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                DBObject dBObject = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, OBJECT_TYPE);
                arrayList.add(dBObject);
            }
            resultSet.close();
        }
        statement.close();
        return arrayList;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        StorageDesign storageDesign = this.getStorageDesign();
        Statement statement = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT").append(' ');
        stringBuffer.append("INITIAL_EXTENT");
        if (storageDesign instanceof StorageDesignOraclev10g) {
            stringBuffer.append(',');
            stringBuffer.append("BIGFILE");
        }
        stringBuffer.append(' ');
        stringBuffer.append("FROM").append(' ');
        stringBuffer.append(this.dbaUser ? "dba_tablespaces" : "user_tablespaces").append(' ');
        stringBuffer.append("WHERE").append(' ');
        stringBuffer.append("TABLESPACE_NAME").append(' ').append('=').append(' ').append('?').append(' ');
        stringBuffer.append("AND").append(' ');
        stringBuffer.append("CONTENTS").append('=').append('\'');
        stringBuffer.append("TEMPORARY").append('\'').append(' ');
        stringBuffer.append("AND").append(' ');
        stringBuffer.append("EXTENT_MANAGEMENT").append('=').append('\'');
        stringBuffer.append("LOCAL").append('\'');
        for (int i = 0; i < list.size(); ++i) {
            DBObject dBObject = (DBObject)list.get(i);
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObject.getType())) continue;
            ResultSet resultSet = null;
            try {
                if (statement == null) {
                    statement = connection.prepareStatement(stringBuffer.toString());
                }
                statement.setString(1, dBObject.getName());
                resultSet = statement.executeQuery();
            }
            catch (Exception exception) {
                System.out.println("MOHTempTableSpaceOracle.generate(): " + exception.getMessage());
                LOGGER.error("MOHTempTableSpaceOracle.generate():", exception);
            }
            if (resultSet != null) {
                if (resultSet.next()) {
                    if (storageDesign instanceof StorageDesignOracle) {
                        long l;
                        TemporaryTablespaceOracle temporaryTablespaceOracle = ((StorageDesignOracle)storageDesign).getTemporaryTablespaceSet().createTemporaryTablespace();
                        temporaryTablespaceOracle.setName(dBObject.getName());
                        String string = resultSet.getString("INITIAL_EXTENT");
                        try {
                            l = Long.parseLong(string);
                        }
                        catch (Exception exception) {
                            LOGGER.error("MOHTempTableSpaceOracle.generate(): Error parsing \"INITIAL_EXTENT\" - " + string);
                            l = 1024L;
                        }
                        if (l % 1024L == 0L) {
                            temporaryTablespaceOracle.setUniformSize(l / 1024L);
                            temporaryTablespaceOracle.setMeasureUnitUniformSize("K");
                        } else {
                            temporaryTablespaceOracle.setUniformSize(l);
                            temporaryTablespaceOracle.setMeasureUnitUniformSize("");
                        }
                        if (temporaryTablespaceOracle instanceof TemporaryTablespaceOraclev10g) {
                            String string2 = resultSet.getString("BIGFILE");
                            if ("YES".equals(string2)) {
                                ((TemporaryTablespaceOraclev10g)temporaryTablespaceOracle).setFileType(TemporaryTablespaceOraclev10g.BIGFILE);
                            } else if ("NO".equals(string2)) {
                                ((TemporaryTablespaceOraclev10g)temporaryTablespaceOracle).setFileType(TemporaryTablespaceOraclev10g.SMALLFILE);
                            }
                        }
                        this.stampModelObject(temporaryTablespaceOracle, dBObject);
                    } else {
                        LOGGER.error("Unable to find Storage Design!");
                    }
                }
                resultSet.close();
            }
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObject);
        }
        if (statement != null) {
            statement.close();
        }
    }
}

