/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBMExtractionController;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.MOHTable;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.ConstraintType;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterColumnOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionLobItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionsListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListStorageTemplatePartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexProperties;
import oracle.dbtools.crest.model.design.storage.oracle.PKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RollbackSegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UniqueOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionsListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ListPartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.LobStorageOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionListOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.TableProxyOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PKProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UniqueOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;
import oracle.sql.ARRAY;
import oracle.sql.Datum;
import oracle.sql.STRUCT;

public abstract class MOHTableOracle
extends MOHTable {
    private boolean isPartitioned;
    private boolean containsClusterRefs;
    private boolean containsXMLTypeTables;
    private static final Logger LOGGER = new Logger(MOHTableOracle.class);
    private final String NOT_NULL_PATTERN = "\" IS NOT NULL";
    private final Map ukMap = new TreeMap();
    private final List fkTempList = new ArrayList();
    public static final String NEW_AS = "NEW AS";
    public static final String OLD_AS = "OLD AS";
    public static final String PARENT_AS = "PARENT AS";
    public final String DESC = "DESC";
    protected boolean dbaUser;
    private PreparedStatement indexp_st = null;
    private PreparedStatement indspat_st = null;
    private PreparedStatement indpartype_st = null;
    private PreparedStatement indglobpartcols_st = null;
    private PreparedStatement indpart_st = null;
    PreparedStatement part_statement = null;
    PreparedStatement partLS_statement = null;
    PreparedStatement subpartCol_statement = null;
    PreparedStatement subpartTemplate_statement = null;
    PreparedStatement subPart_statement = null;
    PreparedStatement subPartLS_statement = null;
    PreparedStatement subPartListLS_statement = null;
    String CWD_TS_TAB_META = "<cwd_ts_tab ";
    String CWD_TS_COLUMN_META = "<cwd_ts_column ";

    public MOHTableOracle(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
        this.dbaUser = false;
    }

    public MOHTableOracle(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView, boolean bl) {
        super(abstractDBMExtractionHandler, applicationView);
        this.dbaUser = bl;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        TimeLog.log("Tables begin");
        this.containsClusterRefs = false;
        this.containsXMLTypeTables = false;
        this.ukMap.clear();
        this.fkTempList.clear();
        StorageDesign storageDesign = this.getStorageDesign();
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT").append(' ');
        stringBuffer.append("a.").append("OWNER").append(',');
        stringBuffer.append("a.").append("TABLE_NAME").append(',');
        stringBuffer.append("TABLESPACE_NAME").append(',');
        stringBuffer.append("CLUSTER_NAME").append(',');
        stringBuffer.append("IOT_NAME").append(',');
        stringBuffer.append("PCT_FREE").append(',');
        stringBuffer.append("PCT_USED").append(',');
        stringBuffer.append("INI_TRANS").append(',');
        stringBuffer.append("MAX_TRANS").append(',');
        stringBuffer.append("INITIAL_EXTENT").append(',');
        stringBuffer.append("NEXT_EXTENT").append(',');
        stringBuffer.append("MIN_EXTENTS").append(',');
        stringBuffer.append("MAX_EXTENTS").append(',');
        stringBuffer.append("PCT_INCREASE").append(',');
        stringBuffer.append("FREELISTS").append(',');
        stringBuffer.append("FREELIST_GROUPS").append(',');
        stringBuffer.append("LOGGING").append(',');
        stringBuffer.append("DEGREE").append(',');
        stringBuffer.append("INSTANCES").append(',');
        stringBuffer.append("CACHE").append(',');
        stringBuffer.append("TABLE_LOCK").append(',');
        stringBuffer.append("PARTITIONED").append(',');
        stringBuffer.append("IOT_TYPE").append(',');
        stringBuffer.append("OBJECT_ID_TYPE").append(',');
        stringBuffer.append("TABLE_TYPE_OWNER").append(',');
        stringBuffer.append("a.").append("TABLE_TYPE").append(',');
        stringBuffer.append("TEMPORARY").append(',');
        stringBuffer.append("DURATION").append(',');
        stringBuffer.append("SECONDARY").append(',');
        stringBuffer.append("NESTED").append(',');
        stringBuffer.append("BUFFER_POOL").append(',');
        stringBuffer.append("ROW_MOVEMENT").append(',');
        if (storageDesign instanceof StorageDesignOraclev9i) {
            stringBuffer.append("MONITORING").append(',');
        } else {
            stringBuffer.append("COMPRESSION").append(',');
            stringBuffer.append("DEPENDENCIES").append(',');
        }
        stringBuffer.append("COMMENTS").append(' ');
        stringBuffer.append("FROM").append(' ');
        stringBuffer.append(this.dbaUser ? "dba_all_tables" : "all_all_tables").append(' ').append("a").append(',');
        stringBuffer.append(this.dbaUser ? "dba_tab_comments" : "all_tab_comments").append(' ').append("b").append(' ');
        stringBuffer.append("WHERE").append(' ');
        stringBuffer.append("a.").append("OWNER").append('=').append(' ');
        stringBuffer.append('?').append(' ');
        stringBuffer.append("AND").append(' ');
        stringBuffer.append("a.").append("TABLE_NAME").append('=').append(' ');
        stringBuffer.append('?').append(' ');
        stringBuffer.append("AND").append(' ');
        stringBuffer.append("a.").append("OWNER").append('=').append("b.").append("OWNER").append(' ').append("(+)").append(' ');
        stringBuffer.append("AND").append(' ');
        stringBuffer.append("a.").append("TABLE_NAME").append('=').append("b.").append("TABLE_NAME").append(' ').append("(+)").append(' ');
        stringBuffer.append("ORDER BY").append(' ').append("OWNER").append(',');
        stringBuffer.append("TABLE_NAME");
        String string = stringBuffer.toString();
        Statement statement = null;
        for (int i = 0; i < list.size(); ++i) {
            DBObject dBObject = (DBObject)list.get(i);
            String string2 = dBObject.getSchema();
            String string3 = dBObject.getName();
            if (!"TABLE".equalsIgnoreCase(dBObject.getType())) continue;
            this.isPartitioned = false;
            ResultSet resultSet = null;
            try {
                if (statement == null) {
                    statement = connection.prepareStatement(string);
                }
                statement.setString(1, string2);
                statement.setString(2, string3);
                resultSet = statement.executeQuery();
                Table table = null;
                TableProxyOracle tableProxyOracle = null;
                if (resultSet == null) continue;
                while (resultSet.next()) {
                    table = this.getDesign().getRelationalDesign().createTable();
                    table.setSchema(dBObject.getSchema());
                    table.setName(dBObject.getName());
                    String string4 = resultSet.getString("COMMENTS");
                    if (string4 != null) {
                        table.setCommentInRDBMS(string4);
                    }
                    dBObject.setTable(table);
                    arrayList.add(dBObject);
                    this.stampModelObject(table, dBObject);
                    this.initObjectType(table, resultSet.getString("TABLE_TYPE_OWNER"), resultSet.getString("TABLE_TYPE"), resultSet.getString("OBJECT_ID_TYPE"), dBObject);
                    if (storageDesign != null && storageDesign instanceof StorageDesignOracle) {
                        tableProxyOracle = (TableProxyOracle)storageDesign.getTableProxySet().getProxy(table.getObjectID());
                        dBObject.setTableProxy(tableProxyOracle);
                        if (tableProxyOracle != null) {
                            tableProxyOracle.setName(dBObject.getName());
                            if (table.getSchemaObject() == null) {
                                this.setUser(tableProxyOracle, (StorageDesignOracle)storageDesign, dBObject.getSchema());
                            }
                            this.setTableSpace(tableProxyOracle, (StorageDesignOracle)storageDesign, resultSet.getString("TABLESPACE_NAME"));
                            this.setCluster(tableProxyOracle, (StorageDesignOracle)storageDesign, resultSet);
                            this.setProperties(tableProxyOracle, (StorageDesignOracle)storageDesign, resultSet);
                        } else {
                            LOGGER.error("Unable to find TableProxy for table ID: " + table.getObjectID());
                        }
                    } else {
                        LOGGER.error("Unable to find Storage Design!");
                    }
                    if (this.isPartitioned && tableProxyOracle != null) {
                        dBObject.partitioned = true;
                    }
                    importLogger.incrementImportedStatements();
                    this.addToHandledObjects(dBObject);
                }
                resultSet.close();
                continue;
            }
            catch (Exception exception) {
                LOGGER.error("MOHTableOracle.generate():", exception);
            }
        }
        if (statement != null) {
            statement.close();
        }
        TimeLog.log("End Tables");
        if (arrayList.size() == 0) {
            return;
        }
        if (this.containsXMLTypeTables) {
            this.initXMLTypeTables(connection, arrayList);
            TimeLog.log("End XMLType Tables");
        }
        this.initColumns(connection, arrayList);
        TimeLog.log("End Columns");
        if (this.containsClusterRefs) {
            this.initClusterColumns(connection, arrayList);
            TimeLog.log("End Cluster Columns");
        }
        if (this.getDbmeHandler().isSpatialProperties()) {
            this.initSpatialTable(connection, arrayList);
            TimeLog.log("End Spatial");
        }
        this.addSnapshot(connection, arrayList);
        TimeLog.log("End Snapshot");
        this.initIndexes(connection, arrayList);
        TimeLog.log("End Indexes");
        this.initUK_PK_FK_CHECK_Constraints(connection, arrayList, this.ukMap, this.fkTempList);
        TimeLog.log("End Constraints");
        this.initTableTriggers(connection, arrayList);
        TimeLog.log("End Triggers");
        this.createFKeys(this.fkTempList, this.ukMap);
        this.fkTempList.clear();
        this.ukMap.clear();
        TimeLog.log("End FKeys");
        this.setPartitionInfo(connection, (StorageDesignOracle)storageDesign, arrayList);
        this.setIndexPartitioning(connection, (StorageDesignOracle)storageDesign, arrayList);
        TimeLog.log("End Partitions");
        this.setTableLobStorage((StorageDesignOracle)storageDesign, connection, arrayList);
        this.setTablePartLobStorage((StorageDesignOracle)storageDesign, connection, arrayList);
        TimeLog.log("End Lob Storage");
        TimeLog.log("Tables end");
    }

    private void addSnapshot(Connection connection, List list) throws SQLException {
        Statement statement = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT").append(' ').append("QUERY").append(',').append(' ');
        stringBuffer.append("UPDATABLE").append(',').append(' ');
        stringBuffer.append("MASTER_ROLLBACK_SEG").append(',').append(' ');
        stringBuffer.append("REWRITE_ENABLED").append(',').append(' ');
        stringBuffer.append("REFRESH_MODE").append(',').append(' ');
        stringBuffer.append("REFRESH_METHOD").append(',').append(' ');
        stringBuffer.append("BUILD_MODE").append(',').append(' ');
        stringBuffer.append("FAST_REFRESHABLE").append(',').append(' ');
        stringBuffer.append("UNKNOWN_PREBUILT").append(',').append(' ');
        stringBuffer.append("USE_NO_INDEX").append(' ');
        stringBuffer.append("FROM").append(' ').append(this.dbaUser ? "dba_mviews" : "all_mviews").append(' ');
        stringBuffer.append("WHERE").append(' ').append("OWNER").append(' ').append('=').append(' ').append('?').append(' ');
        stringBuffer.append("AND").append(' ').append("MVIEW_NAME").append(' ').append('=').append(' ').append('?').append(' ');
        String string = stringBuffer.toString();
        Statement statement2 = null;
        for (DBObject dBObject : list) {
            TableProxyOracle tableProxyOracle = (TableProxyOracle)dBObject.getTableProxy();
            ResultSet resultSet = null;
            try {
                if (statement2 == null) {
                    statement2 = connection.prepareStatement(string);
                }
                statement2.setString(1, dBObject.getSchema());
                statement2.setString(2, tableProxyOracle.getName());
                resultSet = statement2.executeQuery();
                if (resultSet == null) continue;
                if (resultSet.next()) {
                    Object object;
                    StorageDesignOracle storageDesignOracle = (StorageDesignOracle)this.getStorageDesign();
                    SnapshotOracle snapshotOracle = storageDesignOracle.getSnapshotSet().createSnapshot();
                    snapshotOracle.setName(tableProxyOracle.getName());
                    snapshotOracle.setUser(tableProxyOracle.getUser());
                    tableProxyOracle.setSnapshot(snapshotOracle);
                    this.stampModelObject((ModelObject)snapshotOracle, dBObject.getSchema(), tableProxyOracle.getName());
                    ((Table)tableProxyOracle.getObject()).setTypeID(storageDesignOracle.getDesign().getDLSettings().getClassificationTypeByName(ContainerObject.TYPE_SUMMARY).getTypeID());
                    String string2 = resultSet.getString(1);
                    String string3 = resultSet.getString(2);
                    String string4 = resultSet.getString(3);
                    String string5 = resultSet.getString(4);
                    String string6 = resultSet.getString(5);
                    String string7 = resultSet.getString(6);
                    String string8 = resultSet.getString(7);
                    String string9 = resultSet.getString(10);
                    snapshotOracle.setSubquery(string2);
                    Table table = (Table)tableProxyOracle.getObject();
                    if (table != null && table.getPK() == null) {
                        object = table.getKeys();
                        Object object2 = null;
                        for (int i = 0; i < ((KeyObject[])object).length; ++i) {
                            Index index = (Index)object[i];
                            if ("".equals(index.getIndexExpression()) || !"M_ROW$$".equalsIgnoreCase(index.getIndexExpression().trim())) continue;
                            object2 = object[i];
                            break;
                        }
                        if (object2 != null) {
                            snapshotOracle.setWith("ROWID");
                            ((KeyObject)object2).remove();
                        }
                    }
                    if ("N".equals(string3)) {
                        snapshotOracle.setForUpdate("NO");
                    } else {
                        snapshotOracle.setForUpdate("YES");
                    }
                    if (string4 != null && "".equals(string4)) {
                        object = (RollbackSegmentOracle)storageDesignOracle.getRollbackSegmentSet().getByName(string4);
                        if (object == null) {
                            object = storageDesignOracle.getRollbackSegmentSet().createRollbackSegment();
                            ((StorageObject)object).setName(string4);
                            this.stampModelObject((ModelObject)snapshotOracle, dBObject.getSchema(), string4);
                        }
                        if (object != null) {
                            snapshotOracle.setRollbackSegment((RollbackSegmentOracle)object);
                        }
                    }
                    if ("N".equalsIgnoreCase(string5)) {
                        snapshotOracle.setQueryRewrite("DISABLE");
                    } else {
                        snapshotOracle.setQueryRewrite("ENABLE");
                    }
                    if ("N".equals(string9)) {
                        snapshotOracle.setUseIndex("YES");
                    } else {
                        snapshotOracle.setUseIndex("NO");
                    }
                    if ("NEVER".equalsIgnoreCase(string6)) {
                        snapshotOracle.setRefresh("NEVER");
                    } else {
                        snapshotOracle.setRefresh("YES");
                        snapshotOracle.setRefreshType(string7);
                        snapshotOracle.setAction("ON " + string6);
                    }
                    if (string8.equalsIgnoreCase("PREBUILT")) {
                        tableProxyOracle.setSnapshot(null);
                        snapshotOracle.setOnPrebuildTable(tableProxyOracle);
                    } else {
                        snapshotOracle.setBuild(string8);
                    }
                    if (statement == null) {
                        stringBuffer = new StringBuffer();
                        stringBuffer.append("SELECT").append(' ').append("CONTAINER_COLUMN").append(',').append(' ');
                        stringBuffer.append("AGG_FUNCTION").append(',').append(' ');
                        stringBuffer.append("MEASURE").append(' ');
                        stringBuffer.append("FROM").append(' ').append(this.dbaUser ? "dba_mview_aggregates" : "all_mview_aggregates").append(' ');
                        stringBuffer.append("WHERE").append(' ').append("OWNER").append(' ').append('=').append(' ').append('?').append(' ');
                        stringBuffer.append("AND").append(' ').append("MVIEW_NAME").append(' ').append('=').append(' ').append('?').append(' ');
                        object = stringBuffer.toString();
                        statement = connection.prepareStatement((String)object);
                    }
                    this.addSnapshotAggregates((PreparedStatement)statement, tableProxyOracle);
                }
                resultSet.close();
            }
            catch (Exception exception) {
                LOGGER.error("MOHTableOracle.addSnapshot():", exception);
            }
        }
        if (statement != null) {
            statement.close();
        }
        if (statement2 != null) {
            statement2.close();
        }
    }

    private void addSnapshotAggregates(PreparedStatement preparedStatement, TableProxyOracle tableProxyOracle) throws SQLException {
        String string = tableProxyOracle.getOwnerName();
        ResultSet resultSet = null;
        try {
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, tableProxyOracle.getName());
            resultSet = preparedStatement.executeQuery();
        }
        catch (Exception exception) {
            LOGGER.error("MOHTableOracle.addSnapshotAggregates():", exception);
        }
        if (resultSet != null) {
            Table table = (Table)tableProxyOracle.getObject();
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                String string4 = resultSet.getString(3);
                Column column = (Column)table.getElementByName(string2);
                if (column == null) continue;
                column.setSourceType("Aggregate");
                column.setFormulaDesc(string3 + "(" + string4 + ")");
            }
            resultSet.close();
        }
    }

    private void initSpatialTable(Connection connection, List list) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT").append(' ').append("OWNER").append(',').append(' ');
        stringBuffer.append("TABLE_NAME").append(',').append(' ');
        stringBuffer.append("COLUMN_NAME").append(',').append(' ');
        stringBuffer.append("DIMINFO").append(',').append(' ');
        stringBuffer.append("SRID").append(' ');
        stringBuffer.append("FROM").append(' ').append("all_sdo_geom_metadata").append(' ');
        stringBuffer.append("WHERE").append(' ').append("OWNER").append(' ').append('=').append(' ').append('?').append(' ');
        stringBuffer.append("AND").append(' ').append("TABLE_NAME").append(' ').append('=').append(' ').append('?').append(' ');
        String string = stringBuffer.toString();
        Statement statement = null;
        for (DBObject dBObject : list) {
            Table table = dBObject.getTable();
            String string2 = dBObject.getSchema();
            ResultSet resultSet = null;
            try {
                if (statement == null) {
                    statement = connection.prepareStatement(string);
                }
                statement.setString(1, string2);
                statement.setString(2, table.getName());
                resultSet = statement.executeQuery();
                if (resultSet == null) continue;
                while (resultSet.next()) {
                    Object object;
                    String string3 = resultSet.getString("TABLE_NAME");
                    String string4 = resultSet.getString("COLUMN_NAME");
                    if (string3.equals("")) continue;
                    table.setSpatialTable(true);
                    SpatialColumnDefObject spatialColumnDefObject = new SpatialColumnDefObject(table);
                    table.addSpatialDefinition(spatialColumnDefObject);
                    ARRAY aRRAY = (ARRAY)resultSet.getObject("DIMINFO");
                    Datum[] datumArray = aRRAY.getOracleArray();
                    for (int i = 0; i < datumArray.length; ++i) {
                        object = (STRUCT)datumArray[i];
                        Object[] objectArray = object.getAttributes();
                        SpatialColumnDefObject.TableDimension tableDimension = new SpatialColumnDefObject.TableDimension(spatialColumnDefObject);
                        tableDimension.setName(objectArray[0].toString());
                        tableDimension.setLowBoundary(objectArray[1].toString());
                        tableDimension.setUpperBoundary(objectArray[2].toString());
                        tableDimension.setTolerance(objectArray[3].toString());
                    }
                    String string5 = resultSet.getString("SRID");
                    if (string5 != null) {
                        spatialColumnDefObject.setSystemID(string5);
                    }
                    if ((object = (Column)table.getElementByName(string4)) != null) {
                        spatialColumnDefObject.setSpatialColumn((Column)object);
                        continue;
                    }
                    spatialColumnDefObject.setFunction(true);
                    spatialColumnDefObject.setFuncExpression(string4);
                }
                resultSet.close();
            }
            catch (Exception exception) {
                LOGGER.error("MOHTableOracle.initSpatialTable():", exception);
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initObjectType(Table table, String string, String string2, String string3, DBObject dBObject) {
        StructuredTypeProxyOracle structuredTypeProxyOracle;
        if (string2 != null && (structuredTypeProxyOracle = ((StructuredTypeProxySetOracle)this.getStorageDesign().getStructuredTypeProxySet()).getByLongName(string2, string)) != null && structuredTypeProxyOracle.getStructuredType() != null) {
            table.setBasedOnStructuredType(structuredTypeProxyOracle.getStructuredType());
            table.setOidIsPK("USER-DEFINED".equals(string3));
            if (string2.equalsIgnoreCase("XMLTYPE")) {
                this.containsXMLTypeTables = true;
            }
        }
    }

    protected void initXMLTypeTables(Connection connection, List list) throws Exception {
        boolean bl = this.getStorageDesign() instanceof StorageDesignOraclev11g;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT").append(' ');
        stringBuffer.append("XMLSCHEMA").append(',');
        stringBuffer.append("ELEMENT_NAME").append(',');
        stringBuffer.append("STORAGE_TYPE");
        if (bl) {
            stringBuffer.append(',');
            stringBuffer.append("ANYSCHEMA").append(',');
            stringBuffer.append("NONSCHEMA");
        }
        stringBuffer.append(' ');
        stringBuffer.append("FROM").append(' ');
        stringBuffer.append(this.dbaUser ? "dba_xml_tables" : "all_xml_tables").append(' ');
        stringBuffer.append("WHERE").append(' ');
        stringBuffer.append("OWNER").append('=').append(' ').append('?').append(' ');
        stringBuffer.append("AND").append(' ');
        stringBuffer.append("TABLE_NAME").append('=').append(' ').append('?').append(' ');
        String string = stringBuffer.toString();
        Statement statement = null;
        for (DBObject dBObject : list) {
            TableProxyOracle tableProxyOracle;
            Table table = dBObject.getTable();
            StructuredType structuredType = table.getBasedOnStructuredType();
            if (structuredType == null || !structuredType.getName().equalsIgnoreCase("XMLTYPE") || (tableProxyOracle = (TableProxyOracle)this.getStorageDesign().getTableProxySet().getProxy(table.getObjectID())) == null) continue;
            ResultSet resultSet = null;
            try {
                if (statement == null) {
                    statement = connection.prepareStatement(string);
                }
                statement.setString(1, dBObject.getSchema());
                statement.setString(2, table.getName());
                resultSet = statement.executeQuery();
            }
            catch (Exception exception) {
                LOGGER.error("MOHTableOraclev9i.initXMLTypeTables():", exception);
            }
            if (resultSet == null) continue;
            if (resultSet.next()) {
                String string2 = resultSet.getString("XMLSCHEMA");
                String string3 = resultSet.getString("ELEMENT_NAME");
                String string4 = resultSet.getString("STORAGE_TYPE");
                String string5 = null;
                String string6 = null;
                if (bl) {
                    string5 = resultSet.getString("ANYSCHEMA");
                    string6 = resultSet.getString("NONSCHEMA");
                }
                if (string2 != null) {
                    tableProxyOracle.setXmlSchemaUrl(string2);
                }
                if (string3 != null) {
                    tableProxyOracle.setXmlSchemaElement(string3);
                }
                if (string4 != null) {
                    if (string4.equals("BINARY")) {
                        string4 = "BINARY XML";
                    } else if (string4.equals("OBJECT-RELATIONAL")) {
                        string4 = "OBJECT RELATIONAL";
                    }
                    tableProxyOracle.setStoreAs(string4);
                }
                if (string5 != null) {
                    ((TableProxyOraclev11g)tableProxyOracle).setAllowAnySchema(string5);
                }
                if (string6 != null) {
                    ((TableProxyOraclev11g)tableProxyOracle).setAllowNonSchema(string6);
                }
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initUK_PK_FK_CHECK_Constraints(Connection connection, List list, Map map, List list2) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        StorageDesignOracle storageDesignOracle = (StorageDesignOracle)this.getStorageDesign();
        stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT").append(' ');
        stringBuffer.append("CONSTRAINT_NAME").append(',');
        stringBuffer.append("COLUMN_NAME").append(',');
        stringBuffer.append("POSITION").append(' ');
        stringBuffer.append("FROM").append(' ').append(this.dbaUser ? "dba_cons_columns" : "all_cons_columns").append(' ');
        stringBuffer.append("WHERE").append(' ').append("OWNER").append(' ').append('=').append(' ').append('?').append(' ');
        stringBuffer.append("AND").append(' ').append("TABLE_NAME").append(' ').append('=').append(' ').append('?').append(' ');
        stringBuffer.append("ORDER BY").append(' ').append("CONSTRAINT_NAME").append(',').append("POSITION").append(',').append("COLUMN_NAME");
        String string = stringBuffer.toString();
        Statement statement = null;
        stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT").append(' ');
        stringBuffer.append("CONSTRAINT_NAME").append(',').append(' ');
        stringBuffer.append("CONSTRAINT_TYPE").append(',').append(' ');
        stringBuffer.append("DEFERRED").append(',').append(' ');
        stringBuffer.append("STATUS").append(',').append(' ');
        stringBuffer.append("DEFERRABLE").append(',').append(' ');
        stringBuffer.append("VALIDATED").append(',').append(' ');
        stringBuffer.append("SEARCH_CONDITION").append(',').append(' ');
        stringBuffer.append("R_OWNER").append(',').append(' ');
        stringBuffer.append("R_CONSTRAINT_NAME").append(',').append(' ');
        stringBuffer.append("DELETE_RULE").append(',').append(' ');
        stringBuffer.append("INDEX_NAME").append(',').append(' ');
        stringBuffer.append("GENERATED").append(',').append(' ');
        stringBuffer.append("RELY").append(' ');
        stringBuffer.append("FROM").append(' ').append(this.dbaUser ? "dba_constraints" : "all_constraints").append(' ');
        stringBuffer.append("WHERE").append(' ').append("OWNER").append(' ').append('=').append(' ').append('?').append(' ');
        stringBuffer.append("AND").append(' ').append("TABLE_NAME").append(' ').append('=').append(' ').append('?').append(' ');
        stringBuffer.append("AND").append(' ').append("CONSTRAINT_TYPE").append(' ').append("IN").append(' ');
        stringBuffer.append('(').append("'P','U','C','R'").append(')').append(' ');
        stringBuffer.append("ORDER BY").append(' ').append("CONSTRAINT_NAME");
        String string2 = stringBuffer.toString();
        Statement statement2 = null;
        Iterator iterator = list.iterator();
        boolean bl = true;
        TreeMap<String, ArrayList<Object>> treeMap = new TreeMap<String, ArrayList<Object>>();
        while (iterator.hasNext()) {
            DBObject dBObject = (DBObject)iterator.next();
            Table table = dBObject.getTable();
            TableProxyOracle tableProxyOracle = (TableProxyOracle)storageDesignOracle.getTableProxySet().getObjectByID(table.getObjectID());
            int n = 0;
            String string3 = dBObject.getSchema();
            ResultSet resultSet = null;
            try {
                if (statement2 == null) {
                    statement2 = connection.prepareStatement(string2);
                }
                statement2.setString(1, dBObject.getSchema());
                statement2.setString(2, dBObject.getName());
                resultSet = statement2.executeQuery();
                bl = true;
                if (resultSet == null) continue;
                while (resultSet.next()) {
                    Object object;
                    Object object22;
                    Object object3;
                    Object object4;
                    Object object5;
                    ModelIDObject modelIDObject;
                    List<Object> list3;
                    Object object6;
                    String string4;
                    Object object7;
                    String string5 = resultSet.getString(1);
                    String string6 = resultSet.getString(2);
                    String string7 = resultSet.getString(3);
                    String string8 = resultSet.getString(4);
                    String string9 = resultSet.getString(5);
                    String string10 = resultSet.getString(6);
                    String string11 = resultSet.getString(7);
                    String string12 = resultSet.getString(13);
                    if (bl) {
                        object7 = null;
                        bl = false;
                        treeMap.clear();
                        if (statement == null) {
                            statement = connection.prepareStatement(string);
                        }
                        try {
                            statement.setString(1, dBObject.getSchema());
                            statement.setString(2, dBObject.getName());
                            object7 = statement.executeQuery();
                        }
                        catch (Exception exception) {
                            LOGGER.error("MOHTableOracle.initUK_PK_FK_CHECK_Constraints():", exception);
                        }
                        if (object7 != null) {
                            while (object7.next()) {
                                string4 = object7.getString(1);
                                object6 = Token.removeQuotes(object7.getString(2));
                                list3 = (List)treeMap.get(string4);
                                if (list3 == null) {
                                    list3 = new ArrayList<Object>();
                                    treeMap.put(string4, (ArrayList<Object>)list3);
                                }
                                list3.add(object6);
                            }
                        }
                    }
                    if ("R".equalsIgnoreCase(string6)) {
                        object7 = new FKTemp();
                        list2.add(object7);
                        ((FKTemp)object7).name = string5;
                        ((FKTemp)object7).UK_Owner = resultSet.getString(8);
                        ((FKTemp)object7).UK_Name = resultSet.getString(9);
                        ((FKTemp)object7).delete_rule = resultSet.getString(10);
                        ((FKTemp)object7).table = dBObject.getTable();
                        this.initFK_Columns(treeMap, string5, ((FKTemp)object7).columns);
                        ((FKTemp)object7).deferred = string7;
                        ((FKTemp)object7).status = string8;
                        ((FKTemp)object7).deferrable = string9;
                        ((FKTemp)object7).validated = string10;
                        ((FKTemp)object7).rely = string12;
                        continue;
                    }
                    if ("C".equalsIgnoreCase(string6)) {
                        this.processCheckConstr(treeMap, dBObject, string5, string6, string7, string8, string9, string10, string11, string3);
                        continue;
                    }
                    object7 = resultSet.getString(11);
                    string4 = resultSet.getString(12);
                    object6 = null;
                    list3 = table.getIndexByName((String)object7);
                    if (!string4.equalsIgnoreCase("USER NAME")) {
                        if (string5.equals(object7)) {
                            object6 = table.getIndexByName((String)object7);
                        }
                    } else if (!string5.equals(object7) || "INDEX".equalsIgnoreCase(tableProxyOracle.getOrganization())) {
                        object6 = table.getIndexByName(string5);
                    }
                    if ("INDEX".equalsIgnoreCase(tableProxyOracle.getOrganization())) {
                        if (object6 == null) {
                            object6 = list3;
                        }
                        list3 = null;
                    }
                    if ("P".equalsIgnoreCase(string6) && table.isBST()) {
                        if (object6 != null) {
                            modelIDObject = (Index)table.getPK();
                            if (modelIDObject != null) {
                                if (((Index)object6).getElementsCollection().size() > 0) {
                                    object5 = ((Index)modelIDObject).getElementsCollection();
                                    object5.clear();
                                    object5.addAll(((Index)object6).getElementsCollection());
                                }
                                ((KeyObject)object6).remove();
                                object6 = modelIDObject;
                            }
                            if (string4.equalsIgnoreCase("USER NAME")) {
                                ((DesignObject)object6).setName(string5);
                            } else {
                                ((DesignObject)object6).setName((String)object7);
                            }
                        } else {
                            modelIDObject = (Index)table.getPK();
                            if (modelIDObject == null) {
                                modelIDObject = table.createIndex();
                            }
                            if (string4.equalsIgnoreCase("USER NAME")) {
                                ((DesignObject)modelIDObject).setName(string5);
                            } else {
                                ((DesignObject)modelIDObject).setName((String)object7);
                            }
                            this.stampModelObject((ModelObject)modelIDObject, table.getSchema(), ((DesignObject)modelIDObject).getName());
                            this.initPK_UK_Columns((Index)modelIDObject, treeMap, string5);
                            if ("".equals(((Index)modelIDObject).getIndexExpression())) {
                                DesignObject designObject2;
                                object5 = (Column)table.getOidElement();
                                if (object5 != null) {
                                    ((Index)modelIDObject).remove((ContainedObject)object5);
                                }
                                object4 = new ArrayList();
                                for (DesignObject designObject2 : ((Index)modelIDObject).getElementsCollection()) {
                                    object4.add(((ContainedObject)designObject2).getName());
                                }
                                designObject2 = this.getIndexForColumnNames(table, (List)object4, (Index)modelIDObject);
                                if (designObject2 != null) {
                                    ((KeyObject)designObject2).remove();
                                }
                            }
                        }
                    } else if (object6 == null) {
                        object6 = table.createIndex();
                    }
                    if (object6 == null) continue;
                    map.put(string3 + string5, object6);
                    modelIDObject = null;
                    object5 = null;
                    object4 = "";
                    Object object8 = null;
                    int n2 = 0;
                    boolean bl2 = false;
                    IndexProxyOracle indexProxyOracle = null;
                    IndexProxyOracle indexProxyOracle2 = null;
                    if (list3 != null) {
                        indexProxyOracle = (IndexProxyOracle)storageDesignOracle.getIndexProxySet().getProxy(((ModelIDObject)((Object)list3)).getObjectID());
                    } else {
                        indexProxyOracle2 = indexProxyOracle = (IndexProxyOracle)storageDesignOracle.getIndexProxySet().getProxy(((ModelIDObject)object6).getObjectID());
                    }
                    if (indexProxyOracle != null) {
                        modelIDObject = indexProxyOracle.getTableSpace();
                        object5 = indexProxyOracle.getSegment();
                        object4 = indexProxyOracle.getLogging();
                        object8 = indexProxyOracle.getUser();
                        n2 = indexProxyOracle.getCompress();
                        bl2 = indexProxyOracle.isPartitioned();
                    }
                    PKProxyOracle pKProxyOracle = null;
                    UniqueOracle uniqueOracle = null;
                    IndexProxyOracle indexProxyOracle3 = null;
                    if ("U".equalsIgnoreCase(string6)) {
                        ((Index)object6).setIndexState("Unique Constraint");
                        uniqueOracle = (UniqueOracle)storageDesignOracle.getUniqueSet().getProxy(((ModelIDObject)object6).getObjectID());
                        ++n;
                        indexProxyOracle3 = uniqueOracle;
                    } else if ("P".equalsIgnoreCase(string6) && !table.isBST()) {
                        ((Index)object6).setIndexState("Primary Constraint");
                        pKProxyOracle = (PKProxyOracle)storageDesignOracle.getPKProxySet().getProxy(((ModelIDObject)object6).getObjectID());
                        indexProxyOracle3 = pKProxyOracle;
                    }
                    if (indexProxyOracle3 != null) {
                        indexProxyOracle3.setTableSpace((TableSpaceOracle)modelIDObject);
                        indexProxyOracle3.setLogging((String)object4);
                        indexProxyOracle3.setUser((UserOracle)object8);
                        indexProxyOracle3.setCompress(n2);
                        indexProxyOracle3.setPartitioned(bl2);
                        if (pKProxyOracle != null) {
                            pKProxyOracle.setIndexSegment((SegmentOracle)object5);
                            if (string8.equals("ENABLED")) {
                                pKProxyOracle.setEnable("YES");
                            } else {
                                pKProxyOracle.setEnable("NO");
                            }
                            if (string9.equals("DEFERRABLE")) {
                                pKProxyOracle.setDeferrable("YES");
                            } else {
                                pKProxyOracle.setDeferrable("NO");
                            }
                            if (string7.equals("DEFERRED")) {
                                pKProxyOracle.setInitially("DEFERRED");
                            } else {
                                pKProxyOracle.setInitially("IMMEDIATE");
                            }
                            if (string10.equals("VALIDATED")) {
                                pKProxyOracle.setValidate("YES");
                            } else {
                                pKProxyOracle.setValidate("NO");
                            }
                        } else if (uniqueOracle != null) {
                            uniqueOracle.setIndexSegment((SegmentOracle)object5);
                            if (string8.equals("ENABLED")) {
                                uniqueOracle.setEnable("YES");
                            } else {
                                uniqueOracle.setEnable("NO");
                            }
                            if (string9.equals("DEFERRABLE")) {
                                uniqueOracle.setDeferrable("YES");
                            } else {
                                uniqueOracle.setDeferrable("NO");
                            }
                            if (string7.equals("DEFERRED")) {
                                uniqueOracle.setInitially("DEFERRED");
                            } else {
                                uniqueOracle.setInitially("IMMEDIATE");
                            }
                            if (string10.equals("VALIDATED")) {
                                uniqueOracle.setValidate("YES");
                            } else {
                                uniqueOracle.setValidate("NO");
                            }
                        }
                    }
                    boolean bl3 = true;
                    if (((Index)object6).getElementsCollection().size() == 0) {
                        bl3 = this.initPK_UK_Columns((Index)object6, treeMap, string5);
                    }
                    if (!bl3 || table.isBST() && !"".equals(((Index)object6).getIndexExpression())) {
                        map.put(string3 + string5, ((Index)object6).getTable());
                        ((KeyObject)object6).remove();
                    } else if (indexProxyOracle3 != null) {
                        object3 = new ArrayList();
                        for (Object object22 : ((Index)object6).getElementsCollection()) {
                            object3.add(((ContainedObject)object22).getName());
                        }
                        object22 = null;
                        if (indexProxyOracle2 != null) {
                            object22 = indexProxyOracle2;
                        } else {
                            object = this.getIndexForColumnNames(table, (List)object3, (Index)object6);
                            if (object != null) {
                                object22 = (IndexProxyOracle)storageDesignOracle.getIndexProxySet().getProxy(((ModelIDObject)object).getObjectID());
                            }
                        }
                        if (!"INDEX".equalsIgnoreCase(tableProxyOracle.getOrganization())) {
                            if (pKProxyOracle != null) {
                                pKProxyOracle.setUsingIndex("BY INDEX NAME");
                                pKProxyOracle.setExistingIndex((IndexProxyOracle)object22);
                            } else if (uniqueOracle != null) {
                                uniqueOracle.setUsingIndex("BY INDEX NAME");
                                uniqueOracle.setExistingIndex((IndexProxyOracle)object22);
                            }
                        }
                    }
                    if (string4.equalsIgnoreCase("USER NAME")) {
                        ((DesignObject)object6).setName(string5);
                        this.stampModelObject((ModelObject)object6, table.getSchema(), ((DesignObject)object6).getName());
                        continue;
                    }
                    if (DBMExtractionController.swapTargetModel) {
                        ((DesignObject)object6).setName(string5);
                        this.stampModelObject((ModelObject)object6, table.getSchema(), string5);
                        continue;
                    }
                    object3 = table.getDesign().getDLSettings().getNamingStandardRule();
                    String string13 = table.getName();
                    object22 = table.getAbbreviation();
                    if (object22 == null || "".equals(object22)) {
                        object22 = string13;
                    }
                    object = "P".equalsIgnoreCase(string6) ? ApplyNamingStandards.applyToPK((KeyObject)object6, (NamingStandardRule)object3, string13, (String)object22) : ApplyNamingStandards.createUK_Name((KeyObject)object6, n, (NamingStandardRule)object3, table.getDesignPart().getName(), string13, (String)object22);
                    ((DesignObject)object6).setName((String)object);
                    this.stampModelObject((ModelObject)object6, table.getSchema(), string5);
                }
                resultSet.close();
            }
            catch (Exception exception) {
                LOGGER.error("MOHTableOracle.initUK_PK_FK_CHECK_Constraints():", exception);
            }
        }
        if (statement != null) {
            statement.close();
        }
        if (statement2 != null) {
            statement2.close();
        }
    }

    private void processCheckConstr(Map map, DBObject dBObject, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        Object object;
        ModelIDObject modelIDObject;
        List list = (List)map.get(string);
        TableProxyOracle tableProxyOracle = (TableProxyOracle)dBObject.getTableProxy();
        Table table = dBObject.getTable();
        if (list != null && list.size() == 1 && (modelIDObject = (Column)table.getElementByName((String)(object = (String)list.get(0)))) != null) {
            String string9 = "\"" + (String)object + "\" IS NOT NULL";
            if (string9.equalsIgnoreCase(string7)) {
                ((ContainedObject)modelIDObject).setNullsAllowed(false);
                ColumnProxyOracle columnProxyOracle = (ColumnProxyOracle)tableProxyOracle.getColumnProxyByName((String)object);
                if (columnProxyOracle != null) {
                    if ("ENABLED".equalsIgnoreCase(string4)) {
                        columnProxyOracle.setNncEnable("YES");
                    } else {
                        columnProxyOracle.setNncEnable("NO");
                    }
                    if (string5.equals("DEFERRABLE")) {
                        columnProxyOracle.setNncDeferrable("YES");
                    } else {
                        columnProxyOracle.setNncDeferrable("NO");
                    }
                    if (string3.equals("DEFERRED")) {
                        columnProxyOracle.setNncInitially("DEFERRED");
                    } else {
                        columnProxyOracle.setNncInitially("IMMEDIATE");
                    }
                    if (string6.equals("VALIDATED")) {
                        columnProxyOracle.setNncValidate("YES");
                    } else {
                        columnProxyOracle.setNncValidate("NO");
                    }
                    if (!string.startsWith("SYS_C")) {
                        ((Column)modelIDObject).setNotNullConstraintName(string);
                    }
                }
                return;
            }
            if (((Column)modelIDObject).getCheck() == null) {
                Object object2;
                Object object3;
                String string10 = string7;
                boolean bl = ((ContainedObjectWithDomain)modelIDObject).setSeparatedConstraints(string7);
                if (bl) {
                    string10 = ((ContainedObjectWithDomain)modelIDObject).getSeparatedCheckConstraint();
                }
                if (!"".equals(string10)) {
                    object3 = new CheckConstraint();
                    ((ModelObject)object3).setDesign(table.getDesign());
                    ((ModelObject)object3).setName(string);
                    this.stampModelObject((ModelObject)object3, table.getName(), string);
                    object2 = StorageDesignOraclev11g.RDBMS_TYPE;
                    if (this.getStorageDesign() != null) {
                        object2 = this.getStorageDesign().getRDBMSType();
                    }
                    ((CheckConstraint)object3).add((ConstraintType)object2, string10);
                    ((ContainedObjectWithDomain)modelIDObject).setUseDomainConstraints(false);
                    ((Column)modelIDObject).setCheck((CheckConstraint)object3);
                    ((ContainedObject)modelIDObject).setConstraintName(string);
                }
                if (bl) {
                    Object object4;
                    object3 = ((ContainedObjectWithDomain)modelIDObject).getSeparatedRangeConstraint();
                    if (!"".equals(object3)) {
                        object2 = ((String)object3).split(",");
                        int n = 0;
                        while (n < ((String[])object2).length) {
                            object4 = object2[n++];
                            String string11 = object2[n++];
                            AVT aVT = new AVT(((String)object4).trim(), string11.trim(), "");
                            ((ContainedObjectWithDomain)modelIDObject).setUseDomainConstraints(false);
                            ((Column)modelIDObject).addAVT(aVT);
                            ((ContainedObject)modelIDObject).setConstraintName(string);
                        }
                    }
                    if (!"".equals(object2 = ((ContainedObjectWithDomain)modelIDObject).getSeparatedValueConstraint())) {
                        String[] stringArray = object2.split(",");
                        object4 = new ConstraintEnumeration();
                        for (int i = 0; i < stringArray.length; ++i) {
                            ((ConstraintEnumeration)object4).add(stringArray[i].trim());
                        }
                        ((ContainedObjectWithDomain)modelIDObject).setUseDomainConstraints(false);
                        ((Column)modelIDObject).setValueList((ConstraintEnumeration)object4);
                        ((ContainedObject)modelIDObject).setConstraintName(string);
                    }
                }
                if ((object3 = (ColumnProxyOracle)tableProxyOracle.getColumnProxyByName((String)object)) != null) {
                    if ("ENABLED".equalsIgnoreCase(string4)) {
                        ((ColumnProxyOracle)object3).setEnable("YES");
                    } else {
                        ((ColumnProxyOracle)object3).setEnable("NO");
                    }
                    if (string5.equals("DEFERRABLE")) {
                        ((ColumnProxyOracle)object3).setDeferrable("YES");
                    } else {
                        ((ColumnProxyOracle)object3).setDeferrable("NO");
                    }
                    if (string3.equals("DEFERRED")) {
                        ((ColumnProxyOracle)object3).setInitially("DEFERRED");
                    } else {
                        ((ColumnProxyOracle)object3).setInitially("IMMEDIATE");
                    }
                    if (string6.equals("VALIDATED")) {
                        ((ColumnProxyOracle)object3).setValidate("YES");
                    } else {
                        ((ColumnProxyOracle)object3).setValidate("NO");
                    }
                }
                return;
            }
        }
        object = table.createCheckConstraint(string, string7);
        table.addCheckConstraint((TableLevelConstraint)object);
        this.stampModelObject((ModelObject)object, table.getSchema(), string);
        modelIDObject = tableProxyOracle.getTableConstraint((TableLevelConstraint)object);
        if (modelIDObject != null) {
            if (string4.equals("ENABLED")) {
                ((TableCheckConstraintOracle)modelIDObject).setEnable("YES");
            } else {
                ((TableCheckConstraintOracle)modelIDObject).setEnable("NO");
            }
            if (string5.equals("DEFERRABLE")) {
                ((TableCheckConstraintOracle)modelIDObject).setDeferrable("YES");
            } else {
                ((TableCheckConstraintOracle)modelIDObject).setDeferrable("NO");
            }
            if (string3.equals("DEFERRED")) {
                ((TableCheckConstraintOracle)modelIDObject).setInitially("DEFERRED");
            } else {
                ((TableCheckConstraintOracle)modelIDObject).setInitially("IMMEDIATE");
            }
            if (string6.equals("VALIDATED")) {
                ((TableCheckConstraintOracle)modelIDObject).setValidate("YES");
            } else {
                ((TableCheckConstraintOracle)modelIDObject).setValidate("NO");
            }
        }
    }

    private boolean initPK_UK_Columns(Index index, Map map, String string) throws Exception {
        boolean bl = true;
        List list = (List)map.get(string);
        if (list != null) {
            String string2 = "";
            boolean bl2 = false;
            boolean bl3 = true;
            Table table = (Table)index.getContainerWithKeyObject();
            for (int i = 0; i < list.size(); ++i) {
                String string3 = (String)list.get(i);
                if (bl3) {
                    string2 = string3;
                    bl3 = false;
                } else {
                    string2 = string2 + "," + string3;
                }
                Column column = (Column)table.getElementByName(string3);
                if (column != null) {
                    if (column.getCollectionType() != null || column.getStructuredType() != null) {
                        bl = false;
                    }
                    index.add(column);
                    continue;
                }
                if (string3.startsWith("SYS_NC")) {
                    bl = false;
                }
                bl2 = true;
            }
            if (bl2) {
                index.getElementsCollection().clear();
                index.setIndexExpression(string2);
            }
        }
        return bl;
    }

    private void initFK_Columns(Map map, String string, List list) throws Exception {
        List list2 = (List)map.get(string);
        if (list2 != null) {
            list.addAll(list2);
        }
    }

    protected abstract void initColumns(Connection var1, List var2) throws Exception;

    protected void setParameter(Column column, String string, int n) {
        if (n != 0) {
            column.setDataTypeParameter(string, String.valueOf(n));
        }
    }

    protected void initClusterColumns(Connection connection, List list) throws Exception {
        String string = this.dbaUser ? "dba_clu_columns" : "user_clu_columns";
        String string2 = this.getClusterColumnSql(string);
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        for (DBObject dBObject : list) {
            Object object;
            Object object2;
            Table table = dBObject.getTable();
            TableProxyOracle tableProxyOracle = (TableProxyOracle)this.getStorageDesign().getTableProxySet().getProxy(table.getObjectID());
            ClusterOracle clusterOracle = tableProxyOracle.getCluster();
            if (clusterOracle == null) continue;
            String string3 = table.getName();
            String string4 = clusterOracle.getName();
            ResultSet resultSet = null;
            try {
                preparedStatement.setString(1, string3);
                preparedStatement.setString(2, string4);
                if (string.equals("dba_clu_columns")) {
                    preparedStatement.setString(3, dBObject.getSchema());
                }
                resultSet = preparedStatement.executeQuery();
            }
            catch (Exception exception) {
                LOGGER.error("MOHTableOracle.initClusterColumns():", exception);
            }
            if (resultSet == null) continue;
            HashMap<ClusterColumnOracle, ColumnProxy> hashMap = new HashMap<ClusterColumnOracle, ColumnProxy>();
            while (resultSet.next()) {
                object2 = resultSet.getString("TAB_COLUMN_NAME");
                object = resultSet.getString("CLU_COLUMN_NAME");
                ClusterColumnOracle clusterColumnOracle = (ClusterColumnOracle)clusterOracle.getColumnsCollection().getByName((String)object);
                if (clusterColumnOracle == null) continue;
                hashMap.put(clusterColumnOracle, tableProxyOracle.getColumnProxyByName((String)object2));
            }
            resultSet.close();
            object2 = clusterOracle.getColumnsCollection().iterator();
            while (object2.hasNext()) {
                object = (ColumnProxyOracle)hashMap.get(object2.next());
                if (object == null) continue;
                tableProxyOracle.setClusterColumns(((RelationalObjectProxy)object).getObjectID());
            }
        }
        preparedStatement.close();
    }

    private String getClusterColumnSql(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT").append(' ');
        stringBuffer.append("CLU_COLUMN_NAME").append(',');
        stringBuffer.append("TAB_COLUMN_NAME").append(' ');
        stringBuffer.append("FROM").append(' ');
        stringBuffer.append(string).append(' ');
        stringBuffer.append("WHERE").append(' ');
        stringBuffer.append("TABLE_NAME").append('=').append(' ').append('?').append(' ');
        stringBuffer.append("AND").append(' ');
        stringBuffer.append("CLUSTER_NAME").append('=').append(' ').append('?').append(' ');
        if (string.equals("dba_clu_columns")) {
            stringBuffer.append("AND").append(' ');
            stringBuffer.append("OWNER").append('=').append(' ').append('?').append(' ');
        }
        return stringBuffer.toString();
    }

    private List getIndexColumns(PreparedStatement preparedStatement, String string, String string2) throws Exception {
        ArrayList<SimpleColumn> arrayList = new ArrayList<SimpleColumn>();
        ResultSet resultSet = null;
        try {
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, string);
            resultSet = preparedStatement.executeQuery();
        }
        catch (Exception exception) {
            LOGGER.error("MOHTableOracle.getIndexColumns():", exception);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                String string3 = resultSet.getString("COLUMN_NAME");
                String string4 = resultSet.getString("DESCEND");
                SimpleColumn simpleColumn = new SimpleColumn(string3, string4);
                arrayList.add(simpleColumn);
            }
            resultSet.close();
        }
        return arrayList;
    }

    private void initIndexes(Connection connection, List list) throws Exception {
        this.indexp_st = null;
        this.indspat_st = null;
        StorageDesign storageDesign = this.getStorageDesign();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT").append(' ');
        stringBuffer.append("COLUMN_NAME").append(',');
        stringBuffer.append("COLUMN_POSITION").append(',');
        stringBuffer.append("DESCEND").append(' ');
        stringBuffer.append("FROM").append(' ');
        stringBuffer.append(this.dbaUser ? "dba_ind_columns" : "all_ind_columns").append(' ');
        stringBuffer.append("WHERE").append(' ');
        stringBuffer.append("INDEX_OWNER").append('=').append(' ').append('?').append(' ');
        stringBuffer.append("AND").append(' ');
        stringBuffer.append("INDEX_NAME").append('=').append(' ').append('?').append(' ');
        stringBuffer.append("ORDER BY").append(' ');
        stringBuffer.append("COLUMN_POSITION");
        String string = stringBuffer.toString();
        Statement statement = null;
        stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT").append(' ');
        stringBuffer.append("OWNER").append(',');
        stringBuffer.append("INDEX_NAME").append(',');
        stringBuffer.append("INDEX_TYPE").append(',');
        stringBuffer.append("TABLE_OWNER").append(',');
        stringBuffer.append("TABLE_NAME").append(',');
        stringBuffer.append("TABLE_TYPE").append(',');
        stringBuffer.append("UNIQUENESS").append(',');
        stringBuffer.append("PREFIX_LENGTH").append(',');
        stringBuffer.append("TABLESPACE_NAME").append(',');
        stringBuffer.append("INI_TRANS").append(',');
        stringBuffer.append("MAX_TRANS").append(',');
        stringBuffer.append("INITIAL_EXTENT").append(',');
        stringBuffer.append("NEXT_EXTENT").append(',');
        stringBuffer.append("MIN_EXTENTS").append(',');
        stringBuffer.append("MAX_EXTENTS").append(',');
        stringBuffer.append("PCT_INCREASE").append(',');
        stringBuffer.append("INCLUDE_COLUMN").append(',');
        stringBuffer.append("FREELISTS").append(',');
        stringBuffer.append("FREELIST_GROUPS").append(',');
        stringBuffer.append("PCT_FREE").append(',');
        stringBuffer.append("LOGGING").append(',');
        stringBuffer.append("DEGREE").append(',');
        stringBuffer.append("PARTITIONED").append(',');
        stringBuffer.append("SECONDARY").append(',');
        stringBuffer.append("BUFFER_POOL").append(',');
        stringBuffer.append("ITYP_OWNER").append(',');
        stringBuffer.append("ITYP_NAME").append(',');
        stringBuffer.append("PARAMETERS").append(' ');
        stringBuffer.append("FROM").append(' ');
        stringBuffer.append(this.dbaUser ? "dba_indexes" : "all_indexes").append(' ');
        stringBuffer.append("WHERE").append(' ');
        stringBuffer.append("TABLE_OWNER").append('=').append(' ').append('?').append(' ');
        stringBuffer.append("AND").append(' ');
        stringBuffer.append("TABLE_NAME").append('=').append(' ').append('?').append(' ');
        stringBuffer.append("AND").append(' ');
        stringBuffer.append("JOIN_INDEX").append('=').append('\'');
        stringBuffer.append("NO").append('\'');
        String string2 = stringBuffer.toString();
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        for (DBObject dBObject : list) {
            Table table = dBObject.getTable();
            ResultSet resultSet = null;
            try {
                preparedStatement.setString(1, dBObject.getSchema());
                preparedStatement.setString(2, dBObject.getName());
                resultSet = preparedStatement.executeQuery();
                if (resultSet == null) continue;
                while (resultSet.next()) {
                    Object object;
                    Object object22;
                    IndexProxyOracle indexProxyOracle;
                    String string3 = resultSet.getString("INDEX_NAME");
                    String string4 = resultSet.getString("OWNER");
                    String string5 = resultSet.getString("INDEX_TYPE");
                    Index index = table.createIndex();
                    index.setName(string3);
                    index.setSchemaObject(table.getSchemaObject());
                    this.stampModelObject((ModelObject)index, table.getSchema(), string3);
                    String string6 = resultSet.getString("UNIQUENESS");
                    if ("UNIQUE".equalsIgnoreCase(string6)) {
                        index.setIndexState("Unique Plain Index");
                    }
                    if ((indexProxyOracle = (IndexProxyOracle)this.getStorageDesign().getIndexProxySet().getProxy(index.getObjectID())) == null) continue;
                    List list2 = null;
                    boolean bl = false;
                    if (string5 != null) {
                        if (string5.indexOf("FUNCTION") > -1 || string5.indexOf("DOMAIN") > -1) {
                            list2 = this.setIndexExpression(connection, index, string4, string3);
                        } else if ("BITMAP".equalsIgnoreCase(string5)) {
                            indexProxyOracle.setBitmapIndex(true);
                        }
                    }
                    boolean bl2 = false;
                    String string7 = index.getIndexExpression();
                    if (!"".equals(string7)) {
                        bl2 = true;
                    }
                    Object object3 = "";
                    boolean bl3 = false;
                    boolean bl4 = true;
                    if (statement == null) {
                        statement = connection.prepareStatement(string);
                    }
                    int n = 1;
                    List list3 = this.getIndexColumns((PreparedStatement)statement, string3, string4);
                    for (Object object22 : list3) {
                        ExprHelp exprHelp;
                        object = ((SimpleColumn)object22).getName();
                        Column column = (Column)table.getElementByName((String)object);
                        String string8 = null;
                        if (column == null && (exprHelp = this.getExprByColPos(list2, n)) != null && (string8 = Token.getName(exprHelp.expr)) != null) {
                            column = (Column)table.getElementByName(string8);
                        }
                        if (string8 != null) {
                            object = string8;
                            if (column == null && "DESC".equalsIgnoreCase(((SimpleColumn)object22).sortOrder)) {
                                object = (String)object + " " + "DESC";
                            }
                        }
                        if (column != null) {
                            if (column.getCollectionType() != null || column.getStructuredType() != null) {
                                bl = true;
                            }
                            index.add(column);
                            index.setColumnSortOrder(column, ((SimpleColumn)object22).getSortOrder());
                            if (bl2) {
                                index.setIndexExpression("");
                            }
                        } else {
                            if (!bl2 && ((String)object).indexOf("SYS_NC") > -1) {
                                bl = true;
                            }
                            bl3 = true;
                        }
                        if (bl4) {
                            object3 = object;
                            bl4 = false;
                        } else {
                            object3 = (String)object3 + "," + (String)object;
                        }
                        ++n;
                    }
                    if (!bl2 && bl4) {
                        bl = true;
                    }
                    if (bl3) {
                        index.getElementsCollection().clear();
                        index.setIndexExpression((String)object3);
                    }
                    if ((object = ((TableProxyOracle)(object22 = (TableProxyOracle)storageDesign.getTableProxySet().getObjectByID(table.getObjectID()))).getSnapshot()) != null) {
                        if (!"".equals(string7) && string7.indexOf("SYS_OP_MAP_NONNULL") > -1) {
                            bl = true;
                        } else if (!"".equals(index.getIndexExpression()) && "M_ROW$$".equalsIgnoreCase(index.getIndexExpression().trim())) {
                            bl = true;
                            ((SnapshotOracle)object).setWith("ROWID");
                        }
                    }
                    if (bl) {
                        index.remove();
                        continue;
                    }
                    this.setIndexUser(indexProxyOracle, (StorageDesignOracle)storageDesign, string4);
                    this.setIndexTableSpace(indexProxyOracle, (StorageDesignOracle)storageDesign, resultSet.getString("TABLESPACE_NAME"));
                    this.setIndexProperties(connection, table, indexProxyOracle, (StorageDesignOracle)storageDesign, resultSet);
                    if (string5 == null || !string5.startsWith("IOT") || object22 == null || !"INDEX".equals(((TableProxyOracle)object22).getOrganization()) || ((TableProxyOracle)object22).getTableSpace() != null) continue;
                    ((TableProxyOracle)object22).setTableSpace(indexProxyOracle.getTableSpace());
                }
                resultSet.close();
            }
            catch (Exception exception) {
                LOGGER.error("MOHTableOracle.initIndexes():", exception);
            }
        }
        if (statement != null) {
            statement.close();
        }
        if (this.indexp_st != null) {
            this.indexp_st.close();
        }
        if (this.indspat_st != null) {
            this.indspat_st.close();
        }
        preparedStatement.close();
    }

    private ExprHelp getExprByColPos(List list, int n) {
        if (list != null) {
            for (ExprHelp exprHelp : list) {
                if (exprHelp.col_pos != n) continue;
                return exprHelp;
            }
        }
        return null;
    }

    private List setIndexExpression(Connection connection, Index index, String string, String string2) throws SQLException {
        String string3;
        Object object;
        ArrayList<ExprHelp> arrayList = new ArrayList<ExprHelp>();
        if (this.indexp_st == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ');
            ((StringBuffer)object).append("COLUMN_EXPRESSION").append(',').append("COLUMN_POSITION").append(' ');
            ((StringBuffer)object).append("FROM").append(' ');
            ((StringBuffer)object).append(this.dbaUser ? "dba_ind_expressions" : "all_ind_expressions").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ').append("INDEX_OWNER").append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object).append("AND").append(' ').append("INDEX_NAME").append('=').append(' ').append('?').append(' ');
            string3 = ((StringBuffer)object).toString();
            this.indexp_st = connection.prepareStatement(string3);
        }
        object = null;
        try {
            this.indexp_st.setString(1, string);
            this.indexp_st.setString(2, string2);
            object = this.indexp_st.executeQuery();
        }
        catch (Exception exception) {
            LOGGER.error("MOHTableOracle.setIndexExpression():", exception);
        }
        if (object != null) {
            string3 = "";
            boolean bl = true;
            while (object.next()) {
                String string4 = object.getString("COLUMN_EXPRESSION");
                int n = object.getInt("COLUMN_POSITION");
                if (bl) {
                    string3 = string4;
                    bl = false;
                } else {
                    string3 = string3 + "," + string4;
                }
                ExprHelp exprHelp = new ExprHelp();
                exprHelp.expr = string4;
                exprHelp.col_pos = n;
                arrayList.add(exprHelp);
            }
            if (!"".equals(string3)) {
                index.setIndexExpression(string3);
            }
            object.close();
        }
        return arrayList;
    }

    private void setIndexUser(IndexProxyOracle indexProxyOracle, StorageDesignOracle storageDesignOracle, String string) {
        SchemaObjectSet schemaObjectSet;
        SchemaObject schemaObject;
        UserOracle userOracle = (UserOracle)storageDesignOracle.getUserSet().getByName(string);
        if (userOracle == null) {
            userOracle = storageDesignOracle.getUserSet().createUser();
            userOracle.setName(string);
            this.stampModelObject((ModelObject)userOracle, "", string);
        }
        if ((schemaObject = (SchemaObject)(schemaObjectSet = ((RelationalDesign)indexProxyOracle.getIndex().getDesignPart()).getSchemaObjectSet()).getByName(string)) == null) {
            schemaObject = schemaObjectSet.createSchemaObject(null);
            schemaObject.setName(string);
            this.stampModelObject((ModelObject)schemaObject, "", string);
        }
        if (userOracle.getSchemaObject() == null) {
            userOracle.setSchemaObject(schemaObject);
        }
        if (userOracle.getSchemaObject() != schemaObject) {
            indexProxyOracle.setUser(userOracle);
        }
        indexProxyOracle.getIndex().setSchemaObject(schemaObject);
    }

    private void setIndexTableSpace(IndexProxyOracle indexProxyOracle, StorageDesignOracle storageDesignOracle, String string) {
        if (string != null && !"".equalsIgnoreCase(string)) {
            TableSpaceOracle tableSpaceOracle = (TableSpaceOracle)storageDesignOracle.getTableSpaceSet().getByName(string);
            if (tableSpaceOracle == null) {
                tableSpaceOracle = ((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().createTableSpace();
                tableSpaceOracle.setName(string);
                this.stampModelObject((ModelObject)tableSpaceOracle, indexProxyOracle, string);
            }
            indexProxyOracle.setTableSpace(tableSpaceOracle);
        }
    }

    private void setIndexProperties(Connection connection, Table table, IndexProxyOracle indexProxyOracle, StorageDesignOracle storageDesignOracle, ResultSet resultSet) throws Exception {
        SegmentOracle segmentOracle = storageDesignOracle.getSegmentSet().createSegment();
        int n = resultSet.getInt("INI_TRANS");
        int n2 = resultSet.getInt("MAX_TRANS");
        long l = resultSet.getLong("INITIAL_EXTENT");
        long l2 = resultSet.getLong("NEXT_EXTENT");
        int n3 = Integer.MAX_VALUE;
        String string = "";
        try {
            n3 = resultSet.getInt("MIN_EXTENTS");
        }
        catch (Exception exception) {
            LOGGER.error("error in min_extent", exception);
        }
        try {
            string = resultSet.getString("MAX_EXTENTS");
        }
        catch (Exception exception) {
            LOGGER.error("error in max_extent", exception);
        }
        int n4 = resultSet.getInt("PCT_INCREASE");
        int n5 = resultSet.getInt("FREELISTS");
        int n6 = resultSet.getInt("FREELIST_GROUPS");
        int n7 = resultSet.getInt("PCT_FREE");
        String string2 = resultSet.getString("LOGGING");
        String string3 = resultSet.getString("DEGREE");
        String string4 = resultSet.getString("PARTITIONED");
        String string5 = resultSet.getString("BUFFER_POOL");
        String string6 = resultSet.getString("ITYP_OWNER");
        String string7 = resultSet.getString("ITYP_NAME");
        String string8 = resultSet.getString("PARAMETERS");
        String string9 = resultSet.getString("PREFIX_LENGTH");
        if (string9 != null) {
            try {
                indexProxyOracle.setCompress(Integer.parseInt(string9));
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("MOHTableOracle.setIndexProperties(): Can not parse string value for KeyCompression", numberFormatException);
            }
        }
        segmentOracle.setInitrans(n);
        segmentOracle.setMaxTrans(n2);
        segmentOracle.setSCInitialExtent(l);
        segmentOracle.setSCNextExtent(l2);
        segmentOracle.setSCMinExtents(n3);
        segmentOracle.setSCMaxExtents(String.valueOf(string));
        segmentOracle.setSCPctIncrease(n4);
        segmentOracle.setSCFreeLists(n5);
        segmentOracle.setSCFreelistGroups(n6);
        if (n7 > 0 || resultSet.getObject("PCT_FREE") != null) {
            segmentOracle.setPCTFree(n7);
        }
        if (string2 != null) {
            indexProxyOracle.setLogging(string2.trim().toUpperCase());
        }
        if (string5 != null) {
            segmentOracle.setSCBufferPool(string5.trim());
        }
        segmentOracle = storageDesignOracle.getSegmentSet().findEqual(segmentOracle);
        indexProxyOracle.setSegment(segmentOracle);
        if ("1".equalsIgnoreCase(string3.trim())) {
            indexProxyOracle.setParallel("NO");
        } else {
            indexProxyOracle.setParallel("YES");
        }
        if (string6 != null && string7 != null && string6.equalsIgnoreCase("MDSYS") && string7.equals("SPATIAL_INDEX")) {
            String string10 = this.getSpatialColumnName(connection, table, indexProxyOracle);
            Index index = indexProxyOracle.getIndex();
            index.setSpatialIndex(true);
            Column column = (Column)table.getElementByName(string10);
            Iterator iterator = table.getSpatialDefinitions().iterator();
            SpatialColumnDefObject spatialColumnDefObject2 = null;
            boolean bl = false;
            if (column != null) {
                while (iterator.hasNext() && (spatialColumnDefObject2 = (SpatialColumnDefObject)iterator.next()).getSpatialColumn() != column) {
                    spatialColumnDefObject2 = null;
                }
            } else {
                while (iterator.hasNext()) {
                    spatialColumnDefObject2 = (SpatialColumnDefObject)iterator.next();
                    if (spatialColumnDefObject2.getFuncExpression().equals(string10)) {
                        bl = true;
                        break;
                    }
                    spatialColumnDefObject2 = null;
                }
                if (spatialColumnDefObject2 == null && index.hasIndexExpression()) {
                    for (SpatialColumnDefObject spatialColumnDefObject2 : table.getSpatialDefinitions()) {
                        if (spatialColumnDefObject2.isFunction()) {
                            bl = true;
                            break;
                        }
                        spatialColumnDefObject2 = null;
                    }
                }
            }
            if (spatialColumnDefObject2 != null && !bl) {
                indexProxyOracle.getIndex().setSpatialColumnDefiniton(spatialColumnDefObject2);
                spatialColumnDefObject2.setSpatialIndex(index);
                if (column != null) {
                    spatialColumnDefObject2.setFunction(false);
                    spatialColumnDefObject2.setFuncExpression("");
                    if (indexProxyOracle.getIndex().getElementsCollection().size() == 0) {
                        indexProxyOracle.getIndex().add(column);
                    }
                } else if (spatialColumnDefObject2.isFunction()) {
                    indexProxyOracle.getIndex().setIndexExpression(string10);
                }
                if (spatialColumnDefObject2.getSpatialColumn() != null) {
                    indexProxyOracle.getIndex().add(spatialColumnDefObject2.getSpatialColumn());
                }
            } else {
                if (spatialColumnDefObject2 == null) {
                    spatialColumnDefObject2 = new SpatialColumnDefObject(table);
                    table.addSpatialDefinition(spatialColumnDefObject2);
                }
                spatialColumnDefObject2.setSpatialIndex(index);
                if (index.hasIndexExpression()) {
                    index.setSpatialColumnDefiniton(spatialColumnDefObject2);
                    if (!spatialColumnDefObject2.isFunction()) {
                        spatialColumnDefObject2.setFunction(true);
                        spatialColumnDefObject2.setFuncExpression(index.getIndexExpression());
                    }
                }
            }
            if (string8 != null) {
                string8 = Token.replaceAll(string8, "\n", "");
                StringTokenizer stringTokenizer = new StringTokenizer(string8, " ");
                while (stringTokenizer.hasMoreTokens()) {
                    TableSpaceOracle tableSpaceOracle;
                    String string11 = stringTokenizer.nextToken();
                    String[] stringArray = string11.split("=");
                    if (stringArray.length != 2) continue;
                    String string12 = stringArray[0];
                    String string13 = stringArray[1];
                    if (string13.equals("")) continue;
                    if (string12.equalsIgnoreCase("tablespace")) {
                        tableSpaceOracle = (TableSpaceOracle)((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().getByName(string13);
                        if (tableSpaceOracle == null) {
                            tableSpaceOracle = storageDesignOracle.getTableSpaceSet().createTableSpace();
                            tableSpaceOracle.setName(string13);
                            this.stampModelObject((ModelObject)tableSpaceOracle, indexProxyOracle, string13);
                        }
                        indexProxyOracle.setTableSpace(tableSpaceOracle);
                        continue;
                    }
                    if (string12.equalsIgnoreCase("work_tablespace")) {
                        tableSpaceOracle = (TableSpaceOracle)((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().getByName(string13);
                        if (tableSpaceOracle == null) {
                            tableSpaceOracle = storageDesignOracle.getTableSpaceSet().createTableSpace();
                            tableSpaceOracle.setName(string13);
                            this.stampModelObject((ModelObject)tableSpaceOracle, indexProxyOracle, string13);
                        }
                        if (storageDesignOracle instanceof StorageDesignOraclev9i) {
                            ((IndexProxyOraclev9i)indexProxyOracle).setWorkTablespace(tableSpaceOracle);
                            continue;
                        }
                        ((IndexProxyOraclev10g)indexProxyOracle).setWorkTablespace(tableSpaceOracle);
                        continue;
                    }
                    if (string12.equalsIgnoreCase("layer_gtype")) {
                        indexProxyOracle.getIndex().setLayerType(string13);
                        continue;
                    }
                    if (string12.equalsIgnoreCase("sdo_indx_dims")) {
                        try {
                            indexProxyOracle.getIndex().setDimensionsNumber(Integer.parseInt(string13));
                        }
                        catch (NumberFormatException numberFormatException) {
                            LOGGER.error("MOHTableOracle.setIndexProperties(): Can not parse string value.", numberFormatException);
                        }
                        continue;
                    }
                    if (string12.equalsIgnoreCase("geodetic")) {
                        indexProxyOracle.getIndex().setGeodetic("NO");
                        continue;
                    }
                    if (string12.equalsIgnoreCase("sdo_non_leaf_tbl") && string13.equalsIgnoreCase("TRUE")) {
                        if (storageDesignOracle instanceof StorageDesignOraclev9i) {
                            ((IndexProxyOraclev9i)indexProxyOracle).setNonLeaf("YES");
                            continue;
                        }
                        ((IndexProxyOraclev10g)indexProxyOracle).setNonLeaf("YES");
                        continue;
                    }
                    try {
                        if (string12.equalsIgnoreCase("initial")) {
                            segmentOracle.setInitrans(Integer.parseInt(string13));
                            continue;
                        }
                        if (string12.equalsIgnoreCase("next")) {
                            segmentOracle.setSCNextExtent(Long.parseLong(string13));
                            continue;
                        }
                        if (string12.equalsIgnoreCase("minextents")) {
                            segmentOracle.setSCMinExtents(Integer.parseInt(string13));
                            continue;
                        }
                        if (string12.equalsIgnoreCase("maxextents")) {
                            segmentOracle.setSCMaxExtents(string13);
                            continue;
                        }
                        if (string12.equalsIgnoreCase("pctincrease")) {
                            segmentOracle.setSCPctIncrease(Integer.parseInt(string13));
                            continue;
                        }
                        if (!string12.equalsIgnoreCase("sdo_rdr_pctfree")) continue;
                        segmentOracle.setPCTFree(Integer.parseInt(string13));
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.error("MOHTableOracle.setIndexProperties(): Can not parse string value.", numberFormatException);
                    }
                }
            }
        } else if (string6 != null && string7 != null) {
            indexProxyOracle.setIndexType(string6 + "." + string7);
            if (string8 != null) {
                indexProxyOracle.setIndexDomainParameters(string8);
            }
        }
        if ("YES".equalsIgnoreCase(string4.trim())) {
            indexProxyOracle.setPartitioned(true);
        } else {
            indexProxyOracle.setPartitioned(false);
        }
    }

    private void setDefIndexProperties(IndexProxyOracle indexProxyOracle, StorageDesignOracle storageDesignOracle, ResultSet resultSet) throws SQLException {
        SegmentOracle segmentOracle = storageDesignOracle.getSegmentSet().createSegment();
        int n = resultSet.getInt("DEF_INI_TRANS");
        int n2 = resultSet.getInt("DEF_MAX_TRANS");
        String string = resultSet.getString("DEF_INITIAL_EXTENT");
        String string2 = resultSet.getString("DEF_NEXT_EXTENT");
        String string3 = resultSet.getString("DEF_MIN_EXTENTS");
        String string4 = resultSet.getString("DEF_MAX_EXTENTS");
        String string5 = resultSet.getString("DEF_PCT_INCREASE");
        int n3 = resultSet.getInt("DEF_FREELISTS");
        int n4 = resultSet.getInt("DEF_FREELIST_GROUPS");
        int n5 = resultSet.getInt("DEF_PCT_FREE");
        String string6 = resultSet.getString("DEF_BUFFER_POOL");
        String string7 = resultSet.getString("DEF_LOGGING");
        segmentOracle.setInitrans(n);
        segmentOracle.setMaxTrans(n2);
        try {
            if (!string.equals("DEFAULT")) {
                segmentOracle.setSCInitialExtent(Long.parseLong(string.trim()));
            }
        }
        catch (Exception exception) {
            LOGGER.error("error in DEF_INITIAL_EXTENT", exception);
        }
        try {
            if (!string2.equals("DEFAULT")) {
                segmentOracle.setSCNextExtent(Long.parseLong(string2.trim()));
            }
        }
        catch (Exception exception) {
            LOGGER.error("error in DEF_NEXT_EXTENT", exception);
        }
        try {
            if (!string3.equals("DEFAULT")) {
                segmentOracle.setSCMinExtents(Integer.parseInt(string3.trim()));
            }
        }
        catch (Exception exception) {
            LOGGER.error("error in DEF_MIN_EXTENTS", exception);
        }
        if (string4 != null && !string4.equals("DEFAULT")) {
            segmentOracle.setSCMaxExtents(string4.trim());
        }
        try {
            if (!string5.equals("DEFAULT")) {
                segmentOracle.setSCPctIncrease(Integer.parseInt(string5.trim()));
            }
        }
        catch (Exception exception) {
            LOGGER.error("error in DEF_PCT_INCREASE", exception);
        }
        segmentOracle.setSCFreeLists(n3);
        segmentOracle.setSCFreelistGroups(n4);
        if (n5 > 0 || resultSet.getObject("DEF_PCT_FREE") != null) {
            segmentOracle.setPCTFree(n5);
        }
        if (string6 != null) {
            segmentOracle.setSCBufferPool(string6.trim().toUpperCase());
        }
        if (string7 != null) {
            indexProxyOracle.setLogging(string7.trim().toUpperCase());
        }
        segmentOracle = storageDesignOracle.getSegmentSet().findEqual(segmentOracle);
        indexProxyOracle.setSegment(segmentOracle);
    }

    private String getSpatialColumnName(Connection connection, Table table, IndexProxyOracle indexProxyOracle) throws SQLException {
        String string;
        CharSequence charSequence;
        if (this.indspat_st == null) {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT").append(' ').append("COLUMN_NAME").append(' ');
            ((StringBuffer)charSequence).append("FROM").append(' ').append("all_sdo_index_info").append(' ');
            ((StringBuffer)charSequence).append("WHERE").append(' ').append("SDO_INDEX_OWNER").append(' ').append('=').append(' ').append('?').append(' ');
            ((StringBuffer)charSequence).append("AND").append(' ').append("INDEX_NAME").append(' ').append('=').append(' ').append('?').append(' ');
            ((StringBuffer)charSequence).append("AND").append(' ').append("TABLE_OWNER").append(' ').append('=').append(' ').append('?').append(' ');
            string = ((StringBuffer)charSequence).toString();
            this.indspat_st = connection.prepareStatement(string);
        }
        charSequence = null;
        string = table.getSchema();
        String string2 = "";
        if (indexProxyOracle.getUser() != null) {
            string2 = indexProxyOracle.getUser().getName();
        }
        ResultSet resultSet = null;
        try {
            this.indspat_st.setString(1, string2);
            this.indspat_st.setString(2, indexProxyOracle.getName());
            this.indspat_st.setString(3, string);
            resultSet = this.indspat_st.executeQuery();
        }
        catch (Exception exception) {
            LOGGER.error("MOHTableOracle.getSpatialColumnName():", exception);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString("COLUMN_NAME");
            }
            resultSet.close();
        }
        return charSequence;
    }

    private void initIndexPartitioning(Connection connection, IndexProxyOracle indexProxyOracle, String string) throws SQLException {
        Object object;
        String string2;
        Object object2;
        Object object3;
        StorageDesignOracle storageDesignOracle = (StorageDesignOracle)this.getStorageDesign();
        if (this.indpart_st == null) {
            object3 = new StringBuffer();
            ((StringBuffer)object3).append("SELECT").append(' ');
            ((StringBuffer)object3).append("PARTITION_NAME").append(',');
            ((StringBuffer)object3).append("HIGH_VALUE").append(',');
            ((StringBuffer)object3).append("PARTITION_POSITION").append(',');
            ((StringBuffer)object3).append("TABLESPACE_NAME").append(',');
            ((StringBuffer)object3).append("PCT_FREE").append(',');
            ((StringBuffer)object3).append("INI_TRANS").append(',');
            ((StringBuffer)object3).append("MAX_TRANS").append(',');
            ((StringBuffer)object3).append("INITIAL_EXTENT").append(',');
            ((StringBuffer)object3).append("NEXT_EXTENT").append(',');
            ((StringBuffer)object3).append("MIN_EXTENT").append(',');
            ((StringBuffer)object3).append("MAX_EXTENT").append(',');
            ((StringBuffer)object3).append("PCT_INCREASE").append(',');
            ((StringBuffer)object3).append("FREELISTS").append(',');
            ((StringBuffer)object3).append("FREELIST_GROUPS").append(',');
            ((StringBuffer)object3).append("LOGGING").append(',');
            ((StringBuffer)object3).append("COMPRESSION").append(',');
            ((StringBuffer)object3).append("BUFFER_POOL").append(',');
            ((StringBuffer)object3).append("PARAMETERS").append(' ');
            ((StringBuffer)object3).append("FROM").append(' ');
            ((StringBuffer)object3).append(this.dbaUser ? "dba_ind_partitions" : "all_ind_partitions").append(' ');
            ((StringBuffer)object3).append("WHERE").append(' ');
            ((StringBuffer)object3).append("INDEX_OWNER").append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object3).append("AND").append(' ');
            ((StringBuffer)object3).append("INDEX_NAME").append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object3).append("ORDER BY").append(' ');
            ((StringBuffer)object3).append("PARTITION_POSITION");
            object2 = ((StringBuffer)object3).toString();
            this.indpart_st = connection.prepareStatement((String)object2);
        }
        object3 = null;
        try {
            object2 = indexProxyOracle.getUser();
            string2 = "";
            if (object2 != null) {
                string2 = ((StorageObject)object2).getName();
            } else {
                object = indexProxyOracle.getIndex().getSchemaObject();
                if (object != null) {
                    string2 = ((DesignObject)object).getName();
                }
            }
            this.indpart_st.setString(1, string2);
            this.indpart_st.setString(2, indexProxyOracle.getName());
            object3 = this.indpart_st.executeQuery();
        }
        catch (Exception exception) {
            LOGGER.error("MOHTableOracle.initIndexPartitioning():", exception);
        }
        if (object3 != null) {
            if (string.equals("LOCAL")) {
                object2 = (TableProxyOracle)indexProxyOracle.getTableProxy();
                while (object3.next()) {
                    Object object4;
                    StorageObject storageObject;
                    int n = object3.getInt("PARTITION_POSITION") - 1;
                    object = object3.getString("PARAMETERS");
                    String string3 = object3.getString("PARTITION_NAME");
                    String string4 = object3.getString("COMPRESSION");
                    if (n < 0 || n >= ((TableProxyOracle)object2).getPartitions().size() || (storageObject = (StorageObject)((TableProxyOracle)object2).getPartitions().getElement(n)) == null) continue;
                    LocalIndexProperties localIndexProperties = storageDesignOracle.getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(storageObject, indexProxyOracle);
                    if (localIndexProperties == null) {
                        localIndexProperties = storageDesignOracle.getLocalIndexPropertiesSet().createLocalIndexProperties();
                        localIndexProperties.setIndex(indexProxyOracle);
                        localIndexProperties.setPartition(storageObject);
                        localIndexProperties.setLogging(indexProxyOracle.getLogging());
                    }
                    localIndexProperties.setPartitionName(string3);
                    if (string4 != null) {
                        try {
                            if (!string4.equalsIgnoreCase("DISABLED")) {
                                localIndexProperties.setKeyCompression(1);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            LOGGER.error("MOHTableOracle.initIndexPartitioning(): Can not parse string value for KeyCompression", numberFormatException);
                        }
                    }
                    if (object != null) {
                        object4 = new StringTokenizer((String)object, " ");
                        while (((StringTokenizer)object4).hasMoreTokens()) {
                            AbstractStorageObjectOracle abstractStorageObjectOracle;
                            String string5 = ((StringTokenizer)object4).nextToken();
                            String[] stringArray = string5.split("=");
                            if (stringArray.length != 2) continue;
                            String string6 = stringArray[0];
                            String string7 = stringArray[1];
                            if (string7.equals("")) continue;
                            if (string6.equalsIgnoreCase("tablespace")) {
                                abstractStorageObjectOracle = (TableSpaceOracle)storageDesignOracle.getTableSpaceSet().getByName(string7);
                                if (abstractStorageObjectOracle == null) {
                                    abstractStorageObjectOracle = storageDesignOracle.getTableSpaceSet().createTableSpace();
                                    ((TableSpaceOracle)abstractStorageObjectOracle).setName(string7);
                                    this.stampModelObject((ModelObject)abstractStorageObjectOracle, indexProxyOracle, string7);
                                }
                                localIndexProperties.setTableSpace((TableSpaceOracle)abstractStorageObjectOracle);
                                continue;
                            }
                            if (string6.equalsIgnoreCase("work_tablespace")) {
                                abstractStorageObjectOracle = (TableSpaceOracle)storageDesignOracle.getTableSpaceSet().getByName(string7);
                                if (abstractStorageObjectOracle == null) {
                                    abstractStorageObjectOracle = storageDesignOracle.getTableSpaceSet().createTableSpace();
                                    ((TableSpaceOracle)abstractStorageObjectOracle).setName(string7);
                                    this.stampModelObject((ModelObject)abstractStorageObjectOracle, indexProxyOracle, string7);
                                }
                                localIndexProperties.setWorkTablespace((TableSpaceOracle)abstractStorageObjectOracle);
                                continue;
                            }
                            if (string6.equalsIgnoreCase("layer_gtype")) {
                                localIndexProperties.setLayerType(string7);
                                continue;
                            }
                            if (string6.equalsIgnoreCase("sdo_non_leaf_tbl") && string7.equalsIgnoreCase("TRUE")) {
                                if (storageDesignOracle instanceof StorageDesignOraclev9i) {
                                    ((IndexProxyOraclev9i)indexProxyOracle).setNonLeaf("YES");
                                    continue;
                                }
                                if (!(storageDesignOracle instanceof StorageDesignOraclev10g)) continue;
                                ((IndexProxyOraclev10g)indexProxyOracle).setNonLeaf("YES");
                                continue;
                            }
                            abstractStorageObjectOracle = localIndexProperties.getSegment();
                            if (abstractStorageObjectOracle == null) {
                                abstractStorageObjectOracle = storageDesignOracle.getSegmentSet().createSegment();
                                localIndexProperties.setSegment((SegmentOracle)abstractStorageObjectOracle);
                            }
                            try {
                                if (string6.equalsIgnoreCase("initial")) {
                                    ((SegmentOracle)abstractStorageObjectOracle).setInitrans(Integer.parseInt(string7));
                                    continue;
                                }
                                if (string6.equalsIgnoreCase("next")) {
                                    ((SegmentOracle)abstractStorageObjectOracle).setSCNextExtent(Long.parseLong(string7));
                                    continue;
                                }
                                if (string6.equalsIgnoreCase("minextents")) {
                                    ((SegmentOracle)abstractStorageObjectOracle).setSCMinExtents(Integer.parseInt(string7));
                                    continue;
                                }
                                if (string6.equalsIgnoreCase("maxextents")) {
                                    ((SegmentOracle)abstractStorageObjectOracle).setSCMaxExtents(string7);
                                    continue;
                                }
                                if (string6.equalsIgnoreCase("pctincrease")) {
                                    ((SegmentOracle)abstractStorageObjectOracle).setSCPctIncrease(Integer.parseInt(string7));
                                    continue;
                                }
                                if (!string6.equalsIgnoreCase("sdo_rdr_pctfree")) continue;
                                ((SegmentOracle)abstractStorageObjectOracle).setPCTFree(Integer.parseInt(string7));
                            }
                            catch (NumberFormatException numberFormatException) {
                                LOGGER.error("MOHTableOracle.initIndexPartitioning(): Can not parse string value", numberFormatException);
                            }
                        }
                        continue;
                    }
                    object4 = object3.getString("TABLESPACE_NAME");
                    int n2 = object3.getInt("INI_TRANS");
                    int n3 = object3.getInt("MAX_TRANS");
                    long l = object3.getLong("INITIAL_EXTENT");
                    long l2 = object3.getLong("NEXT_EXTENT");
                    int n4 = Integer.MAX_VALUE;
                    int n5 = Integer.MAX_VALUE;
                    try {
                        n4 = object3.getInt("MIN_EXTENT");
                    }
                    catch (Exception exception) {
                        LOGGER.error("error in min_extent", exception);
                    }
                    try {
                        n5 = object3.getInt("MAX_EXTENT");
                    }
                    catch (Exception exception) {
                        LOGGER.error("error in max_extent", exception);
                    }
                    int n6 = object3.getInt("PCT_INCREASE");
                    int n7 = object3.getInt("FREELISTS");
                    int n8 = object3.getInt("FREELIST_GROUPS");
                    int n9 = object3.getInt("PCT_FREE");
                    String string8 = object3.getString("LOGGING");
                    String string9 = object3.getString("BUFFER_POOL");
                    TableSpaceOracle tableSpaceOracle = (TableSpaceOracle)storageDesignOracle.getTableSpaceSet().getByName((String)object4);
                    if (tableSpaceOracle == null) {
                        tableSpaceOracle = storageDesignOracle.getTableSpaceSet().createTableSpace();
                        tableSpaceOracle.setName((String)object4);
                        this.stampModelObject((ModelObject)tableSpaceOracle, indexProxyOracle, (String)object4);
                    }
                    localIndexProperties.setTableSpace(tableSpaceOracle);
                    SegmentOracle segmentOracle = storageDesignOracle.getSegmentSet().createSegment();
                    segmentOracle.setInitrans(n2);
                    segmentOracle.setMaxTrans(n3);
                    segmentOracle.setSCInitialExtent(l);
                    segmentOracle.setSCNextExtent(l2);
                    segmentOracle.setSCMinExtents(n4);
                    segmentOracle.setSCMaxExtents(String.valueOf(n5));
                    segmentOracle.setSCPctIncrease(n6);
                    segmentOracle.setSCFreeLists(n7);
                    segmentOracle.setSCFreelistGroups(n8);
                    segmentOracle.setPCTFree(n9);
                    if (string8 != null) {
                        localIndexProperties.setLogging(string8.trim().toUpperCase());
                    }
                    if (string9 != null) {
                        segmentOracle.setSCBufferPool(string9.trim());
                    }
                    segmentOracle = storageDesignOracle.getSegmentSet().findEqual(segmentOracle);
                    localIndexProperties.setSegment(segmentOracle);
                }
            } else {
                object2 = indexProxyOracle.getIndexGlobalPartitionsList();
                if (object2 != null) {
                    while (object3.next()) {
                        string2 = object3.getString("HIGH_VALUE");
                        object = object3.getString("PARAMETERS");
                        if (object != null) continue;
                        String string10 = object3.getString("PARTITION_NAME");
                        int n = object3.getInt("PARTITION_POSITION");
                        String string11 = object3.getString("TABLESPACE_NAME");
                        int n10 = object3.getInt("PCT_FREE");
                        int n11 = object3.getInt("INI_TRANS");
                        int n12 = object3.getInt("MAX_TRANS");
                        long l = object3.getLong("INITIAL_EXTENT");
                        long l3 = object3.getLong("NEXT_EXTENT");
                        int n13 = Integer.MAX_VALUE;
                        int n14 = Integer.MAX_VALUE;
                        try {
                            n13 = object3.getInt("MIN_EXTENT");
                        }
                        catch (Exception exception) {
                            LOGGER.error("error in min_extent", exception);
                        }
                        try {
                            n14 = object3.getInt("MAX_EXTENT");
                        }
                        catch (Exception exception) {
                            LOGGER.error("error in max_extent", exception);
                        }
                        int n15 = object3.getInt("PCT_INCREASE");
                        int n16 = object3.getInt("FREELISTS");
                        int n17 = object3.getInt("FREELIST_GROUPS");
                        String string12 = object3.getString("LOGGING");
                        String string13 = object3.getString("BUFFER_POOL");
                        TableSpaceOracle tableSpaceOracle = null;
                        if (string11 != null && !"".equalsIgnoreCase(string11) && (tableSpaceOracle = (TableSpaceOracle)storageDesignOracle.getTableSpaceSet().getByName(string11)) == null) {
                            tableSpaceOracle = storageDesignOracle.getTableSpaceSet().createTableSpace();
                            tableSpaceOracle.setName(string11);
                            this.stampModelObject((ModelObject)tableSpaceOracle, indexProxyOracle, string11);
                        }
                        SegmentOracle segmentOracle = storageDesignOracle.getSegmentSet().createSegment();
                        segmentOracle.setPCTFree(n10);
                        segmentOracle.setInitrans(n11);
                        segmentOracle.setMaxTrans(n12);
                        segmentOracle.setSCInitialExtent(l);
                        segmentOracle.setSCNextExtent(l3);
                        segmentOracle.setSCMinExtents(n13);
                        segmentOracle.setSCMaxExtents(String.valueOf(n14));
                        segmentOracle.setSCPctIncrease(n15);
                        segmentOracle.setSCFreeLists(n16);
                        segmentOracle.setSCFreelistGroups(n17);
                        if (string13 != null) {
                            segmentOracle.setSCBufferPool(string13.trim());
                        }
                        segmentOracle = storageDesignOracle.getSegmentSet().findEqual(segmentOracle);
                        IndexGlobalPartitionOracle indexGlobalPartitionOracle = storageDesignOracle.getIndexGlobalPartitionSet().createIndexGlobalPartition();
                        indexGlobalPartitionOracle.setName(string10);
                        indexGlobalPartitionOracle.setIndexGlobalPartList((IndexGlobalPartitionsListOracle)object2);
                        this.stampModelObject((ModelObject)indexGlobalPartitionOracle, indexProxyOracle, string10);
                        indexGlobalPartitionOracle.setPosition(n);
                        if (string2 != null) {
                            indexGlobalPartitionOracle.setValueList(string2);
                        }
                        if (tableSpaceOracle != null) {
                            indexGlobalPartitionOracle.setTableSpace(tableSpaceOracle);
                        }
                        if (!"NONE".equalsIgnoreCase(string12)) {
                            indexGlobalPartitionOracle.setLogging(string12);
                        }
                        indexGlobalPartitionOracle.setSegment(segmentOracle);
                    }
                }
            }
            object3.close();
        }
    }

    private void setIndexPartitioning(Connection connection, StorageDesignOracle storageDesignOracle, List list) throws Exception {
        this.indpartype_st = null;
        this.indglobpartcols_st = null;
        this.indpart_st = null;
        for (DBObject dBObject : list) {
            Object object;
            Object object2;
            TableProxyOracle tableProxyOracle = (TableProxyOracle)dBObject.getTableProxy();
            Iterator iterator = tableProxyOracle.getPrimaryKeys().iterator();
            while (iterator.hasNext()) {
                object2 = (PKProxyOracle)iterator.next();
                if (!((IndexProxy)object2).isPartitioned()) continue;
                this.setIndexPartitioningInfo(connection, (IndexProxyOracle)object2, storageDesignOracle);
            }
            object2 = tableProxyOracle.getUniqueKeys().iterator();
            while (object2.hasNext()) {
                object = (UniqueOracle)object2.next();
                if (!((IndexProxy)object).isPartitioned()) continue;
                this.setIndexPartitioningInfo(connection, (IndexProxyOracle)object, storageDesignOracle);
            }
            object = tableProxyOracle.getIndexes().iterator();
            while (object.hasNext()) {
                IndexProxyOracle indexProxyOracle = (IndexProxyOracle)object.next();
                if (!indexProxyOracle.isPartitioned()) continue;
                this.setIndexPartitioningInfo(connection, indexProxyOracle, storageDesignOracle);
            }
        }
        if (this.indpartype_st != null) {
            this.indpartype_st.close();
        }
        if (this.indglobpartcols_st != null) {
            this.indglobpartcols_st.close();
        }
        if (this.indpart_st != null) {
            this.indpart_st.close();
        }
    }

    private void setIndexPartitioningInfo(Connection connection, IndexProxyOracle indexProxyOracle, StorageDesignOracle storageDesignOracle) throws SQLException {
        String string;
        Object object;
        UserOracle userOracle = indexProxyOracle.getUser();
        String string2 = "";
        if (userOracle != null) {
            string2 = userOracle.getName();
        } else {
            object = indexProxyOracle.getIndex().getSchemaObject();
            if (object != null) {
                string2 = ((DesignObject)object).getName();
            }
        }
        if (this.indpartype_st == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ');
            ((StringBuffer)object).append("LOCALITY").append(',');
            ((StringBuffer)object).append("PARTITIONING_TYPE").append(',');
            ((StringBuffer)object).append("PARTITION_COUNT").append(',');
            ((StringBuffer)object).append("DEF_TABLESPACE_NAME").append(',');
            ((StringBuffer)object).append("DEF_PCT_FREE").append(',');
            ((StringBuffer)object).append("DEF_INI_TRANS").append(',');
            ((StringBuffer)object).append("DEF_MAX_TRANS").append(',');
            ((StringBuffer)object).append("DEF_INITIAL_EXTENT").append(',');
            ((StringBuffer)object).append("DEF_NEXT_EXTENT").append(',');
            ((StringBuffer)object).append("DEF_MIN_EXTENTS").append(',');
            ((StringBuffer)object).append("DEF_MAX_EXTENTS").append(',');
            ((StringBuffer)object).append("DEF_PCT_INCREASE").append(',');
            ((StringBuffer)object).append("DEF_FREELISTS").append(',');
            ((StringBuffer)object).append("DEF_FREELIST_GROUPS").append(',');
            ((StringBuffer)object).append("DEF_LOGGING").append(',');
            ((StringBuffer)object).append("DEF_BUFFER_POOL").append(' ');
            ((StringBuffer)object).append("FROM").append(' ');
            ((StringBuffer)object).append(this.dbaUser ? "dba_part_indexes" : "all_part_indexes").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ');
            ((StringBuffer)object).append("OWNER").append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object).append("AND").append(' ');
            ((StringBuffer)object).append("INDEX_NAME").append('=').append(' ').append('?').append(' ');
            string = ((StringBuffer)object).toString();
            this.indpartype_st = connection.prepareStatement(string);
        }
        object = null;
        try {
            this.indpartype_st.setString(1, string2);
            this.indpartype_st.setString(2, indexProxyOracle.getName());
            object = this.indpartype_st.executeQuery();
        }
        catch (Exception exception) {
            LOGGER.error("MOHTableOracle.setIndexPartitioningInfo():", exception);
        }
        if (object != null) {
            if (object.next()) {
                string = "";
                String string3 = object.getString("LOCALITY");
                if ("LOCAL".equalsIgnoreCase(string3)) {
                    string = "LOCAL";
                    this.setPartitionType(indexProxyOracle, string);
                    this.setIndexTableSpace(indexProxyOracle, storageDesignOracle, object.getString("DEF_TABLESPACE_NAME"));
                    this.setDefIndexProperties(indexProxyOracle, storageDesignOracle, (ResultSet)object);
                } else if ("GLOBAL".equalsIgnoreCase(string3)) {
                    String string4;
                    Object object2;
                    IndexGlobalPartitionsListOracle indexGlobalPartitionsListOracle = storageDesignOracle.getIndexGlobalPartitionsListSet().createIndexGlobalPartitionsList();
                    indexProxyOracle.setIndexGlobalPartitionsList(indexGlobalPartitionsListOracle);
                    indexGlobalPartitionsListOracle.setIndex(indexProxyOracle);
                    if (storageDesignOracle instanceof StorageDesignOraclev10g) {
                        object2 = object.getString("PARTITIONING_TYPE");
                        if (((String)object2).equalsIgnoreCase("RANGE")) {
                            string = "GLOBAL BY RANGE";
                        } else {
                            string = "GLOBAL HASH PARTITIONED BY QUANTITY";
                            ((IndexGlobalPartitionsListOraclev10g)indexGlobalPartitionsListOracle).setHashPQuantity(object.getInt("PARTITION_COUNT"));
                        }
                    } else {
                        string = "GLOBAL";
                    }
                    this.setPartitionType(indexProxyOracle, string);
                    if (this.indglobpartcols_st == null) {
                        object2 = new StringBuffer();
                        ((StringBuffer)object2).append("SELECT").append(' ');
                        ((StringBuffer)object2).append("COLUMN_NAME").append(',');
                        ((StringBuffer)object2).append("COLUMN_POSITION").append(' ');
                        ((StringBuffer)object2).append("FROM").append(' ');
                        ((StringBuffer)object2).append(this.dbaUser ? "dba_part_key_columns" : "all_part_key_columns").append(' ');
                        ((StringBuffer)object2).append("WHERE").append(' ');
                        ((StringBuffer)object2).append("OWNER").append('=').append(' ').append('?').append(' ');
                        ((StringBuffer)object2).append("AND").append(' ');
                        ((StringBuffer)object2).append("NAME").append('=').append(' ').append('?').append(' ');
                        ((StringBuffer)object2).append("AND").append(' ');
                        ((StringBuffer)object2).append("OBJECT_TYPE").append('=').append('\'');
                        ((StringBuffer)object2).append("INDEX").append('\'').append(' ');
                        ((StringBuffer)object2).append("ORDER BY").append(' ');
                        ((StringBuffer)object2).append("COLUMN_POSITION");
                        string4 = ((StringBuffer)object2).toString();
                        this.indglobpartcols_st = connection.prepareStatement(string4);
                    }
                    object2 = null;
                    try {
                        this.indglobpartcols_st.setString(1, string2);
                        this.indglobpartcols_st.setString(2, indexProxyOracle.getName());
                        object2 = this.indglobpartcols_st.executeQuery();
                    }
                    catch (Exception exception) {
                        LOGGER.error("MOHTableOracle.setIndexPartitioningInfo():", exception);
                    }
                    if (object2 != null) {
                        while (object2.next()) {
                            string4 = object2.getString("COLUMN_NAME");
                            indexGlobalPartitionsListOracle.setGlobalPartColumns(indexGlobalPartitionsListOracle.columnNamesToColumnIDs(string4));
                        }
                        object2.close();
                    }
                }
                if (string.equals("LOCAL") || string.equals("GLOBAL BY RANGE") || string.equals("GLOBAL")) {
                    this.initIndexPartitioning(connection, indexProxyOracle, string);
                }
            }
            object.close();
        }
    }

    private void setPartitionType(IndexProxyOracle indexProxyOracle, String string) {
        boolean bl = indexProxyOracle instanceof PKProxyOracle;
        boolean bl2 = indexProxyOracle instanceof UniqueOracle;
        if (bl || bl2) {
            if (indexProxyOracle instanceof PKProxyOraclev9i || indexProxyOracle instanceof UniqueOraclev9i) {
                if (string.equals("LOCAL")) {
                    string = "LOCAL PARTITIONED";
                } else if (string.startsWith("GLOBAL")) {
                    string = "GLOBAL PARTITIONED";
                }
            }
            if (bl) {
                ((PKProxyOracle)indexProxyOracle).setUsingIndex(string);
            } else {
                ((UniqueOracle)indexProxyOracle).setUsingIndex(string);
            }
        } else {
            indexProxyOracle.setIndexPartitioned(string);
        }
    }

    private void setUser(TableProxyOracle tableProxyOracle, StorageDesignOracle storageDesignOracle, String string) {
        UserOracle userOracle = (UserOracle)storageDesignOracle.getUserSet().getByName(string);
        tableProxyOracle.setUser(userOracle);
    }

    private void setTableSpace(TableProxyOracle tableProxyOracle, StorageDesignOracle storageDesignOracle, String string) throws Exception {
        if (string != null && !"".equalsIgnoreCase(string)) {
            TableSpaceOracle tableSpaceOracle = (TableSpaceOracle)storageDesignOracle.getTableSpaceSet().getByName(string);
            if (tableSpaceOracle == null) {
                tableSpaceOracle = storageDesignOracle.getTableSpaceSet().createTableSpace();
                tableSpaceOracle.setName(string);
                this.stampModelObject((ModelObject)tableSpaceOracle, tableProxyOracle, string);
            }
            tableProxyOracle.setTableSpace(tableSpaceOracle);
        }
    }

    private void setCluster(TableProxyOracle tableProxyOracle, StorageDesignOracle storageDesignOracle, ResultSet resultSet) throws Exception {
        ClusterOracle clusterOracle;
        String string = resultSet.getString("CLUSTER_NAME");
        if (string != null && !"".equalsIgnoreCase(string) && (clusterOracle = (ClusterOracle)storageDesignOracle.getClusterSet().getByName(string)) != null) {
            tableProxyOracle.setCluster(clusterOracle);
            this.containsClusterRefs = true;
        }
    }

    private void setProperties(TableProxyOracle tableProxyOracle, StorageDesignOracle storageDesignOracle, ResultSet resultSet) throws Exception {
        String string = resultSet.getString("LOGGING");
        String string2 = resultSet.getString("DEGREE");
        String string3 = resultSet.getString("PARTITIONED");
        String string4 = resultSet.getString("TEMPORARY");
        String string5 = resultSet.getString("DURATION");
        String string6 = resultSet.getString("CACHE");
        String string7 = resultSet.getString("ROW_MOVEMENT");
        String string8 = null;
        String string9 = null;
        String string10 = null;
        if (storageDesignOracle instanceof StorageDesignOraclev9i) {
            string8 = resultSet.getString("MONITORING");
        } else {
            string9 = resultSet.getString("COMPRESSION");
            string10 = resultSet.getString("DEPENDENCIES");
        }
        String string11 = resultSet.getString("IOT_TYPE");
        if ("YES".equalsIgnoreCase(string3.trim())) {
            tableProxyOracle.setPartitioned("YES");
            this.isPartitioned = true;
        } else {
            tableProxyOracle.setPartitioned("NO");
            SegmentOracle segmentOracle = storageDesignOracle.getSegmentSet().createSegment();
            int n = resultSet.getInt("INI_TRANS");
            int n2 = resultSet.getInt("MAX_TRANS");
            long l = resultSet.getLong("INITIAL_EXTENT");
            long l2 = resultSet.getLong("NEXT_EXTENT");
            int n3 = Integer.MAX_VALUE;
            String string12 = "";
            try {
                n3 = resultSet.getInt("MIN_EXTENTS");
            }
            catch (Exception exception) {
                LOGGER.error("error in min_extent", exception);
            }
            try {
                string12 = resultSet.getString("MAX_EXTENTS");
            }
            catch (Exception exception) {
                LOGGER.error("error in max_extent", exception);
            }
            int n4 = resultSet.getInt("PCT_INCREASE");
            int n5 = resultSet.getInt("FREELISTS");
            int n6 = resultSet.getInt("FREELIST_GROUPS");
            int n7 = resultSet.getInt("PCT_FREE");
            int n8 = resultSet.getInt("PCT_USED");
            String string13 = resultSet.getString("BUFFER_POOL");
            segmentOracle.setInitrans(n);
            segmentOracle.setMaxTrans(n2);
            segmentOracle.setSCInitialExtent(l);
            segmentOracle.setSCNextExtent(l2);
            segmentOracle.setSCMinExtents(n3);
            segmentOracle.setSCMaxExtents(String.valueOf(string12));
            segmentOracle.setSCPctIncrease(n4);
            segmentOracle.setSCFreeLists(n5);
            segmentOracle.setSCFreelistGroups(n6);
            if (n7 > 0 || resultSet.getObject("PCT_FREE") != null) {
                segmentOracle.setPCTFree(n7);
            }
            if (n8 > 0) {
                segmentOracle.setPCTUsed(n8);
            }
            if (string13 != null) {
                segmentOracle.setSCBufferPool(string13.trim().toUpperCase());
            }
            segmentOracle = storageDesignOracle.getSegmentSet().findEqual(segmentOracle);
            tableProxyOracle.setSegment(segmentOracle);
        }
        if (string != null) {
            tableProxyOracle.setLogging(string.trim().toUpperCase());
        }
        if ("ENABLED".equalsIgnoreCase(string9)) {
            tableProxyOracle.setDataSegmentCompression("YES");
        } else if ("DISABLED".equalsIgnoreCase(string9)) {
            tableProxyOracle.setDataSegmentCompression("NO");
        }
        if ("ENABLED".equalsIgnoreCase(string10)) {
            tableProxyOracle.setRowDependency("YES");
        }
        if ("1".equalsIgnoreCase(string2.trim())) {
            tableProxyOracle.setParallel("NO");
        } else {
            tableProxyOracle.setParallel("YES");
        }
        if ("Y".equalsIgnoreCase(string4.trim())) {
            tableProxyOracle.setTemporary("YES");
            if ("SYS$TRANSACTION".equalsIgnoreCase(string5)) {
                tableProxyOracle.setTempPreserveRows("NO");
            } else {
                tableProxyOracle.setTempPreserveRows("YES");
            }
        } else {
            tableProxyOracle.setTemporary("NO");
        }
        if ("YES".equalsIgnoreCase(string8)) {
            tableProxyOracle.setMonitoring("YES");
        } else {
            tableProxyOracle.setMonitoring("NO");
        }
        if ("DISABLED".equalsIgnoreCase(string7)) {
            tableProxyOracle.setParttitionedRowMovement("DISABLE");
        } else {
            tableProxyOracle.setParttitionedRowMovement("ENABLE");
        }
        if ("Y".equalsIgnoreCase(string6)) {
            tableProxyOracle.setCache("YES");
        } else {
            tableProxyOracle.setCache("NO");
        }
        if (string11 != null) {
            tableProxyOracle.setOrganization("INDEX");
        }
    }

    private void setDefProperties(TableProxyOracle tableProxyOracle, StorageDesignOracle storageDesignOracle, ResultSet resultSet) throws Exception {
        SegmentOracle segmentOracle = storageDesignOracle.getSegmentSet().createSegment();
        int n = resultSet.getInt("DEF_INI_TRANS");
        int n2 = resultSet.getInt("DEF_MAX_TRANS");
        String string = resultSet.getString("DEF_INITIAL_EXTENT");
        String string2 = resultSet.getString("DEF_NEXT_EXTENT");
        String string3 = resultSet.getString("DEF_MIN_EXTENTS");
        String string4 = resultSet.getString("DEF_MAX_EXTENTS");
        String string5 = resultSet.getString("DEF_PCT_INCREASE");
        int n3 = resultSet.getInt("DEF_FREELISTS");
        int n4 = resultSet.getInt("DEF_FREELIST_GROUPS");
        int n5 = resultSet.getInt("DEF_PCT_FREE");
        int n6 = resultSet.getInt("DEF_PCT_USED");
        String string6 = resultSet.getString("DEF_BUFFER_POOL");
        String string7 = resultSet.getString("DEF_LOGGING");
        String string8 = null;
        if (!(storageDesignOracle instanceof StorageDesignOraclev9i)) {
            string8 = resultSet.getString("DEF_COMPRESSION");
        }
        segmentOracle.setInitrans(n);
        segmentOracle.setMaxTrans(n2);
        try {
            if (string != null && !string.equals("DEFAULT")) {
                segmentOracle.setSCInitialExtent(Long.parseLong(string.trim()));
            }
        }
        catch (Exception exception) {
            LOGGER.error("error in DEF_INITIAL_EXTENT", exception);
        }
        try {
            if (string2 != null && !string2.equals("DEFAULT")) {
                segmentOracle.setSCNextExtent(Long.parseLong(string2.trim()));
            }
        }
        catch (Exception exception) {
            LOGGER.error("error in DEF_NEXT_EXTENT", exception);
        }
        try {
            if (string3 != null && !string3.equals("DEFAULT")) {
                segmentOracle.setSCMinExtents(Integer.parseInt(string3.trim()));
            }
        }
        catch (Exception exception) {
            LOGGER.error("error in DEF_MIN_EXTENTS", exception);
        }
        if (string4 != null && !string4.equals("DEFAULT")) {
            segmentOracle.setSCMaxExtents(string4.trim());
        }
        try {
            if (string5 != null && !string5.equals("DEFAULT")) {
                segmentOracle.setSCPctIncrease(Integer.parseInt(string5.trim()));
            }
        }
        catch (Exception exception) {
            LOGGER.error("error in DEF_PCT_INCREASE", exception);
        }
        segmentOracle.setSCFreeLists(n3);
        segmentOracle.setSCFreelistGroups(n4);
        if (n5 > 0 || resultSet.getObject("DEF_PCT_FREE") != null) {
            segmentOracle.setPCTFree(n5);
        }
        if (n6 > 0) {
            segmentOracle.setPCTUsed(n6);
        }
        if (string6 != null) {
            segmentOracle.setSCBufferPool(string6.trim().toUpperCase());
        }
        if (string7 != null) {
            tableProxyOracle.setLogging(string7.trim().toUpperCase());
        }
        if ("ENABLED".equalsIgnoreCase(string8)) {
            tableProxyOracle.setDataSegmentCompression("YES");
        } else if ("DISABLED".equalsIgnoreCase(string8)) {
            tableProxyOracle.setDataSegmentCompression("NO");
        }
        segmentOracle = storageDesignOracle.getSegmentSet().findEqual(segmentOracle);
        tableProxyOracle.setSegment(segmentOracle);
    }

    private void setPartitionInfo(Connection connection, StorageDesignOracle storageDesignOracle, List list) throws Exception {
        this.part_statement = null;
        this.partLS_statement = null;
        this.subpartCol_statement = null;
        this.subpartTemplate_statement = null;
        this.subPart_statement = null;
        this.subPartLS_statement = null;
        this.subPartListLS_statement = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT").append(' ');
        stringBuffer.append("COLUMN_NAME").append(',');
        stringBuffer.append("COLUMN_POSITION").append(' ');
        stringBuffer.append("FROM").append(' ');
        stringBuffer.append(this.dbaUser ? "dba_part_key_columns" : "all_part_key_columns").append(' ');
        stringBuffer.append("WHERE").append(' ');
        stringBuffer.append("OWNER").append('=').append(' ').append('?').append(' ');
        stringBuffer.append("AND").append(' ');
        stringBuffer.append("NAME").append('=').append(' ').append('?').append(' ');
        stringBuffer.append("AND").append(' ');
        stringBuffer.append("OBJECT_TYPE").append('=').append('\'');
        stringBuffer.append("TABLE").append('\'').append(' ');
        stringBuffer.append("ORDER BY").append(' ');
        stringBuffer.append("COLUMN_POSITION");
        String string = stringBuffer.toString();
        Statement statement = null;
        boolean bl = storageDesignOracle instanceof StorageDesignOraclev9i;
        boolean bl2 = storageDesignOracle instanceof StorageDesignOraclev11g;
        stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT").append(' ');
        stringBuffer.append("TABLE_NAME").append(',');
        stringBuffer.append("PARTITIONING_TYPE").append(',');
        stringBuffer.append("SUBPARTITIONING_TYPE").append(',');
        stringBuffer.append("DEF_TABLESPACE_NAME").append(',');
        stringBuffer.append("DEF_PCT_FREE").append(',');
        stringBuffer.append("DEF_PCT_USED").append(',');
        stringBuffer.append("DEF_INI_TRANS").append(',');
        stringBuffer.append("DEF_MAX_TRANS").append(',');
        stringBuffer.append("DEF_INITIAL_EXTENT").append(',');
        stringBuffer.append("DEF_NEXT_EXTENT").append(',');
        stringBuffer.append("DEF_MIN_EXTENTS").append(',');
        stringBuffer.append("DEF_MAX_EXTENTS").append(',');
        stringBuffer.append("DEF_PCT_INCREASE").append(',');
        stringBuffer.append("DEF_FREELISTS").append(',');
        stringBuffer.append("DEF_FREELIST_GROUPS").append(',');
        stringBuffer.append("DEF_LOGGING").append(',');
        if (!bl) {
            stringBuffer.append("DEF_COMPRESSION").append(',');
        }
        stringBuffer.append("DEF_BUFFER_POOL").append(',');
        stringBuffer.append("PARTITION_COUNT");
        if (bl2) {
            stringBuffer.append(',');
            stringBuffer.append("INTERVAL").append(',');
            stringBuffer.append("REF_PTN_CONSTRAINT_NAME");
        }
        stringBuffer.append(' ');
        stringBuffer.append("FROM").append(' ');
        stringBuffer.append(this.dbaUser ? "dba_part_tables" : "all_part_tables").append(' ');
        stringBuffer.append("WHERE").append(' ');
        stringBuffer.append("OWNER").append('=').append(' ').append('?').append(' ');
        stringBuffer.append("AND").append(' ');
        stringBuffer.append("TABLE_NAME").append('=').append(' ').append('?').append(' ');
        stringBuffer.append("ORDER BY").append(' ');
        stringBuffer.append("TABLE_NAME");
        String string2 = stringBuffer.toString();
        PreparedStatement preparedStatement = null;
        for (DBObject dBObject : list) {
            if (!dBObject.partitioned) continue;
            TableProxyOracle tableProxyOracle = (TableProxyOracle)dBObject.getTableProxy();
            String string3 = dBObject.getSchema();
            ResultSet resultSet = null;
            try {
                if (preparedStatement == null) {
                    preparedStatement = connection.prepareStatement(string2);
                }
                preparedStatement.setString(1, dBObject.getSchema());
                preparedStatement.setString(2, tableProxyOracle.getName());
                resultSet = preparedStatement.executeQuery();
                if (resultSet == null) continue;
                while (resultSet.next()) {
                    this.setTableSpace(tableProxyOracle, storageDesignOracle, resultSet.getString("DEF_TABLESPACE_NAME"));
                    this.setDefProperties(tableProxyOracle, storageDesignOracle, resultSet);
                    String string4 = resultSet.getString("PARTITIONING_TYPE").trim();
                    String string5 = resultSet.getString("SUBPARTITIONING_TYPE").trim();
                    int n = resultSet.getInt("PARTITION_COUNT");
                    PartitionListOracle partitionListOracle = storageDesignOracle.getPartitionListSet().createPartitionList();
                    if ("HASH".equalsIgnoreCase(string4)) {
                        partitionListOracle.setPartitionType("HASH BY LIST OF PARTITIONS");
                    } else if ("HASH".equalsIgnoreCase(string5) && !bl2) {
                        partitionListOracle.setPartitionType("COMPOSITE BY HASH");
                    } else if ("LIST".equalsIgnoreCase(string5) && !bl2) {
                        partitionListOracle.setPartitionType("COMPOSITE BY LIST");
                    } else {
                        partitionListOracle.setPartitionType(string4);
                    }
                    if (bl2) {
                        String string6;
                        partitionListOracle.setSubpartitionType(string5);
                        String string7 = resultSet.getString("INTERVAL");
                        if (string7 != null) {
                            ((PartitionListOraclev11g)partitionListOracle).setIntervalExpression(string7);
                        }
                        if ((string6 = resultSet.getString("REF_PTN_CONSTRAINT_NAME")) != null) {
                            partitionListOracle.setTable(tableProxyOracle);
                            ((PartitionListOraclev11g)partitionListOracle).setRefConstraint(string6);
                        }
                    }
                    tableProxyOracle.setPartitionList(partitionListOracle);
                    if (statement == null) {
                        statement = connection.prepareStatement(string);
                    }
                    this.setPartitioningColumns(tableProxyOracle.getName(), string3, partitionListOracle, (PreparedStatement)statement);
                    if (!"NONE".equalsIgnoreCase(string5) && !"SYSTEM".equalsIgnoreCase(string5)) {
                        this.setSubPartitioningColumns(tableProxyOracle, tableProxyOracle.getName(), string3, partitionListOracle, connection);
                    }
                    if (n <= 0) continue;
                    this.setPartitions(tableProxyOracle, string3, storageDesignOracle, partitionListOracle, connection, string4);
                }
                resultSet.close();
            }
            catch (Exception exception) {
                LOGGER.error("MOHTableOracle.setPartitionInfo():", exception);
            }
        }
        if (this.subPart_statement != null) {
            this.subPart_statement.close();
        }
        if (this.subpartCol_statement != null) {
            this.subpartCol_statement.close();
        }
        if (this.subpartTemplate_statement != null) {
            this.subpartTemplate_statement.close();
        }
        if (this.partLS_statement != null) {
            this.partLS_statement.close();
        }
        if (this.subPartLS_statement != null) {
            this.subPartLS_statement.close();
        }
        if (this.subPartListLS_statement != null) {
            this.subPartListLS_statement.close();
        }
        if (this.part_statement != null) {
            this.part_statement.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (preparedStatement != null) {
            preparedStatement.close();
        }
    }

    private void setPartitioningColumns(String string, String string2, PartitionListOracle partitionListOracle, PreparedStatement preparedStatement) throws Exception {
        ResultSet resultSet = null;
        try {
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, string);
            resultSet = preparedStatement.executeQuery();
        }
        catch (Exception exception) {
            LOGGER.error("MOHTableOracle.setPartitioningColumns():", exception);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                String string3 = resultSet.getString("COLUMN_NAME");
                partitionListOracle.setColumnList(string3);
            }
            resultSet.close();
        }
    }

    private void setSubPartitioningColumns(TableProxyOracle tableProxyOracle, String string, String string2, PartitionListOracle partitionListOracle, Connection connection) throws Exception {
        String string3;
        Object object;
        if (this.subpartCol_statement == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ');
            ((StringBuffer)object).append("COLUMN_NAME").append(',');
            ((StringBuffer)object).append("COLUMN_POSITION").append(' ');
            ((StringBuffer)object).append("FROM").append(' ');
            ((StringBuffer)object).append(this.dbaUser ? "dba_subpart_key_columns" : "all_subpart_key_columns").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ');
            ((StringBuffer)object).append("OWNER").append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object).append("AND").append(' ');
            ((StringBuffer)object).append("NAME").append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object).append("AND").append(' ');
            ((StringBuffer)object).append("OBJECT_TYPE").append('=').append('\'');
            ((StringBuffer)object).append("TABLE").append('\'').append(' ');
            ((StringBuffer)object).append("ORDER BY").append(' ');
            ((StringBuffer)object).append("COLUMN_POSITION");
            string3 = ((StringBuffer)object).toString();
            this.subpartCol_statement = connection.prepareStatement(string3);
        }
        object = null;
        try {
            this.subpartCol_statement.setString(1, string2);
            this.subpartCol_statement.setString(2, string);
            object = this.subpartCol_statement.executeQuery();
        }
        catch (Exception exception) {
            LOGGER.error("MOHTableOracle.setSubPartitioningColumns():", exception);
        }
        if (object != null) {
            while (object.next()) {
                string3 = object.getString("COLUMN_NAME");
                partitionListOracle.setSubPartitionsColumnList(string3);
            }
            object.close();
            this.setSubPartitionTemplate(tableProxyOracle, string, string2, partitionListOracle, connection);
        }
    }

    private void setSubPartitionTemplate(TableProxyOracle tableProxyOracle, String string, String string2, PartitionListOracle partitionListOracle, Connection connection) throws Exception {
        String string3;
        Object object;
        if (this.subpartTemplate_statement == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ');
            ((StringBuffer)object).append("SUBPARTITION_NAME").append(',').append(' ');
            ((StringBuffer)object).append("SUBPARTITION_POSITION").append(',').append(' ');
            ((StringBuffer)object).append("TABLESPACE_NAME").append(',').append(' ');
            ((StringBuffer)object).append("HIGH_BOUND").append(' ');
            ((StringBuffer)object).append("FROM").append(' ');
            ((StringBuffer)object).append(this.dbaUser ? "dba_subpartition_templates" : "all_subpartition_templates").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ');
            ((StringBuffer)object).append("USER_NAME").append(' ').append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object).append("AND").append(' ').append("TABLE_NAME").append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object).append("ORDER BY").append(' ').append("SUBPARTITION_POSITION");
            string3 = ((StringBuffer)object).toString();
            this.subpartTemplate_statement = connection.prepareStatement(string3);
        }
        object = null;
        try {
            this.subpartTemplate_statement.setString(1, string2);
            this.subpartTemplate_statement.setString(2, string);
            object = this.subpartTemplate_statement.executeQuery();
        }
        catch (Exception exception) {
            LOGGER.error("MOHTableOracle.setSubPartitionTemplate():", exception);
        }
        if (object != null) {
            while (object.next()) {
                AbstractStorageObjectOracle abstractStorageObjectOracle;
                string3 = object.getString(1);
                String string4 = object.getString(3);
                StorageDesignOracle storageDesignOracle = (StorageDesignOracle)tableProxyOracle.getStorageDesign();
                TableSpaceOracle tableSpaceOracle = null;
                if (string4 != null && (tableSpaceOracle = (TableSpaceOracle)storageDesignOracle.getTableSpaceSet().getByName(string4)) == null) {
                    tableSpaceOracle = ((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().createTableSpace();
                    tableSpaceOracle.setName(string4);
                    this.stampModelObject((ModelObject)tableSpaceOracle, tableProxyOracle, string4);
                }
                String string5 = object.getString(4);
                String string6 = partitionListOracle.getSubpartitionType();
                if (string6.equals("HASH")) {
                    abstractStorageObjectOracle = storageDesignOracle.getHashPartitionSet().createHashPartition();
                    abstractStorageObjectOracle.setName(string3);
                    ((HashPartitionOracle)abstractStorageObjectOracle).setPartOfStorageTable(tableProxyOracle);
                    if (tableSpaceOracle != null) {
                        ((HashPartitionOracle)abstractStorageObjectOracle).setTableSpace(tableSpaceOracle);
                    }
                } else if (string6.equals("LIST")) {
                    abstractStorageObjectOracle = storageDesignOracle.getListStorageTemplatePartitionSet().createListStorageTemplatePartition();
                    abstractStorageObjectOracle.setName(string3);
                    ((ListStorageTemplatePartitionOracle)abstractStorageObjectOracle).setPartOfStorageTable(tableProxyOracle);
                    if (string5 != null) {
                        ((ListStorageTemplatePartitionOracle)abstractStorageObjectOracle).setValueList(string5);
                    }
                    if (tableSpaceOracle != null) {
                        ((ListStorageTemplatePartitionOracle)abstractStorageObjectOracle).setTablespace(tableSpaceOracle);
                    }
                } else if (string6.equals("RANGE")) {
                    abstractStorageObjectOracle = (PartitionOraclev11g)storageDesignOracle.getPartitionSet().createPartition();
                    abstractStorageObjectOracle.setName(string3);
                    ((PartitionOraclev11g)abstractStorageObjectOracle).setPartOfStorageTable(tableProxyOracle);
                    if (string5 != null) {
                        ((PartitionOracle)abstractStorageObjectOracle).setValueList(string5);
                    }
                    if (tableSpaceOracle != null) {
                        ((PartitionOracle)abstractStorageObjectOracle).setTableSpace(tableSpaceOracle);
                    }
                }
                ((PartitionListOraclev9i)partitionListOracle).setUseSubpartStorageTemplate("YES");
            }
            object.close();
        }
    }

    private void setPartitions(TableProxyOracle tableProxyOracle, String string, StorageDesignOracle storageDesignOracle, PartitionListOracle partitionListOracle, Connection connection, String string2) throws Exception {
        block26: {
            String string3;
            Object object;
            boolean bl = "LIST".equals(string2);
            boolean bl2 = "HASH".equals(string2);
            if (this.part_statement == null) {
                object = new StringBuffer();
                ((StringBuffer)object).append("SELECT").append(' ');
                ((StringBuffer)object).append("PARTITION_NAME").append(',');
                ((StringBuffer)object).append("SUBPARTITION_COUNT").append(',');
                ((StringBuffer)object).append("HIGH_VALUE").append(',');
                ((StringBuffer)object).append("PARTITION_POSITION").append(',');
                ((StringBuffer)object).append("TABLESPACE_NAME").append(',');
                ((StringBuffer)object).append("PCT_FREE").append(',');
                ((StringBuffer)object).append("PCT_USED").append(',');
                ((StringBuffer)object).append("INI_TRANS").append(',');
                ((StringBuffer)object).append("MAX_TRANS").append(',');
                ((StringBuffer)object).append("INITIAL_EXTENT").append(',');
                ((StringBuffer)object).append("NEXT_EXTENT").append(',');
                ((StringBuffer)object).append("MIN_EXTENT").append(',');
                ((StringBuffer)object).append("MAX_EXTENT").append(',');
                ((StringBuffer)object).append("PCT_INCREASE").append(',');
                ((StringBuffer)object).append("FREELISTS").append(',');
                ((StringBuffer)object).append("FREELIST_GROUPS").append(',');
                ((StringBuffer)object).append("LOGGING").append(',');
                ((StringBuffer)object).append("COMPRESSION").append(',');
                ((StringBuffer)object).append("BUFFER_POOL").append(' ');
                ((StringBuffer)object).append("FROM").append(' ');
                ((StringBuffer)object).append(this.dbaUser ? "dba_tab_partitions" : "all_tab_partitions").append(' ');
                ((StringBuffer)object).append("WHERE").append(' ');
                ((StringBuffer)object).append("TABLE_OWNER").append('=').append(' ').append('?').append(' ');
                ((StringBuffer)object).append("AND").append(' ');
                ((StringBuffer)object).append("TABLE_NAME").append('=').append(' ').append('?').append(' ');
                ((StringBuffer)object).append("ORDER BY").append(' ');
                ((StringBuffer)object).append("PARTITION_POSITION");
                string3 = ((StringBuffer)object).toString();
                this.part_statement = connection.prepareStatement(string3);
            }
            object = null;
            try {
                this.part_statement.setString(1, string);
                this.part_statement.setString(2, tableProxyOracle.getName());
                object = this.part_statement.executeQuery();
                if (object == null) break block26;
                while (object.next()) {
                    AbstractStorageObjectOracle abstractStorageObjectOracle;
                    AbstractStorageObjectOracle abstractStorageObjectOracle2;
                    string3 = object.getString("PARTITION_NAME");
                    int n = object.getInt("SUBPARTITION_COUNT");
                    String string4 = object.getString("HIGH_VALUE");
                    int n2 = object.getInt("PARTITION_POSITION");
                    String string5 = object.getString("TABLESPACE_NAME");
                    int n3 = object.getInt("PCT_FREE");
                    String string6 = object.getString("PCT_USED");
                    int n4 = 40;
                    if (string6 != null) {
                        try {
                            n4 = Integer.parseInt(string6);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    int n5 = object.getInt("INI_TRANS");
                    int n6 = object.getInt("MAX_TRANS");
                    long l = object.getLong("INITIAL_EXTENT");
                    long l2 = object.getLong("NEXT_EXTENT");
                    int n7 = object.getInt("MIN_EXTENT");
                    int n8 = object.getInt("MAX_EXTENT");
                    int n9 = object.getInt("PCT_INCREASE");
                    int n10 = object.getInt("FREELISTS");
                    int n11 = object.getInt("FREELIST_GROUPS");
                    String string7 = object.getString("LOGGING");
                    String string8 = object.getString("COMPRESSION");
                    String string9 = object.getString("BUFFER_POOL");
                    TableSpaceOracle tableSpaceOracle = null;
                    if (string5 != null && !"".equalsIgnoreCase(string5) && (tableSpaceOracle = (TableSpaceOracle)storageDesignOracle.getTableSpaceSet().getByName(string5)) == null) {
                        tableSpaceOracle = ((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().createTableSpace();
                        tableSpaceOracle.setName(string5);
                        this.stampModelObject((ModelObject)tableSpaceOracle, tableProxyOracle, string5);
                    }
                    if (bl2) {
                        abstractStorageObjectOracle2 = storageDesignOracle.getHashPartitionSet().createHashPartition();
                        abstractStorageObjectOracle2.setName(string3);
                        ((HashPartitionOracle)abstractStorageObjectOracle2).setPartitionList(partitionListOracle);
                        if (tableSpaceOracle != null) {
                            ((HashPartitionOracle)abstractStorageObjectOracle2).setTableSpace(tableSpaceOracle);
                        }
                        if (!this.hasLobColumns(tableProxyOracle)) continue;
                        this.setPartitionLobStorage(abstractStorageObjectOracle2, tableProxyOracle, string, storageDesignOracle, connection);
                        continue;
                    }
                    abstractStorageObjectOracle2 = storageDesignOracle.getSegmentSet().createSegment();
                    ((SegmentOracle)abstractStorageObjectOracle2).setPCTFree(n3);
                    ((SegmentOracle)abstractStorageObjectOracle2).setPCTUsed(n4);
                    ((SegmentOracle)abstractStorageObjectOracle2).setInitrans(n5);
                    ((SegmentOracle)abstractStorageObjectOracle2).setMaxTrans(n6);
                    ((SegmentOracle)abstractStorageObjectOracle2).setSCInitialExtent(l);
                    ((SegmentOracle)abstractStorageObjectOracle2).setSCNextExtent(l2);
                    ((SegmentOracle)abstractStorageObjectOracle2).setSCMinExtents(n7);
                    ((SegmentOracle)abstractStorageObjectOracle2).setSCMaxExtents(String.valueOf(n8));
                    ((SegmentOracle)abstractStorageObjectOracle2).setSCPctIncrease(n9);
                    ((SegmentOracle)abstractStorageObjectOracle2).setSCFreeLists(n10);
                    ((SegmentOracle)abstractStorageObjectOracle2).setSCFreelistGroups(n11);
                    ((SegmentOracle)abstractStorageObjectOracle2).setSCBufferPool(string9);
                    abstractStorageObjectOracle2 = storageDesignOracle.getSegmentSet().findEqual((SegmentOracle)abstractStorageObjectOracle2);
                    if (bl) {
                        abstractStorageObjectOracle = storageDesignOracle.getListPartitionSet().createListPartition();
                        abstractStorageObjectOracle.setName(string3);
                        ((ListPartitionOracle)abstractStorageObjectOracle).setPartitionList(partitionListOracle);
                        ((ListPartitionOracle)abstractStorageObjectOracle).setPosition(n2);
                        ((ListPartitionOracle)abstractStorageObjectOracle).setColumns(string4);
                        if (tableSpaceOracle != null) {
                            ((ListPartitionOracle)abstractStorageObjectOracle).setTablespace(tableSpaceOracle);
                        }
                        if (!"NONE".equalsIgnoreCase(string7)) {
                            ((ListPartitionOracle)abstractStorageObjectOracle).setLogging(string7);
                        }
                        if ("ENABLED".equalsIgnoreCase(string8)) {
                            ((ListPartitionOracle)abstractStorageObjectOracle).setDataSegmentCompression("YES");
                        } else if ("DISABLED".equalsIgnoreCase(string8)) {
                            ((ListPartitionOracle)abstractStorageObjectOracle).setDataSegmentCompression("NO");
                        }
                        ((ListPartitionOracle)abstractStorageObjectOracle).setSegment((SegmentOracle)abstractStorageObjectOracle2);
                        if (this.hasLobColumns(tableProxyOracle)) {
                            this.setPartitionLobStorage(abstractStorageObjectOracle, tableProxyOracle, string, storageDesignOracle, connection);
                        }
                        if (n <= 0) continue;
                        if (partitionListOracle.getSubpartitionType().equals("HASH") && abstractStorageObjectOracle instanceof ListPartitionOraclev11g) {
                            ((ListPartitionOraclev11g)abstractStorageObjectOracle).setSubPartitionsQuantity(n);
                        }
                        this.setSubPartitions(abstractStorageObjectOracle, tableProxyOracle, string, storageDesignOracle, partitionListOracle, connection);
                        continue;
                    }
                    abstractStorageObjectOracle = storageDesignOracle.getPartitionSet().createPartition();
                    abstractStorageObjectOracle.setName(string3);
                    ((PartitionOracle)abstractStorageObjectOracle).setPartitionList(partitionListOracle);
                    ((PartitionOracle)abstractStorageObjectOracle).setPosition(n2);
                    if (string4 != null) {
                        ((PartitionOracle)abstractStorageObjectOracle).setValueList(string4);
                    }
                    if (tableSpaceOracle != null) {
                        ((PartitionOracle)abstractStorageObjectOracle).setTableSpace(tableSpaceOracle);
                    }
                    if (!"NONE".equalsIgnoreCase(string7)) {
                        ((PartitionOracle)abstractStorageObjectOracle).setLogging(string7);
                    }
                    if ("ENABLED".equalsIgnoreCase(string8)) {
                        ((PartitionOracle)abstractStorageObjectOracle).setDataSegmentCompression("YES");
                    } else if ("DISABLED".equalsIgnoreCase(string8)) {
                        ((PartitionOracle)abstractStorageObjectOracle).setDataSegmentCompression("NO");
                    }
                    ((PartitionOracle)abstractStorageObjectOracle).setSegment((SegmentOracle)abstractStorageObjectOracle2);
                    if (this.hasLobColumns(tableProxyOracle)) {
                        this.setPartitionLobStorage(abstractStorageObjectOracle, tableProxyOracle, string, storageDesignOracle, connection);
                    }
                    if (n <= 0) continue;
                    if (partitionListOracle.getSubpartitionType().equals("HASH")) {
                        ((PartitionOracle)abstractStorageObjectOracle).setSubPartitionsQuantity(n);
                    }
                    this.setSubPartitions(abstractStorageObjectOracle, tableProxyOracle, string, storageDesignOracle, partitionListOracle, connection);
                }
                object.close();
            }
            catch (Exception exception) {
                LOGGER.error("MOHTableOracle.setPartitions():", exception);
            }
        }
    }

    private boolean hasLobColumns(TableProxy tableProxy) {
        Table table = (Table)tableProxy.getObject();
        for (Column column : table.getElementsCollection()) {
            String string = column.getDatatypeString(tableProxy.getRDBMSType().getName()).toUpperCase();
            if (string.indexOf("BLOB") <= -1 && string.indexOf("CLOB") <= -1 && string.indexOf("BFILE") <= -1) continue;
            return true;
        }
        return false;
    }

    private void setSubPartitions(AbstractStorageObjectOracle abstractStorageObjectOracle, TableProxyOracle tableProxyOracle, String string, StorageDesignOracle storageDesignOracle, PartitionListOracle partitionListOracle, Connection connection) throws Exception {
        String string2;
        Object object;
        boolean bl = this.getStorageDesign() instanceof StorageDesignOraclev11g;
        if (this.subPart_statement == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ');
            ((StringBuffer)object).append("SUBPARTITION_NAME").append(',');
            ((StringBuffer)object).append("HIGH_VALUE").append(',');
            if (bl) {
                ((StringBuffer)object).append("COMPRESSION").append(',');
            }
            ((StringBuffer)object).append("TABLESPACE_NAME").append(' ');
            ((StringBuffer)object).append("FROM").append(' ');
            ((StringBuffer)object).append(this.dbaUser ? "dba_tab_subpartitions" : "all_tab_subpartitions").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ');
            ((StringBuffer)object).append("TABLE_OWNER").append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object).append("AND").append(' ');
            ((StringBuffer)object).append("TABLE_NAME").append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object).append("AND").append(' ');
            ((StringBuffer)object).append("PARTITION_NAME").append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object).append("ORDER BY").append(' ');
            ((StringBuffer)object).append("SUBPARTITION_POSITION");
            string2 = ((StringBuffer)object).toString();
            this.subPart_statement = connection.prepareStatement(string2);
        }
        object = null;
        try {
            this.subPart_statement.setString(1, string);
            this.subPart_statement.setString(2, tableProxyOracle.getName());
            this.subPart_statement.setString(3, abstractStorageObjectOracle.getName());
            object = this.subPart_statement.executeQuery();
        }
        catch (Exception exception) {
            LOGGER.error("MOHTableOracle.setSubPartitions():", exception);
        }
        if (object != null) {
            while (object.next()) {
                AbstractStorageObjectOracle abstractStorageObjectOracle2;
                String string3;
                string2 = object.getString("SUBPARTITION_NAME");
                String string4 = object.getString("HIGH_VALUE");
                String string5 = "";
                if (bl) {
                    string5 = object.getString("COMPRESSION");
                }
                String string6 = object.getString("TABLESPACE_NAME");
                TableSpaceOracle tableSpaceOracle = null;
                if (string6 != null && !"".equalsIgnoreCase(string6) && (tableSpaceOracle = (TableSpaceOracle)storageDesignOracle.getTableSpaceSet().getByName(string6)) == null) {
                    tableSpaceOracle = ((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().createTableSpace();
                    tableSpaceOracle.setName(string6);
                    this.stampModelObject((ModelObject)tableSpaceOracle, tableProxyOracle, string6);
                }
                if ((string3 = partitionListOracle.getSubpartitionType()).equals("HASH")) {
                    abstractStorageObjectOracle2 = storageDesignOracle.getHashPartitionSet().createHashPartition();
                    abstractStorageObjectOracle2.setName(string2);
                    ((HashPartitionOracle)abstractStorageObjectOracle2).setSubPartitionOf(abstractStorageObjectOracle);
                    ((HashPartitionOracle)abstractStorageObjectOracle2).setTableSpace(tableSpaceOracle);
                    if (!this.hasLobColumns(tableProxyOracle)) continue;
                    this.setSubPartitionLobStorage(abstractStorageObjectOracle2, tableProxyOracle, string, storageDesignOracle, connection);
                    continue;
                }
                if (string3.equals("LIST")) {
                    abstractStorageObjectOracle2 = storageDesignOracle.getListStorageTemplatePartitionSet().createListStorageTemplatePartition();
                    abstractStorageObjectOracle2.setName(string2);
                    ((ListStorageTemplatePartitionOracle)abstractStorageObjectOracle2).setSubPartitionOf(abstractStorageObjectOracle);
                    ((ListStorageTemplatePartitionOracle)abstractStorageObjectOracle2).setTablespace(tableSpaceOracle);
                    if (string4 != null) {
                        ((ListStorageTemplatePartitionOracle)abstractStorageObjectOracle2).setValueList(string4);
                    }
                    if (bl) {
                        if ("ENABLED".equalsIgnoreCase(string5)) {
                            ((ListStorageTemplatePartitionOracle)abstractStorageObjectOracle2).setDataSegmentCompression("YES");
                        } else if ("DISABLED".equalsIgnoreCase(string5)) {
                            ((ListStorageTemplatePartitionOracle)abstractStorageObjectOracle2).setDataSegmentCompression("NO");
                        }
                    }
                    if (!this.hasLobColumns(tableProxyOracle)) continue;
                    this.setSubPartitionLobStorage(abstractStorageObjectOracle2, tableProxyOracle, string, storageDesignOracle, connection);
                    continue;
                }
                if (!string3.equals("RANGE")) continue;
                abstractStorageObjectOracle2 = (PartitionOraclev11g)storageDesignOracle.getPartitionSet().createPartition();
                abstractStorageObjectOracle2.setName(string2);
                ((PartitionOraclev11g)abstractStorageObjectOracle2).setSubPartitionOf(abstractStorageObjectOracle);
                ((PartitionOracle)abstractStorageObjectOracle2).setTableSpace(tableSpaceOracle);
                if (string4 != null) {
                    ((PartitionOracle)abstractStorageObjectOracle2).setValueList(string4);
                }
                if (bl) {
                    if ("ENABLED".equalsIgnoreCase(string5)) {
                        ((PartitionOracle)abstractStorageObjectOracle2).setDataSegmentCompression("YES");
                    } else if ("DISABLED".equalsIgnoreCase(string5)) {
                        ((PartitionOracle)abstractStorageObjectOracle2).setDataSegmentCompression("NO");
                    }
                }
                if (!this.hasLobColumns(tableProxyOracle)) continue;
                this.setSubPartitionLobStorage(abstractStorageObjectOracle2, tableProxyOracle, string, storageDesignOracle, connection);
            }
            object.close();
        }
    }

    private void setTableLobStorage(StorageDesignOracle storageDesignOracle, Connection connection, List list) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT").append(' ').append("COLUMN_NAME").append(',').append(' ');
        stringBuffer.append("SEGMENT_NAME").append(',').append(' ');
        stringBuffer.append("TABLESPACE_NAME").append(',').append(' ');
        stringBuffer.append("CHUNK").append(',').append(' ');
        stringBuffer.append("PCTVERSION").append(',').append(' ');
        if (storageDesignOracle instanceof StorageDesignOraclev11g) {
            stringBuffer.append("SECUREFILE").append(',').append(' ');
        }
        stringBuffer.append("CACHE").append(',').append(' ');
        stringBuffer.append("LOGGING").append(',').append(' ');
        stringBuffer.append("IN_ROW").append(' ');
        stringBuffer.append("FROM").append(' ').append(this.dbaUser ? "dba_lobs" : "all_lobs").append(' ');
        stringBuffer.append("WHERE").append(' ').append("PARTITIONED").append(' ').append('=').append(' ');
        stringBuffer.append('\'').append("NO").append('\'').append(' ');
        stringBuffer.append("AND").append(' ').append("OWNER").append(' ').append('=').append(' ').append('?').append(' ');
        stringBuffer.append("AND").append(' ').append("TABLE_NAME").append(' ').append('=').append(' ').append('?');
        String string = stringBuffer.toString();
        if (storageDesignOracle instanceof StorageDesignOraclev9i) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT").append(' ').append("COLUMN_NAME").append(',').append(' ');
            stringBuffer.append("SEGMENT_NAME").append(',').append(' ');
            stringBuffer.append("NULL").append(' ').append("AS").append(' ').append("TABLESPACE_NAME").append(',').append(' ');
            stringBuffer.append("CHUNK").append(',').append(' ');
            stringBuffer.append("PCTVERSION").append(',').append(' ');
            stringBuffer.append("CACHE").append(',').append(' ');
            stringBuffer.append("LOGGING").append(',').append(' ');
            stringBuffer.append("IN_ROW").append(' ');
            stringBuffer.append("FROM").append(' ').append(this.dbaUser ? "dba_lobs" : "all_lobs").append(' ');
            stringBuffer.append("WHERE").append(' ').append("OWNER").append(' ').append('=').append(' ').append('?').append(' ');
            stringBuffer.append("AND").append(' ').append("TABLE_NAME").append(' ').append('=').append(' ').append('?');
            string = stringBuffer.toString();
        }
        Statement statement = null;
        for (DBObject dBObject : list) {
            if (!dBObject.hasLOBs) continue;
            TableProxyOracle tableProxyOracle = (TableProxyOracle)dBObject.getTableProxy();
            ResultSet resultSet = null;
            try {
                if (statement == null) {
                    statement = connection.prepareStatement(string);
                }
                statement.setString(1, dBObject.getSchema());
                statement.setString(2, tableProxyOracle.getName());
                resultSet = statement.executeQuery();
                if (resultSet == null) continue;
                while (resultSet.next()) {
                    String string2 = Token.removeQuotes(resultSet.getString("COLUMN_NAME"));
                    if (string2.startsWith("SYS_NC")) continue;
                    String string3 = resultSet.getString("SEGMENT_NAME");
                    if (string2.indexOf(46) > -1 && string3.startsWith("SYS_LOB")) continue;
                    String string4 = resultSet.getString("TABLESPACE_NAME");
                    int n = resultSet.getInt("CHUNK");
                    int n2 = resultSet.getInt("PCTVERSION");
                    String string5 = "";
                    if (storageDesignOracle instanceof StorageDesignOraclev11g) {
                        string5 = resultSet.getString("SECUREFILE");
                    }
                    String string6 = resultSet.getString("CACHE");
                    String string7 = resultSet.getString("LOGGING");
                    String string8 = resultSet.getString("IN_ROW");
                    LobStorageOracle lobStorageOracle = storageDesignOracle.getLobStorageSet().createLobStorage();
                    lobStorageOracle.setName(string3);
                    if (!string3.startsWith("SYS_LOB")) {
                        lobStorageOracle.setLobSegmentName(string3);
                    }
                    lobStorageOracle.setTable(tableProxyOracle);
                    lobStorageOracle.setColumn(string2);
                    lobStorageOracle.setChunk(n);
                    lobStorageOracle.setPCTVersion(n2);
                    if (lobStorageOracle instanceof LobStorageOraclev11g && "YES".equalsIgnoreCase(string5)) {
                        ((LobStorageOraclev11g)lobStorageOracle).setLobStorageType("SECUREFILE");
                    }
                    if ("YES".equalsIgnoreCase(string6 = string6.trim())) {
                        lobStorageOracle.setCache("CACHE");
                    } else if ("CACHEREADS".equalsIgnoreCase(string6)) {
                        lobStorageOracle.setCache("CACHE READS");
                    } else {
                        lobStorageOracle.setCache("NOCACHE");
                    }
                    if ("YES".equalsIgnoreCase(string8.trim())) {
                        lobStorageOracle.setStorageInRow("ENABLE");
                    } else {
                        lobStorageOracle.setStorageInRow("DISABLE");
                    }
                    if (string4 != null && !"".equalsIgnoreCase(string4)) {
                        TableSpaceOracle tableSpaceOracle = (TableSpaceOracle)storageDesignOracle.getTableSpaceSet().getByName(string4);
                        lobStorageOracle.setTableSpace(tableSpaceOracle);
                    }
                    if ("NONE".equalsIgnoreCase(string7 = string7.trim())) continue;
                    if ("YES".equalsIgnoreCase(string5) && "NO".equalsIgnoreCase(string7)) {
                        lobStorageOracle.setLogging("FILESYSTEM_LIKE_LOGGING");
                        continue;
                    }
                    lobStorageOracle.setLogging(string7);
                }
                resultSet.close();
            }
            catch (Exception exception) {
                LOGGER.error("MOHTableOracle.setTableLobStorage():", exception);
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void setTablePartLobStorage(StorageDesignOracle storageDesignOracle, Connection connection, List list) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT").append(' ');
        stringBuffer.append("COLUMN_NAME").append(',');
        stringBuffer.append("LOB_NAME").append(',');
        stringBuffer.append("DEF_CHUNK").append(',');
        stringBuffer.append("DEF_PCTVERSION").append(',');
        if (storageDesignOracle instanceof StorageDesignOraclev11g) {
            stringBuffer.append("DEF_SECUREFILE").append(',').append(' ');
        }
        stringBuffer.append("DEF_CACHE").append(',');
        stringBuffer.append("DEF_IN_ROW").append(',');
        stringBuffer.append("DEF_TABLESPACE_NAME").append(',');
        stringBuffer.append("DEF_INITIAL_EXTENT").append(',');
        stringBuffer.append("DEF_NEXT_EXTENT").append(',');
        stringBuffer.append("DEF_MIN_EXTENTS").append(',');
        stringBuffer.append("DEF_MAX_EXTENTS").append(',');
        stringBuffer.append("DEF_PCT_INCREASE").append(',');
        stringBuffer.append("DEF_FREELISTS").append(',');
        stringBuffer.append("DEF_FREELIST_GROUPS").append(',');
        stringBuffer.append("DEF_LOGGING").append(',');
        stringBuffer.append("DEF_BUFFER_POOL").append(' ');
        stringBuffer.append("FROM").append(' ');
        stringBuffer.append(this.dbaUser ? "dba_part_lobs" : "all_part_lobs").append(' ');
        stringBuffer.append("WHERE").append(' ');
        stringBuffer.append("TABLE_OWNER").append('=').append(' ').append('?').append(' ');
        stringBuffer.append("AND").append(' ');
        stringBuffer.append("TABLE_NAME").append('=').append(' ').append('?').append(' ');
        stringBuffer.append("ORDER BY").append(' ');
        stringBuffer.append("LOB_NAME");
        String string = stringBuffer.toString();
        Statement statement = null;
        for (DBObject dBObject : list) {
            if (!dBObject.partitioned || !dBObject.hasLOBs) continue;
            TableProxyOracle tableProxyOracle = (TableProxyOracle)dBObject.getTableProxy();
            ResultSet resultSet = null;
            try {
                if (statement == null) {
                    statement = connection.prepareStatement(string);
                }
                statement.setString(1, dBObject.getSchema());
                statement.setString(2, tableProxyOracle.getName());
                resultSet = statement.executeQuery();
                if (resultSet == null) continue;
                while (resultSet.next()) {
                    String string2 = resultSet.getString("LOB_NAME");
                    String string3 = resultSet.getString("COLUMN_NAME");
                    int n = resultSet.getInt("DEF_CHUNK");
                    int n2 = resultSet.getInt("DEF_PCTVERSION");
                    String string4 = "";
                    if (storageDesignOracle instanceof StorageDesignOraclev11g) {
                        string4 = resultSet.getString("DEF_SECUREFILE");
                    }
                    String string5 = resultSet.getString("DEF_CACHE");
                    String string6 = resultSet.getString("DEF_IN_ROW");
                    String string7 = resultSet.getString("DEF_TABLESPACE_NAME");
                    String string8 = resultSet.getString("DEF_INITIAL_EXTENT");
                    String string9 = resultSet.getString("DEF_NEXT_EXTENT");
                    String string10 = resultSet.getString("DEF_MIN_EXTENTS");
                    String string11 = resultSet.getString("DEF_MAX_EXTENTS");
                    String string12 = resultSet.getString("DEF_PCT_INCREASE");
                    String string13 = resultSet.getString("DEF_FREELISTS");
                    String string14 = resultSet.getString("DEF_FREELIST_GROUPS");
                    String string15 = resultSet.getString("DEF_LOGGING");
                    String string16 = resultSet.getString("DEF_BUFFER_POOL");
                    LobStorageOracle lobStorageOracle = storageDesignOracle.getLobStorageSet().createLobStorage();
                    lobStorageOracle.setName(string2);
                    lobStorageOracle.setTable(tableProxyOracle);
                    lobStorageOracle.setColumn(string3);
                    lobStorageOracle.setChunk(n);
                    lobStorageOracle.setPCTVersion(n2);
                    if (lobStorageOracle instanceof LobStorageOraclev11g && "YES".equalsIgnoreCase(string4)) {
                        ((LobStorageOraclev11g)lobStorageOracle).setLobStorageType("SECUREFILE");
                    }
                    if ("YES".equalsIgnoreCase(string5 = string5.trim())) {
                        lobStorageOracle.setCache("CACHE");
                    } else if ("CACHEREADS".equalsIgnoreCase(string5)) {
                        lobStorageOracle.setCache("CACHE READS");
                    } else {
                        lobStorageOracle.setCache("NOCACHE");
                    }
                    if ("YES".equalsIgnoreCase(string6.trim())) {
                        lobStorageOracle.setStorageInRow("ENABLE");
                    } else {
                        lobStorageOracle.setStorageInRow("DISABLE");
                    }
                    if (string7 != null && !"".equalsIgnoreCase(string7)) {
                        TableSpaceOracle tableSpaceOracle = (TableSpaceOracle)storageDesignOracle.getTableSpaceSet().getByName(string7);
                        lobStorageOracle.setTableSpace(tableSpaceOracle);
                    }
                    if (string8 != null && !"DEFAULT".equalsIgnoreCase(string8.trim())) {
                        try {
                            long l = Long.parseLong(string8.trim());
                            lobStorageOracle.setSCInitialExtent(l);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (string9 != null && !"DEFAULT".equalsIgnoreCase(string9.trim())) {
                        try {
                            long l = Long.parseLong(string9.trim());
                            lobStorageOracle.setSCNextExtent(l);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (string10 != null && !"DEFAULT".equalsIgnoreCase(string10.trim())) {
                        try {
                            int n3 = Integer.parseInt(string10.trim());
                            lobStorageOracle.setSCMinExtents(n3);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (string11 != null && !"DEFAULT".equalsIgnoreCase(string11.trim())) {
                        try {
                            int n4 = Integer.parseInt(string11.trim());
                            lobStorageOracle.setSCMaxExtents(String.valueOf(n4));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (string12 != null && !"DEFAULT".equalsIgnoreCase(string12.trim())) {
                        try {
                            int n5 = Integer.parseInt(string12.trim());
                            lobStorageOracle.setSCPctIncrease(n5);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (string13 != null && !"DEFAULT".equalsIgnoreCase(string13.trim())) {
                        try {
                            int n6 = Integer.parseInt(string13.trim());
                            lobStorageOracle.setSCFreeLists(n6);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (string14 != null && !"DEFAULT".equalsIgnoreCase(string14.trim())) {
                        try {
                            int n7 = Integer.parseInt(string14.trim());
                            lobStorageOracle.setSCFreelistGroups(n7);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (!"NONE".equalsIgnoreCase(string15 = string15.trim())) {
                        if ("YES".equalsIgnoreCase(string4) && "NO".equalsIgnoreCase(string15)) {
                            lobStorageOracle.setLogging("FILESYSTEM_LIKE_LOGGING");
                        } else {
                            lobStorageOracle.setLogging(string15);
                        }
                    }
                    lobStorageOracle.setSCBufferPool(string16);
                }
                resultSet.close();
            }
            catch (Exception exception) {
                LOGGER.error("MOHTableOracle.setTablePartLobStorage():", exception);
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void setPartitionLobStorage(AbstractStorageObjectOracle abstractStorageObjectOracle, TableProxyOracle tableProxyOracle, String string, StorageDesignOracle storageDesignOracle, Connection connection) throws Exception {
        String string2;
        Object object;
        if (this.partLS_statement == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ');
            ((StringBuffer)object).append("COLUMN_NAME").append(',');
            ((StringBuffer)object).append("LOB_NAME").append(',');
            ((StringBuffer)object).append("CHUNK").append(',');
            ((StringBuffer)object).append("PCTVERSION").append(',');
            if (storageDesignOracle instanceof StorageDesignOraclev11g) {
                ((StringBuffer)object).append("SECUREFILE").append(',').append(' ');
            }
            ((StringBuffer)object).append("CACHE").append(',');
            ((StringBuffer)object).append("IN_ROW").append(',');
            ((StringBuffer)object).append("TABLESPACE_NAME").append(',');
            ((StringBuffer)object).append("INITIAL_EXTENT").append(',');
            ((StringBuffer)object).append("NEXT_EXTENT").append(',');
            ((StringBuffer)object).append("MIN_EXTENTS").append(',');
            ((StringBuffer)object).append("MAX_EXTENTS").append(',');
            ((StringBuffer)object).append("PCT_INCREASE").append(',');
            ((StringBuffer)object).append("FREELISTS").append(',');
            ((StringBuffer)object).append("FREELIST_GROUPS").append(',');
            ((StringBuffer)object).append("LOGGING").append(',');
            ((StringBuffer)object).append("BUFFER_POOL").append(' ');
            ((StringBuffer)object).append("FROM").append(' ');
            ((StringBuffer)object).append(this.dbaUser ? "dba_lob_partitions" : "all_lob_partitions").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ');
            ((StringBuffer)object).append("TABLE_OWNER").append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object).append("AND").append(' ');
            ((StringBuffer)object).append("TABLE_NAME").append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object).append("AND").append(' ');
            ((StringBuffer)object).append("PARTITION_NAME").append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object).append("ORDER BY").append(' ');
            ((StringBuffer)object).append("LOB_NAME");
            string2 = ((StringBuffer)object).toString();
            this.partLS_statement = connection.prepareStatement(string2);
        }
        object = null;
        try {
            this.partLS_statement.setString(1, string);
            this.partLS_statement.setString(2, tableProxyOracle.getName());
            this.partLS_statement.setString(3, abstractStorageObjectOracle.getName());
            object = this.partLS_statement.executeQuery();
        }
        catch (Exception exception) {
            LOGGER.error("MOHTableOracle.setPartitionLobStorage():", exception);
        }
        if (object != null) {
            while (object.next()) {
                AbstractStorageObjectOracle abstractStorageObjectOracle2;
                string2 = object.getString("LOB_NAME");
                String string3 = object.getString("COLUMN_NAME");
                int n = object.getInt("CHUNK");
                int n2 = object.getInt("PCTVERSION");
                String string4 = "";
                if (storageDesignOracle instanceof StorageDesignOraclev11g) {
                    string4 = object.getString("SECUREFILE");
                }
                String string5 = object.getString("CACHE");
                String string6 = object.getString("IN_ROW");
                String string7 = object.getString("TABLESPACE_NAME");
                String string8 = object.getString("INITIAL_EXTENT");
                String string9 = object.getString("NEXT_EXTENT");
                String string10 = object.getString("MIN_EXTENTS");
                String string11 = object.getString("MAX_EXTENTS");
                String string12 = object.getString("PCT_INCREASE");
                String string13 = object.getString("FREELISTS");
                String string14 = object.getString("FREELIST_GROUPS");
                String string15 = object.getString("LOGGING");
                String string16 = object.getString("BUFFER_POOL");
                if (abstractStorageObjectOracle instanceof HashPartitionOracle) {
                    StorageObject storageObject;
                    abstractStorageObjectOracle2 = storageDesignOracle.getHashPartitionLobItemSet().createHashPartitionLobItem();
                    abstractStorageObjectOracle2.setName(string2);
                    ((HashPartitionLobItemOracle)abstractStorageObjectOracle2).setHashPartition((HashPartitionOracle)abstractStorageObjectOracle);
                    if (string3 != null && !"".equalsIgnoreCase(string3)) {
                        storageObject = tableProxyOracle.getColumnProxyByName(string3);
                        ((HashPartitionLobItemOracle)abstractStorageObjectOracle2).setLobColumn((ColumnProxy)storageObject);
                    }
                    if (string7 == null || "".equalsIgnoreCase(string7)) continue;
                    storageObject = (TableSpaceOracle)storageDesignOracle.getTableSpaceSet().getByName(string7);
                    ((HashPartitionLobItemOracle)abstractStorageObjectOracle2).setTableSpace((TableSpaceOracle)storageObject);
                    continue;
                }
                abstractStorageObjectOracle2 = storageDesignOracle.getLobStorageSet().createLobStorage();
                abstractStorageObjectOracle2.setName(string2);
                if (abstractStorageObjectOracle instanceof PartitionOracle) {
                    ((LobStorageOracle)abstractStorageObjectOracle2).setPartition((PartitionOracle)abstractStorageObjectOracle);
                } else if (abstractStorageObjectOracle instanceof ListPartitionOracle) {
                    ((LobStorageOracle)abstractStorageObjectOracle2).setListPartition((ListPartitionOracle)abstractStorageObjectOracle);
                }
                ((LobStorageOracle)abstractStorageObjectOracle2).setColumn(string3);
                ((LobStorageOracle)abstractStorageObjectOracle2).setChunk(n);
                ((LobStorageOracle)abstractStorageObjectOracle2).setPCTVersion(n2);
                if (abstractStorageObjectOracle2 instanceof LobStorageOraclev11g && "YES".equalsIgnoreCase(string4)) {
                    ((LobStorageOraclev11g)abstractStorageObjectOracle2).setLobStorageType("SECUREFILE");
                }
                if ("YES".equalsIgnoreCase(string5 = string5.trim())) {
                    ((LobStorageOracle)abstractStorageObjectOracle2).setCache("CACHE");
                } else if ("CACHEREADS".equalsIgnoreCase(string5)) {
                    ((LobStorageOracle)abstractStorageObjectOracle2).setCache("CACHE READS");
                } else {
                    ((LobStorageOracle)abstractStorageObjectOracle2).setCache("NOCACHE");
                }
                if ("YES".equalsIgnoreCase(string6.trim())) {
                    ((LobStorageOracle)abstractStorageObjectOracle2).setStorageInRow("ENABLE");
                } else {
                    ((LobStorageOracle)abstractStorageObjectOracle2).setStorageInRow("DISABLE");
                }
                if (string7 != null && !"".equalsIgnoreCase(string7)) {
                    TableSpaceOracle tableSpaceOracle = (TableSpaceOracle)storageDesignOracle.getTableSpaceSet().getByName(string7);
                    ((LobStorageOracle)abstractStorageObjectOracle2).setTableSpace(tableSpaceOracle);
                }
                if (string8 != null && !"DEFAULT".equalsIgnoreCase(string8.trim())) {
                    try {
                        long l = Long.parseLong(string8.trim());
                        ((LobStorageOracle)abstractStorageObjectOracle2).setSCInitialExtent(l);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (string9 != null && !"DEFAULT".equalsIgnoreCase(string9.trim())) {
                    try {
                        long l = Long.parseLong(string9.trim());
                        ((LobStorageOracle)abstractStorageObjectOracle2).setSCNextExtent(l);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (string10 != null && !"DEFAULT".equalsIgnoreCase(string10.trim())) {
                    try {
                        int n3 = Integer.parseInt(string10.trim());
                        ((LobStorageOracle)abstractStorageObjectOracle2).setSCMinExtents(n3);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (string11 != null && !"DEFAULT".equalsIgnoreCase(string11.trim())) {
                    try {
                        ((LobStorageOracle)abstractStorageObjectOracle2).setSCMaxExtents(string11);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (string12 != null && !"DEFAULT".equalsIgnoreCase(string12.trim())) {
                    try {
                        int n4 = Integer.parseInt(string12.trim());
                        ((LobStorageOracle)abstractStorageObjectOracle2).setSCPctIncrease(n4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (string13 != null && !"DEFAULT".equalsIgnoreCase(string13.trim())) {
                    try {
                        int n5 = Integer.parseInt(string13.trim());
                        ((LobStorageOracle)abstractStorageObjectOracle2).setSCFreeLists(n5);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (string14 != null && !"DEFAULT".equalsIgnoreCase(string14.trim())) {
                    try {
                        int n6 = Integer.parseInt(string14.trim());
                        ((LobStorageOracle)abstractStorageObjectOracle2).setSCFreelistGroups(n6);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (!"NONE".equalsIgnoreCase(string15 = string15.trim())) {
                    if ("YES".equalsIgnoreCase(string4) && "NO".equalsIgnoreCase(string15)) {
                        ((LobStorageOracle)abstractStorageObjectOracle2).setLogging("FILESYSTEM_LIKE_LOGGING");
                    } else {
                        ((LobStorageOracle)abstractStorageObjectOracle2).setLogging(string15);
                    }
                }
                ((LobStorageOracle)abstractStorageObjectOracle2).setSCBufferPool(string16);
            }
            object.close();
        }
    }

    private void setSubPartitionLobStorage(AbstractStorageObjectOracle abstractStorageObjectOracle, TableProxyOracle tableProxyOracle, String string, StorageDesignOracle storageDesignOracle, Connection connection) throws Exception {
        String string2;
        Object object;
        if (this.subPartLS_statement == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ').append("COLUMN_NAME").append(',');
            ((StringBuffer)object).append("LOB_NAME").append(',');
            ((StringBuffer)object).append("TABLESPACE_NAME").append(' ');
            ((StringBuffer)object).append("FROM").append(' ').append(this.dbaUser ? "dba_lob_subpartitions" : "all_lob_subpartitions").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ').append("TABLE_OWNER").append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object).append("AND").append(' ').append("TABLE_NAME").append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object).append("AND").append(' ').append("SUBPARTITION_NAME").append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object).append("ORDER BY").append(' ').append("LOB_NAME");
            string2 = ((StringBuffer)object).toString();
            this.subPartLS_statement = connection.prepareStatement(string2);
        }
        object = null;
        try {
            this.subPartLS_statement.setString(1, string);
            this.subPartLS_statement.setString(2, tableProxyOracle.getName());
            this.subPartLS_statement.setString(3, abstractStorageObjectOracle.getName());
            object = this.subPartLS_statement.executeQuery();
        }
        catch (Exception exception) {
            LOGGER.error("MOHTableOracle.setSubPartitionLobStorage():", exception);
        }
        if (object != null) {
            while (object.next()) {
                StorageObject storageObject;
                string2 = object.getString("LOB_NAME");
                String string3 = object.getString("COLUMN_NAME");
                String string4 = object.getString("TABLESPACE_NAME");
                HashPartitionLobItemOracle hashPartitionLobItemOracle = storageDesignOracle.getHashPartitionLobItemSet().createHashPartitionLobItem();
                hashPartitionLobItemOracle.setName(string2);
                if (abstractStorageObjectOracle instanceof HashPartitionOracle) {
                    hashPartitionLobItemOracle.setHashPartition((HashPartitionOracle)abstractStorageObjectOracle);
                } else if (abstractStorageObjectOracle instanceof ListStorageTemplatePartitionOracle) {
                    hashPartitionLobItemOracle.setListTemplatePartition((ListStorageTemplatePartitionOracle)abstractStorageObjectOracle);
                } else if (abstractStorageObjectOracle instanceof PartitionOracle) {
                    hashPartitionLobItemOracle.setRangePartition((PartitionOracle)abstractStorageObjectOracle);
                }
                if (string3 != null && !"".equalsIgnoreCase(string3)) {
                    storageObject = tableProxyOracle.getColumnProxyByName(string3);
                    hashPartitionLobItemOracle.setLobColumn((ColumnProxy)storageObject);
                }
                if (string4 == null || "".equalsIgnoreCase(string4)) continue;
                storageObject = (TableSpaceOracle)storageDesignOracle.getTableSpaceSet().getByName(string4);
                hashPartitionLobItemOracle.setTableSpace((TableSpaceOracle)storageObject);
            }
            object.close();
        }
    }

    private Index getIndexForColumnNames(Table table, List list, Index index) {
        Index[] indexArray = (Index[])table.getKeys();
        for (int i = 0; i < indexArray.length; ++i) {
            if (indexArray[i] == index || !this.isIndexForColumnNames(indexArray[i], list)) continue;
            return indexArray[i];
        }
        return null;
    }

    private boolean isIndexForColumnNames(Index index, List list) {
        Column[] columnArray = (Column[])index.getElements();
        if (columnArray.length != list.size()) {
            return false;
        }
        for (int i = 0; i < columnArray.length; ++i) {
            if (columnArray[i].getName().equalsIgnoreCase((String)list.get(i))) continue;
            return false;
        }
        return true;
    }

    private void initTableTriggers(Connection connection, List list) throws Exception {
        Object object;
        ArrayList<TriggerOracle> arrayList = new ArrayList<TriggerOracle>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT").append(' ').append("OWNER").append(',').append(' ');
        stringBuffer.append("TRIGGER_NAME").append(',').append(' ');
        stringBuffer.append("TRIGGER_TYPE").append(',').append(' ');
        stringBuffer.append("TRIGGERING_EVENT").append(',').append(' ');
        stringBuffer.append("REFERENCING_NAMES").append(',').append(' ');
        stringBuffer.append("WHEN_CLAUSE").append(',').append(' ');
        stringBuffer.append("STATUS").append(',').append(' ');
        stringBuffer.append("DESCRIPTION").append(',').append(' ');
        stringBuffer.append("TRIGGER_BODY").append(' ');
        stringBuffer.append("FROM").append(' ').append(this.dbaUser ? "dba_triggers" : "all_triggers").append(' ');
        stringBuffer.append("WHERE").append(' ').append("TABLE_OWNER").append(' ').append('=').append(' ').append('?').append(' ');
        stringBuffer.append("AND").append(' ').append("TABLE_NAME").append(' ').append('=').append(' ').append('?').append(' ');
        String string = stringBuffer.toString();
        Statement statement = null;
        for (Object object2 : list) {
            object = ((DBObject)object2).getTable();
            Object var10_11 = null;
            try {
                if (statement == null) {
                    statement = connection.prepareStatement(string);
                }
                statement.setString(1, ((DBObject)object2).getSchema());
                statement.setString(2, ((DBObject)object2).getName());
                ResultSet resultSet = statement.executeQuery();
                if (resultSet == null) continue;
                StorageDesignOracle storageDesignOracle = (StorageDesignOracle)this.getStorageDesign();
                TableProxyOracle tableProxyOracle = (TableProxyOracle)((DBObject)object2).getTableProxy();
                while (resultSet.next()) {
                    String string2 = resultSet.getString(1);
                    String string3 = resultSet.getString(2);
                    String string4 = resultSet.getString(3);
                    String string5 = resultSet.getString(4);
                    String string6 = resultSet.getString(5);
                    String string7 = resultSet.getString(6);
                    String string8 = resultSet.getString(9);
                    TriggerOracle triggerOracle = storageDesignOracle.getTriggerSet().createTrigger();
                    UserOracle userOracle = (UserOracle)storageDesignOracle.getUserSet().getByName(string2);
                    if (userOracle == null) {
                        userOracle = storageDesignOracle.getUserSet().createUser();
                        userOracle.setName(string2);
                        this.stampModelObject((ModelObject)userOracle, "", string2);
                    }
                    triggerOracle.setOwner(userOracle);
                    triggerOracle.setName(string3);
                    triggerOracle.setTable(tableProxyOracle);
                    this.stampModelObject((ModelObject)triggerOracle, tableProxyOracle, string3);
                    if (string4.indexOf("ROW") > -1) {
                        triggerOracle.setScope(TriggerOracle.SCOPE_TYPES[0]);
                    }
                    if (string4.indexOf("BEFORE") > -1) {
                        triggerOracle.setTriggerTime("BEFORE");
                    } else {
                        triggerOracle.setTriggerTime("AFTER");
                    }
                    if (string5.indexOf("INSERT") > -1) {
                        triggerOracle.setActions(Trigger.ACTION_TYPES[0]);
                    }
                    if (string5.indexOf("UPDATE") > -1) {
                        triggerOracle.setActions(Trigger.ACTION_TYPES[1]);
                        arrayList.add(triggerOracle);
                    }
                    if (string5.indexOf("DELETE") > -1) {
                        triggerOracle.setActions(Trigger.ACTION_TYPES[2]);
                    }
                    String string9 = "NEW";
                    String string10 = "OLD";
                    String string11 = "PARENT";
                    if (string6.indexOf(NEW_AS) > -1 && !"NEW".equalsIgnoreCase(string9 = Token.getFirstToken(Token.getStringAfter(string6, NEW_AS)))) {
                        triggerOracle.setRef_NEW_AS(string9);
                    }
                    if (string6.indexOf(OLD_AS) > -1 && !"OLD".equalsIgnoreCase(string10 = Token.getFirstToken(Token.getStringAfter(string6, OLD_AS)))) {
                        triggerOracle.setRef_OLD_AS(string10);
                    }
                    if (string6.indexOf(PARENT_AS) > -1 && !"PARENT".equalsIgnoreCase(string11 = Token.getFirstToken(Token.getStringAfter(string6, PARENT_AS)))) {
                        triggerOracle.setRef_PARENT_AS(string11);
                    }
                    if (string7 != null) {
                        triggerOracle.setCondition(string7);
                    }
                    triggerOracle.setBody(string8);
                    if (string8.indexOf(this.CWD_TS_TAB_META) > -1) {
                        this.initTriggerTypeSubstitution((Table)object, triggerOracle, string8);
                        triggerOracle.setCWDGenerated(true);
                    }
                    if (string8.indexOf(this.CWD_TS_COLUMN_META) <= -1) continue;
                    this.initTriggerColumnTypeSubstitution((Table)object, triggerOracle, string8);
                    triggerOracle.setCWDGenerated(true);
                }
                resultSet.close();
            }
            catch (Exception exception) {
                LOGGER.error("MOHTableOracle.initTableTriggers():", exception);
            }
        }
        if (statement != null) {
            statement.close();
        }
        if (arrayList.size() > 0) {
            Object object2;
            stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT").append(' ').append("COLUMN_NAME").append(',').append(' ');
            stringBuffer.append("COLUMN_LIST").append(',').append(' ');
            stringBuffer.append("COLUMN_USAGE").append(' ');
            stringBuffer.append("FROM").append(' ').append(this.dbaUser ? "dba_trigger_cols" : "all_trigger_cols").append(' ');
            stringBuffer.append("WHERE").append(' ').append("TRIGGER_OWNER").append(' ').append('=').append(' ').append('?').append(' ');
            stringBuffer.append("AND").append(' ').append("TRIGGER_NAME").append(' ').append('=').append(' ').append('?').append(' ');
            object2 = stringBuffer.toString();
            object = connection.prepareStatement((String)object2);
            for (TriggerOracle triggerOracle : arrayList) {
                this.initTriggerColumns((PreparedStatement)object, triggerOracle);
            }
            object.close();
        }
    }

    private void initTriggerColumns(PreparedStatement preparedStatement, TriggerOracle triggerOracle) throws Exception {
        ResultSet resultSet = null;
        try {
            preparedStatement.setString(1, triggerOracle.getOwner().getName());
            preparedStatement.setString(2, triggerOracle.getName());
            resultSet = preparedStatement.executeQuery();
        }
        catch (Exception exception) {
            LOGGER.error("MOHTableOracle.initTriggerColumns():", exception);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                TableProxyOracle tableProxyOracle;
                ColumnProxy columnProxy;
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                if (!"YES".equalsIgnoreCase(string2) || (columnProxy = (tableProxyOracle = triggerOracle.getTable()).getColumnProxyByName(string)) == null) continue;
                triggerOracle.setColumns(columnProxy.getObjectID());
            }
            resultSet.close();
        }
    }

    private void initTriggerTypeSubstitution(Table table, TriggerOracle triggerOracle, String string) {
        Object object;
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string2 = string;
        int n = this.CWD_TS_TAB_META.length();
        int n2 = string2.indexOf(this.CWD_TS_TAB_META);
        try {
            while (n2 > -1) {
                string2 = string2.substring(n2 + n);
                object2 = Token.getFirstToken(Token.getStringAfter(string2, "table="));
                String string3 = Token.getFirstToken(Token.getStringAfter(string2, "type="));
                Object object3 = Token.getFirstToken(Token.getStringAfter(string2, "parent_type="));
                object = new Temp();
                ((Temp)object).tableName = Token.removeQuotes((String)object2);
                ((Temp)object).typeName = Token.removeQuotes(string3);
                ((Temp)object).parenTypeName = Token.removeQuotes((String)object3);
                arrayList.add(object);
                n2 = string2.indexOf(this.CWD_TS_TAB_META);
            }
        }
        catch (RuntimeException runtimeException) {
            LOGGER.error("MOHTableOracle.initTriggerTypeSubstitution():", runtimeException);
        }
        object2 = new ArrayList();
        for (Object object3 : arrayList) {
            object = (Table)table.getDesign().getRelationalDesign().getTableSet().getByName(((Temp)object3).tableName);
            if (object != null) continue;
            StructuredType structuredType = this.getStructuredType(((Temp)object3).typeName, table.getDesign(), triggerOracle.getStorageDesign());
            StructuredType structuredType2 = this.getStructuredType(((Temp)object3).parenTypeName, table.getDesign(), triggerOracle.getStorageDesign());
            if (structuredType == null || structuredType2 == null) continue;
            ((Temp)object3).st = structuredType;
            ((Temp)object3).stPar = structuredType2;
            object2.add(object3);
        }
        this.createSubTables(table, (List)object2);
    }

    private void initTriggerColumnTypeSubstitution(Table table, Trigger trigger, String string) {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string2 = string;
        int n = this.CWD_TS_COLUMN_META.length();
        int n2 = string2.indexOf(this.CWD_TS_COLUMN_META);
        try {
            while (n2 > -1) {
                string2 = string2.substring(n2 + n);
                String string3 = Token.getFirstToken(Token.getStringAfter(string2, "column="));
                Object object2 = Token.getFirstToken(Token.getStringAfter(string2, "type="));
                object = new Temp();
                ((Temp)object).tableName = Token.removeQuotes(string3);
                ((Temp)object).typeName = Token.removeQuotes((String)object2);
                arrayList.add(object);
                n2 = string2.indexOf(this.CWD_TS_COLUMN_META);
            }
        }
        catch (RuntimeException runtimeException) {
            LOGGER.error("MOHTableOracle.initTriggerColumnTypeSubstitution():", runtimeException);
        }
        for (Object object2 : arrayList) {
            StructuredType structuredType;
            object = (Column)table.getElementByName(((Temp)object2).tableName);
            if (object == null || (structuredType = this.getStructuredType(((Temp)object2).typeName, table.getDesign(), trigger.getStorageDesign())) == null) continue;
            List list = ((ContainedObjectWithDomain)object).getPermittedSubTypes();
            if (!list.contains(structuredType)) {
                list.add(structuredType);
            }
            ((ContainedObjectWithDomain)object).setAllowSubtypeSubstitution(true);
            ((ContainedObjectWithDomain)object).setRestrictedTypeSubstitution(true);
        }
    }

    private void createSubTables(Table table, List list) {
        RelationalDesign relationalDesign = (RelationalDesign)table.getDesignPart();
        DesignPartView designPartView = relationalDesign.getMainView();
        List list2 = this.getElementsForType(table.getBasedOnStructuredType(), list);
        list.removeAll(list2);
        for (Temp temp : list2) {
            Table table2 = relationalDesign.createTable();
            table2.setName(temp.tableName);
            table2.setBasedOnStructuredType(temp.st);
            this.stampModelObject((ModelObject)table2, table.getSchema(), temp.tableName);
            TypeSubstitution typeSubstitution = relationalDesign.createTypeSubstitution();
            typeSubstitution.setChildCV((ContainerView)table2.getFirstViewForDPV(designPartView));
            typeSubstitution.setParentCV((ContainerView)table.getFirstViewForDPV(designPartView));
            if (list.size() <= 0) continue;
            this.createSubTables(table2, list);
        }
    }

    private List getElementsForType(StructuredType structuredType, List list) {
        ArrayList<Temp> arrayList = new ArrayList<Temp>();
        for (Temp temp : list) {
            if (temp.stPar != structuredType) continue;
            arrayList.add(temp);
        }
        return arrayList;
    }

    private StructuredType getStructuredType(String string, Design design, StorageDesign storageDesign) {
        int n = string.indexOf(46);
        if (n > -1) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            StructuredTypeProxyOracle structuredTypeProxyOracle = ((StructuredTypeProxySetOracle)storageDesign.getStructuredTypeProxySet()).getByLongName(string3, string2);
            if (structuredTypeProxyOracle != null) {
                return structuredTypeProxyOracle.getStructuredType();
            }
            return null;
        }
        return (StructuredType)design.getDataTypesDesign().getStructuredTypeSet().getByName(string);
    }

    private void createFKeys(List list, Map map) {
        for (FKTemp fKTemp : list) {
            try {
                ModelIDObject modelIDObject;
                DesignObject designObject = (DesignObject)map.get(fKTemp.UK_Owner + fKTemp.UK_Name);
                KeyObject keyObject = designObject instanceof Table ? ((Table)designObject).getPK() : (Index)designObject;
                if (keyObject == null) {
                    keyObject = (Index)((RelationalDesign)fKTemp.table.getDesignPart()).getGlobalIndexSet().getBySchemaAndName(fKTemp.UK_Owner, fKTemp.UK_Name);
                    modelIDObject = ((RelationalDesign)fKTemp.table.getDesignPart()).getRelatedSyncModel();
                    if (keyObject == null && modelIDObject != null) {
                        keyObject = (Index)((RelationalDesign)modelIDObject).getGlobalIndexSet().getBySchemaAndName(fKTemp.UK_Owner, fKTemp.UK_Name);
                    }
                }
                if (keyObject == null) continue;
                modelIDObject = fKTemp.table.addFK(keyObject);
                ((FKIndexAssociation)modelIDObject).setName(fKTemp.name);
                this.stampModelObject((ModelObject)modelIDObject, fKTemp.table.getSchema(), fKTemp.name);
                Index index = ((FKIndexAssociation)modelIDObject).getLocalFKIndex();
                index.setName(fKTemp.name);
                ((FKIndexAssociation)modelIDObject).setDeleteRule(fKTemp.delete_rule);
                for (int i = 0; i < fKTemp.columns.size(); ++i) {
                    String string = (String)fKTemp.columns.get(i);
                    Column column = (Column)fKTemp.table.getElementByName(string);
                    Column column2 = null;
                    try {
                        column2 = (Column)keyObject.getElement(i);
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    if (column == null || column2 == null) continue;
                    column.addFKAssociation(column2, (FKIndexAssociation)modelIDObject);
                    index.add(column);
                }
                ((FKIndexAssociation)modelIDObject).resetMandatoryUsingColumns();
                FKProxyOracle fKProxyOracle = (FKProxyOracle)this.getStorageDesign().getStorageObject(index.getObjectID());
                if (fKProxyOracle == null) continue;
                if (fKTemp.status.equals("ENABLED")) {
                    fKProxyOracle.setEnable("YES");
                } else {
                    fKProxyOracle.setEnable("NO");
                }
                if (fKTemp.deferrable.equals("DEFERRABLE")) {
                    fKProxyOracle.setDeferrable("YES");
                } else {
                    fKProxyOracle.setDeferrable("NO");
                }
                if (fKTemp.deferred.equals("DEFERRED")) {
                    fKProxyOracle.setInitially("DEFERRED");
                } else {
                    fKProxyOracle.setInitially("IMMEDIATE");
                }
                if (fKTemp.validated.equals("VALIDATED")) {
                    fKProxyOracle.setValidate("YES");
                    continue;
                }
                fKProxyOracle.setValidate("NO");
                if (fKTemp.rely != null && fKTemp.rely.equals("RELY")) {
                    fKProxyOracle.setRely("YES");
                    continue;
                }
                fKProxyOracle.setRely("NO");
            }
            catch (Exception exception) {
                LOGGER.error("MOHTableOracle.createFKeys(): " + fKTemp.name, exception);
            }
        }
    }

    class FKTemp {
        String name;
        String UK_Owner;
        String UK_Name;
        String delete_rule;
        List columns = new ArrayList();
        Table table;
        String status;
        String deferrable;
        String deferred;
        String validated;
        String rely;

        FKTemp() {
        }
    }

    class Temp {
        String tableName;
        String typeName;
        String parenTypeName;
        StructuredType st;
        StructuredType stPar;

        Temp() {
        }
    }

    private class SimpleColumn {
        private final String name;
        private final String sortOrder;

        public SimpleColumn(String string, String string2) {
            this.name = string;
            this.sortOrder = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getSortOrder() {
            return this.sortOrder;
        }
    }

    class ExprHelp {
        String expr;
        int col_pos;

        ExprHelp() {
        }
    }
}

