/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;

public class MOHSequenceOracle
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "SEQUENCE";
    private static final Logger LOGGER = new Logger(MOHSequenceOracle.class);
    protected boolean dbaUser;

    public MOHSequenceOracle(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
        this.dbaUser = false;
    }

    public MOHSequenceOracle(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView, boolean bl) {
        super(abstractDBMExtractionHandler, applicationView);
        this.dbaUser = bl;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        Statement statement = null;
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (DBObject dBObject : list) {
            String string;
            Object object;
            if (!dBObject.isSelected()) continue;
            if (statement == null) {
                object = new StringBuffer();
                ((StringBuffer)object).append("SELECT").append(' ');
                ((StringBuffer)object).append("SEQUENCE_NAME").append(' ');
                ((StringBuffer)object).append("FROM").append(' ');
                ((StringBuffer)object).append(this.dbaUser ? "dba_sequences" : "all_sequences").append(' ');
                ((StringBuffer)object).append("WHERE").append(' ');
                ((StringBuffer)object).append("SEQUENCE_OWNER").append('=').append(' ').append('?').append(' ');
                ((StringBuffer)object).append("ORDER BY").append(' ');
                ((StringBuffer)object).append("SEQUENCE_NAME");
                string = ((StringBuffer)object).toString();
                statement = connection.prepareStatement(string);
            }
            object = null;
            try {
                statement.setString(1, dBObject.getName());
                object = statement.executeQuery();
            }
            catch (Exception exception) {
                System.out.println("MOHSequenceOracle.extract(): " + exception.getMessage());
                LOGGER.error("MOHSequenceOracle.extract():", exception);
            }
            if (object == null) continue;
            while (object.next()) {
                string = object.getString(1);
                DBObject dBObject2 = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), string, OBJECT_TYPE, dBObject.getName());
                arrayList.add(dBObject2);
            }
            object.close();
        }
        if (statement != null) {
            statement.close();
        }
        return arrayList;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        Statement statement = null;
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            DBObject dBObject = (DBObject)list.get(i);
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObject.getType())) continue;
            ResultSet resultSet = null;
            try {
                if (statement == null) {
                    object = new StringBuffer();
                    ((StringBuffer)object).append("SELECT").append(' ');
                    ((StringBuffer)object).append("MIN_VALUE").append(',');
                    ((StringBuffer)object).append("MAX_VALUE").append(',');
                    ((StringBuffer)object).append("INCREMENT_BY").append(',');
                    ((StringBuffer)object).append("CYCLE_FLAG").append(',');
                    ((StringBuffer)object).append("ORDER_FLAG").append(',');
                    ((StringBuffer)object).append("CACHE_SIZE").append(' ');
                    ((StringBuffer)object).append("FROM").append(' ');
                    ((StringBuffer)object).append(this.dbaUser ? "dba_sequences" : "all_sequences").append(' ');
                    ((StringBuffer)object).append("WHERE").append(' ');
                    ((StringBuffer)object).append("SEQUENCE_OWNER").append('=').append('?').append(' ');
                    ((StringBuffer)object).append("AND").append(' ');
                    ((StringBuffer)object).append("SEQUENCE_NAME").append('=').append('?');
                    statement = connection.prepareStatement(((StringBuffer)object).toString());
                }
                statement.setString(1, dBObject.getSchema());
                statement.setString(2, dBObject.getName());
                resultSet = statement.executeQuery();
            }
            catch (Exception exception) {
                System.out.println("MOHSequenceOracle.generate(): " + exception.getMessage());
                LOGGER.error("MOHSequenceOracle.generate():", exception);
            }
            if (resultSet != null) {
                if (resultSet.next()) {
                    object = this.getStorageDesign();
                    if (object != null && object instanceof StorageDesignOracle) {
                        SequenceOracle sequenceOracle = ((StorageDesignOracle)object).getSequenceSet().createSequence();
                        sequenceOracle.setName(dBObject.getName());
                        this.setUser(sequenceOracle, (StorageDesignOracle)object, dBObject.getSchema());
                        this.setProperties(sequenceOracle, resultSet);
                        this.stampModelObject(sequenceOracle, dBObject);
                    } else {
                        LOGGER.error("Unable to find Storage Design!");
                    }
                }
                resultSet.close();
            }
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObject);
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void setUser(SequenceOracle sequenceOracle, StorageDesignOracle storageDesignOracle, String string) {
        UserOracle userOracle = (UserOracle)storageDesignOracle.getUserSet().getByName(string);
        sequenceOracle.setUser(userOracle);
    }

    private void setProperties(SequenceOracle sequenceOracle, ResultSet resultSet) throws Exception {
        try {
            String string = resultSet.getString("MIN_VALUE");
            String string2 = resultSet.getString("MAX_VALUE");
            String string3 = resultSet.getString("INCREMENT_BY");
            String string4 = resultSet.getString("CYCLE_FLAG");
            String string5 = resultSet.getString("ORDER_FLAG");
            String string6 = resultSet.getString("CACHE_SIZE");
            sequenceOracle.setMinValue(string.trim());
            sequenceOracle.setMaxValue(string2.trim());
            sequenceOracle.setIncrementBy(string3.trim());
            if ("Y".equalsIgnoreCase(string4.trim())) {
                sequenceOracle.setCycle("YES");
            } else {
                sequenceOracle.setCycle("NO");
            }
            if ("Y".equalsIgnoreCase(string5.trim())) {
                sequenceOracle.setOrder("YES");
            } else {
                sequenceOracle.setOrder("NO");
            }
            int n = 0;
            if (StringUtilities.isNotEmpty(string6)) {
                n = Integer.parseInt(string6);
            }
            if (n > 0) {
                sequenceOracle.setCache(string6);
            } else {
                sequenceOracle.setNoCache("YES");
            }
        }
        catch (Exception exception) {
            LOGGER.error("MOHSequenceOracle.setProperties()", exception);
        }
    }
}

