/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class MOHPlSqlStorageObjectOracle<T>
extends AbstractMOHandler {
    protected boolean dbaUser;
    public static String WRAPPED = "WRAPPED";
    public static String SPACE_WRAPPED = " WRAPPED";

    public MOHPlSqlStorageObjectOracle(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
        this.dbaUser = false;
    }

    public MOHPlSqlStorageObjectOracle(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView, boolean bl) {
        super(abstractDBMExtractionHandler, applicationView);
        this.dbaUser = bl;
    }

    public abstract Logger getLogger();

    @Override
    public List extract(Connection connection, List list) throws Exception {
        Statement statement = null;
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (DBObject dBObject : list) {
            String string;
            Object object;
            if (!dBObject.isSelected()) continue;
            if (statement == null) {
                object = new StringBuffer();
                ((StringBuffer)object).append("SELECT").append(' ');
                ((StringBuffer)object).append("DISTINCT").append(' ');
                ((StringBuffer)object).append("NAME").append(' ');
                ((StringBuffer)object).append("FROM").append(' ');
                ((StringBuffer)object).append(this.dbaUser ? "dba_source" : "all_source").append(' ');
                ((StringBuffer)object).append("WHERE").append(' ');
                ((StringBuffer)object).append("OWNER").append('=').append(' ').append('?').append(' ');
                ((StringBuffer)object).append("AND").append(' ');
                ((StringBuffer)object).append("TYPE").append('=').append(' ').append('?').append(' ');
                ((StringBuffer)object).append("ORDER BY").append(' ');
                ((StringBuffer)object).append("NAME");
                string = ((StringBuffer)object).toString();
                statement = connection.prepareStatement(string);
            }
            object = null;
            try {
                statement.setString(1, dBObject.getName());
                statement.setString(2, this.getType());
                object = statement.executeQuery();
            }
            catch (Exception exception) {
                this.getLogger().error("extract():", exception);
            }
            if (object == null) continue;
            while (object.next()) {
                string = object.getString("NAME");
                DBObject dBObject2 = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), string, this.getType(), dBObject.getName());
                arrayList.add(dBObject2);
            }
            object.close();
        }
        if (statement != null) {
            statement.close();
        }
        return arrayList;
    }

    public boolean removeName() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        PreparedStatement preparedStatement = this.prepareStatement(connection);
        try {
            for (int i = 0; i < list.size(); ++i) {
                this.generate(preparedStatement, (DBObject)list.get(i), importLogger);
            }
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    protected PreparedStatement prepareStatement(Connection connection) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT").append(' ');
        stringBuffer.append("TEXT").append(' ');
        stringBuffer.append("FROM").append(' ');
        stringBuffer.append(this.dbaUser ? "dba_source" : "all_source").append(' ');
        stringBuffer.append("WHERE").append(' ');
        stringBuffer.append("OWNER").append('=').append(' ').append('?').append(' ');
        stringBuffer.append("AND").append(' ');
        stringBuffer.append("TYPE").append('=').append('\'');
        stringBuffer.append(this.getType()).append('\'').append(' ');
        stringBuffer.append("AND").append(' ');
        stringBuffer.append("NAME").append('=').append(' ').append('?').append(' ');
        stringBuffer.append("ORDER BY").append(' ');
        stringBuffer.append("line");
        String string = stringBuffer.toString();
        return connection.prepareStatement(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T generate(PreparedStatement preparedStatement, DBObject dBObject, ImportLogger importLogger) throws Exception {
        T t = null;
        if (this.canBeGenerated(dBObject)) {
            ResultSet resultSet = null;
            try {
                preparedStatement.setString(1, dBObject.getSchema());
                preparedStatement.setString(2, dBObject.getName());
                resultSet = preparedStatement.executeQuery();
            }
            catch (Exception exception) {
                this.getLogger().error("generate():", exception);
            }
            if (resultSet != null) {
                boolean bl = false;
                StringBuilder stringBuilder = new StringBuilder();
                try {
                    int n = 0;
                    while (resultSet.next() && !bl) {
                        String string = resultSet.getString("TEXT");
                        if (n == 0 && string.toUpperCase().indexOf(WRAPPED) > -1) {
                            bl = true;
                        }
                        ++n;
                        stringBuilder.append(string);
                    }
                }
                finally {
                    resultSet.close();
                }
                String string = stringBuilder.toString();
                if (bl) {
                    string = dBObject.getName() + SPACE_WRAPPED;
                } else {
                    if (this.removeName() && string.toUpperCase().startsWith(this.getType())) {
                        string = string.substring(this.getType().length());
                        int n = dBObject.getName().length();
                        if (string.length() >= n) {
                            string = string.substring(n);
                        }
                    }
                    string = string.trim();
                }
                if (string.length() > 0) {
                    StorageDesignOracle storageDesignOracle = (StorageDesignOracle)this.getStorageDesign();
                    if (storageDesignOracle != null) {
                        t = this.generateObject(storageDesignOracle, dBObject, string);
                    } else {
                        this.getLogger().error("Unable to find Storage Design!");
                    }
                }
            }
            this.incrementImported(dBObject, importLogger);
        }
        return t;
    }

    protected boolean canBeGenerated(DBObject dBObject) {
        return this.getType().equalsIgnoreCase(dBObject.getType());
    }

    protected void incrementImported(DBObject dBObject, ImportLogger importLogger) {
        importLogger.incrementImportedStatements();
        this.addToHandledObjects(dBObject);
    }

    public abstract T generateObject(StorageDesignOracle var1, DBObject var2, String var3);
}

