/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionAttributeOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HierarchyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LevelOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.DimensionOraclev10g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHDimensionOracle
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "DIMENSION";
    private static final Logger LOGGER = new Logger(MOHDimensionOracle.class);
    protected boolean dbaUser;
    PreparedStatement levKey_statement = null;
    PreparedStatement attr_statement = null;
    PreparedStatement hier_statement = null;
    PreparedStatement child_statement = null;
    PreparedStatement jkey_statement = null;
    PreparedStatement lev_statement = null;

    public MOHDimensionOracle(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
        this.dbaUser = false;
    }

    public MOHDimensionOracle(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView, boolean bl) {
        super(abstractDBMExtractionHandler, applicationView);
        this.dbaUser = bl;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        TimeLog.log("Dimensions begin");
        this.levKey_statement = null;
        this.attr_statement = null;
        this.hier_statement = null;
        this.child_statement = null;
        this.jkey_statement = null;
        this.lev_statement = null;
        for (int i = 0; i < list.size(); ++i) {
            DBObject dBObject = (DBObject)list.get(i);
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObject.getType())) continue;
            String string = dBObject.getName();
            String string2 = dBObject.getSchema();
            StorageDesignOracle storageDesignOracle = (StorageDesignOracle)this.getStorageDesign();
            DimensionOracle dimensionOracle = storageDesignOracle.getDimensionSet().createDimension();
            dimensionOracle.setName(string);
            UserOracle userOracle = (UserOracle)storageDesignOracle.getUserSet().getByName(string2);
            if (userOracle == null) {
                userOracle = storageDesignOracle.getUserSet().createUser();
                userOracle.setName(string2);
                this.stampModelObject((ModelObject)userOracle, "", string2);
            }
            dimensionOracle.setUser(userOracle);
            this.initLevels(connection, dimensionOracle, userOracle);
            this.initHierarchies(connection, dimensionOracle, userOracle);
            this.stampModelObject(dimensionOracle, dBObject);
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObject);
        }
        if (this.lev_statement != null) {
            this.lev_statement.close();
        }
        if (this.levKey_statement != null) {
            this.levKey_statement.close();
        }
        if (this.attr_statement != null) {
            this.attr_statement.close();
        }
        if (this.hier_statement != null) {
            this.hier_statement.close();
        }
        if (this.child_statement != null) {
            this.child_statement.close();
        }
        if (this.jkey_statement != null) {
            this.jkey_statement.close();
        }
        TimeLog.log("Dimensions end");
    }

    private void initHierarchies(Connection connection, DimensionOracle dimensionOracle, UserOracle userOracle) throws Exception {
        String string;
        Object object;
        if (this.hier_statement == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ').append("HIERARCHY_NAME").append(' ');
            ((StringBuffer)object).append("FROM").append(' ');
            ((StringBuffer)object).append(this.dbaUser ? "dba_dim_hierarchies" : "all_dim_hierarchies").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ').append("OWNER").append(' ').append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object).append("AND").append(' ').append("DIMENSION_NAME").append(' ').append('=').append(' ').append('?').append(' ');
            string = ((StringBuffer)object).toString();
            this.hier_statement = connection.prepareStatement(string);
        }
        object = null;
        try {
            this.hier_statement.setString(1, userOracle.getName());
            this.hier_statement.setString(2, dimensionOracle.getName());
            object = this.hier_statement.executeQuery();
        }
        catch (Exception exception) {
            LOGGER.error("MOHDimensionOracle.initHierarchies():", exception);
        }
        if (object != null) {
            while (object.next()) {
                string = object.getString(1);
                StorageDesignOracle storageDesignOracle = (StorageDesignOracle)this.getStorageDesign();
                HierarchyOracle hierarchyOracle = storageDesignOracle.getHierarchySet().createHierarchy();
                hierarchyOracle.setName(string);
                hierarchyOracle.setDimension(dimensionOracle);
                this.initChildOfLevels(connection, dimensionOracle, hierarchyOracle, userOracle);
            }
            object.close();
        }
    }

    private void initChildOfLevels(Connection connection, DimensionOracle dimensionOracle, HierarchyOracle hierarchyOracle, UserOracle userOracle) throws Exception {
        String string;
        Object object;
        if (this.child_statement == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ').append("CHILD_LEVEL_NAME").append(',').append(' ');
            ((StringBuffer)object).append("JOIN_KEY_ID").append(',').append(' ');
            ((StringBuffer)object).append("PARENT_LEVEL_NAME").append(' ');
            ((StringBuffer)object).append("FROM").append(' ').append(this.dbaUser ? "dba_dim_child_of" : "all_dim_child_of").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ').append("OWNER").append(' ').append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object).append("AND").append(' ').append("DIMENSION_NAME").append(' ').append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object).append("AND").append(' ').append("HIERARCHY_NAME").append(' ').append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object).append("ORDER BY").append(' ').append("POSITION");
            string = ((StringBuffer)object).toString();
            this.child_statement = connection.prepareStatement(string);
        }
        object = null;
        try {
            this.child_statement.setString(1, userOracle.getName());
            this.child_statement.setString(2, dimensionOracle.getName());
            this.child_statement.setString(3, hierarchyOracle.getName());
            object = this.child_statement.executeQuery();
        }
        catch (Exception exception) {
            LOGGER.error("MOHDimensionOracle.initChildOfLevels():", exception);
        }
        if (object != null) {
            Object object2;
            string = null;
            while (object.next()) {
                object2 = object.getString(1);
                int n = object.getInt(2);
                string = object.getString(3);
                LevelOracle levelOracle = dimensionOracle.getLevelByName((String)object2);
                if (levelOracle != null) {
                    hierarchyOracle.setLevels(levelOracle.getObjectID());
                }
                if (n == 0 || levelOracle == null) continue;
                TableProxyOracle tableProxyOracle = (TableProxyOracle)levelOracle.getLevelTable();
                if (tableProxyOracle != null) {
                    this.initJoinKey(connection, dimensionOracle, hierarchyOracle, userOracle, tableProxyOracle);
                    continue;
                }
                LOGGER.error("Level " + levelOracle.getName() + " has no table assigned!");
            }
            if (string != null && (object2 = dimensionOracle.getLevelByName(string)) != null) {
                hierarchyOracle.setLevels(((ModelIDObject)object2).getObjectID());
            }
            object.close();
        }
    }

    private void initJoinKey(Connection connection, DimensionOracle dimensionOracle, HierarchyOracle hierarchyOracle, UserOracle userOracle, TableProxyOracle tableProxyOracle) throws Exception {
        String string;
        Object object;
        if (this.jkey_statement == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ').append("LEVEL_NAME").append(' ').append("PARENT_LEVEL_NAME").append(',').append(' ');
            ((StringBuffer)object).append("CHILD_JOIN_COLUMN").append(' ');
            ((StringBuffer)object).append("FROM").append(' ').append(this.dbaUser ? "dba_dim_join_key" : "all_dim_join_key").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ').append("OWNER").append(' ').append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object).append("AND").append(' ').append("DIMENSION_NAME").append(' ').append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object).append("AND").append(' ').append("HIERARCHY_NAME").append(' ').append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object).append("ORDER BY").append(' ').append("KEY_POSITION");
            string = ((StringBuffer)object).toString();
            this.jkey_statement = connection.prepareStatement(string);
        }
        object = null;
        try {
            this.jkey_statement.setString(1, userOracle.getName());
            this.jkey_statement.setString(2, dimensionOracle.getName());
            this.jkey_statement.setString(3, hierarchyOracle.getName());
            object = this.jkey_statement.executeQuery();
        }
        catch (Exception exception) {
            LOGGER.error("MOHDimensionOracle.initJoinKey():", exception);
        }
        if (object != null) {
            while (object.next()) {
                string = object.getString(1);
                String string2 = object.getString(2);
                ColumnProxyOracle columnProxyOracle = (ColumnProxyOracle)tableProxyOracle.getColumnProxyByName(string2);
                if (columnProxyOracle == null) continue;
                StringBuffer stringBuffer = new StringBuffer("JOIN KEY ");
                stringBuffer.append(columnProxyOracle.getLongName());
                stringBuffer.append(" REFERENCES ");
                stringBuffer.append(string);
                hierarchyOracle.setJoins(stringBuffer.toString());
            }
            object.close();
        }
    }

    private void initLevels(Connection connection, DimensionOracle dimensionOracle, UserOracle userOracle) throws Exception {
        String string;
        Object object;
        if (this.lev_statement == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ').append("LEVEL_NAME").append(',').append(' ');
            ((StringBuffer)object).append("DETAILOBJ_OWNER").append(',').append(' ');
            ((StringBuffer)object).append("DETAILOBJ_NAME").append(' ');
            ((StringBuffer)object).append("FROM").append(' ').append(this.dbaUser ? "dba_dim_levels" : "all_dim_levels").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ').append("OWNER").append(' ').append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object).append("AND").append(' ').append("DIMENSION_NAME").append(' ').append('=').append(' ').append('?').append(' ');
            string = ((StringBuffer)object).toString();
            this.lev_statement = connection.prepareStatement(string);
        }
        object = null;
        try {
            this.lev_statement.setString(1, userOracle.getName());
            this.lev_statement.setString(2, dimensionOracle.getName());
            object = this.lev_statement.executeQuery();
        }
        catch (Exception exception) {
            LOGGER.error("MOHDimensionOracle.initLevels():", exception);
        }
        if (object != null) {
            while (object.next()) {
                string = object.getString(1);
                String string2 = object.getString(2);
                String string3 = object.getString(3);
                StorageDesignOracle storageDesignOracle = (StorageDesignOracle)this.getStorageDesign();
                LevelOracle levelOracle = storageDesignOracle.getLevelSet().createLevel();
                levelOracle.setName(string);
                levelOracle.setDimension(dimensionOracle);
                TableProxyOracle tableProxyOracle = ((TableProxySetOracle)storageDesignOracle.getTableProxySet()).getByLongName(string3, string2);
                if (tableProxyOracle == null) continue;
                levelOracle.setLevelTable(tableProxyOracle);
                this.initLevelKeys(connection, levelOracle, dimensionOracle, tableProxyOracle);
                this.initAttributes(connection, levelOracle, dimensionOracle, tableProxyOracle);
            }
            object.close();
        }
    }

    private void initAttributes(Connection connection, LevelOracle levelOracle, DimensionOracle dimensionOracle, TableProxyOracle tableProxyOracle) throws Exception {
        Object object;
        Object object2;
        boolean bl = dimensionOracle instanceof DimensionOraclev10g;
        if (this.attr_statement == null) {
            object2 = new StringBuffer();
            ((StringBuffer)object2).append("SELECT").append(' ');
            if (bl) {
                ((StringBuffer)object2).append("ATTRIBUTE_NAME").append(',').append(' ');
            }
            ((StringBuffer)object2).append("COLUMN_NAME").append(' ');
            ((StringBuffer)object2).append("FROM").append(' ');
            ((StringBuffer)object2).append(this.dbaUser ? "dba_dim_attributes" : "all_dim_attributes").append(' ');
            ((StringBuffer)object2).append("WHERE").append(' ').append("OWNER").append(' ').append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object2).append("AND").append(' ').append("DIMENSION_NAME").append(' ').append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object2).append("AND").append(' ').append("LEVEL_NAME").append(' ').append('=').append(' ').append('?').append(' ');
            object = ((StringBuffer)object2).toString();
            this.attr_statement = connection.prepareStatement((String)object);
        }
        object2 = null;
        try {
            this.attr_statement.setString(1, dimensionOracle.getUser().getName());
            this.attr_statement.setString(2, dimensionOracle.getName());
            this.attr_statement.setString(3, levelOracle.getName());
            object2 = this.attr_statement.executeQuery();
        }
        catch (Exception exception) {
            LOGGER.error("MOHDimensionOracle.initAttributes():", exception);
        }
        object = levelOracle.getStorageDesignOracle();
        DimensionAttributeOracle dimensionAttributeOracle = ((StorageDesignOracle)object).getDimensionAttributeSet().createDimensionAttribute();
        dimensionAttributeOracle.setLevel(levelOracle);
        if (object2 != null) {
            while (object2.next()) {
                ColumnProxyOracle columnProxyOracle;
                if (bl) {
                    dimensionAttributeOracle.setName(object2.getString("ATTRIBUTE_NAME"));
                }
                if ((columnProxyOracle = (ColumnProxyOracle)tableProxyOracle.getColumnProxyByName(object2.getString("COLUMN_NAME"))) == null) continue;
                dimensionAttributeOracle.setColumns(columnProxyOracle.getObjectID());
            }
            object2.close();
        }
    }

    private void initLevelKeys(Connection connection, LevelOracle levelOracle, DimensionOracle dimensionOracle, TableProxyOracle tableProxyOracle) throws Exception {
        Object object;
        Object object2;
        if (this.levKey_statement == null) {
            object2 = new StringBuffer();
            ((StringBuffer)object2).append("SELECT").append(' ').append("b.").append("COLUMN_NAME").append(' ');
            ((StringBuffer)object2).append("FROM").append(' ');
            ((StringBuffer)object2).append(this.dbaUser ? "dba_dim_levels" : "all_dim_levels").append(' ').append("a").append(',').append(' ');
            ((StringBuffer)object2).append(this.dbaUser ? "dba_dim_level_key" : "all_dim_level_key").append(' ').append("b").append(' ');
            ((StringBuffer)object2).append("WHERE").append(' ').append("a.").append("OWNER").append(' ').append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object2).append("AND").append(' ').append("a.").append("DIMENSION_NAME").append(' ').append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object2).append("AND").append(' ').append("a.").append("LEVEL_NAME").append(' ').append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object2).append("AND").append(' ').append("a.").append("OWNER").append(' ').append('=').append(' ').append("b.").append("OWNER").append(' ');
            ((StringBuffer)object2).append("AND").append(' ').append("a.").append("DIMENSION_NAME").append(' ').append('=').append(' ').append("b.").append("DIMENSION_NAME").append(' ');
            ((StringBuffer)object2).append("AND").append(' ').append("a.").append("LEVEL_NAME").append(' ').append('=').append(' ').append("b.").append("LEVEL_NAME").append(' ');
            ((StringBuffer)object2).append("ORDER BY").append(' ').append("b.").append("KEY_POSITION");
            object = ((StringBuffer)object2).toString();
            this.levKey_statement = connection.prepareStatement((String)object);
        }
        object2 = null;
        try {
            this.levKey_statement.setString(1, dimensionOracle.getUser().getName());
            this.levKey_statement.setString(2, dimensionOracle.getName());
            this.levKey_statement.setString(3, levelOracle.getName());
            object2 = this.levKey_statement.executeQuery();
        }
        catch (Exception exception) {
            LOGGER.error("MOHDimensionOracle.initLevelKeys():", exception);
        }
        if (object2 != null) {
            while (object2.next()) {
                object = (ColumnProxyOracle)tableProxyOracle.getColumnProxyByName(object2.getString(1));
                if (object == null) continue;
                levelOracle.setColumns(((RelationalObjectProxy)object).getObjectID());
            }
            object2.close();
        }
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        Statement statement = null;
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (DBObject dBObject : list) {
            String string;
            Object object;
            if (!dBObject.isSelected()) continue;
            String string2 = dBObject.getName();
            if (statement == null) {
                object = new StringBuffer();
                ((StringBuffer)object).append("SELECT").append(' ').append("DIMENSION_NAME").append(' ');
                ((StringBuffer)object).append("FROM").append(' ').append(this.dbaUser ? "dba_dimensions" : "all_dimensions").append(' ');
                ((StringBuffer)object).append("WHERE").append(' ').append("OWNER").append(' ').append('=').append(' ').append('?').append(' ');
                string = ((StringBuffer)object).toString();
                statement = connection.prepareStatement(string);
            }
            object = null;
            try {
                statement.setString(1, dBObject.getName());
                object = statement.executeQuery();
            }
            catch (Exception exception) {
                LOGGER.error("MOHDimensionOracle.extract():", exception);
            }
            if (object == null) continue;
            while (object.next()) {
                string = object.getString(1);
                DBObject dBObject2 = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), string, OBJECT_TYPE, string2);
                arrayList.add(dBObject2);
            }
            object.close();
        }
        if (statement != null) {
            statement.close();
        }
        return arrayList;
    }
}

