/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.List;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHTypeIncompleteOraclev9i;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.datatype.NativeDBType;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.oracle.CollectionTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHCollectionTypeOracle
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "COLLECTION";
    private static final Logger LOGGER = new Logger(MOHCollectionTypeOracle.class);
    protected boolean dbaUser;
    PreparedStatement statement = null;

    public MOHCollectionTypeOracle(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
        this.dbaUser = false;
    }

    public MOHCollectionTypeOracle(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView, boolean bl) {
        super(abstractDBMExtractionHandler, applicationView);
        this.dbaUser = bl;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        TimeLog.log("Type Collection begin");
        this.statement = null;
        StorageDesignOracle storageDesignOracle = (StorageDesignOracle)this.getStorageDesign();
        for (DBObject dBObject : MOHTypeIncompleteOraclev9i.getAllTypes()) {
            if (!dBObject.getType().equals(OBJECT_TYPE)) continue;
            String string = dBObject.getName();
            String string2 = dBObject.getSchema();
            CollectionTypeProxyOracle collectionTypeProxyOracle = (CollectionTypeProxyOracle)storageDesignOracle.getCollectionTypeProxySet().getByOwnerAndName(string2, string);
            if (collectionTypeProxyOracle == null) continue;
            CollectionType collectionType = collectionTypeProxyOracle.getCollectionType();
            this.initProperties(connection, collectionType, collectionTypeProxyOracle);
            this.stampModelObject((ModelObject)collectionTypeProxyOracle, collectionTypeProxyOracle.getOwner().getName(), collectionType.getName());
        }
        if (this.statement != null) {
            this.statement.close();
        }
        TimeLog.log("Type Collection end");
    }

    private void initProperties(Connection connection, CollectionType collectionType, CollectionTypeProxyOracle collectionTypeProxyOracle) throws Exception {
        Object object;
        Object object2;
        if (this.statement == null) {
            object2 = new StringBuffer();
            ((StringBuffer)object2).append("SELECT").append(' ');
            ((StringBuffer)object2).append("COLL_TYPE").append(',');
            ((StringBuffer)object2).append("UPPER_BOUND").append(',');
            ((StringBuffer)object2).append("ELEM_TYPE_MOD").append(',');
            ((StringBuffer)object2).append("ELEM_TYPE_OWNER").append(',');
            ((StringBuffer)object2).append("ELEM_TYPE_NAME").append(',');
            ((StringBuffer)object2).append("LENGTH").append(',');
            ((StringBuffer)object2).append("PRECISION").append(',');
            ((StringBuffer)object2).append("SCALE").append(' ');
            ((StringBuffer)object2).append("FROM").append(' ');
            ((StringBuffer)object2).append(this.dbaUser ? "dba_coll_types" : "all_coll_types").append(' ');
            ((StringBuffer)object2).append("WHERE").append(' ');
            ((StringBuffer)object2).append("OWNER").append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object2).append("AND").append(' ');
            ((StringBuffer)object2).append("TYPE_NAME").append('=').append(' ').append('?').append(' ');
            object = ((StringBuffer)object2).toString();
            this.statement = connection.prepareStatement((String)object);
        }
        object2 = null;
        try {
            this.statement.setString(1, collectionTypeProxyOracle.getOwner().getName());
            this.statement.setString(2, collectionType.getName());
            object2 = this.statement.executeQuery();
        }
        catch (Exception exception) {
            LOGGER.error("MOHCollectionTypeOracle.initProperties():", exception);
        }
        object = this.getStorageDesign().getRDBMSType();
        if (object2 != null) {
            while (object2.next()) {
                String string = object2.getString("COLL_TYPE");
                String string2 = object2.getString("ELEM_TYPE_NAME");
                String string3 = object2.getString("ELEM_TYPE_MOD");
                String string4 = object2.getString("UPPER_BOUND");
                String string5 = object2.getString("ELEM_TYPE_OWNER");
                String string6 = object2.getString("LENGTH");
                int n = object2.getInt("PRECISION");
                int n2 = object2.getInt("SCALE");
                if (string.equalsIgnoreCase("TABLE")) {
                    collectionType.setCollectionType();
                } else {
                    collectionType.setArrayType();
                    collectionType.setMaxElement(Integer.parseInt(string4));
                }
                TypeElement typeElement = this.initElementType(collectionType, string2);
                collectionType.setElementType(typeElement);
                String string7 = StandardDatatypeNames.getUsedDatatypeName(string2);
                LogicalDatatype logicalDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), string7);
                NativeDBType nativeDBType = null;
                if (logicalDatatype == null) {
                    nativeDBType = StandardDatatypeNames.getNativeDBType((RDBMSType)object, string7);
                    if (nativeDBType == null && string5 != null) {
                        nativeDBType = StandardDatatypeNames.getNativeDBType((RDBMSType)object, string5 + "." + string7);
                    }
                    if (nativeDBType != null) {
                        logicalDatatype = nativeDBType.getLogicalDatatype();
                    }
                }
                if (logicalDatatype != null && !string7.equalsIgnoreCase("UNKNOWN")) {
                    typeElement.setType(logicalDatatype);
                    typeElement.setSize(string6);
                    typeElement.setScale(n2);
                    typeElement.setPrecision(n);
                    continue;
                }
                StructuredType structuredType = (StructuredType)collectionType.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(string2);
                if (structuredType != null) {
                    typeElement.setType(structuredType);
                    if (!"REF".equalsIgnoreCase(string3)) continue;
                    typeElement.setReference(true);
                    continue;
                }
                CollectionType collectionType2 = (CollectionType)collectionType.getDesign().getDataTypesDesign().getCollectionTypeSet().getByName(string2);
                if (collectionType2 == null) continue;
                typeElement.setType(collectionType2);
            }
            object2.close();
        }
    }

    private TypeElement initElementType(CollectionType collectionType, String string) {
        TypeElement typeElement = new TypeElement(collectionType.getDesignPart(), null);
        typeElement.setDesign(collectionType.getDesign());
        typeElement.setParent(collectionType);
        return typeElement;
    }
}

