/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBMOConstants;
import oracle.dbtools.crest.imports.metadata.oracle.MOHClusterOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHCollectionTypeOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHDatafileOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHDimensionOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHDirectoryOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHFunctionOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHObjectColumnsOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHPackageOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHProcedureOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHSequenceOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHSynonymOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHTableSpaceOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHTempTableSpaceOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHUserOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHViewOracle;
import oracle.dbtools.crest.imports.metadata.oracle.v10g.MOHBitmapIndexesv10g;
import oracle.dbtools.crest.imports.metadata.oracle.v10g.MOHUndoTableSpaceOraclev10g;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHBitmapIndexesv9i;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHContextOraclev9i;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHExternalTableOraclev9i;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHRoleOraclev9i;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHTableOraclev9i;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHTypeIncompleteOraclev9i;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHTypeOraclev9i;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHUndoTableSpaceOraclev9i;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;

public class DBMExtractionHandlerOracle
extends AbstractDBMExtractionHandler
implements DBMOConstants {
    private static DBMExtractionHandlerOracle dbmExtractionHandler;
    private List mohObjectsv9i = null;
    private List mohObjectsv10g = null;
    private List mohObjectsv11g = null;
    private boolean dbaUser = false;
    private ApplicationView view;

    private DBMExtractionHandlerOracle(ApplicationView applicationView) {
        this.view = applicationView;
    }

    public static AbstractDBMExtractionHandler getInstance(ApplicationView applicationView) {
        if (dbmExtractionHandler == null) {
            dbmExtractionHandler = new DBMExtractionHandlerOracle(applicationView);
        }
        return dbmExtractionHandler;
    }

    public static void clearInstance() {
        dbmExtractionHandler = null;
    }

    public void setDBAUser(Connection connection) {
        if (connection != null) {
            try {
                try {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("SELECT").append(' ').append("COUNT").append('(').append('*').append(')');
                    stringBuffer.append(' ').append("FROM").append(' ').append("dba_users");
                    PreparedStatement preparedStatement = connection.prepareStatement(stringBuffer.toString());
                    ResultSet resultSet = preparedStatement.executeQuery();
                    this.dbaUser = true;
                    resultSet.close();
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {
                    this.dbaUser = false;
                }
            }
            catch (Exception exception) {
                this.dbaUser = false;
            }
        }
    }

    @Override
    public List getSchemas(Connection connection) throws Exception {
        List list = super.getSchemas(connection);
        this.setDBAUser(connection);
        return list;
    }

    @Override
    public List getMOHObjects() {
        switch (this.dbMajorVersion) {
            case 8: 
            case 9: {
                return this.getMOHObjectsv9i();
            }
            case 10: {
                return this.getMOHObjectsv10g();
            }
            case 11: {
                return this.getMOHObjectsv11g();
            }
        }
        return this.getMOHObjectsv10g();
    }

    private List getMOHObjectsv9i() {
        if (this.mohObjectsv9i == null) {
            this.mohObjectsv9i = new ArrayList();
            this.mohObjectsv9i.add(new MOHTableSpaceOracle(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHTempTableSpaceOracle(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHUndoTableSpaceOraclev9i(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHDatafileOracle(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHRoleOraclev9i(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHUserOracle(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHTypeIncompleteOraclev9i(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHTypeOraclev9i(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHCollectionTypeOracle(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHDirectoryOracle(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHExternalTableOraclev9i(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHContextOraclev9i(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHClusterOracle(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHTableOraclev9i(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHBitmapIndexesv9i(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHObjectColumnsOracle(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHViewOracle(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHProcedureOracle(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHDimensionOracle(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHSequenceOracle(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHSynonymOracle(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHPackageOracle(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHFunctionOracle(this, this.view, this.dbaUser));
        }
        return this.mohObjectsv9i;
    }

    private List getMOHObjectsv10g() {
        if (this.mohObjectsv10g == null) {
            this.mohObjectsv10g = new ArrayList();
            this.mohObjectsv10g.add(new MOHTableSpaceOracle(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHTempTableSpaceOracle(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHUndoTableSpaceOraclev10g(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHDatafileOracle(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHRoleOraclev9i(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHUserOracle(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHTypeIncompleteOraclev9i(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHTypeOraclev9i(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHCollectionTypeOracle(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHDirectoryOracle(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHExternalTableOraclev9i(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHContextOraclev9i(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHClusterOracle(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHTableOraclev9i(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHBitmapIndexesv10g(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHObjectColumnsOracle(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHViewOracle(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHProcedureOracle(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHDimensionOracle(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHSequenceOracle(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHSynonymOracle(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHPackageOracle(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHFunctionOracle(this, this.view, this.dbaUser));
        }
        return this.mohObjectsv10g;
    }

    private List getMOHObjectsv11g() {
        if (this.mohObjectsv11g == null) {
            this.mohObjectsv11g = new ArrayList();
            this.mohObjectsv11g.add(new MOHTableSpaceOracle(this, this.view, this.dbaUser));
            this.mohObjectsv11g.add(new MOHTempTableSpaceOracle(this, this.view, this.dbaUser));
            this.mohObjectsv11g.add(new MOHUndoTableSpaceOraclev10g(this, this.view, this.dbaUser));
            this.mohObjectsv11g.add(new MOHDatafileOracle(this, this.view, this.dbaUser));
            this.mohObjectsv11g.add(new MOHRoleOraclev9i(this, this.view, this.dbaUser));
            this.mohObjectsv11g.add(new MOHUserOracle(this, this.view, this.dbaUser));
            this.mohObjectsv11g.add(new MOHTypeIncompleteOraclev9i(this, this.view, this.dbaUser));
            this.mohObjectsv11g.add(new MOHTypeOraclev9i(this, this.view, this.dbaUser));
            this.mohObjectsv11g.add(new MOHCollectionTypeOracle(this, this.view, this.dbaUser));
            this.mohObjectsv11g.add(new MOHDirectoryOracle(this, this.view, this.dbaUser));
            this.mohObjectsv11g.add(new MOHExternalTableOraclev9i(this, this.view, this.dbaUser));
            this.mohObjectsv11g.add(new MOHContextOraclev9i(this, this.view, this.dbaUser));
            this.mohObjectsv11g.add(new MOHClusterOracle(this, this.view, this.dbaUser));
            this.mohObjectsv11g.add(new MOHTableOraclev9i(this, this.view, this.dbaUser));
            this.mohObjectsv11g.add(new MOHBitmapIndexesv10g(this, this.view, this.dbaUser));
            this.mohObjectsv11g.add(new MOHObjectColumnsOracle(this, this.view, this.dbaUser));
            this.mohObjectsv11g.add(new MOHViewOracle(this, this.view, this.dbaUser));
            this.mohObjectsv11g.add(new MOHProcedureOracle(this, this.view, this.dbaUser));
            this.mohObjectsv11g.add(new MOHDimensionOracle(this, this.view, this.dbaUser));
            this.mohObjectsv11g.add(new MOHSequenceOracle(this, this.view, this.dbaUser));
            this.mohObjectsv11g.add(new MOHSynonymOracle(this, this.view, this.dbaUser));
            this.mohObjectsv11g.add(new MOHPackageOracle(this, this.view, this.dbaUser));
            this.mohObjectsv11g.add(new MOHFunctionOracle(this, this.view, this.dbaUser));
        }
        return this.mohObjectsv11g;
    }

    @Override
    public RDBMSSite getRDBMSSite() {
        switch (this.dbMajorVersion) {
            case 8: 
            case 9: {
                return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignOraclev9i.RDBMS_TYPE);
            }
            case 10: {
                return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignOraclev10g.RDBMS_TYPE);
            }
            case 11: {
                return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignOraclev11g.RDBMS_TYPE);
            }
        }
        return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignOraclev10g.RDBMS_TYPE);
    }
}

