/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.odbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.odbc.MOHForeignKeyODBC;
import oracle.dbtools.crest.imports.metadata.odbc.MOHTableODBC;
import oracle.dbtools.crest.imports.metadata.odbc.MOHViewODBC;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;

public final class DBMExtractionHandlerODBC
extends AbstractDBMExtractionHandler {
    private static final String DB_NAME_UDB = "UDB";
    private static final String DB_NAME_ORACLE = "ORACLE";
    private static final String DB_NAME_SQL_SERVER = "SQL SERVER";
    private static DBMExtractionHandlerODBC dbmExtractionHandler;
    private List mohObjects = null;
    private ApplicationView view;

    private DBMExtractionHandlerODBC(ApplicationView applicationView) {
        this.view = applicationView;
    }

    @Override
    public List getSchemas(Connection connection) throws Exception {
        boolean bl = false;
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        if (connection != null) {
            Object object;
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            try {
                databaseMetaData.isCatalogAtStart();
                object = databaseMetaData.getSchemaTerm();
                bl = "schema".equalsIgnoreCase((String)object) ? true : databaseMetaData.supportsSchemasInTableDefinitions();
                databaseMetaData.getCatalogTerm();
                this.dbProductName = databaseMetaData.getDatabaseProductName();
                this.dbProductVersion = databaseMetaData.getDatabaseProductVersion();
                this.dbMajorVersion = databaseMetaData.getDatabaseMajorVersion();
            }
            catch (Throwable throwable) {
                System.out.println(throwable.getMessage());
            }
            boolean bl2 = true;
            if (bl) {
                try {
                    object = databaseMetaData.getSchemas();
                    if (!object.next()) {
                        object = databaseMetaData.getCatalogs();
                        DBMExtractionHandlerODBC.setSchemaBased(false);
                    } else {
                        bl2 = false;
                        DBMExtractionHandlerODBC.setSchemaBased(true);
                    }
                }
                catch (SQLException sQLException) {
                    object = databaseMetaData.getCatalogs();
                    DBMExtractionHandlerODBC.setSchemaBased(false);
                }
                int n = 1;
                try {
                    n = object.getMetaData().getColumnCount();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (DBMExtractionHandlerODBC.isSchemaBased()) {
                    String string;
                    DBObject dBObject;
                    String string2;
                    if (!bl2) {
                        string2 = object.getString(1);
                        dBObject = new DBObject(false, string2);
                        if (n > 1) {
                            string = object.getString(2);
                            dBObject.setCatalog(string);
                        }
                        arrayList.add(dBObject);
                    }
                    while (object.next()) {
                        string2 = object.getString(1);
                        dBObject = new DBObject(false, string2);
                        if (n > 1) {
                            string = object.getString(2);
                            dBObject.setCatalog(string);
                        }
                        arrayList.add(dBObject);
                    }
                } else {
                    DBObject dBObject;
                    String string;
                    if (!bl2) {
                        string = object.getString(1);
                        dBObject = new DBObject(false, string);
                        arrayList.add(dBObject);
                    }
                    while (object.next()) {
                        string = object.getString(1);
                        dBObject = new DBObject(false, string);
                        arrayList.add(dBObject);
                    }
                }
                object.close();
            } else {
                DBObject dBObject;
                String string;
                try {
                    object = databaseMetaData.getCatalogs();
                    if (!object.next()) {
                        object = databaseMetaData.getSchemas();
                        DBMExtractionHandlerODBC.setSchemaBased(true);
                    } else {
                        bl2 = false;
                        DBMExtractionHandlerODBC.setSchemaBased(false);
                    }
                }
                catch (SQLException sQLException) {
                    object = databaseMetaData.getSchemas();
                    DBMExtractionHandlerODBC.setSchemaBased(true);
                }
                if (!bl2) {
                    string = object.getString(1);
                    dBObject = new DBObject(false, string);
                    arrayList.add(dBObject);
                }
                while (object.next()) {
                    string = object.getString(1);
                    dBObject = new DBObject(false, string);
                    arrayList.add(dBObject);
                }
                object.close();
            }
        }
        return arrayList;
    }

    public static AbstractDBMExtractionHandler getInstance(ApplicationView applicationView) {
        if (dbmExtractionHandler == null) {
            dbmExtractionHandler = new DBMExtractionHandlerODBC(applicationView);
        }
        return dbmExtractionHandler;
    }

    public static void clearInstance() {
        dbmExtractionHandler = null;
    }

    @Override
    public List getMOHObjects() {
        if (this.mohObjects == null) {
            this.mohObjects = new ArrayList();
            this.mohObjects.add(new MOHTableODBC(this, this.view));
            this.mohObjects.add(new MOHForeignKeyODBC(this, this.view));
            this.mohObjects.add(new MOHViewODBC(this, this.view));
        }
        return this.mohObjects;
    }

    @Override
    public RDBMSSite getRDBMSSite() {
        if (this.dbMajorVersion == -1) {
            String string = this.dbProductVersion.indexOf(46) > -1 ? this.dbProductVersion.substring(0, this.dbProductVersion.indexOf(46)) : this.dbProductVersion;
            try {
                this.dbMajorVersion = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.dbProductName.toUpperCase().indexOf(DB_NAME_ORACLE) > -1) {
            switch (this.dbMajorVersion) {
                case 8: 
                case 9: {
                    return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignOraclev9i.RDBMS_TYPE);
                }
                case 10: {
                    return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignOraclev10g.RDBMS_TYPE);
                }
                case 11: {
                    return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignOraclev11g.RDBMS_TYPE);
                }
            }
            return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignOraclev11g.RDBMS_TYPE);
        }
        if (this.dbProductName.toUpperCase().indexOf(DB_NAME_SQL_SERVER) > -1) {
            return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignSqlServerv2k5.RDBMS_TYPE);
        }
        if (this.dbProductName.toUpperCase().indexOf(DB_NAME_UDB) > -1) {
            switch (this.dbMajorVersion) {
                case 7: {
                    return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignUDBv71.RDBMS_TYPE);
                }
                case 8: {
                    return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignUDBv81.RDBMS_TYPE);
                }
            }
            return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignUDBv81.RDBMS_TYPE);
        }
        switch (this.dbMajorVersion) {
            case 7: {
                return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignDB2v70.RDBMS_TYPE);
            }
            case 8: {
                return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignDB2v80.RDBMS_TYPE);
            }
        }
        return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignDB2v80.RDBMS_TYPE);
    }
}

