/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.db2.v80;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.MOHTable;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.datatype.NativeDBType;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageObjectDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexPartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.PartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.PrivilegesDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.SynonymDB2;
import oracle.dbtools.crest.model.design.storage.db2.TablePartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.TriggerDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.ColumnIdentityDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.TableProxyDB2v80;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHTableDB2v80
extends MOHTable {
    private static final Logger LOGGER = new Logger(MOHTableDB2v80.class);
    protected static final String DBADM = "DBADM";
    protected static final String DBCTRL = "DBCTRL";
    protected static final String DBMAINT = "DBMAINT";
    protected static final String CREATETAB = "CREATETAB";
    protected static final String CREATETS = "CREATETS";
    protected static final String DISPLAYDB = "DISPLAYDB";
    protected static final String DROP = "DROP";
    protected static final String IMAGCOMPY = "IMAGCOMPY";
    protected static final String LOAD = "LOAD";
    protected static final String RECOVERDB = "RECOVERDB";
    protected static final String REORG = "REORG";
    protected static final String REPAIR = "REPAIR";
    protected static final String STARTDB = "STARTDB";
    protected static final String STATS = "STATS";
    protected static final String STOPDB = "STOPDB";
    protected static final String Y = "Y";
    protected static final String G = "G";

    public MOHTableDB2v80(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (DBObject dBObject : list) {
            CharSequence charSequence;
            if (!dBObject.isSelected()) continue;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT name from SYSIBM.SYSTABLES").append(' ');
                ((StringBuffer)charSequence).append("WHERE TYPE = 'T' and CREATOR = '");
                ((StringBuffer)charSequence).append(dBObject.getName()).append("'");
                statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
                resultSet = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHTableDB2v80.extract(): " + sQLException.getMessage());
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                    DBObject dBObject2 = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, "TABLE", dBObject.getName());
                    arrayList.add(dBObject2);
                }
                resultSet.close();
            }
            if (statement == null) continue;
            statement.close();
        }
        return arrayList;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            CharSequence charSequence;
            DBObject dBObject = (DBObject)list.get(i);
            String string = dBObject.getName();
            String string2 = dBObject.getSchema();
            if (!"TABLE".equalsIgnoreCase(dBObject.getType())) continue;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT TSNAME, DBNAME, OBID, EDPROC, VALPROC, ");
                ((StringBuffer)charSequence).append("AUDITING, DATACAPTURE, ENCODING_SCHEME, ");
                ((StringBuffer)charSequence).append("PCTROWCOMP, CREATEDBY, RECLENGTH, NPAGES, PCTPAGES ");
                ((StringBuffer)charSequence).append("from SYSIBM.SYSTABLES ");
                ((StringBuffer)charSequence).append("WHERE TYPE = 'T' and NAME = '");
                ((StringBuffer)charSequence).append(dBObject.getName()).append("' and CREATOR = '").append(string2).append("'");
                statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
                resultSet = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHTableDB2v80.generate(): " + string2 + "." + string, sQLException);
            }
            if (resultSet != null) {
                if (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                    String string3 = resultSet.getString(2);
                    int n = resultSet.getInt(3);
                    String string4 = resultSet.getString(4);
                    String string5 = resultSet.getString(5);
                    String string6 = resultSet.getString(6);
                    String string7 = resultSet.getString(7);
                    String string8 = resultSet.getString(8);
                    int n2 = resultSet.getInt(9);
                    String string9 = resultSet.getString(10);
                    int n3 = resultSet.getInt(11);
                    int n4 = resultSet.getInt(12);
                    int n5 = resultSet.getInt(13);
                    Table table = this.getDesign().getRelationalDesign().createTable();
                    table.setSchema(dBObject.getSchema());
                    table.setName(string);
                    this.stampModelObject(table, dBObject);
                    this.initColumns(connection, table, string2);
                    TableSpaceDB2 tableSpaceDB2 = null;
                    StorageDesign storageDesign = this.getStorageDesign();
                    if (storageDesign != null && storageDesign instanceof AbstractStorageDesignDB2) {
                        TableProxyDB2v80 tableProxyDB2v80;
                        AbstractStorageDesignDB2 abstractStorageDesignDB2 = (AbstractStorageDesignDB2)storageDesign;
                        DataBaseDB2 dataBaseDB2 = (DataBaseDB2)abstractStorageDesignDB2.getDataBaseSet().getByName(string3);
                        if (dataBaseDB2 == null) {
                            dataBaseDB2 = this.createDatabase(connection, string3);
                        }
                        if ((tableProxyDB2v80 = (TableProxyDB2v80)abstractStorageDesignDB2.getTableProxySet().getProxy(table.getObjectID())) != null) {
                            tableProxyDB2v80.setName(string);
                            tableSpaceDB2 = (TableSpaceDB2)abstractStorageDesignDB2.getTableSpaceSet().getByName((String)charSequence);
                            if (tableSpaceDB2 == null) {
                                tableSpaceDB2 = this.createTablespace(connection, (String)charSequence, string3, string2);
                            }
                            tableProxyDB2v80.setTableSpace(tableSpaceDB2);
                            Owner owner = (Owner)abstractStorageDesignDB2.getOwnerSet().getByName(string2);
                            if (owner == null) {
                                owner = (Owner)abstractStorageDesignDB2.getOwnerSet().createElement(string2);
                                owner.setName(string2);
                                this.stampModelObject((ModelObject)owner, "", string2);
                            }
                            tableProxyDB2v80.setOwner(owner);
                            tableProxyDB2v80.setObid(n);
                            tableProxyDB2v80.setEditProc(string4);
                            tableProxyDB2v80.setValidProc(string5);
                            if ("A".equalsIgnoreCase(string6)) {
                                tableProxyDB2v80.setAudit("ALL");
                            } else if ("C".equalsIgnoreCase(string6)) {
                                tableProxyDB2v80.setAudit("CHANGES");
                            }
                            if (Y.equalsIgnoreCase(string7)) {
                                tableProxyDB2v80.setDataCapture(true);
                            } else {
                                tableProxyDB2v80.setDataCapture(false);
                            }
                            if (string8.trim().equalsIgnoreCase("E")) {
                                tableProxyDB2v80.setCcsid("EBCDIC");
                            } else if (string8.trim().equalsIgnoreCase("A")) {
                                tableProxyDB2v80.setCcsid("ASCII");
                            } else if (string8.trim().equalsIgnoreCase("U")) {
                                tableProxyDB2v80.setCcsid("UNICODE");
                            }
                            tableProxyDB2v80.setNumberOfRows(n2);
                            tableProxyDB2v80.setCreatedBy(string9);
                            tableProxyDB2v80.setRecordLength(n3);
                            tableProxyDB2v80.setNumberOfPages(n4);
                            tableProxyDB2v80.setPercentageOfPages(n5);
                            this.initColumnIdentity(connection, tableProxyDB2v80, string2, abstractStorageDesignDB2);
                            if (tableSpaceDB2 != null && tableSpaceDB2.isPartitioned()) {
                                this.initPartitions(connection, tableProxyDB2v80, tableSpaceDB2);
                            }
                            this.initSynonyms(connection, tableProxyDB2v80, string2);
                            this.initTriggers(connection, tableProxyDB2v80, string2);
                        } else {
                            LOGGER.error("Unable to find TableProxy for table ID: " + table.getObjectID());
                        }
                    } else {
                        LOGGER.error("Unable to find Storage Design!");
                    }
                    boolean bl = true;
                    if (tableSpaceDB2 != null) {
                        bl = tableSpaceDB2.isPartitioned();
                    }
                    this.initIndexes(connection, table, string2, bl);
                    this.initUniqueConstraints(connection, table, string2);
                    this.initColumnConstraints(connection, table, string2);
                    this.initTableConstraints(connection, table, string2);
                }
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObject);
        }
    }

    private TableSpaceDB2 createTablespace(Connection connection, String string, String string2, String string3) throws Exception {
        Object object;
        TableSpaceDB2 tableSpaceDB2 = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT TYPE, PARTITIONS, ");
            ((StringBuffer)object).append("DSSIZE, SEGSIZE, BPOOL, LOCKRULE, LOCKMAX, ");
            ((StringBuffer)object).append("CLOSERULE, ENCODING_SCHEME, LOCKPART, MAXROWS, ");
            ((StringBuffer)object).append("OBID, PSID, NACTIVE, CREATEDBY, SPACE ");
            ((StringBuffer)object).append("from SYSIBM.SYSTABLESPACE").append(' ');
            ((StringBuffer)object).append("WHERE NAME = '").append(string).append("'");
            ((StringBuffer)object).append(" AND DBNAME = '").append(string2).append("'");
            statement = connection.prepareStatement(((StringBuffer)object).toString());
            resultSet = statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableDB2v80.createTablespace():", sQLException);
        }
        if (resultSet != null) {
            if (resultSet.next()) {
                object = this.getStorageDesign();
                if (object != null && object instanceof AbstractStorageDesignDB2) {
                    AbstractStorageDesignDB2 abstractStorageDesignDB2 = (AbstractStorageDesignDB2)object;
                    String string4 = resultSet.getString(1);
                    int n = resultSet.getInt(2);
                    int n2 = resultSet.getInt(3);
                    int n3 = resultSet.getInt(4);
                    String string5 = resultSet.getString(5);
                    String string6 = resultSet.getString(6);
                    int n4 = resultSet.getInt(7);
                    String string7 = resultSet.getString(8);
                    String string8 = resultSet.getString(9);
                    String string9 = resultSet.getString(10);
                    int n5 = resultSet.getInt(11);
                    int n6 = resultSet.getInt(12);
                    int n7 = resultSet.getInt(13);
                    int n8 = resultSet.getInt(14);
                    String string10 = resultSet.getString(15);
                    int n9 = resultSet.getInt(16);
                    DataBaseDB2 dataBaseDB2 = (DataBaseDB2)abstractStorageDesignDB2.getDataBaseSet().getByName(string2);
                    if (dataBaseDB2 != null) {
                        tableSpaceDB2 = abstractStorageDesignDB2.getTableSpaceSet().createTableSpace();
                        tableSpaceDB2.setName(string);
                        tableSpaceDB2.setDataBase(dataBaseDB2);
                        this.stampModelObject((ModelObject)tableSpaceDB2, string3, string);
                        if ("L".equalsIgnoreCase(string4)) {
                            tableSpaceDB2.setType("LOB");
                        }
                        tableSpaceDB2.setDsSize(n2 / 0x100000 + " G");
                        tableSpaceDB2.setSegSize("" + n3);
                        BufferPoolDB2 bufferPoolDB2 = (BufferPoolDB2)abstractStorageDesignDB2.getBufferPoolSet().getByName(string5);
                        if (bufferPoolDB2 != null) {
                            tableSpaceDB2.setBufferPool(bufferPoolDB2);
                        }
                        if ("A".equalsIgnoreCase(string6)) {
                            tableSpaceDB2.setLockSize("ANY");
                        } else if ("L".equalsIgnoreCase(string6)) {
                            tableSpaceDB2.setLockSize("LOB");
                        } else if ("P".equalsIgnoreCase(string6)) {
                            tableSpaceDB2.setLockSize("PAGE");
                        } else if ("R".equalsIgnoreCase(string6)) {
                            tableSpaceDB2.setLockSize("ROW");
                        } else if ("S".equalsIgnoreCase(string6)) {
                            tableSpaceDB2.setLockSize("TABLESPACE");
                        } else if ("T".equalsIgnoreCase(string6)) {
                            tableSpaceDB2.setLockSize("TABLE");
                        }
                        tableSpaceDB2.setLockMax(n4);
                        if ("N".equalsIgnoreCase(string7)) {
                            tableSpaceDB2.setClose(false);
                        } else {
                            tableSpaceDB2.setClose(true);
                        }
                        if (string8.trim().equalsIgnoreCase("E")) {
                            tableSpaceDB2.setCcsid("EBCDIC");
                        } else if (string8.trim().equalsIgnoreCase("A")) {
                            tableSpaceDB2.setCcsid("ASCII");
                        } else if (string8.trim().equalsIgnoreCase("U")) {
                            tableSpaceDB2.setCcsid("UNICODE");
                        }
                        if (Y.equalsIgnoreCase(string9)) {
                            tableSpaceDB2.setLockPart(true);
                        } else {
                            tableSpaceDB2.setClose(false);
                        }
                        tableSpaceDB2.setMaxRows(n5);
                        tableSpaceDB2.setObid(n6);
                        tableSpaceDB2.setPsid(n7);
                        tableSpaceDB2.setNactive(n8);
                        tableSpaceDB2.setCreatedBy(string10);
                        tableSpaceDB2.setSpace(n9);
                        tableSpaceDB2.setNumParts(n);
                        if (n > 0) {
                            tableSpaceDB2.setType("PARTITIONED");
                            this.initTablespacePartitions(connection, tableSpaceDB2);
                        }
                    }
                } else {
                    LOGGER.error("Unable to find Storage Design!");
                }
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
        return tableSpaceDB2;
    }

    private void initTablespacePartitions(Connection connection, TableSpaceDB2 tableSpaceDB2) throws Exception {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT PARTITION, COMPRESS, ");
            stringBuffer.append("VCATNAME, STORNAME, PQTY, SQTY, FREEPAGE, PCTFREE, GBPCACHE, TRACKMOD ");
            stringBuffer.append("from SYSIBM.SYSTABLEPART ");
            stringBuffer.append("WHERE TSNAME = '");
            stringBuffer.append(tableSpaceDB2.getName()).append("'");
            stringBuffer.append("ORDER BY PARTITION");
            statement = connection.prepareStatement(stringBuffer.toString());
            resultSet = statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTablespaceDB2.initTablespacePartitions():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                int n = resultSet.getInt(1);
                String string = resultSet.getString(2);
                String string2 = resultSet.getString(3);
                String string3 = resultSet.getString(4).trim();
                int n2 = resultSet.getInt(5) * 4;
                int n3 = resultSet.getInt(6) * 4;
                int n4 = resultSet.getInt(7);
                int n5 = resultSet.getInt(8);
                String string4 = resultSet.getString(9);
                String string5 = resultSet.getString(10);
                if (n <= 0) continue;
                StorageDesign storageDesign = this.getStorageDesign();
                AbstractStorageDesignDB2 abstractStorageDesignDB2 = null;
                if (storageDesign != null && storageDesign instanceof AbstractStorageDesignDB2) {
                    AbstractStorageObjectDB2 abstractStorageObjectDB2;
                    abstractStorageDesignDB2 = (AbstractStorageDesignDB2)storageDesign;
                    tableSpaceDB2.setType("PARTITIONED");
                    PartitionDB2 partitionDB2 = abstractStorageDesignDB2.getPartitionSet().createPartition();
                    partitionDB2.setTableSpace(tableSpaceDB2);
                    partitionDB2.setPartNumber(n);
                    if (Y.equalsIgnoreCase(string)) {
                        partitionDB2.setCompress(true);
                    } else {
                        partitionDB2.setCompress(false);
                    }
                    StorageTemplateDB2 storageTemplateDB2 = abstractStorageDesignDB2.getStorageTemplateSet().createStorageTemplate();
                    partitionDB2.setStorageTemplate(storageTemplateDB2);
                    if (!"".equalsIgnoreCase(string3)) {
                        abstractStorageObjectDB2 = (StorageGroupDB2)abstractStorageDesignDB2.getStorageGroupSet().getByName(string3);
                        if (abstractStorageObjectDB2 != null) {
                            storageTemplateDB2.setStorageGroup((StorageGroupDB2)abstractStorageObjectDB2);
                        }
                    } else {
                        abstractStorageObjectDB2 = (VCatDB2)abstractStorageDesignDB2.getVCatSet().getByName(string2);
                        if (abstractStorageObjectDB2 != null) {
                            storageTemplateDB2.setVCat((VCatDB2)abstractStorageObjectDB2);
                        }
                    }
                    storageTemplateDB2.setSgPriqty(n2);
                    storageTemplateDB2.setSgSeqty(n3);
                    storageTemplateDB2.setFreePage(n4);
                    storageTemplateDB2.setPctFree(n5);
                    if ("A".equalsIgnoreCase(string4)) {
                        storageTemplateDB2.setGbCache("ALL");
                    } else if ("N".equalsIgnoreCase(string4)) {
                        storageTemplateDB2.setGbCache("NONE");
                    } else if ("S".equalsIgnoreCase(string4)) {
                        storageTemplateDB2.setGbCache("SYSTEM");
                    } else if ("".equalsIgnoreCase(string4)) {
                        storageTemplateDB2.setGbCache("CHANGED");
                    }
                    if ("N".equalsIgnoreCase(string5)) {
                        storageTemplateDB2.setTrackMode(false);
                    } else {
                        storageTemplateDB2.setTrackMode(true);
                    }
                    if ((abstractStorageObjectDB2 = abstractStorageDesignDB2.getStorageTemplateSet().removeIfExistEqual(storageTemplateDB2)) == partitionDB2.getStorageTemplate()) continue;
                    partitionDB2.setStorageTemplate((StorageTemplateDB2)abstractStorageObjectDB2);
                    continue;
                }
                LOGGER.error("Unable to find Storage Design!");
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private DataBaseDB2 createDatabase(Connection connection, String string) throws Exception {
        Object object;
        DataBaseDB2 dataBaseDB2 = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT BPOOL, INDEXBP, TYPE, GROUP_MEMBER, STGROUP, ENCODING_SCHEME").append(' ');
            ((StringBuffer)object).append("from SYSIBM.SYSDATABASE").append(' ');
            ((StringBuffer)object).append("WHERE NAME = '").append(string).append("'");
            statement = connection.prepareStatement(((StringBuffer)object).toString());
            resultSet = statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableDB2.createDatabase():", sQLException);
        }
        if (resultSet != null) {
            if (resultSet.next()) {
                object = this.getStorageDesign();
                if (object != null && object instanceof AbstractStorageDesignDB2) {
                    AbstractStorageDesignDB2 abstractStorageDesignDB2 = (AbstractStorageDesignDB2)object;
                    String string2 = resultSet.getString(1);
                    String string3 = resultSet.getString(2);
                    String string4 = resultSet.getString(3);
                    String string5 = resultSet.getString(4);
                    String string6 = resultSet.getString(5);
                    String string7 = resultSet.getString(6);
                    dataBaseDB2 = abstractStorageDesignDB2.getDataBaseSet().createDataBase();
                    dataBaseDB2.setName(string);
                    this.stampModelObject((ModelObject)dataBaseDB2, "", string);
                    BufferPoolDB2 bufferPoolDB2 = (BufferPoolDB2)abstractStorageDesignDB2.getBufferPoolSet().getByName(string2);
                    if (bufferPoolDB2 != null) {
                        dataBaseDB2.setBufferPool(bufferPoolDB2);
                    }
                    if ((bufferPoolDB2 = (BufferPoolDB2)abstractStorageDesignDB2.getBufferPoolSet().getByName(string3)) != null) {
                        dataBaseDB2.setIndexBufferPool(bufferPoolDB2);
                    }
                    if (string4.trim().equalsIgnoreCase("T")) {
                        dataBaseDB2.setType("TEMP");
                    } else if (string4.trim().equalsIgnoreCase("W")) {
                        dataBaseDB2.setType("WORKFILE");
                    }
                    dataBaseDB2.setMember(string5);
                    if (!"".equalsIgnoreCase(string6.trim())) {
                        StorageGroupDB2 storageGroupDB2 = (StorageGroupDB2)abstractStorageDesignDB2.getStorageGroupSet().getByName(string6);
                        if (storageGroupDB2 == null) {
                            storageGroupDB2 = abstractStorageDesignDB2.getStorageGroupSet().createStorageGroup();
                            storageGroupDB2.setName(string6);
                            this.stampModelObject((ModelObject)storageGroupDB2, "", string6);
                        }
                        dataBaseDB2.setStorageGroup(storageGroupDB2);
                    }
                    if (string7.trim().equalsIgnoreCase("E")) {
                        dataBaseDB2.setCcsid("EBCDIC");
                    } else if (string7.trim().equalsIgnoreCase("A")) {
                        dataBaseDB2.setCcsid("ASCII");
                    } else if (string7.trim().equalsIgnoreCase("U")) {
                        dataBaseDB2.setCcsid("UNICODE");
                    }
                    this.initDBPrivileges(connection, dataBaseDB2, abstractStorageDesignDB2);
                } else {
                    LOGGER.error("Unable to find Storage Design!");
                }
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
        return dataBaseDB2;
    }

    private void initDBPrivileges(Connection connection, DataBaseDB2 dataBaseDB2, AbstractStorageDesignDB2 abstractStorageDesignDB2) throws Exception {
        CharSequence charSequence;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT GRANTOR, CREATETABAUTH, CREATETSAUTH, ");
            ((StringBuffer)charSequence).append("DBADMAUTH, DBCTRLAUTH, DBMAINTAUTH, DISPLAYDBAUTH, ");
            ((StringBuffer)charSequence).append("DROPAUTH, IMAGCOPYAUTH, LOADAUTH, REORGAUTH, ");
            ((StringBuffer)charSequence).append("RECOVERDBAUTH, REPAIRAUTH, STARTDBAUTH, STATSAUTH, STOPAUTH ");
            ((StringBuffer)charSequence).append("from SYSIBM.SYSDBAUTH ");
            ((StringBuffer)charSequence).append("WHERE NAME = '");
            ((StringBuffer)charSequence).append(dataBaseDB2.getName()).append("'");
            statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
            resultSet = statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHDatabaseDB2.initPrivileges():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1).trim();
                String string = resultSet.getString(2);
                String string2 = resultSet.getString(3);
                String string3 = resultSet.getString(4);
                String string4 = resultSet.getString(5);
                String string5 = resultSet.getString(6);
                String string6 = resultSet.getString(7);
                String string7 = resultSet.getString(8);
                String string8 = resultSet.getString(9);
                String string9 = resultSet.getString(10);
                String string10 = resultSet.getString(11);
                String string11 = resultSet.getString(12);
                String string12 = resultSet.getString(13);
                String string13 = resultSet.getString(14);
                String string14 = resultSet.getString(15);
                String string15 = resultSet.getString(16);
                StringBuffer stringBuffer = new StringBuffer();
                boolean bl = false;
                boolean bl2 = true;
                if (string.equalsIgnoreCase(Y)) {
                    stringBuffer.append(CREATETAB);
                    bl2 = false;
                } else if (string.equalsIgnoreCase(G)) {
                    stringBuffer.append(CREATETAB);
                    bl2 = false;
                    bl = true;
                }
                if (string2.equalsIgnoreCase(Y)) {
                    if (bl2) {
                        stringBuffer.append(CREATETS);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(CREATETS);
                    }
                } else if (string2.equalsIgnoreCase(G)) {
                    if (bl2) {
                        stringBuffer.append(CREATETS);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(CREATETS);
                    }
                    bl = true;
                }
                if (string3.equalsIgnoreCase(Y)) {
                    if (bl2) {
                        stringBuffer.append(DBADM);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(DBADM);
                    }
                } else if (string3.equalsIgnoreCase(G)) {
                    if (bl2) {
                        stringBuffer.append(DBADM);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(DBADM);
                    }
                    bl = true;
                }
                if (string4.equalsIgnoreCase(Y)) {
                    if (bl2) {
                        stringBuffer.append(DBCTRL);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(DBCTRL);
                    }
                } else if (string4.equalsIgnoreCase(G)) {
                    if (bl2) {
                        stringBuffer.append(DBCTRL);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(DBCTRL);
                    }
                    bl = true;
                }
                if (string5.equalsIgnoreCase(Y)) {
                    if (bl2) {
                        stringBuffer.append(DBMAINT);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(DBMAINT);
                    }
                } else if (string5.equalsIgnoreCase(G)) {
                    if (bl2) {
                        stringBuffer.append(DBMAINT);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(DBMAINT);
                    }
                    bl = true;
                }
                if (string6.equalsIgnoreCase(Y)) {
                    if (bl2) {
                        stringBuffer.append(DISPLAYDB);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(DISPLAYDB);
                    }
                } else if (string6.equalsIgnoreCase(G)) {
                    if (bl2) {
                        stringBuffer.append(DISPLAYDB);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(DISPLAYDB);
                    }
                    bl = true;
                }
                if (string7.equalsIgnoreCase(Y)) {
                    if (bl2) {
                        stringBuffer.append(DROP);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(DROP);
                    }
                } else if (string7.equalsIgnoreCase(G)) {
                    if (bl2) {
                        stringBuffer.append(DROP);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(DROP);
                    }
                    bl = true;
                }
                if (string8.equalsIgnoreCase(Y)) {
                    if (bl2) {
                        stringBuffer.append(IMAGCOMPY);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(IMAGCOMPY);
                    }
                } else if (string8.equalsIgnoreCase(G)) {
                    if (bl2) {
                        stringBuffer.append(IMAGCOMPY);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(IMAGCOMPY);
                    }
                    bl = true;
                }
                if (string9.equalsIgnoreCase(Y)) {
                    if (bl2) {
                        stringBuffer.append(LOAD);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(LOAD);
                    }
                } else if (string9.equalsIgnoreCase(G)) {
                    if (bl2) {
                        stringBuffer.append(LOAD);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(LOAD);
                    }
                    bl = true;
                }
                if (string11.equalsIgnoreCase(Y)) {
                    if (bl2) {
                        stringBuffer.append(RECOVERDB);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(RECOVERDB);
                    }
                } else if (string11.equalsIgnoreCase(G)) {
                    if (bl2) {
                        stringBuffer.append(RECOVERDB);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(RECOVERDB);
                    }
                    bl = true;
                }
                if (string10.equalsIgnoreCase(Y)) {
                    if (bl2) {
                        stringBuffer.append(REORG);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(REORG);
                    }
                } else if (string10.equalsIgnoreCase(G)) {
                    if (bl2) {
                        stringBuffer.append(REORG);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(REORG);
                    }
                    bl = true;
                }
                if (string12.equalsIgnoreCase(Y)) {
                    if (bl2) {
                        stringBuffer.append(REPAIR);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(REPAIR);
                    }
                } else if (string12.equalsIgnoreCase(G)) {
                    if (bl2) {
                        stringBuffer.append(REPAIR);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(REPAIR);
                    }
                    bl = true;
                }
                if (string13.equalsIgnoreCase(Y)) {
                    if (bl2) {
                        stringBuffer.append(STARTDB);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(STARTDB);
                    }
                } else if (string12.equalsIgnoreCase(G)) {
                    if (bl2) {
                        stringBuffer.append(STARTDB);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(STARTDB);
                    }
                    bl = true;
                }
                if (string14.equalsIgnoreCase(Y)) {
                    if (bl2) {
                        stringBuffer.append(STATS);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(STATS);
                    }
                } else if (string14.equalsIgnoreCase(G)) {
                    if (bl2) {
                        stringBuffer.append(STATS);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(STATS);
                    }
                    bl = true;
                }
                if (string15.equalsIgnoreCase(Y)) {
                    if (bl2) {
                        stringBuffer.append(STOPDB);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(STOPDB);
                    }
                } else if (string15.equalsIgnoreCase(G)) {
                    if (bl2) {
                        stringBuffer.append(STOPDB);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(STOPDB);
                    }
                    bl = true;
                }
                PrivilegesDB2 privilegesDB2 = abstractStorageDesignDB2.getPrivilegesSet().createPriv();
                privilegesDB2.setDb(dataBaseDB2);
                Owner owner = (Owner)abstractStorageDesignDB2.getOwnerSet().getByName((String)charSequence);
                if (owner == null) {
                    owner = (Owner)abstractStorageDesignDB2.getOwnerSet().createElement((String)charSequence);
                    owner.setName((String)charSequence);
                    this.stampModelObject((ModelObject)owner, "", (String)charSequence);
                }
                privilegesDB2.setUser(owner);
                privilegesDB2.setSystemPrivileges(stringBuffer.toString());
                if (bl) {
                    privilegesDB2.setGrantOption("YES");
                    continue;
                }
                privilegesDB2.setGrantOption("NO");
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initColumnIdentity(Connection connection, TableProxyDB2 tableProxyDB2, String string, AbstractStorageDesignDB2 abstractStorageDesignDB2) throws Exception {
        CharSequence charSequence;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("select d.dcolname, ");
            ((StringBuffer)charSequence).append("s.START, s.INCREMENT, s.MINVALUE, ");
            ((StringBuffer)charSequence).append("s.MAXVALUE, s.CYCLE, s.CACHE, s.ORDER ");
            ((StringBuffer)charSequence).append("from sysibm.syssequencesdep d, sysibm.syssequences s ");
            ((StringBuffer)charSequence).append("where ");
            ((StringBuffer)charSequence).append("d.dcreator = '").append(string).append('\'');
            ((StringBuffer)charSequence).append(" and d.dname = '").append(tableProxyDB2.getName()).append('\'');
            ((StringBuffer)charSequence).append(" and s.sequenceid = d.bsequenceid");
            ((StringBuffer)charSequence).append(" AND s.SEQTYPE = 'I'");
            statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
            resultSet = statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableDB2.initIdentityColumn():", sQLException);
        }
        catch (Exception exception) {
            LOGGER.error("MOHTableDB2.initIdentityColumn():", exception);
        }
        if (resultSet != null) {
            if (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                int n = resultSet.getInt(3);
                int n2 = resultSet.getInt(4);
                int n3 = resultSet.getInt(5);
                String string3 = resultSet.getString(6);
                int n4 = resultSet.getInt(7);
                String string4 = resultSet.getString(8);
                ColumnProxyDB2 columnProxyDB2 = tableProxyDB2.getColumn((String)charSequence);
                if (columnProxyDB2 != null) {
                    ColumnIdentityDB2v80 columnIdentityDB2v80 = (ColumnIdentityDB2v80)abstractStorageDesignDB2.getColumnIdentitySet().createColumnIdentity();
                    columnIdentityDB2v80.setColumn(columnProxyDB2);
                    columnIdentityDB2v80.setStartWith(string2);
                    columnIdentityDB2v80.setIncrementBy(n);
                    columnIdentityDB2v80.setMinValue("" + n2);
                    columnIdentityDB2v80.setMaxValue("" + n3);
                    if ("N".equalsIgnoreCase(string3)) {
                        columnIdentityDB2v80.setCycle(false);
                    } else {
                        columnIdentityDB2v80.setCycle(true);
                    }
                    columnIdentityDB2v80.setCache(n4);
                    if ("N".equalsIgnoreCase(string4)) {
                        columnIdentityDB2v80.setOrder("NO");
                    } else {
                        columnIdentityDB2v80.setOrder("YES");
                    }
                    columnProxyDB2.setColumnIdentity(columnIdentityDB2v80);
                }
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initColumns(Connection connection, Table table, String string) throws Exception {
        Comparable<StringBuffer> comparable;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            comparable = new StringBuffer();
            ((StringBuffer)comparable).append("SELECT NAME, COLTYPE, LENGTH, SCALE, ");
            ((StringBuffer)comparable).append("NULLS, REMARKS, DEFAULT, DEFAULTVALUE, ");
            ((StringBuffer)comparable).append("LABEL ");
            ((StringBuffer)comparable).append("from SYSIBM.SYSCOLUMNS ");
            ((StringBuffer)comparable).append("WHERE TBNAME = '");
            ((StringBuffer)comparable).append(table.getName()).append("'");
            ((StringBuffer)comparable).append(" AND TBCREATOR = '");
            ((StringBuffer)comparable).append(string).append("' ORDER BY COLNO");
            statement = connection.prepareStatement(((StringBuffer)comparable).toString());
            resultSet = statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableDB2v80.initColumns():", sQLException);
        }
        comparable = this.getStorageDesign().getRDBMSType();
        if (resultSet != null) {
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString(2).trim();
                int n = resultSet.getInt(3);
                int n2 = resultSet.getInt(4);
                String string4 = resultSet.getString(5);
                String string5 = resultSet.getString(6);
                String string6 = resultSet.getString(7);
                String string7 = resultSet.getString(8);
                String string8 = resultSet.getString(9);
                if ("TIMESTMP".equalsIgnoreCase(string3)) {
                    string3 = "TIMESTAMP";
                } else if ("VARG".equalsIgnoreCase(string3)) {
                    string3 = "VARGRAPHIC";
                } else if ("LONGVARG".equalsIgnoreCase(string3)) {
                    string3 = "LONG VARGRAPHIC";
                } else if ("LONGVAR".equalsIgnoreCase(string3)) {
                    string3 = "LONG VARCHAR";
                }
                Column column = table.createColumn(string2);
                this.stampModelObject((ModelObject)column, table.getName(), string2);
                LogicalDatatype logicalDatatype = null;
                NativeDBType nativeDBType = StandardDatatypeNames.getNativeDBType(comparable, string3);
                if (nativeDBType != null) {
                    logicalDatatype = nativeDBType.getLogicalDatatype();
                }
                if (logicalDatatype == null) {
                    logicalDatatype = this.getDesign().getLogicalDatatypeSet().getLogTypeByNativeType(string3, this.getDbmeHandler().getRDBMSSite().getType().getName());
                }
                if (logicalDatatype != null) {
                    column.setUse((short)1);
                    column.setLogicalDatatype(logicalDatatype);
                    column.setDataTypeParameter("size", String.valueOf(n));
                    column.setDataTypeParameter("precision", String.valueOf(n));
                    column.setDataTypeParameter("scale", String.valueOf(n2));
                } else {
                    System.out.println("Unable to find logical datatype for: " + string3);
                }
                if (Y.equalsIgnoreCase(string4)) {
                    column.setNullsAllowed(true);
                } else {
                    column.setNullsAllowed(false);
                }
                if ("N".equalsIgnoreCase(string6)) {
                    column.setUsesDefaultValue(false);
                } else {
                    column.setUsesDefaultValue(true);
                    column.setDefaultValue(string7);
                }
                column.setComment(string5);
                column.setCommentInRDBMS(string8);
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initIndexes(Connection connection, Table table, String string, boolean bl) throws Exception {
        CharSequence charSequence;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT i.NAME, i.UNIQUERULE, i.CLUSTERED, ");
            ((StringBuffer)charSequence).append("i.PGSIZE, i.BPOOL, i.CLOSERULE, i.COPY, i.CREATOR ");
            ((StringBuffer)charSequence).append("from SYSIBM.SYSINDEXES i ");
            ((StringBuffer)charSequence).append("WHERE i.TBNAME = '");
            ((StringBuffer)charSequence).append(table.getName()).append("'");
            ((StringBuffer)charSequence).append(" AND i.TBCREATOR = '");
            ((StringBuffer)charSequence).append(string).append("'");
            ((StringBuffer)charSequence).append(" AND not exists (");
            ((StringBuffer)charSequence).append(" select 1 from sysibm.systabconst t ");
            ((StringBuffer)charSequence).append("where ");
            ((StringBuffer)charSequence).append("t.ixowner = i.creator and ");
            ((StringBuffer)charSequence).append("t.ixname = i.name)");
            statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
            resultSet = statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableDB2v80.initIndexes():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(3);
                int n = resultSet.getInt(4);
                String string4 = resultSet.getString(5);
                String string5 = resultSet.getString(6);
                String string6 = resultSet.getString(7);
                String string7 = resultSet.getString(8);
                Index index = table.createIndex();
                index.setName((String)charSequence);
                this.stampModelObject((ModelObject)index, string, (String)charSequence);
                boolean bl2 = false;
                if ("U".equalsIgnoreCase(string2)) {
                    index.setIndexState("Unique Plain Index");
                } else if ("P".equalsIgnoreCase(string2)) {
                    index.setIndexState("Primary Constraint");
                } else if ("C".equalsIgnoreCase(string2) || "R".equalsIgnoreCase(string2)) {
                    index.setIndexState("Unique Constraint");
                } else if ("N".equalsIgnoreCase(string2)) {
                    index.setIndexState("Unique Plain Index");
                    bl2 = true;
                }
                this.initKeyColumns(connection, index, (String)charSequence, table);
                StorageDesign storageDesign = this.getStorageDesign();
                StorageDesign storageDesign2 = null;
                if (storageDesign != null && storageDesign instanceof AbstractStorageDesignDB2) {
                    storageDesign2 = (AbstractStorageDesignDB2)storageDesign;
                }
                if (storageDesign2 != null) {
                    IndexProxyDB2 indexProxyDB2 = (IndexProxyDB2)storageDesign2.getIndexProxySet().getProxy(index.getObjectID());
                    if (indexProxyDB2 != null) {
                        Owner owner = (Owner)((AbstractStorageDesignDB2)storageDesign2).getOwnerSet().getByName(string7);
                        if (owner != null) {
                            indexProxyDB2.setOwner(owner);
                        }
                        if (Y.equalsIgnoreCase(string3)) {
                            indexProxyDB2.setClustered(true);
                        } else if ("N".equalsIgnoreCase(string3)) {
                            indexProxyDB2.setClustered(false);
                        }
                        indexProxyDB2.setPieceSize(n + " K");
                        BufferPoolDB2 bufferPoolDB2 = (BufferPoolDB2)((AbstractStorageDesignDB2)storageDesign2).getBufferPoolSet().getByName(string4);
                        if (bufferPoolDB2 != null) {
                            indexProxyDB2.setBufferPool(bufferPoolDB2);
                        }
                        indexProxyDB2.setWhereNotNull(bl2);
                        if (Y.equalsIgnoreCase(string5)) {
                            indexProxyDB2.setClose(true);
                        } else {
                            indexProxyDB2.setClose(false);
                        }
                        if (Y.equalsIgnoreCase(string6)) {
                            indexProxyDB2.setCopy(true);
                        } else {
                            indexProxyDB2.setCopy(false);
                        }
                        if (!bl) continue;
                        this.initIndexPartitions(connection, indexProxyDB2);
                        continue;
                    }
                    LOGGER.error("Unable to find IndexProxy for table ID: " + table.getObjectID());
                    continue;
                }
                LOGGER.error("Unable to find Storage Design!");
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initIndexPartitions(Connection connection, IndexProxyDB2 indexProxyDB2) throws Exception {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT i.PARTITION, ");
            stringBuffer.append("i.VCATNAME, i.STORNAME, i.PQTY, i.SQTY, ");
            stringBuffer.append("i.FREEPAGE, i.PCTFREE, i.GBPCACHE, t.TRACKMOD ");
            stringBuffer.append("from SYSIBM.SYSINDEXPART i, SYSIBM.SYSTABLEPART t ");
            stringBuffer.append("WHERE i.IXNAME = '");
            stringBuffer.append(indexProxyDB2.getName()).append("'");
            stringBuffer.append(" AND i.IXNAME = t.IXNAME ");
            stringBuffer.append(" AND i.IXCREATOR = t.IXCREATOR ");
            stringBuffer.append(" AND i.PARTITION = t.PARTITION ");
            statement = connection.prepareStatement(stringBuffer.toString());
            resultSet = statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableDB2v80.initIndexPartitions():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                int n = resultSet.getInt(1);
                String string = resultSet.getString(2);
                String string2 = resultSet.getString(3).trim();
                int n2 = resultSet.getInt(4) * 4;
                int n3 = resultSet.getInt(5) * 4;
                int n4 = resultSet.getInt(6);
                int n5 = resultSet.getInt(7);
                String string3 = resultSet.getString(8);
                String string4 = resultSet.getString(9);
                if (n <= 0) continue;
                StorageDesign storageDesign = this.getStorageDesign();
                AbstractStorageDesignDB2 abstractStorageDesignDB2 = null;
                if (storageDesign != null && storageDesign instanceof AbstractStorageDesignDB2) {
                    AbstractStorageObjectDB2 abstractStorageObjectDB2;
                    abstractStorageDesignDB2 = (AbstractStorageDesignDB2)storageDesign;
                    indexProxyDB2.setPartitioned(true);
                    IndexPartitionDB2 indexPartitionDB2 = abstractStorageDesignDB2.getIndexPartitionSet().createIndexPartition();
                    indexPartitionDB2.setIndex(indexProxyDB2);
                    indexPartitionDB2.setPartNumber(n);
                    StorageTemplateDB2 storageTemplateDB2 = abstractStorageDesignDB2.getStorageTemplateSet().createStorageTemplate();
                    indexPartitionDB2.setStorageTemplate(storageTemplateDB2);
                    if (!"".equalsIgnoreCase(string2)) {
                        abstractStorageObjectDB2 = (StorageGroupDB2)abstractStorageDesignDB2.getStorageGroupSet().getByName(string2);
                        if (abstractStorageObjectDB2 != null) {
                            storageTemplateDB2.setStorageGroup((StorageGroupDB2)abstractStorageObjectDB2);
                        }
                    } else {
                        abstractStorageObjectDB2 = (VCatDB2)abstractStorageDesignDB2.getVCatSet().getByName(string);
                        if (abstractStorageObjectDB2 != null) {
                            storageTemplateDB2.setVCat((VCatDB2)abstractStorageObjectDB2);
                        }
                    }
                    storageTemplateDB2.setSgPriqty(n2);
                    storageTemplateDB2.setSgSeqty(n3);
                    storageTemplateDB2.setFreePage(n4);
                    storageTemplateDB2.setPctFree(n5);
                    if ("A".equalsIgnoreCase(string3)) {
                        storageTemplateDB2.setGbCache("ALL");
                    } else if ("N".equalsIgnoreCase(string3)) {
                        storageTemplateDB2.setGbCache("NONE");
                    } else if ("S".equalsIgnoreCase(string3)) {
                        storageTemplateDB2.setGbCache("SYSTEM");
                    } else if ("".equalsIgnoreCase(string3)) {
                        storageTemplateDB2.setGbCache("CHANGED");
                    }
                    if ("N".equalsIgnoreCase(string4)) {
                        storageTemplateDB2.setTrackMode(false);
                    } else {
                        storageTemplateDB2.setTrackMode(true);
                    }
                    if ((abstractStorageObjectDB2 = abstractStorageDesignDB2.getStorageTemplateSet().removeIfExistEqual(storageTemplateDB2)) == indexPartitionDB2.getStorageTemplate()) continue;
                    indexPartitionDB2.setStorageTemplate((StorageTemplateDB2)abstractStorageObjectDB2);
                    continue;
                }
                LOGGER.error("Unable to find Storage Design!");
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initUniqueConstraints(Connection connection, Table table, String string) throws Exception {
        CharSequence charSequence;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT t.constname, t.ixowner, t.ixname, ");
            ((StringBuffer)charSequence).append("i.uniquerule, i.CLUSTERED, i.PGSIZE, ");
            ((StringBuffer)charSequence).append("i.BPOOL, i.CLOSERULE, i.COPY ");
            ((StringBuffer)charSequence).append("FROM sysibm.systabconst t, sysibm.sysindexes i ");
            ((StringBuffer)charSequence).append("WHERE t.TBNAME = '");
            ((StringBuffer)charSequence).append(table.getName()).append("'");
            ((StringBuffer)charSequence).append(" AND t.tbcreator = '");
            ((StringBuffer)charSequence).append(string).append("'");
            ((StringBuffer)charSequence).append(" AND t.ixowner = i.creator");
            ((StringBuffer)charSequence).append(" AND t.ixname = i.name");
            statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
            resultSet = statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableDB2v80.initUniqueConstraints():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(3);
                String string4 = resultSet.getString(4);
                String string5 = resultSet.getString(5);
                int n = resultSet.getInt(6);
                String string6 = resultSet.getString(7);
                String string7 = resultSet.getString(8);
                String string8 = resultSet.getString(9);
                Index index = table.createIndex();
                index.setContainerObject(table);
                index.setName((String)charSequence);
                this.stampModelObject((ModelObject)index, string, (String)charSequence);
                boolean bl = false;
                if ("U".equalsIgnoreCase(string4)) {
                    index.setIndexState("Unique Plain Index");
                } else if ("P".equalsIgnoreCase(string4)) {
                    index.setIndexState("Primary Constraint");
                } else if ("C".equalsIgnoreCase(string4) || "R".equalsIgnoreCase(string4)) {
                    index.setIndexState("Unique Constraint");
                } else if ("N".equalsIgnoreCase(string4)) {
                    index.setIndexState("Unique Plain Index");
                    bl = true;
                }
                this.initKeyColumns(connection, index, string3, table);
                StorageDesign storageDesign = this.getStorageDesign();
                StorageDesign storageDesign2 = null;
                if (storageDesign != null && storageDesign instanceof AbstractStorageDesignDB2) {
                    storageDesign2 = (AbstractStorageDesignDB2)storageDesign;
                }
                if (storageDesign2 != null) {
                    IndexProxyDB2 indexProxyDB2 = (IndexProxyDB2)storageDesign2.getIndexProxySet().getProxy(index.getObjectID());
                    if (indexProxyDB2 != null) {
                        indexProxyDB2.setName(string3);
                        Owner owner = (Owner)((AbstractStorageDesignDB2)storageDesign2).getOwnerSet().getByName(string2);
                        if (owner != null) {
                            indexProxyDB2.setOwner(owner);
                        }
                        if (Y.equalsIgnoreCase(string5)) {
                            indexProxyDB2.setClusterType("CLUSTERED_PARTITIONED");
                        } else if ("N".equalsIgnoreCase(string5)) {
                            indexProxyDB2.setClusterType("CLUSTERED");
                        } else {
                            indexProxyDB2.setClusterType("NONE");
                        }
                        indexProxyDB2.setPieceSize(n + " K");
                        BufferPoolDB2 bufferPoolDB2 = (BufferPoolDB2)((AbstractStorageDesignDB2)storageDesign2).getBufferPoolSet().getByName(string6);
                        if (bufferPoolDB2 != null) {
                            indexProxyDB2.setBufferPool(bufferPoolDB2);
                        }
                        indexProxyDB2.setWhereNotNull(bl);
                        if (Y.equalsIgnoreCase(string7)) {
                            indexProxyDB2.setClose(true);
                        } else {
                            indexProxyDB2.setClose(false);
                        }
                        if (Y.equalsIgnoreCase(string8)) {
                            indexProxyDB2.setCopy(true);
                            continue;
                        }
                        indexProxyDB2.setCopy(false);
                        continue;
                    }
                    LOGGER.error("Unable to find IndexProxy for table ID: " + table.getObjectID());
                    continue;
                }
                LOGGER.error("Unable to find Storage Design!");
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initKeyColumns(Connection connection, Index index, String string, Table table) throws Exception {
        CharSequence charSequence;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT COLNAME, ORDERING ");
            ((StringBuffer)charSequence).append("from SYSIBM.SYSKEYS ");
            ((StringBuffer)charSequence).append("WHERE IXNAME = '");
            ((StringBuffer)charSequence).append(string).append("'");
            ((StringBuffer)charSequence).append(" ORDER BY COLSEQ ");
            statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
            resultSet = statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableDB2v80.initKeyColumns():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                Column column = (Column)table.getElementByName((String)charSequence);
                if (column == null) continue;
                index.add(column);
                if ("A".equals(string2)) {
                    index.setColumnSortOrder(column, "ASC");
                    continue;
                }
                index.setColumnSortOrder(column, "DESC");
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initPartitions(Connection connection, TableProxyDB2v80 tableProxyDB2v80, TableSpaceDB2 tableSpaceDB2) throws Exception {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT PARTITION, LIMITKEY ");
            stringBuffer.append("from SYSIBM.SYSTABLEPART ");
            stringBuffer.append("WHERE TSNAME = '");
            stringBuffer.append(tableSpaceDB2.getName()).append("'");
            stringBuffer.append("ORDER BY PARTITION");
            statement = connection.prepareStatement(stringBuffer.toString());
            resultSet = statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTablespaceDB2.initTablespacePartitions():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                int n = resultSet.getInt(1);
                String string = resultSet.getString(2);
                if (n <= 0) continue;
                StorageDesign storageDesign = this.getStorageDesign();
                StorageDesignDB2v80 storageDesignDB2v80 = null;
                if (storageDesign != null && storageDesign instanceof AbstractStorageDesignDB2) {
                    storageDesignDB2v80 = (StorageDesignDB2v80)storageDesign;
                    tableProxyDB2v80.setPartitioned("YES");
                    TablePartitionDB2 tablePartitionDB2 = storageDesignDB2v80.getTablePartitionSet().createTablePartition();
                    tablePartitionDB2.setTable(tableProxyDB2v80);
                    tablePartitionDB2.setPartNumber(n);
                    tablePartitionDB2.setPartConstants(string);
                    continue;
                }
                LOGGER.error("Unable to find Storage Design!");
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initColumnConstraints(Connection connection, Table table, String string) throws Exception {
        CharSequence charSequence;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("select c.checkname, c.checkcondition, p.colname ");
            ((StringBuffer)charSequence).append("from sysibm.syschecks c, sysibm.syscheckdep p ");
            ((StringBuffer)charSequence).append("where ");
            ((StringBuffer)charSequence).append("c.tbowner = '");
            ((StringBuffer)charSequence).append(string).append("' and ");
            ((StringBuffer)charSequence).append("c.tbname = '");
            ((StringBuffer)charSequence).append(table.getName()).append("' and ");
            ((StringBuffer)charSequence).append("p.tbowner = c.tbowner and ");
            ((StringBuffer)charSequence).append("p.checkname = c.checkname and ");
            ((StringBuffer)charSequence).append("p.tbname = c.tbname and ");
            ((StringBuffer)charSequence).append("1=( ");
            ((StringBuffer)charSequence).append("select count(*) ");
            ((StringBuffer)charSequence).append("from sysibm.syscheckdep d ");
            ((StringBuffer)charSequence).append("where ");
            ((StringBuffer)charSequence).append("d.tbowner = c.tbowner and ");
            ((StringBuffer)charSequence).append("d.checkname = c.checkname and ");
            ((StringBuffer)charSequence).append("d.tbname = c.tbname )");
            statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
            resultSet = statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableDB2v80.initColumnConstraints():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(3);
                CheckConstraint checkConstraint = new CheckConstraint();
                checkConstraint.setName((String)charSequence);
                checkConstraint.add(StorageDesignDB2v80.RDBMS_TYPE, string2);
                Column column = (Column)table.getElementByName(string3);
                if (column == null) continue;
                column.setUseDomainConstraints(false);
                column.setCheck(checkConstraint);
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initTableConstraints(Connection connection, Table table, String string) throws Exception {
        CharSequence charSequence;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("select c.checkname, c.checkcondition ");
            ((StringBuffer)charSequence).append("from sysibm.syschecks c ");
            ((StringBuffer)charSequence).append("where ");
            ((StringBuffer)charSequence).append("c.tbowner = '");
            ((StringBuffer)charSequence).append(string).append("' and ");
            ((StringBuffer)charSequence).append("c.tbname = '");
            ((StringBuffer)charSequence).append(table.getName()).append("' and ");
            ((StringBuffer)charSequence).append("1<( ");
            ((StringBuffer)charSequence).append("select count(*) ");
            ((StringBuffer)charSequence).append("from sysibm.syscheckdep d ");
            ((StringBuffer)charSequence).append("where ");
            ((StringBuffer)charSequence).append("d.tbowner = c.tbowner and ");
            ((StringBuffer)charSequence).append("d.checkname = c.checkname and ");
            ((StringBuffer)charSequence).append("d.tbname = c.tbname )");
            statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
            resultSet = statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableDB2v80.initColumnConstraints():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                TableLevelConstraint tableLevelConstraint = table.createCheckConstraint((String)charSequence, string2);
                table.addCheckConstraint(tableLevelConstraint);
                this.stampModelObject((ModelObject)tableLevelConstraint, string, (String)charSequence);
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initSynonyms(Connection connection, TableProxyDB2 tableProxyDB2, String string) throws Exception {
        CharSequence charSequence;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT NAME, CREATOR ");
            ((StringBuffer)charSequence).append("from SYSIBM.SYSSYNONYMS ");
            ((StringBuffer)charSequence).append("WHERE TBNAME = '");
            ((StringBuffer)charSequence).append(tableProxyDB2.getName()).append("'");
            ((StringBuffer)charSequence).append(" AND TBCREATOR = '");
            ((StringBuffer)charSequence).append(string).append("'");
            statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
            resultSet = statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableDB2v80.initSynonyms():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                StorageDesign storageDesign = this.getStorageDesign();
                AbstractStorageDesignDB2 abstractStorageDesignDB2 = null;
                if (storageDesign != null && storageDesign instanceof AbstractStorageDesignDB2) {
                    abstractStorageDesignDB2 = (AbstractStorageDesignDB2)storageDesign;
                    SynonymDB2 synonymDB2 = abstractStorageDesignDB2.getSynonymSet().createSynonym();
                    synonymDB2.setName((String)charSequence);
                    synonymDB2.setTable(tableProxyDB2);
                    this.stampModelObject((ModelObject)synonymDB2, string2, (String)charSequence);
                    Owner owner = (Owner)abstractStorageDesignDB2.getOwnerSet().getByName(string2);
                    if (owner == null) {
                        owner = (Owner)abstractStorageDesignDB2.getOwnerSet().createElement(string2);
                        owner.setName(string2);
                        this.stampModelObject((ModelObject)owner, "", string2);
                    }
                    if (owner == null) continue;
                    synonymDB2.setOwner(owner);
                    continue;
                }
                LOGGER.error("Unable to find Storage Design!");
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initTriggers(Connection connection, TableProxyDB2 tableProxyDB2, String string) throws Exception {
        CharSequence charSequence;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT NAME, SCHEMA, TRIGTIME, TRIGEVENT, GRANULARITY, REMARKS ");
            ((StringBuffer)charSequence).append("from SYSIBM.SYSTRIGGERS ");
            ((StringBuffer)charSequence).append("WHERE TBNAME = '");
            ((StringBuffer)charSequence).append(tableProxyDB2.getName()).append("'");
            ((StringBuffer)charSequence).append(" AND TBOWNER = '");
            ((StringBuffer)charSequence).append(string).append("'");
            statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
            resultSet = statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableDB2v80.initTriggers():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(3);
                String string4 = resultSet.getString(4);
                String string5 = resultSet.getString(5);
                String string6 = resultSet.getString(6);
                StorageDesign storageDesign = this.getStorageDesign();
                AbstractStorageDesignDB2 abstractStorageDesignDB2 = null;
                if (storageDesign != null && storageDesign instanceof AbstractStorageDesignDB2) {
                    abstractStorageDesignDB2 = (AbstractStorageDesignDB2)storageDesign;
                    TriggerDB2 triggerDB2 = abstractStorageDesignDB2.getTriggerSet().createTrigger();
                    triggerDB2.setName((String)charSequence);
                    triggerDB2.setTable(tableProxyDB2);
                    this.stampModelObject((ModelObject)triggerDB2, string2, (String)charSequence);
                    Owner owner = (Owner)abstractStorageDesignDB2.getOwnerSet().getByName(string2);
                    if (owner != null) {
                        triggerDB2.setOwner(owner);
                    } else {
                        owner = (Owner)abstractStorageDesignDB2.getOwnerSet().createElement(string2);
                        owner.setName(string2);
                        this.stampModelObject((ModelObject)owner, "", string2);
                    }
                    if ("A".equalsIgnoreCase(string3)) {
                        triggerDB2.setTriggerTime("AFTER");
                    } else {
                        triggerDB2.setTriggerTime("NO CASCADE BEFORE");
                    }
                    if ("I".equalsIgnoreCase(string4)) {
                        triggerDB2.setActions("INSERT");
                    } else if ("D".equalsIgnoreCase(string4)) {
                        triggerDB2.setActions("DELETE");
                    } else {
                        triggerDB2.setActions("UPDATE");
                    }
                    if ("R".equalsIgnoreCase(string5)) {
                        triggerDB2.setScope("FOR EACH ROW");
                    } else {
                        triggerDB2.setScope("FOR EACH STATEMENT");
                    }
                    triggerDB2.setCommentInRDBMS(string6);
                    this.initTriggerBody(connection, triggerDB2);
                    continue;
                }
                LOGGER.error("Unable to find Storage Design!");
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initTriggerBody(Connection connection, TriggerDB2 triggerDB2) throws Exception {
        StringBuffer stringBuffer;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT TEXT ");
            stringBuffer.append("FROM SYSIBM.SYSTRIGGERS ");
            stringBuffer.append("WHERE SCHEMA = '");
            stringBuffer.append(triggerDB2.getOwner().getName()).append("'");
            stringBuffer.append("AND NAME = '");
            stringBuffer.append(triggerDB2.getName()).append("'");
            stringBuffer.append(" ORDER BY SEQNO ");
            statement = connection.prepareStatement(stringBuffer.toString());
            resultSet = statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableDB2v80.initTriggerBody():", sQLException);
        }
        stringBuffer = new StringBuffer();
        if (resultSet != null) {
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                stringBuffer.append(string);
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
        triggerDB2.setBody(stringBuffer.toString());
    }
}

