/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.db2.v80;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.db2.MOHProcedureDB2;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.StoredProcedureDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHProcedureDB2v80
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "PROCEDURE";
    private static final Logger LOGGER = new Logger(MOHProcedureDB2.class);

    public MOHProcedureDB2v80(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            StringBuffer stringBuffer;
            DBObject dBObject = (DBObject)list.get(i);
            String string = dBObject.getName();
            String string2 = dBObject.getSchema();
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObject.getType())) continue;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                stringBuffer = new StringBuffer();
                stringBuffer.append("SELECT s.CREATESTMT ");
                stringBuffer.append("from SYSIBM.SYSROUTINES r, SYSIBM.SYSROUTINES_SRC s ");
                stringBuffer.append("WHERE r.NAME = '").append(string).append("'");
                stringBuffer.append(" AND r.SCHEMA = '").append(string2).append("'");
                stringBuffer.append(" AND r.ROUTINETYPE = 'P'");
                stringBuffer.append(" AND r.NAME = s.ROUTINENAME");
                stringBuffer.append(" AND r.LANGUAGE = 'SQL'");
                stringBuffer.append(" AND r.SCHEMA = s.SCHEMA");
                stringBuffer.append(" ORDER BY s.SEQNO ");
                statement = connection.prepareStatement(stringBuffer.toString());
                resultSet = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHProcedureDB2v80.generate():", sQLException);
            }
            stringBuffer = new StringBuffer();
            if (resultSet != null) {
                while (resultSet.next()) {
                    object = resultSet.getString(1);
                    stringBuffer.append(((String)object).toString());
                }
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
            if ((object = this.getStorageDesign()) != null && object instanceof AbstractStorageDesignDB2) {
                AbstractStorageDesignDB2 abstractStorageDesignDB2 = (AbstractStorageDesignDB2)object;
                StoredProcedureDB2 storedProcedureDB2 = abstractStorageDesignDB2.getStoredProcedureSet().createStoredProcedure();
                storedProcedureDB2.setName(string);
                storedProcedureDB2.setBody(stringBuffer.toString());
                this.stampModelObject(storedProcedureDB2, dBObject);
                Owner owner = (Owner)abstractStorageDesignDB2.getOwnerSet().getByName(string2);
                if (owner != null) {
                    storedProcedureDB2.setOwner(owner);
                } else {
                    owner = (Owner)abstractStorageDesignDB2.getOwnerSet().createElement(string2);
                    owner.setName(string2);
                    this.stampModelObject((ModelObject)owner, "", string2);
                }
            } else {
                LOGGER.error("Unable to find Storage Design!");
            }
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObject);
        }
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (DBObject dBObject : list) {
            CharSequence charSequence;
            if (!dBObject.isSelected()) continue;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT NAME from SYSIBM.SYSROUTINES ");
                ((StringBuffer)charSequence).append("WHERE SCHEMA = '");
                ((StringBuffer)charSequence).append(dBObject.getName()).append("'");
                ((StringBuffer)charSequence).append(" AND LANGUAGE = 'SQL'");
                ((StringBuffer)charSequence).append(" AND ROUTINETYPE = 'P'");
                statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
                resultSet = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHProcedureDB2v80.extract(): " + sQLException.getMessage());
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                    DBObject dBObject2 = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, OBJECT_TYPE, dBObject.getName());
                    arrayList.add(dBObject2);
                }
                resultSet.close();
            }
            if (statement == null) continue;
            statement.close();
        }
        return arrayList;
    }
}

