/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.db2;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.model.design.storage.db2.VolumesDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHStorageGroupDB2
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "STORAGE GROUP";
    private static final Logger LOGGER = new Logger(MOHStorageGroupDB2.class);

    public MOHStorageGroupDB2(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            DBObject dBObject = (DBObject)list.get(i);
            String string = dBObject.getName();
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObject.getType())) continue;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                object = new StringBuffer();
                ((StringBuffer)object).append("SELECT VCATNAME").append(' ');
                ((StringBuffer)object).append("from SYSIBM.SYSSTOGROUP").append(' ');
                ((StringBuffer)object).append("WHERE NAME = '").append(string).append("'");
                statement = connection.prepareStatement(((StringBuffer)object).toString());
                resultSet = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHStorageGroupDB2.generate():", sQLException);
            }
            if (resultSet != null) {
                if (resultSet.next()) {
                    object = this.getStorageDesign();
                    if (object != null && object instanceof AbstractStorageDesignDB2) {
                        AbstractStorageDesignDB2 abstractStorageDesignDB2 = (AbstractStorageDesignDB2)object;
                        String string2 = resultSet.getString(1);
                        VCatDB2 vCatDB2 = (VCatDB2)abstractStorageDesignDB2.getVCatSet().getByName(string2);
                        if (vCatDB2 == null) {
                            vCatDB2 = abstractStorageDesignDB2.getVCatSet().createVCat();
                            vCatDB2.setName(string2);
                            this.stampModelObject((ModelObject)vCatDB2, dBObject.getSchema(), string2);
                        }
                        StorageGroupDB2 storageGroupDB2 = abstractStorageDesignDB2.getStorageGroupSet().createStorageGroup();
                        storageGroupDB2.setName(string);
                        this.stampModelObject(storageGroupDB2, dBObject);
                        storageGroupDB2.setVCat(vCatDB2);
                        this.initVolumes(connection, storageGroupDB2, abstractStorageDesignDB2);
                    } else {
                        LOGGER.error("Unable to find Storage Design!");
                    }
                }
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObject);
        }
    }

    private void initVolumes(Connection connection, StorageGroupDB2 storageGroupDB2, AbstractStorageDesignDB2 abstractStorageDesignDB2) throws Exception {
        Object object;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT VOLID").append(' ');
            ((StringBuffer)object).append("from SYSIBM.SYSVOLUMES").append(' ');
            ((StringBuffer)object).append("WHERE SGNAME = '").append(storageGroupDB2.getName()).append("'");
            statement = connection.prepareStatement(((StringBuffer)object).toString());
            resultSet = statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHStorageGroupDB2.initVolumes():", sQLException);
        }
        if (resultSet != null) {
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            while (resultSet.next()) {
                String string = resultSet.getString(1).trim();
                if ("*".equals(string)) {
                    ++n;
                    storageGroupDB2.setSMSManaged(true);
                    continue;
                }
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(string);
                object = (VolumesDB2)abstractStorageDesignDB2.getVolumesSet().getByName(string);
                if (object != null) continue;
                object = abstractStorageDesignDB2.getVolumesSet().createVolumes();
                ((StorageObject)object).setName(string);
            }
            if (n > 0) {
                storageGroupDB2.setSMSManaged(true);
                storageGroupDB2.setSMSVolumes(n);
            }
            storageGroupDB2.setVolumes(stringBuffer.toString());
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (DBObject dBObject : list) {
            CharSequence charSequence;
            if (!dBObject.isSelected()) continue;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT name from SYSIBM.SYSSTOGROUP").append(' ');
                ((StringBuffer)charSequence).append("WHERE CREATOR = '");
                ((StringBuffer)charSequence).append(dBObject.getName()).append("'");
                statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
                resultSet = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHStorageGroupDB2.extract(): " + sQLException.getMessage());
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                    DBObject dBObject2 = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, OBJECT_TYPE, dBObject.getName());
                    arrayList.add(dBObject2);
                }
                resultSet.close();
            }
            if (statement == null) continue;
            statement.close();
        }
        return arrayList;
    }
}

