/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.db2;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHDatatypeDB2
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "DATATYPE";
    private static final Logger LOGGER = new Logger(MOHDatatypeDB2.class);

    public MOHDatatypeDB2(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            DBObject dBObject = (DBObject)list.get(i);
            String string = dBObject.getName();
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObject.getType())) continue;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                object = new StringBuffer();
                ((StringBuffer)object).append("SELECT SOURCETYPE, LENGTH, SCALE ");
                ((StringBuffer)object).append("from SYSIBM.SYSDATATYPES ");
                ((StringBuffer)object).append("WHERE NAME = '").append(dBObject.getName()).append("'");
                statement = connection.prepareStatement(((StringBuffer)object).toString());
                resultSet = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHDatatypeDB2.generate():", sQLException);
            }
            if (resultSet != null) {
                if (resultSet.next()) {
                    object = this.getDesign().getDataTypesDesign().createDistinctType();
                    ((DesignObject)object).setName(string);
                    this.stampModelObject((ModelObject)object, dBObject);
                    this.setProperties((DistinctType)object, resultSet);
                }
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObject);
        }
    }

    private void setProperties(DistinctType distinctType, ResultSet resultSet) throws Exception {
        String string = resultSet.getString(1);
        int n = resultSet.getInt(2);
        int n2 = resultSet.getInt(3);
        LogicalDatatype logicalDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getDbmeHandler().getRDBMSSite().getType(), string);
        if (logicalDatatype == null) {
            logicalDatatype = this.getDesign().getLogicalDatatypeSet().getLogTypeByNativeType(string, this.getDbmeHandler().getRDBMSSite().getType().getName());
        }
        if (logicalDatatype != null) {
            distinctType.setLogicalDataType(logicalDatatype);
            distinctType.setSize("" + n);
            distinctType.setScale(n2);
            distinctType.setPrecision(n);
        }
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (DBObject dBObject : list) {
            CharSequence charSequence;
            if (!dBObject.isSelected()) continue;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT name from SYSIBM.SYSDATATYPES").append(' ');
                ((StringBuffer)charSequence).append("WHERE SCHEMA = '");
                ((StringBuffer)charSequence).append(dBObject.getName()).append("'");
                statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
                resultSet = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHDatatypeDB2.extract(): " + sQLException.getMessage());
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                    DBObject dBObject2 = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, OBJECT_TYPE, dBObject.getName());
                    arrayList.add(dBObject2);
                }
                resultSet.close();
            }
            if (statement == null) continue;
            statement.close();
        }
        return arrayList;
    }
}

