/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.db2;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.AliasDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxySetDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxySetDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHAliasDB2
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "ALIAS";
    private static final Logger LOGGER = new Logger(MOHAliasDB2.class);

    public MOHAliasDB2(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            DBObject dBObject = (DBObject)list.get(i);
            String string = dBObject.getName();
            String string2 = dBObject.getSchema();
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObject.getType())) continue;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                object = new StringBuffer();
                ((StringBuffer)object).append("SELECT TBNAME from SYSIBM.SYSTABLES").append(' ');
                ((StringBuffer)object).append("WHERE TYPE = 'A' and NAME = '");
                ((StringBuffer)object).append(dBObject.getName()).append("' and CREATOR = '").append(string2).append("'");
                statement = connection.prepareStatement(((StringBuffer)object).toString());
                resultSet = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHAliasDB2.generate():", sQLException);
            }
            if (resultSet != null) {
                if (resultSet.next()) {
                    object = this.getStorageDesign();
                    if (object != null && object instanceof AbstractStorageDesignDB2) {
                        TableProxyDB2 tableProxyDB2;
                        AbstractStorageDesignDB2 abstractStorageDesignDB2 = (AbstractStorageDesignDB2)object;
                        String string3 = resultSet.getString(1);
                        AliasDB2 aliasDB2 = abstractStorageDesignDB2.getAliasSet().createAlias();
                        aliasDB2.setName(string);
                        this.stampModelObject(aliasDB2, dBObject);
                        Owner owner = (Owner)abstractStorageDesignDB2.getOwnerSet().getByName(string2);
                        if (owner == null) {
                            owner = (Owner)abstractStorageDesignDB2.getOwnerSet().createElement(string2);
                            owner.setName(string2);
                            this.stampModelObject((ModelObject)owner, "", string2);
                        }
                        if (owner != null) {
                            aliasDB2.setOwner(owner);
                        }
                        if ((tableProxyDB2 = ((TableProxySetDB2)abstractStorageDesignDB2.getTableProxySet()).getByName(string3)) != null) {
                            aliasDB2.setTable(tableProxyDB2);
                        } else {
                            TableViewProxyDB2 tableViewProxyDB2 = ((TableViewProxySetDB2)abstractStorageDesignDB2.getTableViewProxySet()).getByName(string3);
                            if (tableViewProxyDB2 != null) {
                                aliasDB2.setView(tableViewProxyDB2);
                            } else {
                                AliasDB2 aliasDB22 = (AliasDB2)abstractStorageDesignDB2.getAliasSet().getByName(string3);
                                if (aliasDB22 != null) {
                                    aliasDB2.setAnotherAlias(aliasDB22);
                                }
                            }
                        }
                    } else {
                        LOGGER.error("Unable to find Storage Design!");
                    }
                }
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObject);
        }
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (DBObject dBObject : list) {
            CharSequence charSequence;
            if (!dBObject.isSelected()) continue;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT name from SYSIBM.SYSTABLES").append(' ');
                ((StringBuffer)charSequence).append("WHERE TYPE = 'A' and CREATOR = '");
                ((StringBuffer)charSequence).append(dBObject.getName()).append("'");
                statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
                resultSet = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHAliasDB2.extract(): " + sQLException.getMessage());
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                    DBObject dBObject2 = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, OBJECT_TYPE, dBObject.getName());
                    arrayList.add(dBObject2);
                }
                resultSet.close();
            }
            if (statement == null) continue;
            statement.close();
        }
        return arrayList;
    }
}

