/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class AbstractDBMExtractionHandler {
    protected String dbProductName = "";
    protected String dbProductVersion = "";
    protected int dbMajorVersion = -1;
    private boolean secondaryTables = false;
    private boolean spatialProperties = false;
    private static boolean allSelected = false;
    private static boolean schemaBased = true;
    private static final Logger LOGGER = new Logger(AbstractDBMExtractionHandler.class);

    protected AbstractDBMExtractionHandler() {
    }

    public abstract RDBMSSite getRDBMSSite();

    public abstract List getMOHObjects();

    public String getDBProductVersion() {
        return this.dbProductVersion;
    }

    public String getDBProductName() {
        return this.dbProductName;
    }

    public int getDBMajorVersion() {
        return this.dbMajorVersion;
    }

    public static boolean isAllSelected() {
        return allSelected;
    }

    public static void setAllSelected(boolean bl) {
        allSelected = bl;
    }

    public static boolean isSchemaBased() {
        return schemaBased;
    }

    public static void setSchemaBased(boolean bl) {
        schemaBased = bl;
    }

    protected void dumpResultSet(ResultSet resultSet) {
        try {
            while (resultSet.next()) {
                System.out.println("-----------------------------------------------");
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                    System.out.println(resultSetMetaData.getColumnName(i) + " : " + resultSetMetaData.getColumnTypeName(i) + " = " + resultSet.getString(i));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List getSchemas(Connection connection) throws Exception {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        if (connection != null) {
            Object object;
            Object object2;
            AutoCloseable autoCloseable;
            boolean bl = false;
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            try {
                this.dbProductName = databaseMetaData.getDatabaseProductName();
                if (this.dbProductName.toUpperCase().indexOf("ORACLE") > -1) {
                    block14: {
                        autoCloseable = connection.createStatement();
                        try {
                            object2 = autoCloseable.executeQuery("select product, version from product_component_version where product like 'Oracle%'");
                            if (object2 == null) break block14;
                            if (object2.next()) {
                                this.dbProductVersion = object2.getString(1);
                                object = object2.getString(2);
                                if (object != null && ((String)object).length() > 0) {
                                    try {
                                        object = ((String)object).substring(0, ((String)object).indexOf("."));
                                        this.dbMajorVersion = Integer.parseInt((String)object);
                                        bl = true;
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                            object2.close();
                        }
                        catch (Exception exception) {
                            this.dbProductVersion = databaseMetaData.getDatabaseProductVersion();
                        }
                    }
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                } else {
                    this.dbProductVersion = databaseMetaData.getDatabaseProductVersion();
                }
                if (!bl) {
                    this.dbMajorVersion = databaseMetaData.getDatabaseMajorVersion();
                }
            }
            catch (Throwable throwable) {
                LOGGER.error(throwable);
                System.out.println(throwable.getMessage());
            }
            autoCloseable = databaseMetaData.getSchemas();
            while (autoCloseable.next()) {
                object2 = autoCloseable.getString(1);
                object = new DBObject(false, (String)object2);
                arrayList.add((DBObject)object);
            }
            autoCloseable.close();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getDBObjects(Connection connection, List list) throws Exception {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        List list2 = this.getMOHObjects();
        if (list2.size() > 0 && connection != null) {
            for (AbstractMOHandler abstractMOHandler : list2) {
                abstractMOHandler.reset();
                List list3 = abstractMOHandler.extract(connection, list);
                for (Object e : list3) {
                    if (!(e instanceof DBObject)) continue;
                    arrayList.add((DBObject)e);
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getDBObjects(Connection connection, List list, String string) throws Exception {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        List list2 = this.getMOHObjects();
        if (list2.size() > 0 && connection != null) {
            for (AbstractMOHandler abstractMOHandler : list2) {
                if (!string.equalsIgnoreCase(abstractMOHandler.getType())) continue;
                abstractMOHandler.reset();
                List list3 = abstractMOHandler.extract(connection, list);
                for (Object e : list3) {
                    if (!(e instanceof DBObject)) continue;
                    arrayList.add((DBObject)e);
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateDesign(Connection connection, List list, ImportLogger importLogger, ProgressDialog progressDialog) throws Exception {
        block16: {
            List list2 = this.getMOHObjects();
            if (list.size() <= 0 || list2.size() <= 0 || connection == null) break block16;
            try {
                int n = 0;
                double d = 10.0;
                int n2 = list2.size();
                for (AbstractMOHandler abstractMOHandler : list2) {
                    System.out.println(abstractMOHandler.getType());
                    abstractMOHandler.setSupportInformation_Schema(true);
                    abstractMOHandler.generate(connection, list, importLogger);
                    abstractMOHandler.clearHandledObjects(list);
                    ++n;
                    progressDialog.setProgress((int)(d += 75.0 / (double)n2));
                }
                for (AbstractMOHandler abstractMOHandler : list2) {
                    abstractMOHandler.postGenerateProcessing(connection);
                }
            }
            catch (Exception exception) {
                LOGGER.error(exception.toString());
                MessageDialogs.showErrorMessage(ApplicationView.frame, exception.getMessage() != null ? exception.getMessage() : "An error occured while importing from database.\nSee the log file for more details.");
            }
            finally {
                try {
                    if (!connection.isClosed()) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    LOGGER.error(exception.toString());
                }
            }
        }
    }

    public boolean isSecondaryTables() {
        return this.secondaryTables;
    }

    public void setSecondaryTables(boolean bl) {
        this.secondaryTables = bl;
    }

    public boolean isSpatialProperties() {
        return this.spatialProperties;
    }

    public void setSpatialProperties(boolean bl) {
        this.spatialProperties = bl;
    }

    public void init(Connection connection) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            try {
                this.dbProductName = databaseMetaData.getDatabaseProductName();
                this.dbProductVersion = databaseMetaData.getDatabaseProductVersion();
                this.dbMajorVersion = databaseMetaData.getDatabaseMajorVersion();
            }
            catch (Throwable throwable) {
                System.out.println(throwable.getMessage());
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

