/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.erwin;

import java.io.CharArrayWriter;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Stack;
import oracle.dbtools.crest.imports.erwin.SAXAttributeHandler;
import oracle.dbtools.crest.imports.erwin.SAXElementHandler;
import oracle.dbtools.crest.imports.erwin.SAXEntityHandler;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ERSAXHandler
extends DefaultHandler {
    private ApplicationView appView;
    private boolean inExistingDesign;
    private String designName;
    private Design design;
    private ProgressDialog monitor;
    private int monitorPercent;
    CharArrayWriter text = new CharArrayWriter();
    ERParseContext context = new ERParseContext();
    SAXElementHandler chain;
    protected Stack stack = null;

    public ERSAXHandler(ApplicationView applicationView, boolean bl) {
        this.appView = applicationView;
        this.inExistingDesign = bl;
        this.design = applicationView.getCurrentDesign();
        this.monitor = new ProgressDialog(applicationView, "Import ERwin 7.x", 0, 100);
        this.monitorPercent = 0;
        this.stack = new Stack();
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.stack.push(string3);
        if (this.chain != null) {
            this.text.reset();
            this.chain.handleStartElement(string, string2, string3, attributes, this.context);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        this.stack.pop();
        if (this.chain != null) {
            this.chain.handleEndElement(string, string2, string3, this.context);
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        this.text.write(cArray, n, n2);
    }

    public String getText() {
        return this.text.toString().trim();
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        this.monitor.close();
        throw sAXParseException;
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.monitor.close();
        throw sAXParseException;
    }

    public Design getDesign() {
        return this.design;
    }

    protected void setDesignName(String string) {
        this.designName = !this.inExistingDesign ? string : this.appView.getDesignName();
        this.appView.getCurrentDesign().setDesignPath(ApplicationView.TEMP_DIR);
        if (this.appView.designExists(string)) {
            this.appView.deleteDesign(string);
        }
        if (!this.inExistingDesign) {
            this.appView.setDesignName(string);
        }
        if (!this.inExistingDesign) {
            this.design.setFileName(this.designName);
        }
    }

    public String deriveObjectID(String string, String string2) {
        return string + string2.substring(1, 37);
    }

    public void monitorProgress(String string, int n) {
        this.monitor.setNote(string);
        if (n < 0) {
            this.monitor.close();
            return;
        }
        if (n == 0) {
            this.monitorPercent = 0;
        } else if (n == 100) {
            this.monitorPercent = 100;
        } else {
            this.monitorPercent += n;
            if (this.monitorPercent > 95) {
                this.monitorPercent = 95;
            }
        }
        this.monitor.setProgress(this.monitorPercent);
    }

    public void monitorClose() {
        if (this.monitor != null) {
            this.monitor.close();
        }
    }

    protected boolean isUTFString(String string) {
        int n = string.length();
        try {
            byte[] byArray = string.getBytes("UTF-8");
            return n < byArray.length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
    }

    protected void createMappings(Design design, Map map, Map map2) {
        for (Object k : map.keySet()) {
            DesignObject designObject = (DesignObject)map.get(k);
            DesignObject designObject2 = (DesignObject)map2.get(k);
            if (designObject == null || designObject2 == null || design.getExtendedMap().getMapping(designObject, designObject2) != null || this.isDeleted(designObject) || this.isDeleted(designObject2)) continue;
            XtdMapping xtdMapping = design.getExtendedMap().createMapping(designObject, designObject2);
            designObject2.setGeneratorID(designObject.getObjectID());
            xtdMapping.setCreationTime(System.currentTimeMillis());
        }
    }

    protected boolean isDeleted(DesignObject designObject) {
        if (designObject instanceof ContainedObject) {
            ContainedObject containedObject = (ContainedObject)designObject;
            return containedObject.getContainer() == null;
        }
        return false;
    }

    protected void initChain() {
        this.chain = new SAXEntityHandler(this);
        this.chain.add(new SAXAttributeHandler(this));
    }

    public static class ERParseContext {
        public Entity entity;
        public boolean inEntity;
        public Attribute attribute;
        public boolean inAttribute;
    }
}

