/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.domains;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.Messages;
import oracle.dbtools.crest.imports.domains.DomainPropertiesComparator;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.engineering.EngEmptyPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngFilteredSelection;
import oracle.dbtools.crest.model.design.engineering.EngineeringObjectSelection;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.persistence.xml.standalone_domains.ReadStAlDomains;

public class DomainImportSelection
extends EngFilteredSelection {
    LogicalDesign ldes;
    private EngineeringObjectSelection rightRoot;
    private Map comparatorsMap = new TreeMap();
    private String fileName = "";
    private List impDomains;
    private List existingDomains = new ArrayList();

    public DomainImportSelection(LogicalDesign logicalDesign, File file) {
        super(logicalDesign.getDesign().getName());
        this.setDesign(logicalDesign.getDesign());
        this.ldes = logicalDesign;
        this.fileName = file.getName();
        this.setName(MessageFormat.format(Messages.getString("DomainImportSelection.DomainsInFile"), this.fileName));
        this.rightRoot = new EngFilteredSelection(logicalDesign.getName());
        this.rightRoot.setName(MessageFormat.format(Messages.getString("DomainImportSelection.CorrespondingDomainsInDesign"), logicalDesign.getDesign().getName()));
        this.setCorrespondentNode(this.rightRoot);
        this.rightRoot.setCorrespondentNode(this);
        this.setEmptyComparator(this);
        this.setEmptyComparator(this.rightRoot);
        RDBMSSite rDBMSSite = null;
        if (logicalDesign.getDesign().getRelationalDesign() != null) {
            rDBMSSite = logicalDesign.getDesign().getRelationalDesign().getSelectedRDBMSSite();
        }
        ReadStAlDomains readStAlDomains = new ReadStAlDomains(logicalDesign.getDesign().getAppView(), rDBMSSite, this.getDesign());
        this.impDomains = readStAlDomains.readDomains(file);
        logicalDesign.getDesign().getDomainSet().addAllElementsTo(this.existingDomains);
        this.addDomains();
    }

    private void setEmptyComparator(EngineeringObjectSelection engineeringObjectSelection) {
        engineeringObjectSelection.setPropertiesComparator(new EngEmptyPropertiesComparator(null, null));
    }

    private Domain getDomainByImportedID(List list, String string) {
        for (Domain domain : list) {
            String string2 = domain.getImportedId();
            if (string2 == null || !string.equalsIgnoreCase(string2)) continue;
            return domain;
        }
        return null;
    }

    private Domain getDomainByID(List list, String string) {
        for (Domain domain : list) {
            if (!string.equalsIgnoreCase(domain.getObjectID())) continue;
            return domain;
        }
        return null;
    }

    private Domain getDomainByName(List list, String string) {
        for (Domain domain : list) {
            if (!string.equalsIgnoreCase(domain.getName())) continue;
            return domain;
        }
        return null;
    }

    private void addDomain(Domain domain, EngineeringObjectSelection engineeringObjectSelection, EngineeringObjectSelection engineeringObjectSelection2, boolean bl) {
        EngineeringObjectSelection engineeringObjectSelection3 = new EngineeringObjectSelection(domain);
        engineeringObjectSelection3.setSelected(true);
        Domain domain2 = this.getDomainByImportedID(this.existingDomains, domain.getObjectID());
        if (domain2 == null) {
            domain2 = this.getDomainByID(this.existingDomains, domain.getObjectID());
        }
        if (domain2 == null && domain.getImportedId() != null && !"".equals(domain.getImportedId()) && (domain2 = this.getDomainByID(this.existingDomains, domain.getImportedId())) == null) {
            domain2 = this.getDomainByImportedID(this.existingDomains, domain.getImportedId());
        }
        if (domain2 == null) {
            domain2 = this.getDomainByName(this.existingDomains, domain.getName());
        }
        EngineeringObjectSelection engineeringObjectSelection4 = null;
        if (domain2 != null) {
            engineeringObjectSelection4 = new EngineeringObjectSelection(domain2);
            DomainPropertiesComparator domainPropertiesComparator = new DomainPropertiesComparator(domain, domain2);
            engineeringObjectSelection3.setPropertiesComparator(domainPropertiesComparator);
            engineeringObjectSelection4.setPropertiesComparator(domainPropertiesComparator);
            this.comparatorsMap.put(domainPropertiesComparator.getID(), domainPropertiesComparator);
        } else {
            engineeringObjectSelection4 = new EngineeringObjectSelection(domain.getName());
            engineeringObjectSelection3.setStatus(ModelIdObjectSelection.STATE_NEW);
            engineeringObjectSelection4.setStatus(ModelIdObjectSelection.STATE_NEW);
            engineeringObjectSelection4.setElementDescriptor(Domain.class);
            DomainPropertiesComparator domainPropertiesComparator = new DomainPropertiesComparator(domain, null);
            engineeringObjectSelection3.setPropertiesComparator(domainPropertiesComparator);
            engineeringObjectSelection4.setPropertiesComparator(domainPropertiesComparator);
        }
        engineeringObjectSelection4.setCorrespondentNode(engineeringObjectSelection3);
        engineeringObjectSelection3.setCorrespondentNode(engineeringObjectSelection4);
        engineeringObjectSelection.addChild(engineeringObjectSelection3);
        engineeringObjectSelection2.addChild(engineeringObjectSelection4);
    }

    private void addDomains() {
        for (Domain domain : this.impDomains) {
            this.addDomain(domain, this, this.rightRoot, true);
        }
    }

    public EngineeringObjectSelection getLeftRoot() {
        return this;
    }

    public EngineeringObjectSelection getRightRoot() {
        return this.rightRoot;
    }

    public Map getComparatorsMap() {
        return this.comparatorsMap;
    }
}

