/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb.v81;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.IndexProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.PermissionsUDB;
import oracle.dbtools.crest.model.design.storage.udb.PrivilegesUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxySetUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxySetUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.UserGroupUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.SequenceUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;

public class SHGrantUDBv81
extends DDLStatementHandler {
    private PermissionsUDB permissions;
    private StorageDesignUDBv81 storageDesign;
    private TableProxyUDB table = null;
    private TableViewProxyUDB view = null;

    public SHGrantUDBv81(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHGrantUDBv81.clearCR(string);
        if (Token.startsWithString(string2, "grant use of tablespace")) {
            try {
                this.parseGrantUseOf(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                this.importLog.addFailedStatement(SHGrantUDBv81.FormatCR(string, "\n"));
            }
        } else if (Token.startsWithString(string2, "grant control on index")) {
            try {
                this.parseGrantControl(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                this.importLog.addFailedStatement(SHGrantUDBv81.FormatCR(string, "\n"));
            }
        } else if (Token.startsWithString(string2, "grant") && (Token.hasToken(string2, "ALTERIN") || Token.hasToken(string2, "CREATEIN") || Token.hasToken(string2, "DROPIN"))) {
            try {
                this.parseSchemaPrivileges(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                this.importLog.addFailedStatement(SHGrantUDBv81.FormatCR(string, "\n"));
            }
        } else if (Token.startsWithString(string2, "grant usage on sequence") && Token.hasToken(string2, "PUBLIC")) {
            try {
                this.parseGrantSequence(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                this.importLog.addFailedStatement(SHGrantUDBv81.FormatCR(string, "\n"));
            }
        } else if (Token.startsWithString(string2, "grant") && Token.hasToken(string2, "ON") && Token.hasToken(string2, "TO")) {
            try {
                this.grantPermissions(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                this.importLog.addFailedStatement(SHGrantUDBv81.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    private void parseGrantUseOf(String string) {
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignUDBv81 storageDesignUDBv81 = (StorageDesignUDBv81)this.design.getStorageDesign(rDBMSSite);
        String string2 = Token.getStringAfterToken(string, "TABLESPACE");
        string2 = Token.getStringBeforeToken(string2, "TO");
        String string3 = Token.getStringAfterToken(string, "TO");
        boolean bl = false;
        if (Token.hasToken(string3, "GRANT")) {
            string3 = Token.getStringBeforeToken(string3, "WITH");
            bl = true;
        }
        TableSpaceUDB tableSpaceUDB = (TableSpaceUDB)storageDesignUDBv81.getTableSpaceSet().getByName(string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        while (stringTokenizer.hasMoreTokens()) {
            StorageObject storageObject;
            String string4 = stringTokenizer.nextToken().trim();
            if (string4.toUpperCase().startsWith("USER")) {
                string4 = Token.cutFirstToken(string4).trim();
                if (storageDesignUDBv81.getOwnerSet().getByName(string4) == null) {
                    storageObject = (OwnerUDB)storageDesignUDBv81.getOwnerSet().createElement(null);
                    storageObject.setName(string4);
                    this.design.getRelationalDesign().stampModelObjectDDL(storageObject);
                }
                tableSpaceUDB.setUsers(string4);
                continue;
            }
            if (string4.toUpperCase().startsWith("PUBLIC")) {
                if (storageDesignUDBv81.getOwnerSet().getByName(string4) == null) {
                    storageObject = (OwnerUDB)storageDesignUDBv81.getOwnerSet().createElement(null);
                    storageObject.setName(string4);
                    this.design.getRelationalDesign().stampModelObjectDDL(storageObject);
                }
                tableSpaceUDB.setUsers(string4);
                continue;
            }
            if (string4.toUpperCase().startsWith("GROUP")) {
                string4 = Token.cutFirstToken(string4).trim();
                if (storageDesignUDBv81.getUserGroupSet().getByName(string4) == null) {
                    storageObject = storageDesignUDBv81.getUserGroupSet().createUserGroup();
                    storageObject.setName(string4);
                }
                tableSpaceUDB.setGroups(string4);
                continue;
            }
            if (storageDesignUDBv81.getOwnerSet().getByName(string4) == null) {
                storageObject = (OwnerUDB)storageDesignUDBv81.getOwnerSet().createElement(null);
                storageObject.setName(string4);
                this.design.getRelationalDesign().stampModelObjectDDL(storageObject);
            }
            tableSpaceUDB.setUsers(string4);
        }
        if (bl) {
            tableSpaceUDB.setGrantOption("YES");
        }
    }

    private void parseGrantControl(String string) {
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignUDBv81 storageDesignUDBv81 = (StorageDesignUDBv81)this.design.getStorageDesign(rDBMSSite);
        String string2 = Token.getStringAfterToken(string, "INDEX");
        string2 = Token.getStringBeforeToken(string2, "TO");
        String string3 = Token.getStringAfter(string, "TO");
        IndexProxyUDB indexProxyUDB = (IndexProxyUDB)storageDesignUDBv81.getIndexProxySet().getByName(string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        while (stringTokenizer.hasMoreTokens()) {
            StorageObject storageObject;
            String string4 = stringTokenizer.nextToken().trim();
            if (string4.toUpperCase().startsWith("USER")) {
                string4 = Token.cutFirstToken(string4).trim();
                if (storageDesignUDBv81.getOwnerSet().getByName(string4) == null) {
                    storageObject = (OwnerUDB)storageDesignUDBv81.getOwnerSet().createElement(null);
                    storageObject.setName(string4);
                    this.design.getRelationalDesign().stampModelObjectDDL(storageObject);
                }
                indexProxyUDB.setUsers(string4);
                continue;
            }
            if (string4.toUpperCase().startsWith("PUBLIC")) {
                if (storageDesignUDBv81.getOwnerSet().getByName(string4) == null) {
                    storageObject = (OwnerUDB)storageDesignUDBv81.getOwnerSet().createElement(null);
                    storageObject.setName(string4);
                    this.design.getRelationalDesign().stampModelObjectDDL(storageObject);
                }
                indexProxyUDB.setUsers(string4);
                continue;
            }
            if (string4.toUpperCase().startsWith("GROUP")) {
                string4 = Token.cutFirstToken(string4).trim();
                if (storageDesignUDBv81.getUserGroupSet().getByName(string4) == null) {
                    storageObject = storageDesignUDBv81.getUserGroupSet().createUserGroup();
                    storageObject.setName(string4);
                }
                indexProxyUDB.setGroups(string4);
                continue;
            }
            if (storageDesignUDBv81.getOwnerSet().getByName(string4) == null) {
                storageObject = (OwnerUDB)storageDesignUDBv81.getOwnerSet().createElement(null);
                storageObject.setName(string4);
                this.design.getRelationalDesign().stampModelObjectDDL(storageObject);
            }
            indexProxyUDB.setUsers(string4);
        }
    }

    private void parseSchemaPrivileges(String string) {
        String string2 = Token.getStringAfterToken(string, "GRANT");
        string2 = Token.getStringBeforeToken(string2, "ON");
        String string3 = Token.getStringAfterToken(string, "SCHEMA");
        string3 = Token.getStringBeforeToken(string3, "TO");
        String string4 = Token.getStringAfterToken(string, "TO");
        boolean bl = false;
        if (Token.hasToken(string4, "GRANT")) {
            string4 = Token.getStringBeforeToken(string4, "WITH");
            bl = true;
        }
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignUDBv81 storageDesignUDBv81 = (StorageDesignUDBv81)this.design.getStorageDesign(rDBMSSite);
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            SchemaUDB schemaUDB = (SchemaUDB)storageDesignUDBv81.getSchemaSet().getByName(string5);
            StringTokenizer stringTokenizer2 = new StringTokenizer(string4, ",");
            while (stringTokenizer2.hasMoreTokens()) {
                StringTokenizer stringTokenizer3;
                PrivilegesUDB privilegesUDB;
                StorageObject storageObject;
                String string6 = stringTokenizer2.nextToken().trim();
                if (string6.toUpperCase().startsWith("USER")) {
                    string6 = Token.cutFirstToken(string6).trim();
                    if (storageDesignUDBv81.getOwnerSet().getByName(string6) == null) {
                        storageObject = (OwnerUDB)storageDesignUDBv81.getOwnerSet().createElement(null);
                        storageObject.setName(string6);
                        this.design.getRelationalDesign().stampModelObjectDDL(storageObject);
                    } else {
                        storageObject = (OwnerUDB)storageDesignUDBv81.getOwnerSet().getByName(string6);
                    }
                    privilegesUDB = this.getPrivileges(schemaUDB, string6);
                    privilegesUDB.setUser((OwnerUDB)storageObject);
                    stringTokenizer3 = new StringTokenizer(string2, ",");
                    while (stringTokenizer3.hasMoreTokens()) {
                        privilegesUDB.setSystemPrivileges(stringTokenizer3.nextToken().trim());
                    }
                    if (!bl) continue;
                    privilegesUDB.setGrantOption("YES");
                    continue;
                }
                if (string6.toUpperCase().startsWith("PUBLIC")) {
                    if (storageDesignUDBv81.getOwnerSet().getByName(string6) == null) {
                        storageObject = (OwnerUDB)storageDesignUDBv81.getOwnerSet().createElement(null);
                        storageObject.setName(string6);
                        this.design.getRelationalDesign().stampModelObjectDDL(storageObject);
                    } else {
                        storageObject = (OwnerUDB)storageDesignUDBv81.getOwnerSet().getByName(string6);
                    }
                    privilegesUDB = this.getPrivileges(schemaUDB, string6);
                    privilegesUDB.setUser((OwnerUDB)storageObject);
                    stringTokenizer3 = new StringTokenizer(string2, ",");
                    while (stringTokenizer3.hasMoreTokens()) {
                        privilegesUDB.setSystemPrivileges(stringTokenizer3.nextToken().trim());
                    }
                    if (!bl) continue;
                    privilegesUDB.setGrantOption("YES");
                    continue;
                }
                if (string6.toUpperCase().startsWith("GROUP")) {
                    string6 = Token.cutFirstToken(string6).trim();
                    if (storageDesignUDBv81.getUserGroupSet().getByName(string6) == null) {
                        storageObject = storageDesignUDBv81.getUserGroupSet().createUserGroup();
                        storageObject.setName(string6);
                    } else {
                        storageObject = (UserGroupUDB)storageDesignUDBv81.getUserGroupSet().getByName(string6);
                    }
                    privilegesUDB = this.getPrivileges(schemaUDB, string6);
                    privilegesUDB.setGroup((UserGroupUDB)storageObject);
                    stringTokenizer3 = new StringTokenizer(string2, ",");
                    while (stringTokenizer3.hasMoreTokens()) {
                        privilegesUDB.setSystemPrivileges(stringTokenizer3.nextToken().trim());
                    }
                    if (!bl) continue;
                    privilegesUDB.setGrantOption("YES");
                    continue;
                }
                if (storageDesignUDBv81.getOwnerSet().getByName(string6) == null) {
                    storageObject = (OwnerUDB)storageDesignUDBv81.getOwnerSet().createElement(null);
                    storageObject.setName(string6);
                    this.design.getRelationalDesign().stampModelObjectDDL(storageObject);
                } else {
                    storageObject = (OwnerUDB)storageDesignUDBv81.getOwnerSet().getByName(string6);
                }
                privilegesUDB = this.getPrivileges(schemaUDB, string6);
                privilegesUDB.setUser((OwnerUDB)storageObject);
                stringTokenizer3 = new StringTokenizer(string2, ",");
                while (stringTokenizer3.hasMoreTokens()) {
                    privilegesUDB.setSystemPrivileges(stringTokenizer3.nextToken().trim());
                }
                if (!bl) continue;
                privilegesUDB.setGrantOption("YES");
            }
        }
    }

    private PrivilegesUDB getPrivileges(SchemaUDB schemaUDB, Object object) {
        PrivilegesUDB privilegesUDB;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignUDBv81 storageDesignUDBv81 = (StorageDesignUDBv81)this.design.getStorageDesign(rDBMSSite);
        Iterator iterator = storageDesignUDBv81.getPrivilegesSet().iterator();
        while (iterator.hasNext()) {
            privilegesUDB = (PrivilegesUDB)iterator.next();
            if (privilegesUDB.getSchema() != schemaUDB || privilegesUDB.getUser() != object && privilegesUDB.getGroup() != object) continue;
            return privilegesUDB;
        }
        privilegesUDB = storageDesignUDBv81.getPrivilegesSet().createPriv();
        privilegesUDB.setSchema(schemaUDB);
        return privilegesUDB;
    }

    private void grantPermissions(String string) {
        this.statement = string.replaceAll("\"", "");
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignUDBv81)this.design.getStorageDesign(rDBMSSite);
        if (this.storageDesign != null) {
            ArrayList arrayList = this.initUsersAndRoles();
            RelationalObjectProxy relationalObjectProxy = this.initOn();
            if (relationalObjectProxy != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.permissions = this.getPermissionForUser((StorageObject)arrayList.get(i), relationalObjectProxy) != null ? this.getPermissionForUser((StorageObject)arrayList.get(i), relationalObjectProxy) : this.storageDesign.getPermissionsSet().createPermissions();
                    if (this.permissions == null) continue;
                    this.initPrivileges();
                    this.initOnObject(relationalObjectProxy);
                    this.initTo(arrayList.get(i));
                }
            }
        }
    }

    private PermissionsUDB getPermissionForUser(StorageObject storageObject, RelationalObjectProxy relationalObjectProxy) {
        Iterator iterator = this.storageDesign.getPermissionsSet().iterator();
        PermissionsUDB permissionsUDB = null;
        while (iterator.hasNext()) {
            permissionsUDB = (PermissionsUDB)iterator.next();
            if (permissionsUDB.getUser() != storageObject && permissionsUDB.getGroup() != storageObject || permissionsUDB.getTable() != relationalObjectProxy && permissionsUDB.getView() != relationalObjectProxy) continue;
            return permissionsUDB;
        }
        return null;
    }

    private ArrayList initUsersAndRoles() {
        ArrayList<StorageObject> arrayList = new ArrayList<StorageObject>();
        String string = Token.getStringAfter(this.statement, "TO").trim();
        if (Token.hasToken(string, "WITH")) {
            string = Token.getStringBeforeToken(string, "WITH");
        }
        if (!string.equalsIgnoreCase("")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            String string2 = null;
            while (stringTokenizer.hasMoreTokens()) {
                StorageObject storageObject;
                string2 = stringTokenizer.nextToken().trim();
                if (string2.toUpperCase().startsWith("USER")) {
                    string2 = Token.cutFirstToken(string2).trim();
                    if (this.storageDesign.getOwnerSet().getByName(string2) == null) {
                        storageObject = (OwnerUDB)this.storageDesign.getOwnerSet().createElement(null);
                        storageObject.setName(string2);
                        this.design.getRelationalDesign().stampModelObjectDDL(storageObject);
                    } else {
                        storageObject = (OwnerUDB)this.storageDesign.getOwnerSet().getByName(string2);
                    }
                    arrayList.add(storageObject);
                    continue;
                }
                if (string2.toUpperCase().startsWith("GROUP")) {
                    string2 = Token.cutFirstToken(string2).trim();
                    if (this.storageDesign.getUserGroupSet().getByName(string2) == null) {
                        storageObject = (UserGroupUDB)this.storageDesign.getUserGroupSet().createElement(null);
                        storageObject.setName(string2);
                        this.design.getRelationalDesign().stampModelObjectDDL(storageObject);
                    } else {
                        storageObject = (UserGroupUDB)this.storageDesign.getUserGroupSet().getByName(string2);
                    }
                    arrayList.add(storageObject);
                    continue;
                }
                if (string2.toUpperCase().startsWith("PUBLIC")) {
                    if (this.storageDesign.getOwnerSet().getByName(string2) == null) {
                        storageObject = (OwnerUDB)this.storageDesign.getOwnerSet().createElement(null);
                        storageObject.setName(string2);
                        this.design.getRelationalDesign().stampModelObjectDDL(storageObject);
                    } else {
                        storageObject = (OwnerUDB)this.storageDesign.getOwnerSet().getByName(string2);
                    }
                    arrayList.add(storageObject);
                    continue;
                }
                if (this.storageDesign.getOwnerSet().getByName(string2) == null) {
                    storageObject = (OwnerUDB)this.storageDesign.getOwnerSet().createElement(null);
                    storageObject.setName(string2);
                    this.design.getRelationalDesign().stampModelObjectDDL(storageObject);
                } else {
                    storageObject = (OwnerUDB)this.storageDesign.getOwnerSet().getByName(string2);
                }
                arrayList.add(storageObject);
            }
        }
        return arrayList;
    }

    private void initPrivileges() {
        Object object;
        String string = Token.getStringAfter(this.statement.toUpperCase(), "GRANT").trim();
        if (Token.hasCloseAndOpenBrackets(string = Token.getStringBeforeToken(string, "ON"))) {
            object = Token.getValBetweenBrackets(string).trim();
            string = Token.getStringBefore(string, "(").trim();
            this.initColumns((String)object, string);
        }
        if (this.statement.toUpperCase().indexOf("WITH GRANT OPTION") > -1) {
            object = new StringTokenizer(string, ",");
            String string2 = null;
            while (((StringTokenizer)object).hasMoreTokens()) {
                string2 = ((StringTokenizer)object).nextToken().trim();
                this.permissions.setPrivilegesWithGrantOption(string2);
            }
        } else {
            object = new StringTokenizer(string, ",");
            String string3 = null;
            while (((StringTokenizer)object).hasMoreTokens()) {
                string3 = ((StringTokenizer)object).nextToken().trim();
                this.permissions.setPrivileges(string3);
            }
        }
    }

    private void initColumns(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken().trim();
            if (string3.equalsIgnoreCase("") || this.table == null || this.table.getColumn(string3) == null) continue;
            string3 = string3 + ", " + string2;
            this.permissions.setColumnList(string3);
        }
    }

    private RelationalObjectProxy initOn() {
        String string = Token.getStringAfterToken(this.statement, "ON").trim();
        if (!(string = Token.getStringBeforeToken(string, "TO")).equalsIgnoreCase("")) {
            this.table = ((TableProxySetUDB)this.storageDesign.getTableProxySet()).getByName(string);
            if (this.table != null) {
                return this.table;
            }
            this.view = ((TableViewProxySetUDB)this.storageDesign.getTableViewProxySet()).getByName(string);
            if (this.view != null) {
                return this.view;
            }
        }
        this.importLog.addError("Error in setting object of permission " + this.statement);
        return null;
    }

    private void initOnObject(RelationalObjectProxy relationalObjectProxy) {
        if (relationalObjectProxy instanceof TableProxyUDB) {
            this.permissions.setTable((TableProxyUDB)relationalObjectProxy);
        } else if (relationalObjectProxy instanceof TableViewProxyUDB) {
            this.permissions.setView((TableViewProxyUDB)relationalObjectProxy);
        }
    }

    private void initTo(Object object) {
        String string = Token.getStringAfter(this.statement.toUpperCase(), "TO").trim();
        if (Token.hasToken(string, "WITH")) {
            string = Token.getStringBeforeToken(string, "WITH");
        }
        if (!string.equalsIgnoreCase("")) {
            if (object instanceof OwnerUDB) {
                this.permissions.setUser((OwnerUDB)object);
            } else if (object instanceof UserGroupUDB) {
                this.permissions.setGroup((UserGroupUDB)object);
            }
        } else {
            this.importLog.addError("Error in setting TO objects of permission " + this.statement);
        }
    }

    private void parseGrantSequence(String string) {
        String string2 = Token.getTokenAfter(string, "SEQUENCE");
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignUDBv81)this.design.getStorageDesign(rDBMSSite);
        if (this.storageDesign.getSequenceSet().getByName(string2) != null) {
            ((SequenceUDBv81)this.storageDesign.getSequenceSet().getByName(string2)).setUsedByPublic("YES");
        }
    }
}

