/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb.v81;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableViewProxyUDBv81;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateViewUDBv81
extends DDLStatementHandler {
    private boolean allColumnsAreMade;
    private AbstractView view;
    private String schemaName = null;
    private String userDefined;
    private static final Logger LOGGER = new Logger(SHCreateViewUDBv81.class);

    public SHCreateViewUDBv81(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateViewUDBv81.clearCR(string);
        if (Token.startsWithString(string2, "create view") || Token.startsWithString(string2, "create federated view")) {
            try {
                this.userDefined = SHCreateViewUDBv81.FormatCR(string, "\n");
                this.parseView(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for UDB failed!", exception);
                this.importLog.addFailedStatement(SHCreateViewUDBv81.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    public void parseView(String string) {
        this.statement = string;
        this.allColumnsAreMade = true;
        if (this.allColumnsAreMade) {
            this.view = this.design.getRelationalDesign().getTableViewSet().createTableView(null);
            String string2 = this.initName();
            if (this.schemaName != null && !"".equals(this.schemaName)) {
                this.view.setSchema(this.schemaName);
            }
            this.view.setName(string2);
            this.design.getRelationalDesign().stampModelObjectDDL(this.view);
            if (Token.getTokenAfter(string, string2).trim().equalsIgnoreCase("OF")) {
                TableViewProxyUDB tableViewProxyUDB;
                RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
                StorageDesignUDB storageDesignUDB = (StorageDesignUDB)this.design.getStorageDesign(rDBMSSite);
                if (storageDesignUDB != null && (tableViewProxyUDB = (TableViewProxyUDB)storageDesignUDB.getTableViewProxySet().getProxy(this.view.getObjectID())) != null) {
                    String string3;
                    StructuredType structuredType;
                    String string4 = Token.getStringAfterToken(string, "OF").trim();
                    String string5 = Token.getFirstToken(string4).trim();
                    int n = string5.indexOf(46);
                    if (n > 0) {
                        string5 = Token.getValAfterCharacter(string5, '.');
                    }
                    if ((structuredType = (StructuredType)this.design.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(string5)) != null) {
                        this.view.setBasedOnStructuredType(structuredType);
                    } else {
                        LOGGER.error("Unable to find required Structured Type: " + string5);
                    }
                    if (Token.hasToken(string, "UNDER")) {
                        AbstractView abstractView;
                        string3 = Token.getTokenAfter(string, "UNDER").trim();
                        n = string3.indexOf(46);
                        if (n > 0) {
                            string3 = Token.getValAfterCharacter(string3, '.');
                        }
                        if ((abstractView = (AbstractView)this.design.getRelationalDesign().getTableViewSet().getByName(string3)) != null) {
                            ContainerView containerView = (ContainerView)abstractView.getTopView();
                            ContainerView containerView2 = (ContainerView)this.view.getTopView();
                            if (containerView != null && containerView2 != null) {
                                TypeSubstitution typeSubstitution = this.design.getRelationalDesign().createTypeSubstitution();
                                this.design.getRelationalDesign().stampModelObjectDDL(typeSubstitution);
                                typeSubstitution.setChildCV(containerView2);
                                typeSubstitution.setParentCV(containerView);
                                typeSubstitution.addToAllDPVs();
                            }
                        }
                    }
                    if (Token.hasString(string, "REF IS")) {
                        string3 = Token.getStringAfter(string, "REF IS").trim();
                        string3 = Token.getFirstToken(string3).trim();
                        tableViewProxyUDB.setOidColumnName(string3);
                        if (Token.hasToken(string, "UNCHECKED")) {
                            tableViewProxyUDB.setOidColumnUniqueness(false);
                        }
                    }
                }
            } else {
                TableViewProxyUDBv81 tableViewProxyUDBv81;
                RDBMSSite rDBMSSite;
                StorageDesignUDB storageDesignUDB;
                this.initUserDefinedSql();
                if (!this.initCols()) {
                    this.initCol();
                }
                if ((storageDesignUDB = (StorageDesignUDB)this.design.getStorageDesign(rDBMSSite = this.design.getSelectedRDBMSSite())) != null && (tableViewProxyUDBv81 = (TableViewProxyUDBv81)storageDesignUDB.getTableViewProxySet().getProxy(this.view.getObjectID())) != null) {
                    tableViewProxyUDBv81.setDefinition(this.userDefined);
                    this.initCheckOption(tableViewProxyUDBv81);
                    this.initFederated(tableViewProxyUDBv81);
                    this.initOwner(tableViewProxyUDBv81, storageDesignUDB);
                }
            }
        }
    }

    public boolean initCols() {
        String string = Token.getStringBefore(this.statement, " as ");
        if (!Token.hasToken(string, "OF") && Token.hasCloseAndOpenBrackets(string)) {
            String string2 = Token.getValBetweenBrackets(string, 1);
            if (!"".equalsIgnoreCase(string2)) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                String string3 = "";
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = Token.removeQuotes(stringTokenizer.nextToken());
                    AbstractViewElement abstractViewElement = this.view.createViewElement(this.design.getLogicalDesign().getMainDPVPlaceHolder().getDesignPart());
                    abstractViewElement.setName(string3);
                    abstractViewElement.setDesign(this.design);
                    abstractViewElement.setAlias(string3);
                    abstractViewElement.setContainer(this.view);
                    this.design.getRelationalDesign().stampModelObjectDDL(abstractViewElement);
                    this.view.add(abstractViewElement);
                }
            }
            return true;
        }
        return false;
    }

    private void initCheckOption(TableViewProxyUDBv81 tableViewProxyUDBv81) {
        String string = Token.getTokenAfter(this.statement, "WITH");
        if (string.equalsIgnoreCase("LOCAL")) {
            tableViewProxyUDBv81.setCheckOptionScope("LOCAL");
        } else {
            tableViewProxyUDBv81.setCheckOptionScope("CASCADED");
        }
        if (!string.equalsIgnoreCase("")) {
            tableViewProxyUDBv81.setCheckOption(true);
        } else {
            tableViewProxyUDBv81.setCheckOption(false);
        }
    }

    private void initFederated(TableViewProxyUDBv81 tableViewProxyUDBv81) {
        if (this.statement.toUpperCase().indexOf("FEDERATED") > -1) {
            tableViewProxyUDBv81.setFederated("YES");
        }
    }

    private void initUserDefinedSql() {
        this.view.setUserDefinedSQL(this.userDefined);
        this.view.setUserDefined(true);
        this.view.setSyntaxProvider("DB2");
    }

    private void initOwner(TableViewProxyUDBv81 tableViewProxyUDBv81, StorageDesignUDB storageDesignUDB) {
        if (this.schemaName != null) {
            SchemaUDB schemaUDB = (SchemaUDB)storageDesignUDB.getSchemaSet().getByName(this.schemaName);
            if (schemaUDB == null) {
                schemaUDB = storageDesignUDB.getSchemaSet().createSchema();
                schemaUDB.setName(this.schemaName);
                this.design.getRelationalDesign().stampModelObjectDDL(schemaUDB);
            }
            if (schemaUDB != null) {
                tableViewProxyUDBv81.setSchema(schemaUDB);
            }
        }
    }

    private String initName() {
        String string = Token.getNameAfterToken(this.statement, "VIEW", '\"', '\"').trim();
        int n = string.indexOf(46);
        if (n > 0) {
            this.schemaName = Token.getValBeforeCharacter(string, '.');
            string = Token.getValAfterCharacter(string, '.');
        }
        return string;
    }

    public void initCol() {
        String string = Token.getStringAfter(this.statement, "AS SELECT").trim();
        if (string.equalsIgnoreCase("") && !this.isAsSelectOnly()) {
            string = Token.getStringAfter(this.statement, "SELECT").trim();
        }
        if (!string.equalsIgnoreCase("")) {
            String string2;
            if (Token.hasToken(this.statement, "FROM")) {
                int n = string.toUpperCase().indexOf("FROM");
                string2 = string.substring(0, n);
                while (Token.tokenNumber(string2, "(") > Token.tokenNumber(string2, ")")) {
                    n = string.toUpperCase().indexOf("FROM", n + 1);
                    string2 = string.substring(0, n);
                }
                string = string2;
            }
            if (Token.getFirstToken(string).equalsIgnoreCase("ALL")) {
                string = Token.getStringAfterToken(string, "ALL").trim();
            }
            if (Token.getFirstToken(string).equalsIgnoreCase("DISTINCT")) {
                string = Token.getStringAfterToken(string, "DISTINCT").trim();
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            string2 = null;
            String string3 = null;
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken().trim();
                string3 = null;
                StringBuffer stringBuffer = new StringBuffer(string2);
                while (Token.tokenNumber(string2, "(") > Token.tokenNumber(string2, ")") && stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append(",").append(stringTokenizer.nextToken().trim());
                    string2 = stringBuffer.toString().trim();
                }
                if (Token.hasToken(string2, "AS")) {
                    string3 = Token.getNameAfterToken(string2, "AS", '\"', '\"');
                    string2 = Token.getStringBeforeToken(string2, "AS");
                }
                if ((string2 = Token.encodeQuotedString(string2)).indexOf(" ") > -1) {
                    if (string2.charAt(string2.length() - 1) == '\"') {
                        string3 = string2.substring(0, string2.length() - 1);
                        int n = string3.lastIndexOf(34);
                        string3 = string3.substring(n) + "\"";
                        string2 = string2.substring(0, n - 1);
                    } else if (string2.charAt(string2.length() - 1) == '\'') {
                        string3 = string2.substring(0, string2.length() - 1);
                        int n = string3.lastIndexOf(39);
                        string3 = string3.substring(n) + "'";
                        string2 = string2.substring(0, n - 1);
                    } else {
                        String string4 = Token.getLastToken(string2);
                        if (string4.indexOf(41) == -1 && !string4.equalsIgnoreCase("END")) {
                            string3 = string4;
                            string2 = string2.substring(0, string2.lastIndexOf(string4)).trim();
                        }
                    }
                }
                if (!Token.hasCloseAndOpenBrackets(string2 = Token.removeQuotes(Token.decodeQuotedString(string2))) && string2.indexOf(43) == -1 && string2.indexOf(45) == -1 && string2.indexOf(42) == -1 && string2.indexOf(47) == -1 && string2.indexOf(58) == -1 && string2.indexOf("||") == -1 && !Token.hasToken(string2, "CONCAT") && string2.indexOf(46) > -1 && (string2 = string2.substring(string2.indexOf(46) + 1)).indexOf(46) > -1) {
                    string2 = string2.substring(string2.indexOf(46) + 1);
                }
                if (string2.equalsIgnoreCase("") || string2.equalsIgnoreCase("*")) continue;
                AbstractViewElement abstractViewElement = this.view.createViewElement(this.design.getLogicalDesign().getMainDPVPlaceHolder().getDesignPart());
                if (string3 != null) {
                    abstractViewElement.setName(string3);
                } else {
                    abstractViewElement.setName(string2);
                }
                abstractViewElement.setDesign(this.design);
                abstractViewElement.setExpression(string2);
                abstractViewElement.setContainer(this.view);
                this.design.getRelationalDesign().stampModelObjectDDL(abstractViewElement);
                this.view.add(abstractViewElement);
                if (string3 != null) {
                    string3 = Token.removeQuotes(Token.decodeQuotedString(string3));
                    abstractViewElement.setAlias(string3);
                    continue;
                }
                abstractViewElement.setAlias(abstractViewElement.getName());
            }
        }
    }

    public void setView(AbstractView abstractView) {
        this.view = abstractView;
    }
}

