/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb.v81;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.ParseException;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TriggerUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableProxySetUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableViewProxySetUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableViewProxyUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TriggerUDBv81;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateTriggerUDBv81
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateTriggerUDBv81.class);
    private String line;
    private TriggerUDBv81 trigger;
    private StorageDesignUDBv81 storageDesign;

    public SHCreateTriggerUDBv81(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateTriggerUDBv81.clearCR(string);
        this.line = string;
        if (Token.startsWithString(string2, "create trigger") || Token.startsWithString(string2, "CREATE TRIGGER")) {
            this.parseTrigger(string2);
        } else {
            this.nextHandler(string);
        }
    }

    private void parseTrigger(String string) {
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignUDBv81)this.design.getStorageDesign(rDBMSSite);
        if (this.storageDesign != null) {
            this.trigger = (TriggerUDBv81)this.storageDesign.getTriggerSet().createTrigger();
            if (this.trigger != null) {
                try {
                    this.initTriggerName();
                    this.initTriggeringTime();
                    this.initAction();
                    this.initOnTable();
                    this.initReferencing();
                    this.initScope();
                    this.initCondition();
                    this.initBody();
                    this.design.getRelationalDesign().stampModelObjectDDL(this.trigger);
                    this.importLog.incrementImportedStatements();
                }
                catch (Exception exception) {
                    LOGGER.error(" Parsing " + string + " for UDB failed!", exception);
                    this.importLog.addFailedStatement(SHCreateTriggerUDBv81.FormatCR(this.line, "\n"));
                }
            }
        }
    }

    private void initTriggerName() {
        String string = Token.getTokenAfter(this.statement, "TRIGGER").trim();
        if (string.indexOf(46) > -1) {
            String string2 = string.substring(0, string.indexOf(46));
            string2 = Token.getValBetweenSquareBrackets(string2);
            SchemaUDB schemaUDB = (SchemaUDB)this.storageDesign.getSchemaSet().getByName(string2);
            if (schemaUDB != null) {
                this.trigger.setSchema(schemaUDB);
            }
            string = string.substring(string.indexOf(46) + 1);
        }
        this.trigger.setName(string);
    }

    private void initTriggeringTime() throws ParseException {
        if (Token.hasString(this.statement, "NO CASCADE BEFORE")) {
            this.trigger.setTriggerTime("NO CASCADE BEFORE");
        } else if (Token.hasString(this.statement, "AFTER")) {
            this.trigger.setTriggerTime("AFTER");
        } else if (Token.hasString(this.statement, "INSTEAD OF")) {
            this.trigger.setTriggerTime("INSTEAD OF");
        } else {
            this.importLog.addError("Unknown triggering time for trigger " + this.trigger.getName());
            throw new ParseException("Error parsing triggering time for trigger " + this.trigger.getName() + "(UDB) ");
        }
    }

    private void initAction() {
        String string = this.trigger.getTriggerTime();
        if (string != null) {
            String string2;
            String string3 = Token.getStringAfter(this.statement, string);
            String string4 = Token.getFirstToken(string3);
            this.trigger.setActions(string4);
            if (string4.equalsIgnoreCase("UPDATE") && (string2 = Token.getFirstToken(string3 = Token.getStringAfter(string3, "UPDATE").trim()).trim()).equalsIgnoreCase("OF")) {
                string3 = string3.substring(2, string3.indexOf(" ON "));
                this.trigger.setColumns(string3);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initOnTable() throws ParseException {
        String string = this.statement.substring(this.statement.indexOf(" ON ") + 3).trim();
        string = Token.getFirstToken(string);
        String string2 = Token.getLastToken(string);
        String string3 = "";
        if (string2.indexOf(40) > -1) {
            string2 = Token.getStringBefore(string2, "(").trim();
        }
        if (string2.indexOf(46) > -1) {
            string3 = string2.substring(0, string2.indexOf(46)).trim();
            string2 = string2.substring(string2.indexOf(46) + 1).trim();
        }
        if (!"".equals(string3)) {
            if (((TableProxySetUDBv81)this.storageDesign.getTableProxySet()).getByUserSchemaAndName(string3, string2) != null) {
                this.trigger.setTable((TableProxyUDB)((TableProxySetUDBv81)this.storageDesign.getTableProxySet()).getByUserSchemaAndName(string3, string2));
                return;
            }
            if (((TableViewProxySetUDBv81)this.storageDesign.getTableViewProxySet()).getBySchemaAndName(string3, string2) != null) {
                this.trigger.setView((TableViewProxyUDBv81)((TableViewProxySetUDBv81)this.storageDesign.getTableViewProxySet()).getBySchemaAndName(string3, string2));
                return;
            }
            this.importLog.addError("Specified table on trigger " + this.trigger.getName() + "does not exist");
            throw new ParseException("Specified table or view on trigger " + this.trigger.getName() + "does not exist ");
        }
        if (((TableProxySetUDBv81)this.storageDesign.getTableProxySet()).getByName(string2) != null) {
            this.trigger.setTable(((TableProxySetUDBv81)this.storageDesign.getTableProxySet()).getByName(string2));
            return;
        }
        if (((TableViewProxySetUDBv81)this.storageDesign.getTableViewProxySet()).getByName(string2) != null) {
            this.trigger.setView((TableViewProxyUDBv81)((TableViewProxySetUDBv81)this.storageDesign.getTableViewProxySet()).getByName(string2));
            return;
        }
        this.importLog.addError("Specified table on trigger " + this.trigger.getName() + "does not exist");
        throw new ParseException("Specified table or view on trigger " + this.trigger.getName() + "does not exist ");
    }

    private void initReferencing() {
        if (Token.hasString(this.statement, "REFERENCING")) {
            String string;
            String string2 = Token.getStringAfter(this.statement, "REFERENCING");
            if (Token.hasString(string2, "OLD AS ")) {
                string = string2.substring(string2.indexOf("OLD AS ") + 6);
                this.trigger.setRef_OLD_AS(Token.getFirstToken(string));
            } else if (Token.hasString(string2, "OLD_AS ")) {
                string = string2.substring(string2.indexOf("OLD_AS ") + 6);
                this.trigger.setRef_OLD_AS(Token.getFirstToken(string));
            } else {
                string = Token.getStringAfter(string2, " OLD ").trim();
                if (!string.equalsIgnoreCase("") && !Token.getFirstToken(string).equalsIgnoreCase("TABLE")) {
                    this.trigger.setRef_OLD_AS(Token.getFirstToken(string));
                }
            }
            if (Token.hasString(string2, "NEW AS ")) {
                string = string2.substring(string2.indexOf("NEW AS ") + 6);
                this.trigger.setRef_NEW_AS(Token.getFirstToken(string));
            } else if (Token.hasString(string2, "NEW_AS ")) {
                string = string2.substring(string2.indexOf("NEW_AS ") + 6);
                this.trigger.setRef_NEW_AS(Token.getFirstToken(string));
            } else {
                string = Token.getStringAfter(string2, " NEW ").trim();
                if (!string.equalsIgnoreCase("") && !Token.getFirstToken(string).equalsIgnoreCase("TABLE")) {
                    this.trigger.setRef_NEW_AS(Token.getFirstToken(string));
                }
            }
            if (Token.hasString(string2, "OLD TABLE AS ")) {
                string = string2.substring(string2.indexOf("OLD TABLE AS ") + 13);
                this.trigger.setOLD_TABLE_AS(Token.getFirstToken(string));
            }
            if (Token.hasString(string2, "NEW TABLE AS ")) {
                string = string2.substring(string2.indexOf("NEW TABLE AS ") + 13);
                this.trigger.setNEW_TABLE_AS(Token.getFirstToken(string));
            }
        }
    }

    private void initScope() throws ParseException {
        if (Token.hasString(this.statement, "FOR EACH ROW")) {
            this.trigger.setScope(TriggerUDB.SCOPE_TYPES[0]);
        } else if (Token.hasString(this.statement, "FOR EACH STATEMENT")) {
            this.trigger.setScope(TriggerUDB.SCOPE_TYPES[1]);
        } else {
            this.importLog.addError("Scope is not specified on trigger " + this.trigger.getName());
            throw new ParseException("Scope is not specified on trigger " + this.trigger.getName());
        }
    }

    private void initCondition() {
        if (Token.hasString(this.statement, "WHEN")) {
            String string = Token.getStringAfter(this.statement, "WHEN");
            this.trigger.setCondition(Token.getValBetweenBrackets(string, 1).trim());
        }
    }

    private void initBody() {
        String string = Token.getStringAfter(this.statement, "MODE DB2SQL").trim();
        if (!this.trigger.getCondition().trim().equalsIgnoreCase("")) {
            string = Token.getStringAfter(string, this.trigger.getCondition()).trim();
            string = string.substring(1);
        }
        this.trigger.setBody(string);
    }
}

