/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb.v81;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.ContainerUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.BufferPoolUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.DBPartitionGroupUDBv81;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateTablespaceUDBv81
extends DDLStatementHandler {
    private TableSpaceUDB tableSpace;
    private RDBMSSite site;
    private StorageDesignUDB stoDesign;
    private static final Logger LOGGER = new Logger(SHCreateTablespaceUDBv81.class);

    public SHCreateTablespaceUDBv81(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateTablespaceUDBv81.clearCR(string);
        if (Token.startsWithString(string2, "create tablespace") || Token.startsWithString(string2, "create regular tablespace") || Token.startsWithString(string2, "create large tablespace") || Token.startsWithString(string2, "create temporary tablespace") || Token.startsWithString(string2, "create system temporary tablespace") || Token.startsWithString(string2, "create user temporary tablespace")) {
            try {
                this.parseTablespace(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for UDB 8.1 failed!", exception);
                this.importLog.addFailedStatement(SHCreateTablespaceUDBv81.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    public void parseTablespace(String string) {
        this.statement = string;
        this.site = this.design.getSelectedRDBMSSite();
        this.stoDesign = (StorageDesignUDB)this.design.getStorageDesign(this.site);
        if (this.stoDesign != null) {
            this.tableSpace = this.stoDesign.getTableSpaceSet().createTableSpace();
            this.initType();
            this.initName();
            this.initDBPartitionGroup();
            this.initPageSize();
            this.initManagedBy();
            this.initUsingBlock();
            this.initExtentSize();
            this.initPrefetchSize();
            this.initBufferpool();
            this.initOverhead();
            this.initTransferRate();
            this.initDroppedTableRecovery();
            this.design.getRelationalDesign().stampModelObjectDDL(this.tableSpace);
        }
    }

    private void initType() {
        String string = Token.getTokenAfter(this.statement, "CREATE").trim();
        if ("USER".equalsIgnoreCase(string)) {
            this.tableSpace.setDataType("USER TEMPORARY");
        } else if ("LONG".equalsIgnoreCase(string)) {
            this.tableSpace.setDataType("LONG");
        } else if ("SYSTEM".equalsIgnoreCase(string)) {
            this.tableSpace.setDataType("SYSTEM TEMPORARY");
        } else {
            this.tableSpace.setDataType("REGULAR");
        }
    }

    private void initName() {
        String string = Token.getNameAfterToken(this.statement, "TABLESPACE", '\"', '\"').trim();
        this.tableSpace.setName(string);
    }

    private void initDBPartitionGroup() {
        if (Token.hasToken(this.statement, "IN")) {
            String string = this.statement.substring(this.statement.toUpperCase().indexOf("IN") + 3);
            if (Token.getFirstToken(string).equalsIgnoreCase("NODEGROUP")) {
                string = Token.cutFirstToken(string);
            } else if (Token.getFirstToken(string).equalsIgnoreCase("DATABASE")) {
                string = Token.cutFirstToken(string);
                string = Token.cutFirstToken(string);
                string = Token.cutFirstToken(string);
            }
            String string2 = Token.getFirstToken(string);
            DBPartitionGroupUDBv81 dBPartitionGroupUDBv81 = (DBPartitionGroupUDBv81)this.stoDesign.getNodeGroupSet().getByName(string2);
            if (dBPartitionGroupUDBv81 != null) {
                this.tableSpace.setNodeGroup(dBPartitionGroupUDBv81);
            } else {
                dBPartitionGroupUDBv81 = (DBPartitionGroupUDBv81)this.stoDesign.getNodeGroupSet().createNodeGroup();
                dBPartitionGroupUDBv81.setName(string2);
                this.tableSpace.setNodeGroup(dBPartitionGroupUDBv81);
            }
        }
    }

    private void initPageSize() {
        if (Token.hasToken(this.statement, "PAGESIZE")) {
            try {
                int n = Integer.parseInt(Token.getTokenAfter(this.statement, "PAGESIZE"));
                this.tableSpace.setPageSize(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong PAGESIZE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateTablespaceUDB.initPageSize : " + numberFormatException.getMessage());
            }
        }
    }

    private void initManagedBy() {
        if (Token.hasToken(this.statement, "BY")) {
            String string = Token.getTokenAfter(this.statement, "BY");
            this.tableSpace.setManagedBy(string);
        }
    }

    private void initUsingBlock() {
        int n;
        if (Token.hasToken(this.statement, "USING") && (n = this.statement.indexOf("USING")) > -1) {
            String string = this.statement.substring(n);
            while (string.indexOf("USING") > -1) {
                String string2 = Token.getValBetweenBrackets(string, 1);
                String string3 = Token.getValAfterBrackets(string, 1);
                if (string.length() == string3.length()) break;
                ContainerUDB containerUDB = ((StorageDesignUDB)this.tableSpace.getStorageDesign()).getContainerSet().createContainer();
                if (containerUDB == null) continue;
                containerUDB.setTableSpace(this.tableSpace);
                containerUDB.setContainers(string2);
                this.design.getRelationalDesign().stampModelObjectDDL(containerUDB);
                if (string3.toUpperCase().startsWith("ON")) {
                    String string4 = Token.getValBetweenBrackets(string3, 1);
                    containerUDB.setOnNodes(string4.trim());
                }
                string = Token.getValAfterBrackets(string3, 1);
            }
        }
    }

    private void initExtentSize() {
        if (Token.hasToken(this.statement, "EXTENTSIZE")) {
            this.tableSpace.setExtentSize(Token.getTokenAfter(this.statement, "EXTENTSIZE"));
        }
    }

    private void initPrefetchSize() {
        if (Token.hasToken(this.statement, "PREFETCHSIZE")) {
            this.tableSpace.setPrefetchSize(Token.getTokenAfter(this.statement, "PREFETCHSIZE"));
        }
    }

    private void initBufferpool() {
        String string;
        if (Token.hasToken(this.statement, "BUFFERPOOL") && !(string = Token.getTokenAfter(this.statement, "BUFFERPOOL").trim()).equals("")) {
            BufferPoolUDBv81 bufferPoolUDBv81 = (BufferPoolUDBv81)this.stoDesign.getBufferPoolSet().getByName(string);
            if (bufferPoolUDBv81 == null) {
                BufferPoolUDBv81 bufferPoolUDBv812 = (BufferPoolUDBv81)this.stoDesign.getBufferPoolSet().createBufferPool();
                bufferPoolUDBv812.setName(string);
                this.design.getRelationalDesign().stampModelObjectDDL(bufferPoolUDBv812);
                this.tableSpace.setBufferPool(bufferPoolUDBv812);
            } else {
                this.tableSpace.setBufferPool(bufferPoolUDBv81);
            }
        }
    }

    private void initOverhead() {
        if (Token.hasToken(this.statement, "OVERHEAD")) {
            try {
                float f = Float.parseFloat(Token.getTokenAfter(this.statement, "OVERHEAD"));
                this.tableSpace.setOverhead(f);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong OVERHEAD format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateTablespaceUDB.initOverhead : " + numberFormatException.getMessage());
            }
        }
    }

    private void initTransferRate() {
        if (Token.hasToken(this.statement, "TRANSFERRATE")) {
            try {
                float f = Float.parseFloat(Token.getTokenAfter(this.statement, "TRANSFERRATE"));
                this.tableSpace.setTransferRate(f);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong TRANSFERRATE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateTablespaceUDB.initTransferRate : " + numberFormatException.getMessage());
            }
        }
    }

    private void initDroppedTableRecovery() {
        String string;
        if (Token.hasToken(this.statement, "RECOVERY") && "ON".equalsIgnoreCase(string = Token.getTokenAfter(this.statement, "RECOVERY").trim())) {
            this.tableSpace.setDroppedTableRecovery(true);
        }
    }
}

