/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb.v81;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.DBPartitionGroupUDBv81;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateDBPartitionGroupUDBv81
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateDBPartitionGroupUDBv81.class);
    public static final String DBPARTITIONNUMS = "DBPARTITIONNUMS";

    public SHCreateDBPartitionGroupUDBv81(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateDBPartitionGroupUDBv81.clearCR(string);
        if (Token.startsWithString(string2, "create nodegroup")) {
            try {
                this.parseNodeGroup(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for UDB failed!", exception);
                this.importLog.addFailedStatement(SHCreateDBPartitionGroupUDBv81.FormatCR(string, "\n"));
            }
        } else if (Token.startsWithString(string2, "create database partition group")) {
            try {
                this.parseDBPartitionGroup(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for UDB failed!", exception);
                this.importLog.addFailedStatement(SHCreateDBPartitionGroupUDBv81.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    public void parseDBPartitionGroup(String string) {
        this.statement = string;
        String string2 = Token.getTokenAfter(this.statement, "GROUP").trim();
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignUDB storageDesignUDB = (StorageDesignUDB)this.design.getStorageDesign(rDBMSSite);
        DBPartitionGroupUDBv81 dBPartitionGroupUDBv81 = (DBPartitionGroupUDBv81)storageDesignUDB.getNodeGroupSet().createNodeGroup();
        if (dBPartitionGroupUDBv81 != null) {
            dBPartitionGroupUDBv81.setName(string2);
            String string3 = Token.getTokenAfter(this.statement, "ON").trim();
            if (string3.equalsIgnoreCase(DBPARTITIONNUMS)) {
                dBPartitionGroupUDBv81.setScope("ON SOME DBPARTITIONNUMS");
                if (Token.hasCloseAndOpenBrackets(this.statement)) {
                    String string4 = Token.getValBetweenBrackets(this.statement).trim();
                    dBPartitionGroupUDBv81.setNodeNumbers(string4);
                }
            }
        }
    }

    public void parseNodeGroup(String string) {
        this.statement = string;
        String string2 = Token.getTokenAfter(this.statement, "NODEGROUP").trim();
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignUDB storageDesignUDB = (StorageDesignUDB)this.design.getStorageDesign(rDBMSSite);
        DBPartitionGroupUDBv81 dBPartitionGroupUDBv81 = (DBPartitionGroupUDBv81)storageDesignUDB.getNodeGroupSet().createNodeGroup();
        if (dBPartitionGroupUDBv81 != null) {
            dBPartitionGroupUDBv81.setName(string2);
            String string3 = Token.getTokenAfter(this.statement, "ON").trim();
            if (string3.equalsIgnoreCase("NODES")) {
                dBPartitionGroupUDBv81.setScope("ON SOME NODES");
                if (Token.hasCloseAndOpenBrackets(this.statement)) {
                    String string4 = Token.getValBetweenBrackets(this.statement).trim();
                    dBPartitionGroupUDBv81.setNodeNumbers(string4);
                }
            }
        }
    }
}

