/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb.v81;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.crest.imports.StatementsConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.NameElements;
import oracle.dbtools.crest.model.datatype.NotStandartDataTypeNames;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.util.logging.Logger;

public class SHColumnElementsUDBv81
implements StatementsConstants {
    private static final String ZERO = "0";
    private static final String[] CONSTRAINT_NAMES = new String[]{"CONSTRAINT", "PRIMARY", "UNIQUE", "FOREIGN", "CHECK"};
    private static final String NO_CACHE = "NO CACHE";
    private static final String NO_CYCLE = "NO CYCLE";
    private static final String NO_MAXVALUE = "NO MAXVALUE";
    private static final String NO_MINVALUE = "NO MINVALUE";
    private static final String NO_ORDER = "NO ORDER";
    private static final String INCREMENT_BY = "INCREMENT BY";
    private static final String NOT_ENFORCED = "NOT ENFORCED";
    private static final String DISABLE_QUERY_OPTIMIZATION = "DISABLE QUERY OPTIMIZATION";
    private Map mapElementsColumn;
    private String statement;
    private Set constraints = new HashSet<String>(Arrays.asList(CONSTRAINT_NAMES));
    private static final Logger LOGGER = new Logger(SHColumnElementsUDBv81.class);
    private String tstatement = "";

    private void parseColumns(String string, boolean bl) {
        this.statement = string;
        this.mapElementsColumn = new HashMap();
        this.tstatement = this.statement.toUpperCase();
        try {
            if (this.initColumnName()) {
                if (!bl) {
                    this.initDatatype();
                }
                this.initNotNull();
                this.initWithDefault();
                this.initLobOptions();
                this.initDataLinkOptions();
                this.initIdentity();
                this.initCompressSystemDefault();
                this.initPrimaryKeyOrUnique();
                this.initFor();
                this.initReferences();
                this.initConstraintCheck();
            } else {
                this.initConstraints();
            }
        }
        catch (Exception exception) {
            LOGGER.error(" Parsing " + this.statement + " for UDB failed!", exception);
        }
    }

    private boolean initColumnName() {
        String string = Token.getFirstToken(this.statement);
        if (this.constraints.contains(string.toUpperCase())) {
            this.mapElementsColumn.put("IS_CONSTRAINT", Boolean.TRUE);
            return false;
        }
        String string2 = "";
        if (this.statement.indexOf("\"") > -1) {
            string2 = Token.getValBetweenDoubleQuotes(this.statement);
            this.statement = Token.getStringAfter(this.statement, string2);
            this.statement = Token.cutFirstToken(this.statement);
        } else {
            string2 = Token.getFirstToken(this.statement).trim();
            this.statement = Token.getStringAfter(this.statement, string2);
        }
        this.mapElementsColumn.put("IS_CONSTRAINT", Boolean.FALSE);
        this.mapElementsColumn.put("columnname", string2);
        return true;
    }

    private void initDatatype() {
        if (!Token.hasString(this.statement, "USER GENERATED") && !this.statement.startsWith("FOREIGN")) {
            int n;
            String string = this.statement;
            String string2 = this.searchWhichDatatype(string);
            String string3 = null;
            String string4 = null;
            if (string2 != null) {
                string3 = string2;
                string4 = Token.getStringAfter(this.statement, string2).trim();
                if (string4.startsWith("(") && (n = string4.indexOf(")")) > -1) {
                    string3 = string2 + string4.substring(0, n + 1);
                }
            }
            if (string2 == null) {
                string2 = this.searchNotStandartDatatypes(this.statement);
                if (string2 != null && !"".equalsIgnoreCase(this.statement.trim())) {
                    string3 = string2;
                    string4 = Token.getStringAfter(this.statement, string2).trim();
                    if (string4.startsWith("(") && (n = string4.indexOf(")")) > -1) {
                        string3 = string2 + string4.substring(0, n + 1);
                    }
                    this.mapElementsColumn.put("typename", string3);
                } else {
                    this.mapElementsColumn.put(NameElements.COL_STRUCTURED_TYPE, string);
                }
            }
            if (string2 != null) {
                String string5 = StandardDatatypeNames.getUsedDatatypeName(string2);
                if (Token.hasCloseAndOpenBrackets(string5)) {
                    string3 = string5;
                    string2 = string5 = Token.getValBeforeBrackets(string5).trim();
                }
                if (string5 != null) {
                    string3 = Token.cutTokenFromFront(string3, string2);
                    this.mapElementsColumn.put("datatype", string5);
                    if (!string3.equalsIgnoreCase("")) {
                        boolean bl = Token.hasCloseAndOpenBrackets(string3);
                        if (bl) {
                            String string6 = Token.getValBetweenBrackets(string3, 1);
                            int n2 = string6.indexOf(",");
                            if (n2 != -1) {
                                this.mapElementsColumn.put("size", ZERO);
                                this.mapElementsColumn.put("precision", string6.substring(0, n2).trim());
                                this.mapElementsColumn.put("scale", string6.substring(n2 + 1).trim());
                            } else if (string5.equals("DECIMAL")) {
                                this.mapElementsColumn.put("size", ZERO);
                                this.mapElementsColumn.put("scale", ZERO);
                                this.mapElementsColumn.put("precision", string6.trim());
                            } else if (string5.equalsIgnoreCase("NUMERIC")) {
                                if (n2 != -1) {
                                    this.mapElementsColumn.put("size", ZERO);
                                    this.mapElementsColumn.put("precision", string6.substring(0, n2).trim());
                                    this.mapElementsColumn.put("scale", string6.substring(n2 + 1).trim());
                                } else {
                                    this.mapElementsColumn.put("size", ZERO);
                                    this.mapElementsColumn.put("precision", string6.trim());
                                    this.mapElementsColumn.put("scale", ZERO);
                                }
                            } else {
                                this.mapElementsColumn.put("scale", ZERO);
                                this.mapElementsColumn.put("precision", ZERO);
                                this.mapElementsColumn.put("size", string6.trim());
                            }
                            this.statement = Token.cutFirstToken(this.statement);
                        }
                    } else {
                        this.statement = Token.cutFirstToken(this.statement);
                    }
                } else {
                    StringBuffer stringBuffer = new StringBuffer("datatype is unknown in SHColumnElements.initDatatype: ");
                    LOGGER.error(stringBuffer.toString());
                }
            } else {
                this.statement = Token.cutFirstToken(this.statement);
            }
        }
    }

    protected String searchWhichDatatype(String string) {
        String[] stringArray = StandardDatatypeNames.getAllPossibleDatatypes("DB2/UDB 8.1");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            boolean bl = string.toUpperCase().startsWith(string2);
            if (!bl) continue;
            try {
                char c = string.charAt(string2.length());
                bl = c == '(' || c == ' ' || c == '\n' || c == '\t' || c == ',' || c == ')';
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                bl = true;
            }
            if (!bl) continue;
            return string2;
        }
        return null;
    }

    private String searchNotStandartDatatypes(String string) {
        String[] stringArray = NotStandartDataTypeNames.getAllNewTypes();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            boolean bl = string.startsWith(string2);
            if (!bl) continue;
            try {
                char c = string.charAt(string2.length());
                bl = c == '(' || c == ' ' || c == '\n' || c == '\t';
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                bl = true;
            }
            if (!bl) continue;
            return string2;
        }
        return null;
    }

    private void initNotNull() {
        String string;
        if (this.statement.trim().startsWith("(")) {
            this.statement = Token.getValAfterBrackets(this.statement.trim(), 1);
        }
        if ((string = Token.getFirstToken(this.statement).trim()).equalsIgnoreCase("NOT")) {
            if ("NULL".equalsIgnoreCase(Token.getTokenAfter(this.statement, "NOT"))) {
                this.mapElementsColumn.put("NOT NULL", Boolean.TRUE);
                this.statement = Token.cutTokenFromFront(this.statement, "NOT NULL");
            } else {
                this.mapElementsColumn.put("NOT NULL", Boolean.FALSE);
            }
        } else {
            this.mapElementsColumn.put("NOT NULL", Boolean.FALSE);
        }
    }

    private void initIdentity() {
        String string = Token.getFirstToken(this.statement).trim();
        if (string.equalsIgnoreCase("GENERATED")) {
            this.statement = Token.cutTokenFromFront(this.statement, "GENERATED");
            String string2 = Token.getFirstToken(this.statement).trim();
            if (string2.equalsIgnoreCase("ALWAYS")) {
                this.mapElementsColumn.put("GENERATED", "ALWAYS");
            } else if (string2.equalsIgnoreCase("BY")) {
                this.mapElementsColumn.put("GENERATED", "BY DEFAULT");
            }
            if (Token.hasCloseAndOpenBrackets(this.statement) && this.statement.toUpperCase().indexOf("IDENTITY") > -1) {
                String string3;
                int n = this.statement.indexOf(40);
                this.statement = this.statement.substring(n).trim();
                String string4 = Token.getValBetweenBrackets(this.statement);
                if (string4.indexOf("START") > -1) {
                    string3 = Token.getTokenAfter(string4, "WITH");
                    this.mapElementsColumn.put("START", string3);
                }
                if (string4.indexOf(INCREMENT_BY) > -1) {
                    string3 = Token.getTokenAfter(string4, "BY");
                    this.mapElementsColumn.put("INCREMENT", string3);
                }
                if (Token.hasToken(string4, "CACHE")) {
                    if (string4.indexOf(NO_CACHE) > -1) {
                        this.mapElementsColumn.put("CACHE", "NO");
                    } else {
                        string3 = Token.getTokenAfter(string4, "CACHE");
                        this.mapElementsColumn.put("CACHE", string3);
                    }
                }
                if (Token.hasToken(string4, "CYCLE")) {
                    if (string4.indexOf(NO_CYCLE) > -1) {
                        this.mapElementsColumn.put("CYCLE", "NO");
                    } else {
                        this.mapElementsColumn.put("CYCLE", "YES");
                    }
                }
                if (Token.hasToken(string4, "MAXVALUE")) {
                    if (string4.indexOf(NO_MAXVALUE) > -1) {
                        this.mapElementsColumn.put("MAXVALUE", "NO");
                    } else {
                        string3 = Token.getTokenAfter(string4, "MAXVALUE");
                        this.mapElementsColumn.put("MAXVALUE", string3);
                    }
                }
                if (Token.hasToken(string4, "MINVALUE")) {
                    if (string4.indexOf(NO_MINVALUE) > -1) {
                        this.mapElementsColumn.put("MINVALUE", "NO");
                    } else {
                        string3 = Token.getTokenAfter(string4, "MINVALUE");
                        this.mapElementsColumn.put("MINVALUE", string3);
                    }
                }
                if (Token.hasToken(string4, "ORDER")) {
                    if (string4.indexOf(NO_ORDER) > -1) {
                        this.mapElementsColumn.put("ORDER", "NO");
                    } else {
                        this.mapElementsColumn.put("ORDER", "YES");
                    }
                }
                n = this.statement.indexOf(41);
                this.statement = this.statement.substring(n + 1).trim();
            } else if (Token.hasCloseAndOpenBrackets(this.statement)) {
                int n = this.statement.indexOf(40);
                this.statement = this.statement.substring(n).trim();
                String string5 = Token.getValBetweenBrackets(this.statement);
                this.mapElementsColumn.put("GENERATION_EXPRESSION", string5);
                n = this.statement.indexOf(41);
                this.statement = this.statement.substring(n + 1).trim();
            }
        }
    }

    private void initCompressSystemDefault() {
        if (this.statement.toUpperCase().indexOf("COMPRESS SYSTEM DEFAULT") > -1) {
            this.mapElementsColumn.put("COMPRESS SYSTEM DEFAULT", Boolean.TRUE);
        } else {
            this.mapElementsColumn.put("COMPRESS SYSTEM DEFAULT", Boolean.FALSE);
        }
    }

    private void initPrimaryKeyOrUnique() {
        boolean bl = Token.isTokenEqualTo(this.statement, 1, "PRIMARY");
        boolean bl2 = Token.isTokenEqualTo(this.statement, 2, "KEY");
        if (bl && bl2) {
            this.mapElementsColumn.put("PRIMARY KEY", Boolean.TRUE);
            this.statement = Token.cutTokenFromFront(this.statement, "PRIMARY KEY");
        } else {
            this.mapElementsColumn.put("PRIMARY KEY", Boolean.FALSE);
            boolean bl3 = Token.isTokenEqualTo(this.statement, 1, "UNIQUE");
            if (bl3) {
                this.mapElementsColumn.put("UNIQUE", Boolean.TRUE);
                this.statement = Token.cutTokenFromFront(this.statement, "UNIQUE");
            } else {
                this.mapElementsColumn.put("UNIQUE", Boolean.FALSE);
            }
        }
    }

    private void initWithDefault() {
        int n = this.statement.indexOf("WITH");
        if (n > -1) {
            boolean bl;
            this.statement = this.statement.substring(n);
            boolean bl2 = Token.isTokenEqualTo(this.statement, 1, "WITH");
            if (bl2) {
                this.statement = Token.cutTokenFromFront(this.statement, "WITH");
            }
            if (bl = Token.isTokenEqualTo(this.statement, 1, "DEFAULT")) {
                this.statement = Token.cutTokenFromFront(this.statement, "DEFAULT");
                String string = "";
                if (Token.getFirstToken(this.statement).startsWith("'")) {
                    string = Token.getValBetweenQuotes(this.statement).trim();
                    this.statement = Token.getStringAfter(this.statement, string);
                } else {
                    string = Token.getFirstToken(this.statement);
                }
                this.statement = Token.cutFirstToken(this.statement);
                this.mapElementsColumn.put("IS DEFAULT", Boolean.TRUE);
                if (!(string.equalsIgnoreCase("REFERENCES") || string.equalsIgnoreCase("CONSTRAINT") || string.equalsIgnoreCase("FIELDPROC"))) {
                    this.mapElementsColumn.put("DEFAULT", string);
                }
            } else {
                this.mapElementsColumn.put("IS DEFAULT", Boolean.FALSE);
            }
        }
    }

    private void initConstraintCheck() {
        boolean bl;
        boolean bl2;
        if (this.statement.trim().startsWith("(")) {
            this.statement = Token.getValBetweenBrackets(this.statement);
        }
        if (bl2 = Token.isTokenEqualTo(this.statement, 1, "CONSTRAINT")) {
            this.statement = Token.cutTokenFromFront(this.statement, "CONSTRAINT");
            String string = Token.getFirstToken(this.statement).trim();
            this.mapElementsColumn.put("CONSTRAINT", string);
            this.statement = Token.cutTokenFromFront(this.statement, string);
        }
        if (bl = Token.isTokenEqualTo(this.statement, 1, "CHECK")) {
            this.statement = Token.cutTokenFromFront(this.statement, "CHECK");
            String string = Token.getFirstToken(this.statement).trim();
            this.statement = Token.cutTokenFromFront(this.statement, string);
            if (Token.hasOpenBracketNoClose(string)) {
                String string2;
                StringBuffer stringBuffer = new StringBuffer(string);
                while (!Token.hasCloseBracket(Token.getFirstToken(this.statement)) && !(string2 = Token.getFirstToken(this.statement)).equals("")) {
                    stringBuffer.append(" ").append(string2);
                    this.statement = Token.cutTokenFromFront(this.statement, string2);
                }
                stringBuffer.append(" )");
                stringBuffer.append(" )");
                string = stringBuffer.toString();
                this.statement = Token.cutTokenFromFront(this.statement, ")");
            }
            string = Token.getValBetweenBrackets(string);
            this.mapElementsColumn.put("CHECK", string);
            if (this.statement.toUpperCase().indexOf(NOT_ENFORCED) > -1) {
                this.mapElementsColumn.put("VALIDATION", "NO");
            } else {
                this.mapElementsColumn.put("VALIDATION", "YES");
            }
            if (this.statement.toUpperCase().indexOf(DISABLE_QUERY_OPTIMIZATION) > -1) {
                this.mapElementsColumn.put("QUERY OPTIMIZATION", "DISABLE");
            } else {
                this.mapElementsColumn.put("QUERY OPTIMIZATION", "ENABLE");
            }
        }
    }

    public Map getElementsColumn(String string, boolean bl) {
        this.parseColumns(string.replaceAll("\"", ""), bl);
        return this.mapElementsColumn;
    }

    private void initLobOptions() {
        String string = Token.getFirstToken(this.statement).trim();
        if (string.equalsIgnoreCase("NOT")) {
            this.mapElementsColumn.put("NOT LOGGED", Boolean.TRUE);
            this.statement = Token.cutTokenFromFront(this.statement, "NOT LOGGED").trim();
        } else {
            this.mapElementsColumn.put("NOT LOGGED", Boolean.FALSE);
        }
        String string2 = Token.getFirstToken(this.statement).trim();
        if (string2.equalsIgnoreCase("COMPACT")) {
            this.mapElementsColumn.put("COMPACT", Boolean.TRUE);
            this.statement = Token.cutTokenFromFront(this.statement, "COMPACT").trim();
        } else {
            this.mapElementsColumn.put("COMPACT", Boolean.FALSE);
        }
    }

    private void initDataLinkOptions() {
        String string = Token.getFirstToken(this.statement).trim();
        if (string.equalsIgnoreCase("LINKTYPE")) {
            if (Token.hasToken(this.statement, "INTEGRITY")) {
                String string2;
                this.mapElementsColumn.put("INTEGRITY", Boolean.TRUE);
                while (!Token.getFirstToken(this.statement).equalsIgnoreCase("READ")) {
                    this.statement = Token.cutFirstToken(this.statement);
                }
                this.statement = Token.cutTokenFromFront(this.statement, "READ").trim();
                this.statement = Token.cutTokenFromFront(this.statement, "PERMISSION").trim();
                String string3 = Token.getFirstToken(this.statement).trim();
                this.mapElementsColumn.put("READ", string3);
                this.statement = Token.cutFirstToken(this.statement);
                while (!Token.getFirstToken(this.statement).equalsIgnoreCase("WRITE")) {
                    this.statement = Token.cutFirstToken(this.statement);
                }
                this.statement = Token.cutTokenFromFront(this.statement, "WRITE").trim();
                this.statement = Token.cutTokenFromFront(this.statement, "PERMISSION").trim();
                String string4 = Token.getStringAfter(this.statement, "WRITE PERMISSION").trim();
                if (string4.toUpperCase().startsWith("FS")) {
                    string4 = "FS";
                } else if (string4.toUpperCase().startsWith("BLOCKED")) {
                    string4 = "BLOCKED";
                } else if (string4.toUpperCase().startsWith("ADMIN REQUIRING TOKEN FOR UPDATE")) {
                    string4 = "ADMIN REQUIRING TOKEN FOR UPDATE";
                } else if (string4.toUpperCase().startsWith("ADMIN NOT REQUIRING TOKEN FOR UPDATE")) {
                    string4 = "ADMIN NOT REQUIRING TOKEN FOR UPDATE";
                }
                this.mapElementsColumn.put("WRITE", string4);
                this.statement = Token.cutFirstToken(this.statement);
                string = Token.getFirstToken(this.statement).trim();
                if (string.equalsIgnoreCase("RECOVERY")) {
                    this.statement = Token.cutTokenFromFront(this.statement, "RECOVERY").trim();
                    string2 = Token.getFirstToken(this.statement).trim();
                    this.mapElementsColumn.put("RECOVERY", string2);
                    this.statement = Token.cutFirstToken(this.statement);
                }
                if ((string = Token.getFirstToken(this.statement).trim()).equalsIgnoreCase("ON")) {
                    if ("UNLINK".equalsIgnoreCase(Token.getTokenAfter(this.statement, "ON"))) {
                        this.statement = Token.cutFirstToken(this.statement);
                        this.statement = Token.cutFirstToken(this.statement);
                        string2 = Token.getFirstToken(this.statement).trim();
                        this.mapElementsColumn.put("UNLINK", string2);
                        this.statement = Token.cutFirstToken(this.statement);
                    } else {
                        this.mapElementsColumn.put("UNLINK", "RESTORE");
                    }
                }
            } else {
                this.mapElementsColumn.put("INTEGRITY", Boolean.FALSE);
            }
        }
    }

    private void initConstraints() {
        String string = Token.getFirstToken(this.statement);
        if (string.equalsIgnoreCase("CONSTRAINT")) {
            String string2 = Token.getTokenAfter(this.statement, "CONSTRAINT").trim();
            this.statement = Token.getStringAfterToken(this.statement, string2);
            this.mapElementsColumn.put("CONSTRAINT_NAME", string2);
            this.initPrimaryKeyOrUnique();
            this.initTableConstraints();
            this.initValue();
        } else {
            this.mapElementsColumn.put("CONSTRAINT_NAME", "");
            this.initPrimaryKeyOrUnique();
            this.initTableConstraints();
            this.initValue();
        }
    }

    private void initTableConstraints() {
        boolean bl = Token.isTokenEqualTo(this.statement, 1, "CHECK");
        if (bl) {
            this.mapElementsColumn.put("CHECK", Boolean.TRUE);
        } else {
            this.mapElementsColumn.put("CHECK", Boolean.FALSE);
        }
    }

    private void initValue() {
        if (Token.hasCloseAndOpenBrackets(this.statement)) {
            String string = Token.getValBetweenBrackets(this.statement);
            this.mapElementsColumn.put("CONSTRAINT_VALUE", string);
        } else {
            this.mapElementsColumn.put("CONSTRAINT_VALUE", "");
        }
    }

    private void initReferences() {
        boolean bl = Token.isTokenEqualTo(this.statement, 1, "REFERENCES");
        if (bl) {
            boolean bl2;
            this.statement = Token.cutTokenFromFront(this.statement, "REFERENCES");
            String string = Token.getFirstToken(this.statement);
            int n = string.indexOf("(");
            if (n > 0) {
                string = string.substring(0, n);
            }
            this.mapElementsColumn.put("REFERENCES", string);
            this.statement = Token.cutTokenFromFront(this.statement, string);
            boolean bl3 = Token.hasString(this.statement, "(");
            if (bl3) {
                String string2 = Token.getValBetweenBrackets(this.statement);
                this.mapElementsColumn.put("REFERENCED_COLUMN", string2);
            }
            if (bl2 = Token.isTokenEqualTo(this.statement, 1, "ON")) {
                this.statement = Token.cutTokenFromFront(this.statement, "ON DELETE");
                String string3 = Token.getFirstToken(this.statement).trim();
                this.mapElementsColumn.put("ON DELETE", string3);
                this.statement = Token.cutTokenFromFront(this.statement, string3);
            }
        }
    }

    private void initFor() {
        boolean bl;
        int n = this.tstatement.indexOf("FOR");
        if (n > -1 && (bl = Token.isTokenEqualTo(this.statement, 1, "FOR"))) {
            this.statement = Token.cutTokenFromFront(this.statement, "FOR");
            String string = Token.getFirstToken(this.statement).trim();
            this.mapElementsColumn.put("FOR", string);
            this.statement = Token.cutTokenFromFront(this.statement, string);
        }
    }
}

