/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.DataTypeObject;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.MethodParamProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.MethodProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.StructuredTypeProxyUDB;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateTypeUDB
extends DDLStatementHandler {
    private String ownerName = null;
    private static final Logger LOGGER = new Logger(SHCreateTypeUDB.class);

    public SHCreateTypeUDB(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateTypeUDB.clearCR(string);
        if (Token.startsWithString(string2, "create type")) {
            try {
                this.parseCreateType(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for UDB failed!", exception);
                this.importLog.addFailedStatement(SHCreateTypeUDB.FormatCR(string, "\n"));
            }
        } else if (Token.startsWithString(string2, "alter type")) {
            try {
                this.parseAlterType(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for UDB failed!", exception);
                this.importLog.addFailedStatement(SHCreateTypeUDB.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    private void parseCreateType(String string) {
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignUDB storageDesignUDB = (StorageDesignUDB)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignUDB != null) {
            StructuredTypeProxyUDB structuredTypeProxyUDB;
            StructuredType structuredType;
            String string2 = Token.getNameAfterToken(this.statement, "TYPE", '\"', '\"').trim();
            int n = string2.indexOf(46);
            if (n > 0) {
                this.ownerName = Token.getValBeforeCharacter(string2, '.');
                string2 = Token.getValAfterCharacter(string2, '.');
            }
            if (this.design.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(string2) != null) {
                structuredType = (StructuredType)this.design.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(string2);
                structuredTypeProxyUDB = (StructuredTypeProxyUDB)storageDesignUDB.getStructuredTypeProxySet().getProxy(structuredType.getObjectID());
            } else {
                structuredType = this.design.getDesign().getDataTypesDesign().createStructuredType();
                structuredType.setName(string2);
                this.design.getRelationalDesign().stampModelObjectDDL(structuredType);
                this.initSuperType(structuredType);
                structuredTypeProxyUDB = (StructuredTypeProxyUDB)storageDesignUDB.getProxy(structuredType.getObjectID());
            }
            if (structuredTypeProxyUDB != null) {
                this.initOwner(structuredTypeProxyUDB);
                this.initElements(structuredType, structuredTypeProxyUDB);
                this.initInstantiable(structuredType);
                this.initInlineLength(structuredTypeProxyUDB);
                this.initFinal(structuredType);
                this.initWithFunctionAccess(structuredTypeProxyUDB);
                this.initRefUsingType(structuredTypeProxyUDB);
                this.initCastFunctions(structuredTypeProxyUDB);
                this.initMethods(structuredType, structuredTypeProxyUDB);
            }
        }
    }

    private void initOwner(StructuredTypeProxyUDB structuredTypeProxyUDB) {
        if (this.ownerName != null) {
            SchemaUDB schemaUDB = (SchemaUDB)((StorageDesignUDB)structuredTypeProxyUDB.getStorageDesign()).getSchemaSet().getByName(this.ownerName);
            if (schemaUDB == null) {
                schemaUDB = ((StorageDesignUDB)structuredTypeProxyUDB.getStorageDesign()).getSchemaSet().createSchema();
                schemaUDB.setName(this.ownerName);
                this.design.getRelationalDesign().stampModelObjectDDL(schemaUDB);
            }
            structuredTypeProxyUDB.setSchema(schemaUDB);
        }
    }

    private void initSuperType(StructuredType structuredType) {
        if (Token.hasToken(this.statement, "UNDER")) {
            StructuredType structuredType2;
            String string = Token.getTokenAfter(this.statement, "UNDER");
            if (this.design.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(string) != null) {
                structuredType2 = (StructuredType)this.design.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(string);
            } else {
                structuredType2 = this.design.getDesign().getDataTypesDesign().createStructuredType();
                structuredType2.setName(string);
                this.design.getRelationalDesign().stampModelObjectDDL(structuredType);
            }
            structuredType.setParentType(structuredType2, false);
        }
    }

    private void initElements(StructuredType structuredType, StructuredTypeProxyUDB structuredTypeProxyUDB) {
        String string;
        if (Token.hasToken(this.statement, "AS") && (string = Token.getStringAfter(this.statement, "AS").trim()).startsWith("(")) {
            string = Token.getValBetweenBrackets(this.statement, 1).trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                String string3 = Token.getFirstToken(string2);
                String string4 = Token.cutFirstToken(string2);
                TypeElement typeElement = new TypeElement(structuredType.getDesignPart(), structuredType);
                typeElement.setName(string3);
                typeElement.setDesign(structuredType.getDesign());
                this.initDatatype(string4, typeElement);
                structuredType.add(typeElement);
                this.design.getRelationalDesign().stampModelObjectDDL(typeElement);
            }
        }
    }

    private void initInstantiable(StructuredType structuredType) {
        if (Token.hasString(this.statement, "NOT INSTANTIABLE")) {
            structuredType.setInstantiable(false);
        } else if (Token.hasToken(this.statement, "INSTANTIABLE")) {
            structuredType.setInstantiable(true);
        }
    }

    private void initInlineLength(StructuredTypeProxyUDB structuredTypeProxyUDB) {
        if (Token.hasString(this.statement, "INLINE LENGTH")) {
            String string = Token.getStringAfter(this.statement, "INLINE LENGTH").trim();
            string = Token.getFirstToken(string).trim();
            structuredTypeProxyUDB.setInlineLength(string);
        }
    }

    private void initFinal(StructuredType structuredType) {
        if (Token.hasString(this.statement, "NOT FINAL")) {
            structuredType.setFinal(false);
        } else {
            structuredType.setFinal(true);
        }
    }

    private void initWithFunctionAccess(StructuredTypeProxyUDB structuredTypeProxyUDB) {
        if (Token.hasString(this.statement, "FUNCTION ACCESS")) {
            structuredTypeProxyUDB.setWithFunctionAccess("YES");
        }
    }

    private void initRefUsingType(StructuredTypeProxyUDB structuredTypeProxyUDB) {
        if (Token.hasString(this.statement, "REF USING")) {
            String string = Token.getStringAfter(this.statement, "REF USING").trim();
            string = Token.getFirstToken(string).trim();
            this.initDatatype(string, structuredTypeProxyUDB);
        }
    }

    private void initCastFunctions(StructuredTypeProxyUDB structuredTypeProxyUDB) {
        if (Token.hasToken(this.statement, "CAST")) {
            String string = Token.getStringAfterToken(this.statement, "CAST").trim();
            if (string.startsWith("(SOURCE AS REF)")) {
                string = Token.getToken(string, 5).trim();
                structuredTypeProxyUDB.setRefType2RefCastFunction(string);
            } else if (string.startsWith("(REF AS SOURCE)")) {
                string = Token.getToken(string, 5).trim();
                structuredTypeProxyUDB.setRef2RefTypeCastFunction(string);
            }
        }
    }

    private void initMethods(StructuredType structuredType, StructuredTypeProxyUDB structuredTypeProxyUDB) {
    }

    private void initDatatype(String string, DataTypeObject dataTypeObject) {
        String string2;
        String string3 = string;
        String string4 = "";
        int n = 0;
        int n2 = 0;
        if (Token.hasCloseAndOpenBrackets(string)) {
            string3 = string.substring(0, string.indexOf("(")).trim();
            string2 = Token.getValBetweenBrackets(string, 1);
            int n3 = string2.indexOf(44);
            if (n3 > -1) {
                string4 = "";
                try {
                    n = Integer.parseInt(string2.substring(0, n3).trim());
                }
                catch (NumberFormatException numberFormatException) {
                    n = 0;
                }
                try {
                    n2 = Integer.parseInt(string2.substring(n3 + 1).trim());
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = 0;
                }
            } else if (string3.equalsIgnoreCase("DECIMAL") || string3.equalsIgnoreCase("NUMERIC")) {
                string4 = "";
                n2 = 0;
                try {
                    n = Integer.parseInt(string2.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    n = 0;
                }
            } else {
                n2 = 0;
                n = 0;
                string4 = string2.trim();
            }
        }
        if ("UNKNOWN".equalsIgnoreCase(string2 = StandardDatatypeNames.getUsedDatatypeName(string3))) {
            StructuredType structuredType = (StructuredType)dataTypeObject.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(string3);
            if (structuredType != null) {
                dataTypeObject.setType(structuredType);
            }
        } else {
            LogicalDatatype logicalDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), string2);
            if (logicalDatatype != null) {
                dataTypeObject.setType(logicalDatatype);
                dataTypeObject.setSize(string4);
                dataTypeObject.setScale(n2);
                dataTypeObject.setPrecision(n);
            }
        }
    }

    private void parseAlterType(String string) {
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignUDB storageDesignUDB = (StorageDesignUDB)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignUDB != null) {
            String string2 = Token.getNameAfterToken(this.statement, "TYPE", '\"', '\"').trim();
            int n = string2.indexOf(46);
            if (n > 0) {
                this.ownerName = Token.getValBeforeCharacter(string2, '.');
                string2 = Token.getValAfterCharacter(string2, '.');
            }
            if (this.design.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(string2) != null) {
                StructuredType structuredType = (StructuredType)this.design.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(string2);
                StructuredTypeProxyUDB structuredTypeProxyUDB = (StructuredTypeProxyUDB)storageDesignUDB.getStructuredTypeProxySet().getByName(string2);
                if (structuredTypeProxyUDB != null) {
                    this.initDefinition(structuredType, structuredTypeProxyUDB);
                }
            } else {
                LOGGER.error("Unable to find required Structured Type: " + string2);
            }
        }
    }

    private void initDefinition(StructuredType structuredType, StructuredTypeProxyUDB structuredTypeProxyUDB) {
        if (Token.hasToken(this.statement, "ADD")) {
            String string = Token.getTokenAfter(this.statement, "ADD").trim();
            if ("ATTRIBUTE".equalsIgnoreCase(string)) {
                this.initAttribute(structuredType, structuredTypeProxyUDB);
            } else if ("METHOD".equalsIgnoreCase(string)) {
                this.initMethod(structuredType, structuredTypeProxyUDB);
            }
        }
    }

    private void initAttribute(StructuredType structuredType, StructuredTypeProxyUDB structuredTypeProxyUDB) {
        String string = Token.getStringAfterToken(this.statement, "ATTRIBUTE");
        String string2 = Token.getFirstToken(string);
        String string3 = Token.cutFirstToken(string);
        TypeElement typeElement = new TypeElement(structuredType.getDesignPart(), structuredType);
        typeElement.setName(string2);
        typeElement.setDesign(structuredType.getDesign());
        this.initDatatype(string3, typeElement);
        structuredType.add(typeElement);
        this.design.getRelationalDesign().stampModelObjectDDL(typeElement);
    }

    private void initMethod(StructuredType structuredType, StructuredTypeProxyUDB structuredTypeProxyUDB) {
        String string = Token.getTokenAfter(this.statement, "METHOD").trim();
        Method method = new Method(structuredType.getDesignPart(), structuredType);
        method.setName(string);
        method.setDesign(structuredType.getDesign());
        structuredType.addMethod(method);
        this.design.getRelationalDesign().stampModelObjectDDL(method);
        String string2 = Token.getStringAfter(this.statement, string).trim();
        if (string2.startsWith("(")) {
            string2 = Token.getValBetweenBrackets(this.statement, 1).trim();
            if (Token.hasCloseAndOpenBrackets(string2)) {
                int n = Token.getCloseBracketIndex(string2);
                String string3 = string2.substring(0, n + 1);
                String string4 = string2.substring(n + 1);
                this.initMethodParam(structuredType, structuredTypeProxyUDB, method, string3);
                while (string4 != null && !string4.equalsIgnoreCase("")) {
                    String string5;
                    int n2 = Token.getCloseBracketIndex(string4 = Token.getStringAfter(string4, ","));
                    if (n2 != -1) {
                        string5 = string4.substring(0, n2 + 1);
                        this.initMethodParam(structuredType, structuredTypeProxyUDB, method, string5);
                        string4 = string4.substring(n2 + 1);
                        continue;
                    }
                    string5 = Token.getStringBefore(string4, ",");
                    if (!string5.equalsIgnoreCase("")) {
                        this.initMethodParam(structuredType, structuredTypeProxyUDB, method, string5);
                    } else {
                        this.initMethodParam(structuredType, structuredTypeProxyUDB, method, string4);
                    }
                    string4 = Token.getStringAfter(string4, string5);
                }
            } else {
                this.initMethodParam(structuredType, structuredTypeProxyUDB, method, string2);
            }
        }
        this.initReturns(method);
        MethodProxyUDB methodProxyUDB = (MethodProxyUDB)structuredTypeProxyUDB.getStorageDesign().getMethodProxySet().getByName(method.getName());
        if (methodProxyUDB != null) {
            this.initSpecific(methodProxyUDB);
            this.initSelfAsResult(methodProxyUDB);
            this.initLanguage(methodProxyUDB);
            this.initParameterStyle(methodProxyUDB);
            this.initDeterministic(methodProxyUDB);
            this.initExternalAction(methodProxyUDB);
            this.initSqlStatementType(methodProxyUDB);
            this.initNullParametersTreatment(methodProxyUDB);
            this.initFederated(methodProxyUDB);
            this.initFenced(methodProxyUDB);
            this.initScratchpad(methodProxyUDB);
            this.initFinalCall(methodProxyUDB);
            this.initParallelInvocation(methodProxyUDB);
            this.initDBInfo(methodProxyUDB);
        }
    }

    private void initReturns(Method method) {
        if (Token.hasToken(this.statement, "RETURNS")) {
            String string = Token.getTokenAfter(this.statement, "RETURNS").trim();
            MethodParam methodParam = new MethodParam(method.getDesignPart());
            methodParam.setDesign(method.getDesign());
            this.initDatatype(string, methodParam);
            method.setReturnValue(methodParam);
        }
    }

    private void initSpecific(MethodProxyUDB methodProxyUDB) {
        if (Token.hasToken(this.statement, "SPECIFIC")) {
            String string = Token.getTokenAfter(this.statement, "SPECIFIC").trim();
            methodProxyUDB.setSpecificName(string);
        }
    }

    private void initSelfAsResult(MethodProxyUDB methodProxyUDB) {
        if (Token.hasString(this.statement, "SELF AS RESULT")) {
            methodProxyUDB.setReturnSelfAsResult("YES");
        }
    }

    private void initLanguage(MethodProxyUDB methodProxyUDB) {
        if (Token.hasToken(this.statement, "LANGUAGE")) {
            String string = Token.getTokenAfter(this.statement, "LANGUAGE").trim();
            methodProxyUDB.setLanguage(string.toUpperCase());
        }
    }

    private void initParameterStyle(MethodProxyUDB methodProxyUDB) {
        if (Token.hasToken(this.statement, "STYLE")) {
            String string = Token.getTokenAfter(this.statement, "STYLE").trim();
            methodProxyUDB.setExt_R_ParameterStyle(string.toUpperCase());
        }
    }

    private void initDeterministic(MethodProxyUDB methodProxyUDB) {
        if (Token.hasToken(this.statement, "DETERMINISTIC")) {
            if (Token.getTokenBefore(this.statement, "DETERMINISTIC").trim().equalsIgnoreCase("NOT")) {
                methodProxyUDB.setDeterministic("NO");
            } else {
                methodProxyUDB.setDeterministic("YES");
            }
        }
    }

    private void initExternalAction(MethodProxyUDB methodProxyUDB) {
        if (Token.hasToken(this.statement, "EXTERNAL")) {
            if (Token.getTokenBefore(this.statement, "EXTERNAL").trim().equalsIgnoreCase("NO")) {
                methodProxyUDB.setExternalAction("NO");
            } else {
                methodProxyUDB.setExternalAction("YES");
            }
        }
    }

    protected void initSqlStatementType(MethodProxyUDB methodProxyUDB) {
        if (Token.hasString(this.statement, "READS SQL DATA")) {
            methodProxyUDB.setSqlStatementType("READS SQL DATA");
        } else if (Token.hasString(this.statement, "CONTAINS SQL")) {
            methodProxyUDB.setSqlStatementType("CONTAINS SQL");
        }
    }

    private void initNullParametersTreatment(MethodProxyUDB methodProxyUDB) {
        if (Token.hasString(this.statement, "RETURNS NULL ON NULL INPUT")) {
            methodProxyUDB.setNullParametersTreatment("RETURNS NULL ON NULL INPUT");
        }
    }

    private void initFederated(MethodProxyUDB methodProxyUDB) {
        if (Token.hasString(this.statement, "FEDERATED")) {
            methodProxyUDB.setFederated("YES");
        }
    }

    protected void initFenced(MethodProxyUDB methodProxyUDB) {
        if (Token.hasToken(this.statement, "FENCED")) {
            if (Token.getTokenBefore(this.statement, "FENCED").trim().equalsIgnoreCase("NOT")) {
                methodProxyUDB.setExt_R_Safeness("NOT FENCED");
            } else {
                methodProxyUDB.setExt_R_Safeness("FENCED");
            }
        }
    }

    private void initScratchpad(MethodProxyUDB methodProxyUDB) {
        if (Token.hasToken(this.statement, "SCRATCHPAD") && !Token.getTokenBefore(this.statement, "SCRATCHPAD").trim().equalsIgnoreCase("NO")) {
            String string = Token.getTokenAfter(this.statement, "SCRATCHPAD").trim();
            methodProxyUDB.setExt_R_Scratchpad(string);
        }
    }

    private void initFinalCall(MethodProxyUDB methodProxyUDB) {
        if (Token.hasString(this.statement, "NO FINAL CALL")) {
            methodProxyUDB.setExt_R_FinalCall("NO");
        } else if (Token.hasString(this.statement, "FINAL CALL")) {
            methodProxyUDB.setExt_R_FinalCall("YES");
        }
    }

    private void initParallelInvocation(MethodProxyUDB methodProxyUDB) {
        if (Token.hasToken(this.statement, "DISALLOW")) {
            methodProxyUDB.setExt_R_ParallelInvocation("DISALLOW");
        }
    }

    private void initDBInfo(MethodProxyUDB methodProxyUDB) {
        if (Token.hasToken(this.statement, "DBINFO")) {
            methodProxyUDB.setExt_R_DBInfo("YES");
        }
    }

    private void initMethodParam(StructuredType structuredType, StructuredTypeProxyUDB structuredTypeProxyUDB, Method method, String string) {
        MethodParamProxyUDB methodParamProxyUDB;
        String string2 = Token.getFirstToken(string).trim();
        String string3 = Token.cutFirstToken(string);
        string3 = Token.getFirstToken(string3);
        MethodParam methodParam = new MethodParam(structuredType.getDesignPart());
        methodParam.setName(string2);
        methodParam.setDesign(structuredType.getDesign());
        this.initDatatype(string3, methodParam);
        method.addParameter(methodParam);
        if (Token.hasToken(string, "LOCATOR") && (methodParamProxyUDB = (MethodParamProxyUDB)structuredTypeProxyUDB.getStorageDesign().getMethodParamProxySet().getByName(string2)) != null) {
            methodParamProxyUDB.setAsLocator(true);
        }
    }
}

