/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.ContainerUDB;
import oracle.dbtools.crest.model.design.storage.udb.NodeGroupUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.BufferPoolUDBv71;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateTablespaceUDB
extends DDLStatementHandler {
    private TableSpaceUDB tableSpace;
    private RDBMSSite site;
    private StorageDesignUDB stoDesign;
    private static final Logger LOGGER = new Logger(SHCreateTablespaceUDB.class);

    public SHCreateTablespaceUDB(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateTablespaceUDB.clearCR(string);
        if (Token.startsWithString(string2, "create tablespace") || Token.startsWithString(string2, "create regular tablespace") || Token.startsWithString(string2, "create long tablespace") || Token.startsWithString(string2, "create temporary tablespace") || Token.startsWithString(string2, "create system temporary tablespace") || Token.startsWithString(string2, "create user temporary tablespace")) {
            try {
                this.parseTablespace(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for UDB failed!", exception);
                this.importLog.addFailedStatement(SHCreateTablespaceUDB.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    public void parseTablespace(String string) {
        this.statement = string;
        this.site = this.design.getSelectedRDBMSSite();
        this.stoDesign = (StorageDesignUDB)this.design.getStorageDesign(this.site);
        if (this.stoDesign != null) {
            this.tableSpace = this.stoDesign.getTableSpaceSet().createTableSpace();
            this.initType();
            this.initName();
            this.initNodeGroup();
            this.initPageSize();
            this.initManagedBy();
            this.initUsingBlock();
            this.initExtentSize();
            this.initPrefetchSize();
            this.initBufferpool();
            this.initOverhead();
            this.initTransferRate();
            this.initDroppedTableRecovery();
            this.design.getRelationalDesign().stampModelObjectDDL(this.tableSpace);
        }
    }

    private void initType() {
        String string = Token.getTokenAfter(this.statement, "CREATE").trim();
        if ("USER".equalsIgnoreCase(string)) {
            this.tableSpace.setDataType("USER TEMPORARY");
        } else if ("LONG".equalsIgnoreCase(string)) {
            this.tableSpace.setDataType("LONG");
        } else if ("SYSTEM".equalsIgnoreCase(string)) {
            this.tableSpace.setDataType("SYSTEM TEMPORARY");
        } else {
            this.tableSpace.setDataType("REGULAR");
        }
    }

    private void initName() {
        String string = Token.getNameAfterToken(this.statement, "TABLESPACE", '\"', '\"').trim();
        this.tableSpace.setName(string);
    }

    private void initNodeGroup() {
        if (Token.hasToken(this.statement, "NODEGROUP")) {
            String string = Token.getTokenAfter(this.statement, "NODEGROUP");
            NodeGroupUDB nodeGroupUDB = (NodeGroupUDB)this.stoDesign.getNodeGroupSet().getByName(string);
            if (nodeGroupUDB != null) {
                this.tableSpace.setNodeGroup(nodeGroupUDB);
            } else {
                nodeGroupUDB = this.stoDesign.getNodeGroupSet().createNodeGroup();
                nodeGroupUDB.setName(string);
                this.tableSpace.setNodeGroup(nodeGroupUDB);
            }
        }
    }

    private void initPageSize() {
        if (Token.hasToken(this.statement, "PAGESIZE")) {
            try {
                int n = Integer.parseInt(Token.getTokenAfter(this.statement, "PAGESIZE"));
                this.tableSpace.setPageSize(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong PAGESIZE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateTablespaceUDB.initPageSize : " + numberFormatException.getMessage());
            }
        }
    }

    private void initManagedBy() {
        if (Token.hasToken(this.statement, "BY")) {
            String string = Token.getTokenAfter(this.statement, "BY");
            this.tableSpace.setManagedBy(string);
        }
    }

    private void initUsingBlock() {
        int n;
        if (Token.hasToken(this.statement, "USING") && (n = this.statement.indexOf("USING")) > -1) {
            String string = this.statement.substring(n);
            while (string.indexOf("USING") > -1) {
                String string2 = Token.getValBetweenBrackets(string, 1);
                String string3 = Token.getValAfterBrackets(string, 1);
                if (string.length() == string3.length()) break;
                ContainerUDB containerUDB = ((StorageDesignUDB)this.tableSpace.getStorageDesign()).getContainerSet().createContainer();
                if (containerUDB == null) continue;
                containerUDB.setTableSpace(this.tableSpace);
                containerUDB.setContainers(string2);
                this.design.getRelationalDesign().stampModelObjectDDL(containerUDB);
                if (string3.toUpperCase().startsWith("ON")) {
                    String string4 = Token.getValBetweenBrackets(string3, 1);
                    containerUDB.setOnNodes(string4.trim());
                }
                string = Token.getValAfterBrackets(string3, 1);
            }
        }
    }

    private void initExtentSize() {
        if (Token.hasToken(this.statement, "EXTENTSIZE")) {
            this.tableSpace.setExtentSize(Token.getTokenAfter(this.statement, "EXTENTSIZE"));
        }
    }

    private void initPrefetchSize() {
        if (Token.hasToken(this.statement, "PREFETCHSIZE")) {
            this.tableSpace.setPrefetchSize(Token.getTokenAfter(this.statement, "PREFETCHSIZE"));
        }
    }

    private void initBufferpool() {
        String string;
        if (Token.hasToken(this.statement, "BUFFERPOOL") && !(string = Token.getTokenAfter(this.statement, "BUFFERPOOL").trim()).equals("")) {
            BufferPoolUDBv71 bufferPoolUDBv71 = (BufferPoolUDBv71)this.stoDesign.getBufferPoolSet().getByName(string);
            if (bufferPoolUDBv71 == null) {
                BufferPoolUDBv71 bufferPoolUDBv712 = (BufferPoolUDBv71)this.stoDesign.getBufferPoolSet().createBufferPool();
                bufferPoolUDBv712.setName(string);
                this.design.getRelationalDesign().stampModelObjectDDL(bufferPoolUDBv712);
                this.tableSpace.setBufferPool(bufferPoolUDBv712);
            } else {
                this.tableSpace.setBufferPool(bufferPoolUDBv71);
            }
        }
    }

    private void initOverhead() {
        if (Token.hasToken(this.statement, "OVERHEAD")) {
            try {
                float f = Float.parseFloat(Token.getTokenAfter(this.statement, "OVERHEAD"));
                this.tableSpace.setOverhead(f);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong OVERHEAD format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateTablespaceUDB.initOverhead : " + numberFormatException.getMessage());
            }
        }
    }

    private void initTransferRate() {
        if (Token.hasToken(this.statement, "TRANSFERRATE")) {
            try {
                float f = Float.parseFloat(Token.getTokenAfter(this.statement, "TRANSFERRATE"));
                this.tableSpace.setTransferRate(f);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong TRANSFERRATE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateTablespaceUDB.initTransferRate : " + numberFormatException.getMessage());
            }
        }
    }

    private void initDroppedTableRecovery() {
        String string;
        if (Token.hasToken(this.statement, "RECOVERY") && "ON".equalsIgnoreCase(string = Token.getTokenAfter(this.statement, "RECOVERY").trim())) {
            this.tableSpace.setDroppedTableRecovery(true);
        }
    }
}

